/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroTableModel;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SpecialFunctionTableModel
extends JP1TableModel<SpecialProtocolFunction> {
    private static String[] colNames = new String[]{"#", "<html>Device<br>Button</html>", "Key", "Type", "Function", "<html>DSM<br>Type</html>", "Hex", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "_VCR/DVD_", "shift-Thumbs_Up", " ToadTog(0,ForceOff) ", "[Short]:DiscreteON;DiscreteON; [Long]:DiscreteOFF;DiscreteOFF", "Controlled_", "00 11 22 33", "A reasonable length note", "Color_"};
    private static boolean[] colWidths = new boolean[]{true, true, true, false, false, true, false, false, true};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, DeviceButton.class, Integer.class, String.class, String.class, String.class, Hex.class, String.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private JComboBox deviceButtonBox = new JComboBox();
    private SelectAllCellEditor noteEditor = new SelectAllCellEditor();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private static final Color normalBGColor = Color.white;
    public static Color normalSelectedBGColor = Color.blue;
    private static final Color attachedBGColor = Color.lightGray;
    private static final Color attachedSelectedBGColor = Color.darkGray;

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            Remote remote = remoteConfig.getRemote();
            this.setData(remoteConfig.getSpecialFunctions());
            DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
            if (remote.hasGlobalSpecialFunctions()) {
                comboModel.addElement(DeviceButton.noButton);
            }
            this.deviceButtonBox.setModel(comboModel);
            this.highlightKeyRenderer.setRemote(remote);
        }
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 2;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        if (MacroTableModel.useTypeCol(this.remoteConfig)) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[this.getEffectiveColumn(col)];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[this.getEffectiveColumn(col)];
    }

    private int getEffectiveColumn(int col) {
        if (this.remoteConfig != null && col > 4 && !MacroTableModel.useTypeCol(this.remoteConfig)) {
            ++col;
        }
        return col;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[this.getEffectiveColumn(col)];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return (col = this.getEffectiveColumn(col)) != 0 && col != 2 && col != 3 && col != 4 && col != 6;
    }

    @Override
    public Object getValueAt(int row, int col) {
        SpecialProtocolFunction sf = (SpecialProtocolFunction)this.getRow(row);
        Remote r = this.remoteConfig.getRemote();
        col = this.getEffectiveColumn(col);
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                int index = sf.getDeviceButtonIndex();
                if (r.hasGlobalSpecialFunctions() && index == -1) {
                    return DeviceButton.noButton;
                }
                return r.getDeviceButton(index);
            }
            case 2: {
                return new Integer(sf.getKeyCode());
            }
            case 3: {
                return sf.getDisplayType(this.remoteConfig);
            }
            case 4: {
                return sf.getValueString(this.remoteConfig);
            }
            case 5: {
                Macro macro = sf.getMacro();
                if (macro != null) {
                    String classText = macro.getMacroClass().toString().toLowerCase();
                    return classText.equals("multi") ? "multi item" : classText;
                }
            }
            case 6: {
                return sf.getCmd();
            }
            case 7: {
                return sf.getNotes();
            }
            case 8: {
                return sf.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SpecialProtocolFunction sf = (SpecialProtocolFunction)this.getRow(row);
        if ((col = this.getEffectiveColumn(col)) == 1) {
            Remote r = this.remoteConfig.getRemote();
            ArrayList<DeviceButton> dbList = new ArrayList<DeviceButton>();
            dbList.addAll(Arrays.asList(r.getDeviceButtons()));
            if (r.hasGlobalSpecialFunctions()) {
                dbList.add(DeviceButton.noButton);
            }
            for (int i = 0; i < dbList.size(); ++i) {
                if (dbList.get(i) != value) continue;
                int index = ((DeviceButton)dbList.get(i)).getButtonIndex();
                sf.setDeviceButtonIndex(index);
                break;
            }
        } else if (col == 2) {
            sf.setKeyCode((Integer)value);
        } else if (col == 7) {
            sf.setNotes((String)value);
        } else if (col == 8) {
            sf.setHighlight((Color)value);
        } else {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(col == 8 ? "highlight" : "data", null, null);
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if ((col = this.getEffectiveColumn(col)) == 1) {
            DefaultCellEditor editor = new DefaultCellEditor(this.deviceButtonBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        if (col == 7) {
            return this.noteEditor;
        }
        if (col == 8) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 2) {
            return this.highlightKeyRenderer;
        }
        if (col == 8) {
            return this.colorRenderer;
        }
        return this.highlightRenderer;
    }
}

