/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DSMSpecialProtocol;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.LDKPSpecialProtocol;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.ModeNameSpecialProtocol;
import com.hifiremote.jp1.MultiplexSpecialProtocol;
import com.hifiremote.jp1.PauseSpecialProtocol;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import com.hifiremote.jp1.ToadTogSpecialProtocol;
import com.hifiremote.jp1.UDSMSpecialProtocol;
import com.hifiremote.jp1.ULDKPSpecialProtocol;
import com.hifiremote.jp1.UserSpecialProtocol;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class SpecialProtocol {
    private String name = null;
    private boolean internal = false;
    private int internalSerial = 0;
    private String deviceTypeName = null;
    private Hex pid = null;
    private DeviceType deviceType = null;
    private int setupCode = -1;
    private boolean assumePresent = false;
    private String[] userFunctions;

    public boolean getAssumePresent() {
        return this.assumePresent;
    }

    protected SpecialProtocol(String name, Hex pid) {
        this.name = name;
        this.pid = pid;
    }

    public static SpecialProtocol create(String name, String text, Remote remote) {
        int colon = text.indexOf(58);
        String prefix = null;
        if (colon != -1) {
            prefix = text.substring(0, colon);
            text = text.substring(colon + 1);
        }
        int paren = text.indexOf(40);
        ArrayList<String> userNames = null;
        if (paren != -1) {
            userNames = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(text.substring(paren), "(,)");
            text = text.substring(0, paren).trim();
            while (st.hasMoreTokens()) {
                userNames.add(st.nextToken().trim());
            }
        }
        boolean hasDash = false;
        if (text.startsWith("-")) {
            text = text.substring(1);
            hasDash = true;
        }
        Hex pid = new Hex(text);
        SpecialProtocol sp = null;
        sp = name.equals("DSM") ? new DSMSpecialProtocol(name, pid) : (name.equals("UDSM") ? new UDSMSpecialProtocol(name, pid) : (name.equals("LDKP") ? new LDKPSpecialProtocol(name, pid) : (name.equals("ULDKP") ? new ULDKPSpecialProtocol(name, pid) : (name.equals("Multiplex") ? new MultiplexSpecialProtocol(name, pid) : (name.equals("Pause") ? new PauseSpecialProtocol(name, pid) : (name.equals("ToadTog") ? new ToadTogSpecialProtocol(name, pid) : (name.equals("ModeName") ? new ModeNameSpecialProtocol(name, pid) : new UserSpecialProtocol(name, pid))))))));
        if (sp != null) {
            sp.userFunctions = (String[])sp.getFunctions().clone();
            if (userNames != null) {
                for (int i = 0; i < sp.userFunctions.length; ++i) {
                    if (i >= userNames.size()) continue;
                    sp.userFunctions[i] = (String)userNames.get(i);
                }
            }
        }
        if (name.equals("Pause")) {
            ((PauseSpecialProtocol)sp).setPauseParameters(remote);
        }
        sp.assumePresent = hasDash;
        if (prefix != null) {
            if (prefix.equalsIgnoreCase("Internal")) {
                sp.internal = true;
                sp.internalSerial = pid.getData()[0];
            } else {
                int slash = prefix.indexOf(47);
                sp.deviceTypeName = prefix.substring(0, slash);
                sp.setupCode = Integer.parseInt(prefix.substring(slash + 1));
                if (sp.deviceTypeName != null && !Remote.prelimLoad) {
                    System.err.println("deviceTypeName=" + sp.deviceTypeName);
                    sp.deviceType = remote.getDeviceType(sp.deviceTypeName);
                    System.err.println("deviceType=" + sp.deviceType);
                }
            }
        }
        return sp;
    }

    public void checkSpecialProtocol(Remote remote) {
        if (this.deviceTypeName != null && this.deviceType == null) {
            this.deviceType = remote.getDeviceType(this.deviceTypeName);
        }
    }

    public DeviceUpgrade getDeviceUpgrade(List<DeviceUpgrade> upgrades) {
        System.err.println("in getDeviceUpgrade");
        if (this.internal) {
            return null;
        }
        for (DeviceUpgrade upgrade : upgrades) {
            if (upgrade == null) continue;
            System.err.println("Checking " + upgrade);
            if (!upgrade.getProtocol().getID().equals(this.pid.subHex(0, 2))) continue;
            if (this.pid.getData().length == 4 && upgrade.getCode().getData()[this.pid.getData()[2]] != this.pid.getData()[3]) {
                System.err.println("PID matched but failed XPID check");
                continue;
            }
            System.err.println("It's a match!");
            return upgrade;
        }
        System.err.println("No match found!");
        return null;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public int getInternalSerial() {
        return this.internalSerial;
    }

    public boolean isPresent(RemoteConfiguration config) {
        if (this.internal) {
            System.err.println("Present because internal");
            return true;
        }
        if (this.deviceTypeName != null) {
            System.err.println("Device upgrade present because built in");
            if (this.assumePresent) {
                System.err.println("Protocol assumed built in");
                return true;
            }
            int spID = this.pid.get(0);
            System.err.println("Seeking protocol upgrade " + spID);
            for (ProtocolUpgrade protocol : config.getProtocolUpgrades()) {
                if (protocol.getPid() != spID) continue;
                if (this.pid.getData().length == 4 && protocol.getCode().getData()[this.pid.getData()[2]] != this.pid.getData()[3]) {
                    return false;
                }
                System.err.println("Found protocol upgrade");
                return true;
            }
            return false;
        }
        return this.getDeviceUpgrade(config.getDeviceUpgrades()) != null;
    }

    public abstract SpecialProtocolFunction createFunction(KeyMove var1);

    public abstract SpecialProtocolFunction createFunction(Macro var1);

    public abstract Hex createHex(SpecialFunctionDialog var1);

    public abstract String[] getFunctions();

    public String getName() {
        return this.name;
    }

    public Hex getPid() {
        return this.pid;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public int getSetupCode() {
        return this.setupCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(':');
        if (this.pid != null) {
            sb.append(this.pid.toString());
        } else if (this.deviceTypeName != null) {
            sb.append(this.deviceTypeName);
            sb.append('/');
            sb.append(this.setupCode);
        }
        return sb.toString();
    }

    public String[] getUserFunctions() {
        return this.userFunctions;
    }
}

