/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocol;
import java.awt.Color;
import java.util.Properties;

public abstract class SpecialProtocolFunction
extends Highlight {
    private KeyMove keyMove = null;
    private Macro macro = null;
    private static final String[] unknownFunctions = new String[]{"<unknown>", "<unknown>", "<unknown>"};

    public SpecialProtocolFunction(KeyMove keyMove) {
        this.keyMove = new KeyMove(keyMove);
    }

    public SpecialProtocolFunction(Macro macro) {
        this.macro = new Macro(macro);
    }

    public SpecialProtocolFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        this.keyMove = new KeyMove(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public SpecialProtocolFunction(Properties props, Remote remote) {
        boolean internal = false;
        String temp = props.getProperty("Internal");
        if (temp != null) {
            internal = Boolean.parseBoolean(temp);
        }
        if (internal) {
            this.macro = new Macro(props, remote);
        } else {
            this.keyMove = new KeyMove(props);
        }
    }

    public String[] getUserFunctions(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        for (SpecialProtocol sp : remote.getSpecialProtocols()) {
            if (this.isInternal()) {
                if (!sp.isInternal() || sp.getInternalSerial() != this.getInternalSerial()) continue;
                return sp.getUserFunctions();
            }
            if (sp.isInternal()) continue;
            DeviceType type = null;
            int code = 0;
            DeviceUpgrade upgrade = sp.getDeviceUpgrade(remoteConfig.getDeviceUpgrades());
            if (upgrade != null) {
                type = upgrade.getDeviceType();
                code = upgrade.getSetupCode();
            } else {
                type = sp.getDeviceType();
                code = sp.getSetupCode();
            }
            if (type == null || type.getNumber() != this.getDeviceType() || code != this.getSetupCode()) continue;
            return sp.getUserFunctions();
        }
        return unknownFunctions;
    }

    public KeyMove getKeyMove() {
        return this.keyMove;
    }

    public Macro getMacro() {
        return this.macro;
    }

    @Override
    public Highlight.UploadStatus getUploadStatus() {
        if (this.macro != null) {
            return this.macro.getUploadStatus();
        }
        return this.keyMove.getUploadStatus();
    }

    @Override
    public int getKeyCode() {
        if (this.keyMove != null) {
            return this.keyMove.getKeyCode();
        }
        return this.macro.getKeyCode();
    }

    @Override
    public void setKeyCode(int keyCode) {
        if (this.keyMove != null) {
            this.keyMove.setKeyCode(keyCode);
        } else {
            this.macro.setKeyCode(keyCode);
        }
    }

    public String getValueString(RemoteConfiguration getValueString) {
        if (this.keyMove != null) {
            return this.keyMove.getValueString(getValueString);
        }
        return this.macro.getValueString(getValueString);
    }

    public Hex getCmd() {
        if (this.keyMove != null) {
            return this.keyMove.getCmd();
        }
        return this.macro.getData();
    }

    @Override
    public int getDeviceButtonIndex() {
        if (this.keyMove != null) {
            return this.keyMove.getDeviceButtonIndex();
        }
        return this.macro.getDeviceButtonIndex();
    }

    @Override
    public void setDeviceButtonIndex(int index) {
        if (this.keyMove != null) {
            this.keyMove.setDeviceButtonIndex(index);
        } else {
            this.macro.setDeviceButtonIndex(index);
        }
    }

    public int getDeviceType() {
        return this.keyMove.getDeviceType();
    }

    public int getSetupCode() {
        return this.keyMove.getSetupCode();
    }

    public int getInternalSerial() {
        return this.macro.getSequenceNumber();
    }

    public boolean isInternal() {
        return this.macro != null;
    }

    @Override
    public String getNotes() {
        if (this.keyMove != null) {
            return this.keyMove.getNotes();
        }
        return this.macro.getNotes();
    }

    public void setNotes(String notes) {
        if (this.keyMove != null) {
            this.keyMove.setNotes(notes);
        } else {
            this.macro.setNotes(notes);
        }
    }

    @Override
    public Color getHighlight() {
        if (this.keyMove != null) {
            return this.keyMove.getHighlight();
        }
        return this.macro.getHighlight();
    }

    @Override
    public void setHighlight(Color color) {
        if (this.keyMove != null) {
            this.keyMove.setHighlight(color);
        } else {
            this.macro.setHighlight(color);
        }
    }

    @Override
    public int getMemoryUsage() {
        if (this.keyMove != null) {
            return this.keyMove.getMemoryUsage();
        }
        return this.macro.getMemoryUsage();
    }

    public abstract void update(SpecialFunctionDialog var1);

    public abstract String get_Type(RemoteConfiguration var1);

    public abstract String getDisplayType(RemoteConfiguration var1);
}

