/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Remote;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ChangeListener {
    private JSpinner spinner = null;
    private Hex colorHex = null;
    private JTextField textField = null;

    public SpinnerCellEditor(int min, int max, int step) {
        this.spinner = new JSpinner(new SpinnerNumberModel(max, min, max, step));
        this.spinner.addChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : SpinnerCellEditor.this.spinner.getEditor().getComponents()) {
                    if (!(c instanceof JTextField)) continue;
                    SpinnerCellEditor.this.textField = (JTextField)c;
                    break;
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.spinner.setValue(value);
        this.setColor(value);
        return this.spinner;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    public void setColorHex(Hex colorHex) {
        this.colorHex = colorHex;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setColor(this.spinner.getValue());
    }

    private void setColor(Object value) {
        if (this.colorHex != null) {
            int ndx = (Integer)value;
            if (this.textField != null) {
                this.textField.setBackground(Remote.getColorByIndex(ndx));
            }
        }
    }
}

