/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.LittleEndianProcessor;
import java.util.LinkedHashMap;

public class TI2541Processor
extends LittleEndianProcessor {
    public TI2541Processor(String name) {
        super(name);
        this.setPageSize(2048);
    }

    @Override
    public String getEquivalentName() {
        return "TI2541";
    }

    @Override
    public AssemblerOpCode.AddressMode disasmModify(AssemblerOpCode.AddressMode mode, Object[] obj) {
        switch (mode.modifier) {
            case 1: {
                LinkedHashMap<String, AssemblerOpCode.AddressMode> modes = this.getAddressModes();
                int op1 = (Integer)obj[0];
                if (op1 < 112) {
                    mode = modes.get("Fun1");
                    break;
                }
                if (op1 == 115) {
                    mode = modes.get("Fun1Z");
                    break;
                }
                if (op1 >= 128) break;
                mode = modes.get("Fun1B");
            }
        }
        return mode;
    }

    @Override
    public int[] getCarrierData(Hex hex) {
        short[] data = hex.getData();
        int carrier = this.getInt(data, 1);
        int duty = data[3] * 10;
        return new int[]{carrier, duty};
    }
}

