/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KMTableModel;
import com.hifiremote.jp1.LocalObjectTransferable;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.TableSorter;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.WrapLayout;
import com.hifiremote.jp1.clipboard.ClipboardReader;
import com.hifiremote.jp1.clipboard.ClipboardReaderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public abstract class TablePanel<E>
extends KMPanel
implements ActionListener,
ListSelectionListener {
    protected JTableX table = null;
    protected KMTableModel<E> model = null;
    private TableSorter sorter = null;
    protected JPanel buttonPanel = null;
    private JButton newButton = null;
    private JButton deleteButton = null;
    private JButton cleanButton = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private JButton copyButton = null;
    private JButton pasteButton = null;
    private JButton pasteFromIEButton = null;
    private int popupRow = 0;
    private int popupCol = 0;
    protected JPopupMenu popup = null;
    private JMenuItem newItem = null;
    private JMenuItem deleteItem = null;
    private JMenuItem copyItem = null;
    private JMenuItem pasteItem = null;
    private JMenuItem pasteFromIEItem = null;
    private boolean pasteFromIE = false;
    private Clipboard clipboard = null;
    private Toolkit kit = null;
    public static boolean suppressDeletePrompts = false;

    public TablePanel(String name, DeviceUpgrade devUpgrade, KMTableModel<E> tableModel) {
        super(name, devUpgrade);
        this.setLayout(new BorderLayout());
        this.kit = Toolkit.getDefaultToolkit();
        this.clipboard = this.kit.getSystemClipboard();
        this.model = tableModel;
        this.sorter = new TableSorter(this.model);
        this.table = new JTableX(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setCellSelectionEnabled(true);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setToolTipText("Click to sort is ascending order, or shift-click to sort in descending order.");
        SelectAllCellEditor e = new SelectAllCellEditor();
        new TextPopupMenu((JTextComponent)e.getComponent());
        this.table.setDefaultEditor(String.class, e);
        TransferHandler th = new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new LocalObjectTransferable(new Integer(TablePanel.this.table.getSelectedRow()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                boolean rc = false;
                for (int i = 0; i < flavors.length; ++i) {
                    if (flavors[i] != DataFlavor.stringFlavor && flavors[i] != LocalObjectTransferable.getFlavor()) continue;
                    rc = true;
                    break;
                }
                return rc;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                boolean rc = false;
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        ClipboardReader rdr = ClipboardReaderFactory.getClipboardReader(t, TablePanel.this.pasteFromIE);
                        int colCount = TablePanel.this.table.getModel().getColumnCount();
                        int addedRow = -1;
                        int row = TablePanel.this.table.getSelectedRow();
                        int col = TablePanel.this.table.getSelectedColumn();
                        List<String> tokens = rdr.readNextLine();
                        while (tokens != null) {
                            if (!tokens.isEmpty()) {
                                if (row == TablePanel.this.model.getRowCount()) {
                                    TablePanel.this.model.addRow(TablePanel.this.createRowObject());
                                    if (addedRow == -1) {
                                        addedRow = row;
                                    }
                                }
                                int workCol = col;
                                for (String token : tokens) {
                                    if (token.length() == 0) {
                                        token = null;
                                    }
                                    if (workCol == colCount) break;
                                    String value = null;
                                    int modelCol = TablePanel.this.table.convertColumnIndexToModel(workCol);
                                    Class<?> aClass = TablePanel.this.sorter.getColumnClass(modelCol);
                                    value = aClass == String.class ? (token != null && token.length() == 5 && token.startsWith("num ") && Character.isDigit(token.charAt(4)) ? token.substring(4) : token) : token;
                                    TablePanel.this.sorter.setValueAt(value, row, modelCol);
                                    ++workCol;
                                }
                                ++row;
                            }
                            tokens = rdr.readNextLine();
                        }
                        rdr.close();
                        if (addedRow != -1) {
                            TablePanel.this.sorter.fireTableRowsInserted(addedRow, row - 1);
                        }
                        TablePanel.this.sorter.fireTableRowsUpdated(TablePanel.this.popupRow, row - 1);
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage();
                        if (message == null) {
                            message = ex.toString();
                        }
                        ex.printStackTrace(System.err);
                    }
                } else if (t.isDataFlavorSupported(LocalObjectTransferable.getFlavor())) {
                    try {
                        int dragRow = (Integer)t.getTransferData(LocalObjectTransferable.getFlavor());
                        int dropRow = TablePanel.this.table.getSelectedRow();
                        if (dropRow != dragRow) {
                            dragRow = TablePanel.this.sorter.modelIndex(dragRow);
                            dropRow = TablePanel.this.sorter.modelIndex(dropRow);
                            TablePanel.this.model.moveRow(dragRow, dropRow);
                            if (dropRow < dragRow) {
                                TablePanel.this.model.fireTableRowsUpdated(dropRow, dragRow);
                            } else {
                                TablePanel.this.model.fireTableRowsUpdated(dragRow, dropRow);
                            }
                            rc = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                return rc;
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                JTable table = (JTable)comp;
                int[] selectedRows = table.getSelectedRows();
                int[] selectedCols = table.getSelectedColumns();
                StringBuilder buff = new StringBuilder(200);
                for (int rowNum = 0; rowNum < selectedRows.length; ++rowNum) {
                    if (rowNum != 0) {
                        buff.append("\n");
                    }
                    for (int colNum = 0; colNum < selectedCols.length; ++colNum) {
                        if (colNum != 0) {
                            buff.append("\t");
                        }
                        int selRow = selectedRows[rowNum];
                        int selCol = selectedCols[colNum];
                        int convertedCol = table.convertColumnIndexToModel(selCol);
                        Object value = table.getValueAt(selRow, selCol);
                        if (value == null) continue;
                        DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)table.getColumnModel().getColumn(selCol).getCellRenderer();
                        if (cellRenderer != null) {
                            cellRenderer.getTableCellRendererComponent(table, value, false, false, selRow, convertedCol);
                            value = cellRenderer.getText();
                        }
                        buff.append(value.toString());
                    }
                }
                StringSelection data = new StringSelection(buff.toString());
                TablePanel.this.clipboard.setContents(data, data);
            }
        };
        this.table.setTransferHandler(th);
        this.popup = new JPopupMenu();
        this.newItem = new JMenuItem("New");
        this.newItem.setToolTipText("Create a new function");
        this.newItem.addActionListener(this);
        this.popup.add(this.newItem);
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.setToolTipText("Delete the selected function");
        this.deleteItem.addActionListener(this);
        this.popup.add(this.deleteItem);
        this.popup.add(new JSeparator());
        this.copyItem = new JMenuItem("Copy");
        this.copyItem.setToolTipText("Copy the selection to the clipboard.");
        this.copyItem.addActionListener(this);
        this.popup.add(this.copyItem);
        this.pasteItem = new JMenuItem("Paste");
        this.pasteItem.setToolTipText("Paste from the clipboard into the selection.");
        this.pasteItem.addActionListener(this);
        this.popup.add(this.pasteItem);
        this.pasteFromIEItem = new JMenuItem("Paste (IE)");
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.pasteFromIEItem.setToolTipText("Paste multiple columns from Internet Explorer into the selection.");
            this.pasteFromIEItem.addActionListener(this);
            this.popup.add(this.pasteFromIEItem);
        }
        MouseAdapter mh = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private boolean showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TablePanel.this.finishEditing();
                    TablePanel.this.popupRow = TablePanel.this.table.rowAtPoint(e.getPoint());
                    TablePanel.this.popupCol = TablePanel.this.table.columnAtPoint(e.getPoint());
                    if (TablePanel.this.popupCol == 0) {
                        return false;
                    }
                    Function func = (Function)TablePanel.this.model.getRow(TablePanel.this.sorter.modelIndex(TablePanel.this.popupRow));
                    TablePanel.this.deleteItem.setEnabled(!func.assigned());
                    Transferable clipData = TablePanel.this.clipboard.getContents(TablePanel.this.clipboard);
                    if (clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor) && TablePanel.this.popupCol != 0) {
                        TablePanel.this.pasteItem.setEnabled(true);
                        TablePanel.this.pasteFromIEItem.setEnabled(true);
                    } else {
                        TablePanel.this.pasteItem.setEnabled(false);
                        TablePanel.this.pasteFromIEItem.setEnabled(false);
                    }
                    TablePanel.this.copyItem.setEnabled(TablePanel.this.table.getSelectedRowCount() > 0);
                    TablePanel.this.popup.show(TablePanel.this.table, e.getX(), e.getY());
                    return true;
                }
                return false;
            }
        };
        this.table.addMouseListener(mh);
        this.table.setLongToolTipTimeout();
        MouseMotionAdapter mmh = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int tableCol = TablePanel.this.table.columnAtPoint(e.getPoint());
                int modelCol = TablePanel.this.table.convertColumnIndexToModel(tableCol);
                if (modelCol == 0) {
                    TablePanel.this.table.getTransferHandler().exportAsDrag(TablePanel.this.table, e, 2);
                }
            }
        };
        this.table.addMouseMotionListener(mmh);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.buttonPanel = new JPanel(new WrapLayout(1));
        this.add((Component)this.buttonPanel, "South");
        this.newButton = new JButton("New");
        this.newButton.addActionListener(this);
        this.newButton.setToolTipText(JTableX.getHtmlToolTip("Add a new function. &nbsp&nbsp&nbsp Key: INS<br>(For INS key, table must have the focus and not be empty.)"));
        this.buttonPanel.add(this.newButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setToolTipText(JTableX.getHtmlToolTip("Delete a function. &nbsp&nbsp&nbsp Key: DEL (For DEL key, table must have the focus.)<br>If the menu item \"Options > Suppress Messages > Confirmation prompts\" <br>is selected, this will delete any assignments of the selected functions<br>to buttons.  Otherwise, to delete a function assigned to a button, first<br>delete the assignment."));
        this.deleteButton.setEnabled(false);
        this.buttonPanel.add(this.deleteButton);
        this.cleanButton = new JButton("Clean up");
        this.cleanButton.addActionListener(this);
        this.cleanButton.setToolTipText("Delete all undefined functions (no hex)");
        this.cleanButton.setEnabled(false);
        this.buttonPanel.add(this.cleanButton);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.upButton.setToolTipText("Move the selected function up in the list.");
        this.upButton.setEnabled(false);
        this.buttonPanel.add(this.upButton);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        this.downButton.setToolTipText("Move the selected function down in the list.");
        this.downButton.setEnabled(false);
        this.buttonPanel.add(this.downButton);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(this);
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setEnabled(false);
        this.buttonPanel.add(this.copyButton);
        this.pasteButton = new JButton("Paste");
        this.pasteButton.addActionListener(this);
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setEnabled(false);
        this.buttonPanel.add(this.pasteButton);
        this.pasteFromIEButton = new JButton("Paste (IE)");
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.pasteFromIEButton.addActionListener(this);
            this.pasteFromIEButton.setToolTipText("Paste multiple columns from Internet Explorer");
            this.pasteFromIEButton.setEnabled(false);
            this.buttonPanel.add(this.pasteFromIEButton);
        }
        RMPanel.setButtonKeys(this.table, this.deleteButton, this.newButton, null);
    }

    @Override
    public void setDeviceUpgrade(DeviceUpgrade deviceUpgrade) {
        super.setDeviceUpgrade(deviceUpgrade);
        this.initColumns();
    }

    @Override
    public void update() {
        this.cleanButton.setEnabled(this.table.getRowCount() > 0);
    }

    private void finishEditing() {
        TableCellEditor editor;
        int editRow = this.table.getEditingRow();
        if (editRow != -1 && !(editor = this.table.getCellEditor(editRow, this.table.getEditingColumn())).stopCellEditing()) {
            editor.cancelCellEditing();
        }
    }

    protected abstract E createRowObject();

    protected boolean canDelete(E o) {
        return true;
    }

    protected void delete(E o) {
    }

    protected void doNotDelete(E o) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.finishEditing();
        int row = 0;
        boolean select = false;
        Object source = e.getSource();
        if (source.getClass() == JButton.class) {
            row = this.table.getSelectedRow();
            if (row != -1) {
                select = true;
            }
        } else {
            row = this.popupRow;
            if (this.table.isRowSelected(row)) {
                select = true;
            }
        }
        if (source == this.newButton || source == this.newItem) {
            E o = this.createRowObject();
            if (row == -1) {
                this.model.addRow(o);
                row = 0;
            } else {
                this.model.insertRow(this.sorter.modelIndex(row), o);
            }
            try {
                this.model.fireTableRowsInserted(this.sorter.modelIndex(row), this.sorter.modelIndex(row));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (select) {
                this.table.setRowSelectionInterval(row, row);
            }
        } else if (source == this.deleteButton || source == this.deleteItem) {
            Object rowObject = this.model.getRow(this.sorter.modelIndex(row));
            if (!this.canDelete(rowObject)) {
                this.deleteButton.setEnabled(false);
                this.doNotDelete(rowObject);
            } else {
                int count = source == this.deleteButton ? this.table.getSelectedRowCount() : 1;
                String message = "<html>Are you sure you want to delete the selected entr" + (count > 1 ? "ies?" : "y?") + "<br><br>To suppress this message in future, select the menu item<br>Options/Suppress Messages/All table deletes.</html>";
                String title = "Confirm Deletion";
                if (suppressDeletePrompts || JOptionPane.showConfirmDialog(this, message, title, 0, 3) == 0) {
                    for (int n = row + count - 1; n >= row; --n) {
                        rowObject = this.model.getRow(this.sorter.modelIndex(n));
                        this.delete(rowObject);
                        this.model.removeRow(this.sorter.modelIndex(n));
                    }
                    this.model.fireTableRowsDeleted(this.sorter.modelIndex(row), this.sorter.modelIndex(row + count - 1));
                    if (row == this.model.getRowCount()) {
                        --row;
                    }
                    if (select) {
                        this.table.setRowSelectionInterval(row, row);
                    }
                }
            }
        } else if (source == this.cleanButton) {
            String message = "Cleaning deletes all functions that have no hex\nvalue assigned.  Are you sure you want to do this?";
            String title = "Confirm Cleaning";
            if (suppressDeletePrompts || JOptionPane.showConfirmDialog(this, message, title, 0, 3) == 0) {
                List functions = this.model.getData();
                ListIterator i = functions.listIterator();
                while (i.hasNext()) {
                    Object efn = i.next();
                    Function f = (Function)efn;
                    if (f.getHex() != null && f.getHex().length() != 0) continue;
                    i.remove();
                    this.delete(efn);
                    if (efn instanceof ExternalFunction) {
                        this.deviceUpgrade.getExternalFunctions().remove(efn);
                        continue;
                    }
                    this.deviceUpgrade.getFunctions().remove(efn);
                }
                this.model.fireTableDataChanged();
            }
        } else if (source == this.upButton || source == this.downButton) {
            int to;
            int start = 0;
            int end = 0;
            int sel = 0;
            int from = row;
            if (source == this.upButton) {
                start = row - 1;
                end = row;
                to = start;
                sel = start;
            } else {
                start = row;
                to = end = row + 1;
                sel = end;
            }
            this.model.moveRow(this.sorter.modelIndex(from), this.sorter.modelIndex(to));
            this.model.fireTableRowsUpdated(this.sorter.modelIndex(start), this.sorter.modelIndex(end));
            if (select) {
                this.table.setRowSelectionInterval(sel, sel);
            }
        } else if (source == this.copyItem || source == this.copyButton) {
            this.table.getTransferHandler().exportToClipboard(this.table, this.clipboard, 1);
        } else if (source == this.pasteItem || source == this.pasteButton) {
            Transferable clipData = this.clipboard.getContents(this.clipboard);
            if (clipData != null) {
                this.pasteFromIE = false;
                this.table.getTransferHandler().importData(this.table, this.clipboard.getContents(this.clipboard));
            } else {
                this.kit.beep();
            }
        } else if (source == this.pasteFromIEItem || source == this.pasteFromIEButton) {
            Transferable clipData = this.clipboard.getContents(this.clipboard);
            if (clipData != null) {
                this.pasteFromIE = true;
                this.table.getTransferHandler().importData(this.table, this.clipboard.getContents(this.clipboard));
            } else {
                this.kit.beep();
            }
        }
        this.cleanButton.setEnabled(this.table.getRowCount() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.cleanButton.setEnabled(this.table.getRowCount() > 0);
            int row = this.table.getSelectedRow();
            if (row != -1) {
                this.upButton.setEnabled(row > 0);
                this.downButton.setEnabled(row < this.sorter.getRowCount() - 1);
                Transferable clipData = this.clipboard.getContents(this.clipboard);
                this.copyButton.setEnabled(true);
                if (clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor) && this.table.convertColumnIndexToModel(this.table.getSelectedColumn()) != 0) {
                    this.pasteButton.setEnabled(true);
                    this.pasteFromIEButton.setEnabled(true);
                } else {
                    this.pasteButton.setEnabled(false);
                    this.pasteFromIEButton.setEnabled(false);
                }
            } else {
                this.pasteButton.setEnabled(false);
                this.copyButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            int[] rows = this.table.getSelectedRows();
            boolean deleteAllowed = true;
            for (int n : rows) {
                if (this.canDelete(this.model.getRow(this.sorter.modelIndex(n)))) continue;
                deleteAllowed = false;
                break;
            }
            this.deleteButton.setEnabled(rows.length > 0 && deleteAllowed);
        }
    }

    @Override
    public void commit() {
        this.finishEditing();
    }

    protected void initColumns() {
        JLabel l = new JLabel();
        l.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        TableColumnModel columnModel = this.table.getColumnModel();
        int cols = this.model.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            TableCellRenderer renderer;
            this.table.setColumnWidth(i, this.model.getColumnPrototypeName(i), this.model.isColumnWidthFixed(i), 4);
            TableColumn column = columnModel.getColumn(i);
            TableCellEditor editor = this.model.getColumnEditor(i);
            if (editor != null) {
                column.setCellEditor(editor);
            }
            if ((renderer = this.model.getColumnRenderer(i)) != null) {
                column.setCellRenderer(renderer);
            }
            if (!this.model.getColumnName(i).startsWith("<html>")) continue;
            column.setHeaderRenderer(this.table.getTableHeader().getDefaultRenderer());
        }
        this.table.validate();
    }

    @Override
    public void setFont(Font aFont) {
        super.setFont(aFont);
        if (aFont == null || this.table == null) {
            return;
        }
        this.table.setRowHeight(aFont.getSize() + 2);
        this.initColumns();
    }
}

