/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.SetupCode;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TextFileViewer
extends JDialog
implements ActionListener,
KeyListener {
    private File file = null;
    private JTextArea textArea = null;
    private boolean openedFromToolBar = false;
    private RMIRSetup remoteMaster = null;
    private Remote remote = null;
    private JButton saveButton = new JButton("Save");
    private JButton closeButton = new JButton("Close");

    private TextFileViewer(Component c, Remote remote, String title, boolean Editable) {
        super(c instanceof JDialog ? (JDialog)c : (JFrame)SwingUtilities.getRoot(c));
        this.file = remote.getFile();
        this.remote = remote;
        this.openedFromToolBar = c instanceof RMIRSetup;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        if (this.openedFromToolBar) {
            this.remoteMaster = (RMIRSetup)c;
        } else {
            this.setModal(true);
        }
        this.textArea = new JTextArea(30, 80);
        this.textArea.setEditable(this.file.canWrite());
        if (this.textArea.isEditable()) {
            this.textArea.addKeyListener(this);
        }
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.add((Component)scrollPane, "Center");
        JPanel footer = new JPanel(new FlowLayout(1));
        footer.add(this.saveButton);
        footer.add(this.closeButton);
        contentPane.add((Component)footer, "Last");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        FileReader in = null;
        try {
            in = new FileReader(this.file);
            this.textArea.read(in, this.file.toString());
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TextFileViewer showFile(Component locationComp, Remote remote, String title, boolean editable) {
        TextFileViewer viewer = new TextFileViewer(locationComp, remote, title, editable);
        viewer.pack();
        viewer.setLocationRelativeTo(locationComp);
        viewer.setVisible(true);
        return viewer;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.dispose();
        } else if (source == this.saveButton) {
            String title;
            String message = null;
            message = this.openedFromToolBar ? "Do you want to apply your changes?\n\nYes = save and apply changes\nNo = save changes without applying them\nCancel = abort the save operation" : "Are you sure you want to save your changes?";
            int response = JOptionPane.showConfirmDialog(this, message, title = "Confirm save", !this.openedFromToolBar ? 2 : 1, 3);
            if (response == 2) {
                return;
            }
            FileWriter out = null;
            try {
                out = new FileWriter(this.file);
                this.textArea.write(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.saveButton.setEnabled(false);
            if (this.openedFromToolBar && response == 0) {
                String rmTitle = this.remoteMaster.getTitle();
                RemoteConfiguration remoteConfig = this.remoteMaster.getRemoteConfiguration();
                remoteConfig.setSavedData();
                Remote newRemote = new Remote(this.remote, this.remote.getNameIndex());
                RemoteManager.getRemoteManager().replaceRemote(this.remote, newRemote);
                this.remote = newRemote;
                this.remote.load();
                remoteConfig.setRemote(this.remote);
                if (remoteConfig.hasSegments()) {
                    remoteConfig.setDeviceButtonSegments();
                    ArrayList<Activity> list = new ArrayList<Activity>();
                    LinkedHashMap<Button, Activity> activities = remoteConfig.getActivities();
                    if (activities != null) {
                        for (Activity activity : remoteConfig.getActivities().values()) {
                            activity.set(this.remote);
                            list.add(activity);
                        }
                        activities.clear();
                        for (Activity activity : list) {
                            activities.put(activity.getButton(), activity);
                        }
                    }
                }
                SetupCode.setMax(this.remote);
                remoteConfig.updateImage();
                RemoteConfiguration.resetDialogs();
                this.remoteMaster.update();
                this.remoteMaster.setTitle(rmTitle);
            } else if (response == 0) {
                Remote newRemote = new Remote(this.remote, this.remote.getNameIndex());
                RemoteManager.getRemoteManager().replaceRemote(this.remote, newRemote);
                this.remote = newRemote;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.saveButton.setEnabled(true);
    }
}

