/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextPopupMenu
extends JPopupMenu {
    private JTextComponent c = null;
    private JMenuItem copyItem = null;
    private JMenuItem cutItem = null;
    private JMenuItem pasteItem = null;
    private JMenuItem selectItem = null;

    TextPopupMenu(JTextComponent comp) {
        this.c = comp;
        this.c.setDragEnabled(true);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TextPopupMenu.this.c.requestFocusInWindow();
                    if (TextPopupMenu.this.cutItem == null) {
                        TextPopupMenu.this.initMenuItems();
                    }
                    boolean flag = TextPopupMenu.this.c.getSelectedText() != null;
                    TextPopupMenu.this.cutItem.setEnabled(flag && TextPopupMenu.this.c.isEditable());
                    TextPopupMenu.this.copyItem.setEnabled(flag);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable clipData = clipboard.getContents(clipboard);
                    TextPopupMenu.this.pasteItem.setEnabled(clipData != null && TextPopupMenu.this.c.getTransferHandler().canImport(TextPopupMenu.this.c, clipData.getTransferDataFlavors()));
                    Document doc = TextPopupMenu.this.c.getDocument();
                    TextPopupMenu.this.selectItem.setEnabled(doc != null && doc.getLength() != 0);
                    TextPopupMenu.this.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.c.addMouseListener(ml);
    }

    private void initMenuItems() {
        Action[] actions = this.c.getActions();
        Hashtable<String, Action> h = new Hashtable<String, Action>();
        for (int i = 0; i < actions.length; ++i) {
            String name = (String)actions[i].getValue("Name");
            if (!name.equals("cut-to-clipboard") && !name.equals("copy-to-clipboard") && !name.equals("paste-from-clipboard") && !name.equals("select-all")) continue;
            h.put(name, actions[i]);
        }
        this.cutItem = this.addItem((Action)h.get("cut-to-clipboard"), "Cut");
        this.copyItem = this.addItem((Action)h.get("copy-to-clipboard"), "Copy");
        this.pasteItem = this.addItem((Action)h.get("paste-from-clipboard"), "Paste");
        this.addSeparator();
        this.selectItem = this.addItem((Action)h.get("select-all"), "Select All");
    }

    private JMenuItem addItem(Action a, String text) {
        JMenuItem item = new JMenuItem(a);
        item.setText(text);
        this.add(item);
        return item;
    }
}

