/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.DaySchedule;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexReader;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.RMTime;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;

public class TimedMacro
extends AdvancedCode {
    private RMTime time = new RMTime();
    private DaySchedule daySchedule = new DaySchedule();
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm");

    public TimedMacro(DaySchedule daySchedule, RMTime time, Hex hex, String notes) {
        super(0, hex, notes);
        this.daySchedule = daySchedule;
        this.time = time;
    }

    public TimedMacro(int dayHour, int minuteByte, Hex hex, String notes) {
        super(0, hex, notes);
        Calendar c = Calendar.getInstance();
        c.set(11, dayHour & 0x1F);
        c.set(12, minuteByte & 0x3F);
        this.time.set(c.getTime());
        if ((dayHour >>= 5) == 0) {
            this.daySchedule.set7Days();
            this.daySchedule.setWeeklyRepeat(true);
        } else {
            this.daySchedule.set(2 + dayHour - 1, true);
            this.daySchedule.setWeeklyRepeat((minuteByte & 0x40) == 64);
        }
    }

    public TimedMacro(Properties props) {
        super(props);
        this.daySchedule.setMap(Integer.parseInt(props.getProperty("DaySchedule")));
        try {
            this.time.set(this.timeFormat.parse(props.getProperty("Time")));
        }
        catch (ParseException pe) {
            pe.printStackTrace(System.err);
        }
    }

    public static TimedMacro read(HexReader reader, Remote remote) {
        if (reader.available() < 4 || reader.peek() == remote.getSectionTerminator()) {
            return null;
        }
        int minuteByte = reader.read();
        int hourLength = reader.read();
        short dayByte = reader.read();
        Hex hex = new Hex(reader.read(hourLength & 0xF));
        boolean isPM = (minuteByte & 0x80) == 128;
        Calendar c = Calendar.getInstance();
        c.set(10, (hourLength >>= 4) % 12);
        c.set(9, isPM ? 1 : 0);
        c.set(12, minuteByte &= 0x3F);
        DaySchedule daySchedule = new DaySchedule(dayByte);
        RMTime time = new RMTime(c.getTime());
        TimedMacro timedMacro = new TimedMacro(daySchedule, time, hex, null);
        return timedMacro;
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] keys = this.data.getData();
        for (int i = 0; i < keys.length; ++i) {
            if (i != 0) {
                buff.append(';');
            }
            buff.append(remote.getButtonName(keys[i]));
        }
        return buff.toString();
    }

    @Override
    public int store(short[] buffer, int offset, Remote remote) {
        Calendar c = Calendar.getInstance();
        c.setTime(this.time.get());
        int minuteByte = c.get(12);
        int dataLength = this.data.length();
        if (remote.getTimedMacroAddress() != null) {
            int hourLength;
            if (c.get(9) == 1) {
                minuteByte |= 0x80;
            }
            if ((hourLength = c.get(10)) == 0) {
                hourLength = 12;
            }
            hourLength = (hourLength << 4) + dataLength;
            buffer[offset++] = (short)(minuteByte | 0x40);
            buffer[offset++] = (short)hourLength;
            buffer[offset++] = (short)this.daySchedule.getMap();
            Hex.put(this.data, buffer, offset);
            return offset + dataLength;
        }
        if (remote.getMacroCodingType().hasTimedMacros()) {
            int dayHour = 0;
            if (!this.daySchedule.isDaily()) {
                dayHour = (this.daySchedule.getFirstDay() - 2 + 7) % 7 + 1;
            }
            if (this.daySchedule.isWeeklyRepeat()) {
                minuteByte |= 0x40;
            }
            dayHour <<= 5;
            buffer[offset++] = (short)(dayHour |= c.get(11));
            buffer[offset++] = (short)(minuteByte | 0x80);
            buffer[offset++] = (short)dataLength;
            Hex.put(this.data, buffer, offset);
            return offset + dataLength;
        }
        return offset;
    }

    @Override
    public void store(PropertyWriter pw) {
        pw.print("DaySchedule", this.daySchedule.getMap());
        pw.print("Time", this.timeFormat.format(this.time.get()));
        pw.print("Data", this.data);
        if (this.notes != null && this.notes.length() > 0) {
            pw.print("Notes", this.notes);
        }
    }

    @Override
    public int getSize(Remote remote) {
        return this.data.length() + 3;
    }

    public RMTime getTime() {
        return this.time;
    }

    public void setTime(RMTime time) {
        this.time = time;
    }

    public DaySchedule getDaySchedule() {
        return this.daySchedule;
    }

    public void setDaySchedule(DaySchedule daySchedule) {
        this.daySchedule = daySchedule;
    }
}

