/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.DaySchedule;
import com.hifiremote.jp1.DayScheduleBox;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.RMTime;
import com.hifiremote.jp1.RMTimePanel;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.TimedMacro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TimedMacroDialog
extends JDialog
implements ActionListener,
ButtonEnabler {
    private static TimedMacroDialog dialog = null;
    private TimedMacro timedMacro = null;
    private RemoteConfiguration config = null;
    private MacroDefinitionBox macroBox = null;
    private DayScheduleBox dayScheduleBox = null;
    private JTextArea notes = new JTextArea(2, 10);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private RMTimePanel timePanel = null;

    public static TimedMacro showDialog(Component locationComp, TimedMacro timedMacro, RemoteConfiguration config) {
        if (dialog == null || config != TimedMacroDialog.dialog.config) {
            dialog = new TimedMacroDialog(locationComp);
        }
        dialog.setRemoteConfiguration(config);
        dialog.setTimedMacro(timedMacro);
        dialog.pack();
        dialog.setLocationRelativeTo(locationComp);
        dialog.setVisible(true);
        return TimedMacroDialog.dialog.timedMacro;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private TimedMacroDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Timed Macro");
        this.setModal(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box settingsBox = Box.createHorizontalBox();
        contentPane.add((Component)settingsBox, "North");
        this.dayScheduleBox = new DayScheduleBox();
        settingsBox.add(this.dayScheduleBox);
        this.timePanel = new RMTimePanel();
        settingsBox.add(this.timePanel);
        this.macroBox = new MacroDefinitionBox(false);
        this.macroBox.setButtonEnabler(this);
        contentPane.add((Component)this.macroBox, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        panel = new JPanel(new FlowLayout(2));
        bottomPanel.add((Component)panel, "South");
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        if (this.config == config) {
            return;
        }
        this.config = config;
        this.macroBox.setRemoteConfiguration(config);
    }

    private void setTimedMacro(TimedMacro timedMacro) {
        this.timedMacro = null;
        if (timedMacro == null) {
            DaySchedule defaultDaySchedule = new DaySchedule();
            if (this.config != null && this.config.getRemote().getMacroCodingType().hasTimedMacros()) {
                defaultDaySchedule.set(2, true);
            }
            this.dayScheduleBox.setValue(defaultDaySchedule);
            this.timePanel.setValue(new RMTime());
            this.macroBox.setValue((Object)null);
            this.notes.setText(null);
        } else {
            this.dayScheduleBox.setValue(timedMacro.getDaySchedule());
            this.timePanel.setValue(timedMacro.getTime());
            this.macroBox.setValue(timedMacro.getData());
            this.notes.setText(timedMacro.getNotes());
        }
        this.macroBox.enableButtons();
    }

    @Override
    public void enableButtons(Button b, MacroDefinitionBox macroBox) {
        int limit = 15;
        if (this.config.getRemote().getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
            limit = 255;
        }
        boolean canAdd = b != null && macroBox.isMoreRoom(limit);
        macroBox.add.setEnabled(canAdd && b.canAssignToTimedMacro());
        macroBox.insert.setEnabled(canAdd && b.canAssignToTimedMacro());
        macroBox.addShift.setEnabled(canAdd && b.canAssignShiftedToTimedMacro());
        macroBox.insertShift.setEnabled(canAdd && b.canAssignShiftedToTimedMacro());
        boolean xShiftEnabled = this.config.getRemote().getXShiftEnabled();
        macroBox.addXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToTimedMacro());
        macroBox.insertXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToTimedMacro());
    }

    @Override
    public boolean isAvailable(Button b) {
        return this.config.getRemote().getDistinctButtons().contains(b) && (b.canAssignToTimedMacro() || b.canAssignShiftedToTimedMacro() || b.canAssignXShiftedToTimedMacro());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            if (this.macroBox.isEmpty()) {
                this.showWarning("You haven't included any keys in your macro!");
                return;
            }
            DaySchedule daySchedule = this.dayScheduleBox.getValue();
            RMTime time = this.timePanel.getValue();
            Hex data = (Hex)this.macroBox.getValue();
            String notesStr = this.notes.getText();
            if (time == null) return;
            this.timedMacro = new TimedMacro(daySchedule, time, data, notesStr);
            this.setVisible(false);
            return;
        } else {
            if (source != this.cancelButton) return;
            this.timedMacro = null;
            this.setVisible(false);
        }
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Missing Information", 0);
    }
}

