/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DaySchedule;
import com.hifiremote.jp1.DayScheduleBox;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RMSetterEditor;
import com.hifiremote.jp1.RMTime;
import com.hifiremote.jp1.RMTimePanel;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.TimedMacro;
import java.awt.Color;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TimedMacroTableModel
extends JP1TableModel<TimedMacro> {
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Every Mon;Tue;Wed;Thu;Fri", "00:00_", "A reasonable length macro with a reasonable number of steps ", "A reasonable length note for a macro", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, DaySchedule.class, RMTime.class, String.class, String.class, Color.class};
    private static final boolean[] colWidths = new boolean[]{true, false, true, false, false, true};
    private static final String[] colNames = new String[]{"#", "Days", "Time", "Macro Keys", "Notes", "<html>Size &amp<br>Color</html>"};
    private RemoteConfiguration remoteConfig = null;
    private RMSetterEditor<DaySchedule, DayScheduleBox> dayScheduleEditor = new RMSetterEditor(DayScheduleBox.class);
    private RMSetterEditor<RMTime, RMTimePanel> timeEditor = new RMSetterEditor(RMTimePanel.class);
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.setData(remoteConfig.getTimedMacros());
            this.dayScheduleEditor.setRemoteConfiguration(remoteConfig);
            this.dayScheduleEditor.setTitle("Day Schedule Setter");
            this.timeEditor.setRemoteConfiguration(remoteConfig);
            this.timeEditor.setTitle("Time Setter");
        }
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (col == 1) {
            return this.dayScheduleEditor;
        }
        if (col == 2) {
            return this.timeEditor;
        }
        if (col == 5) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 && col != 3;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 5) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        TimedMacro timedMacro = this.remoteConfig.getTimedMacros().get(row);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return timedMacro.getDaySchedule();
            }
            case 2: {
                return timedMacro.getTime();
            }
            case 3: {
                return timedMacro.getValueString(this.remoteConfig);
            }
            case 4: {
                return timedMacro.getNotes();
            }
            case 5: {
                return timedMacro.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimedMacro timedMacro = (TimedMacro)this.getRow(row);
        if (col == 1) {
            timedMacro.setDaySchedule((DaySchedule)value);
        } else if (col == 2) {
            timedMacro.setTime((RMTime)value);
        } else if (col == 4) {
            timedMacro.setNotes((String)value);
        } else if (col == 5) {
            timedMacro.setHighlight((Color)value);
        }
        this.propertyChangeSupport.firePropertyChange(col == 5 ? "highlight" : "data", null, null);
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }
}

