/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.util.Properties;

public class ToadTogFunction
extends SpecialProtocolFunction {
    public static int TOGGLE = 0;
    public static int FORCE_OFF = 1;
    public static int TEST_ONLY = 2;
    public static int FORCE_ON = 3;
    public static String[] styleStrings = new String[]{"Toggle", "ForceOff", "TestOnly", "ForceOn"};
    public static String[] onStrings = new String[]{"On->Off", "On->Off", "On", "Already On"};
    public static String[] offStrings = new String[]{"Off->On", "Already Off", "Off", "Off->On"};

    public ToadTogFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public ToadTogFunction(Macro macro) {
        super(macro);
    }

    public ToadTogFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public ToadTogFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    public int getToggleNumber() {
        return (this.getCmd().getData()[0] & 0x70) >> 4;
    }

    public int getOnLength() {
        return this.getCmd().getData()[0] & 7;
    }

    public int getStyle() {
        short val = this.getCmd().getData()[0];
        int style = (val & 0x80) >> 6;
        return style |= (val & 8) >> 3;
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        int style = this.getStyle();
        StringBuilder buff = new StringBuilder();
        buff.append(this.getUserFunctions(remoteConfig)[0]);
        buff.append('(');
        buff.append(Integer.toString(this.getToggleNumber()));
        buff.append(',');
        buff.append(styleStrings[style]);
        buff.append(')');
        return buff.toString();
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        int i;
        Remote remote = remoteConfig.getRemote();
        int style = this.getStyle();
        short[] keyCodes = this.getCmd().getData();
        StringBuilder buff = new StringBuilder();
        buff.append('[');
        buff.append(onStrings[style]);
        buff.append("]:");
        if (this.getOnLength() == 0) {
            buff.append("<none>");
        }
        boolean first = true;
        for (i = 0; i < this.getOnLength(); ++i) {
            if (first) {
                first = false;
            } else {
                buff.append(';');
            }
            buff.append(remote.getButtonName(keyCodes[i + 1]));
        }
        buff.append(" [");
        buff.append(offStrings[style]);
        buff.append("]:");
        if (i == keyCodes.length - 1) {
            buff.append("<none>");
        }
        first = false;
        while (i < keyCodes.length - 1) {
            if (first) {
                first = false;
            } else {
                buff.append(';');
            }
            buff.append(remote.getButtonName(keyCodes[i + 1]));
            ++i;
        }
        return buff.toString();
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        int i;
        dlg.setToggle(this.getToggleNumber());
        dlg.setCondition(this.getStyle());
        short[] keyCodes = this.getCmd().getData();
        int length = this.getOnLength();
        Integer[] temp = new Integer[length];
        int offset = 1;
        for (i = 0; i < length; ++i) {
            temp[i] = new Integer(keyCodes[offset++]);
        }
        dlg.setFirstMacroButtons(temp);
        length = keyCodes.length - length - 1;
        temp = new Integer[length];
        for (i = 0; i < length; ++i) {
            temp[i] = new Integer(keyCodes[offset++]);
        }
        dlg.setSecondMacroButtons(temp);
    }

    public static Hex createHex(SpecialFunctionDialog dlg) {
        int i;
        int toggle = dlg.getToggle();
        int condition = dlg.getCondition();
        Integer[] firstKeyCodes = dlg.getFirstMacroButtons();
        Integer[] secondKeyCodes = dlg.getSecondMacroButtons();
        short[] temp = new short[1 + firstKeyCodes.length + secondKeyCodes.length];
        temp[0] = (short)((condition & 2) << 6 | (condition & 1) << 3 | toggle << 4 | firstKeyCodes.length);
        int offset = 1;
        for (i = 0; i < firstKeyCodes.length; ++i) {
            temp[offset++] = firstKeyCodes[i].shortValue();
        }
        for (i = 0; i < secondKeyCodes.length; ++i) {
            temp[offset++] = secondKeyCodes[i].shortValue();
        }
        return new Hex(temp);
    }
}

