/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.HexEditorNode;
import com.hifiremote.jp1.HexParmEditorNode;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import com.hifiremote.jp1.TranslatorEditorNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TranslatorEditorPanel
extends ProtocolEditorPanel
implements ActionListener,
TableColumnModelListener,
AdjustmentListener,
ChangeListener {
    private TranslatorEditorNode node = null;
    private JRadioButton msb = null;
    private JRadioButton lsb = null;
    private JCheckBox comp = null;
    private JTableX parmTable = null;
    private Box dataBox = null;
    private JTableX dataTable = null;
    private MyScrollBar dataBar = null;
    private JSpinner adjustment = null;

    public TranslatorEditorPanel() {
        super("Translator");
        Box outerBox = Box.createVerticalBox();
        this.add((Component)outerBox, "Center");
        Box box = Box.createVerticalBox();
        outerBox.add(box);
        TitledBorder border = BorderFactory.createTitledBorder("Bit order");
        box.setBorder(border);
        box.setAlignmentX(0.0f);
        this.msb = new JRadioButton("MSB (Most Significant Bit first)");
        this.msb.addActionListener(this);
        box.add(this.msb);
        box.add(Box.createVerticalStrut(5));
        this.lsb = new JRadioButton("LSB (Least Significant Bit first)");
        this.lsb.addActionListener(this);
        box.add(this.lsb);
        ButtonGroup group = new ButtonGroup();
        group.add(this.msb);
        group.add(this.lsb);
        outerBox.add(Box.createVerticalStrut(5));
        Box innerBox = Box.createVerticalBox();
        outerBox.add(innerBox);
        Insets insets = border.getBorderInsets(box);
        innerBox.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, 0));
        this.comp = new JCheckBox("Complement");
        this.comp.setToolTipText("Select this if the parameter should be complemented during translation");
        this.comp.setAlignmentX(0.0f);
        this.comp.addActionListener(this);
        innerBox.add(this.comp);
        innerBox.add(Box.createVerticalStrut(10));
        JLabel label = new JLabel("Parameter bits to be translated:");
        label.setAlignmentX(0.0f);
        innerBox.add(label);
        this.parmTable = new JTableX(new ParmDefaultTableModel(8));
        ((DefaultTableCellRenderer)this.parmTable.getDefaultRenderer(Integer.class)).setHorizontalAlignment(0);
        this.parmTable.setCellSelectionEnabled(false);
        this.parmTable.setRowSelectionAllowed(false);
        this.parmTable.setColumnSelectionAllowed(true);
        this.parmTable.setAlignmentX(0.0f);
        this.parmTable.getColumnModel().addColumnModelListener(this);
        innerBox.add(this.parmTable);
        innerBox.add(Box.createVerticalStrut(10));
        innerBox.add(new JLabel("Bits to receive the translated parameter bits:"));
        this.dataBar = new MyScrollBar(0, 0, 8, 0, 24);
        this.dataBar.addAdjustmentListener(this);
        this.dataBar.setAlignmentX(0.0f);
        this.dataBar.setAlignmentY(0.0f);
        int h = this.dataBar.getMinimumSize().height;
        innerBox.add(this.dataBar);
        this.dataBox = Box.createHorizontalBox();
        this.dataBox.add(Box.createHorizontalStrut(h));
        this.dataTable = new JTableX(new DataDefaultTableModel(24));
        ((DefaultTableCellRenderer)this.dataTable.getDefaultRenderer(Integer.class)).setHorizontalAlignment(0);
        this.dataTable.setCellSelectionEnabled(false);
        this.dataTable.setRowSelectionAllowed(false);
        this.dataTable.setColumnSelectionAllowed(true);
        this.dataTable.setAlignmentX(0.0f);
        this.dataTable.setAlignmentY(0.0f);
        this.dataBox.add(this.dataTable);
        this.dataBox.add(Box.createHorizontalStrut(h));
        this.dataBox.setAlignmentX(0.0f);
        innerBox.add(this.dataBox);
        this.adjustSizes();
        innerBox.add(Box.createVerticalStrut(10));
        box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(new JLabel("Adjustment:"));
        this.adjustment = new JSpinner(new SpinnerNumberModel(0, -8, 8, 1));
        this.adjustment.setMaximumSize(this.adjustment.getPreferredSize());
        this.adjustment.setToolTipText("This value is added to the parameter before translation occurs.");
        box.add(Box.createHorizontalStrut(5));
        box.add(this.adjustment);
        this.adjustment.addChangeListener(this);
        box.setMaximumSize(box.getPreferredSize());
        innerBox.add(box);
        this.setText("Translators are used to store the value a user enters for a parameter in the appropriate bits of the protocol data.");
    }

    private void adjustSizes() {
        int h = this.dataBar.getMinimumSize().height;
        JLabel label = new JLabel("111");
        int w = label.getPreferredSize().width;
        TableColumnModel model = this.parmTable.getColumnModel();
        for (int i = 0; i < this.parmTable.getColumnCount(); ++i) {
            TableColumn col = model.getColumn(i);
            col.setPreferredWidth(w);
            col.setMaxWidth(w);
            col.setMinWidth(w);
        }
        Dimension d = this.parmTable.getPreferredSize();
        this.parmTable.setMaximumSize(d);
        this.parmTable.setMinimumSize(d);
        model = this.dataTable.getColumnModel();
        for (int i = 0; i < this.dataTable.getColumnCount(); ++i) {
            TableColumn col = model.getColumn(i);
            col.setPreferredWidth(w);
            col.setMaxWidth(w);
            col.setMinWidth(w);
        }
        d = this.dataTable.getPreferredSize();
        this.dataTable.setMaximumSize(d);
        this.dataTable.setMinimumSize(d);
        d.width += h;
        d.width += h;
        this.dataBox.setMaximumSize(d);
        this.dataBox.setMinimumSize(d);
        Dimension s = this.dataBar.getPreferredSize();
        s.width = d.width;
        this.dataBar.setMaximumSize(s);
        this.dataBar.setMinimumSize(s);
    }

    @Override
    public void update(ProtocolEditorNode aNode) {
        this.node = (TranslatorEditorNode)aNode;
        if (this.node.getBitOrder() == 0) {
            this.msb.setSelected(true);
        } else {
            this.lsb.setSelected(true);
        }
        this.comp.setSelected(this.node.getComp());
        HexParmEditorNode parm = (HexParmEditorNode)this.node.getParent();
        int parmBits = parm.getBits();
        this.parmTable.getColumnModel().removeColumnModelListener(this);
        this.parmTable.clearSelection();
        ((ParmDefaultTableModel)this.parmTable.getModel()).setCols(parmBits);
        HexEditorNode hex = (HexEditorNode)parm.getParent();
        int hexBits = hex.getHex().length() * 8;
        ((DataDefaultTableModel)this.dataTable.getModel()).setCols(hexBits);
        int lastCol = parmBits - this.node.getLSBOffset() - 1;
        int firstCol = lastCol - this.node.getBits() + 1;
        this.parmTable.addColumnSelectionInterval(firstCol, lastCol);
        this.parmTable.getColumnModel().addColumnModelListener(this);
        this.dataBar.removeAdjustmentListener(this);
        this.dataBar.setValues(this.node.getMSBOffset(), this.node.getBits(), 0, hexBits);
        this.dataBar.addAdjustmentListener(this);
        this.adjustSizes();
        this.adjustment.setValue(new Integer(this.node.getAdjust()));
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.msb) {
            this.node.setBitOrder(0);
        } else if (source == this.lsb) {
            this.node.setBitOrder(1);
        } else if (source == this.comp) {
            this.node.setComp(this.comp.isSelected());
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] selection = this.parmTable.getSelectedColumns();
        int bits = selection.length;
        int firstCol = 100;
        int lastCol = 0;
        for (int i = 0; i < bits; ++i) {
            int col = selection[i];
            if (col < firstCol) {
                firstCol = col;
            }
            if (col <= lastCol) continue;
            lastCol = col;
        }
        this.node.setBits(bits);
        this.node.setLSBOffset(this.parmTable.getColumnCount() - lastCol - 1);
        HexParmEditorNode parm = (HexParmEditorNode)this.node.getParent();
        HexEditorNode hex = (HexEditorNode)parm.getParent();
        int hexBits = hex.getHex().length() * 8;
        if (this.dataBar.getValue() + bits > hexBits) {
            this.dataBar.setValue(hexBits - bits);
        }
        this.dataBar.setVisibleAmount(bits);
        this.dataBar.setBlockIncrement(bits);
        this.dataBar.validate();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        this.node.setMSBOffset(value);
        this.dataTable.clearSelection();
        this.dataTable.addColumnSelectionInterval(value, value + this.node.getBits() - 1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.adjustment && this.node != null) {
            this.node.setAdjust((Integer)this.adjustment.getValue());
        }
    }

    private class MyScrollBar
    extends JScrollBar {
        private Dimension max;
        private Dimension min;

        public MyScrollBar(int orientation, int value, int extent, int min, int max) {
            super(orientation, value, extent, min, max);
            this.max = null;
            this.min = null;
        }

        @Override
        public Dimension getMaximumSize() {
            if (this.max != null) {
                return this.max;
            }
            return super.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.min != null) {
                return this.min;
            }
            return super.getMinimumSize();
        }

        @Override
        public void setMaximumSize(Dimension size) {
            this.max = size;
        }

        @Override
        public void setMinimumSize(Dimension size) {
            this.min = size;
        }

        @Override
        public void setSize(int width, int height) {
            if (height < this.min.height) {
                height = this.min.height;
            }
            if (width < this.min.width) {
                width = this.min.width;
            }
            if (height > this.max.height) {
                height = this.max.height;
            }
            if (width > this.max.width) {
                width = this.max.width;
            }
            super.setSize(width, height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (height < this.min.height) {
                height = this.min.height;
            }
            if (width < this.min.width) {
                width = this.min.width;
            }
            if (height > this.max.height) {
                height = this.max.height;
            }
            if (width > this.max.width) {
                width = this.max.width;
            }
            super.setBounds(x, y, width, height);
        }
    }

    private class ParmDefaultTableModel
    extends AbstractTableModel {
        private int cols;

        public ParmDefaultTableModel(int cols) {
            this.cols = cols;
        }

        public void setCols(int cols) {
            this.cols = cols;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return this.cols;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Integer.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return new Integer(this.cols - col - 1);
        }
    }

    private class DataDefaultTableModel
    extends ParmDefaultTableModel {
        public DataDefaultTableModel(int cols) {
            super(cols);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return new Integer(col);
        }
    }
}

