/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.util.Properties;

public class ULDKPFunction
extends SpecialProtocolFunction {
    public static int DSM = 0;
    public static int LKP = 1;
    public static int DKP = 2;
    public static final String[] typeStrings = new String[]{"UDSM", "ULKP", "UDKP"};
    public static final String[] styleStrings = new String[]{"DSM", "LKP", "DKP"};
    public static final String[] firstStrings = new String[]{null, "Short", "Single"};
    public static final String[] secondStrings = new String[]{null, "Long", "Double"};

    public ULDKPFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public ULDKPFunction(Macro macro) {
        super(macro);
    }

    public ULDKPFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public ULDKPFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    public int getDuration() {
        return this.getCmd().getData()[0] & 0xF;
    }

    public int getStyle() {
        return this.getCmd().getData()[0] >> 4;
    }

    public int getFirstKeyCode() {
        return this.getCmd().getData()[1];
    }

    public int getSecondKeyCode() {
        return this.getCmd().getData()[2];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        int duration = this.getDuration();
        int style = this.getStyle();
        StringBuilder buff = new StringBuilder();
        buff.append(this.getUserFunctions(remoteConfig)[style]);
        if (style == DSM) {
            return buff.toString();
        }
        buff.append('(');
        buff.append(Integer.toString(duration));
        buff.append(')');
        return buff.toString();
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[this.getStyle()];
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        int style = this.getStyle();
        int macroKey = this.getFirstKeyCode();
        String keyName = remote.getButtonName(macroKey);
        if (style == DSM) {
            return keyName;
        }
        StringBuilder buff = new StringBuilder();
        buff.append('[');
        buff.append(firstStrings[style]);
        buff.append("]:");
        buff.append(keyName);
        buff.append(" [");
        buff.append(secondStrings[style]);
        buff.append("]:");
        buff.append(remote.getButtonName(this.getSecondKeyCode()));
        return buff.toString();
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        int style = this.getStyle();
        int keyCode = this.getFirstKeyCode();
        if (style == DSM) {
            dlg.setMacroKey(keyCode);
            return;
        }
        dlg.setFirstMacroKey(keyCode);
        dlg.setSecondMacroKey(this.getSecondKeyCode());
    }

    public static Hex createHex(SpecialFunctionDialog dlg) {
        String type = dlg.get_Type();
        int style = DSM;
        for (int i = 0; i < styleStrings.length; ++i) {
            if (!styleStrings[i].equals(type)) continue;
            style = i;
            break;
        }
        short[] temp = new short[3];
        temp[0] = (short)(style << 4);
        if (style == DSM) {
            temp[1] = (short)dlg.getMacroKey();
            temp[2] = 0;
            return new Hex(temp);
        }
        temp[0] = (short)(temp[0] | (short)dlg.getULDKPDuration());
        temp[1] = (short)dlg.getFirstMacroKey();
        temp[2] = (short)dlg.getSecondMacroKey();
        return new Hex(temp);
    }
}

