/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import org.harctoolbox.ircore.IrSignal;

public class UnpackLearned {
    public boolean ok;
    public String error;
    public int frequency;
    public int[] bursts;
    public int[] durations;
    public int oneTime;
    public int repeat;
    public int extra;
    public int[] parts;
    public boolean[] partTypes;
    private final int[] romBurstsA = new int[]{419, 19073, 1679, 1680, 419, 1270, 419, 420, 210, 44812, 210, 17671, 631, 211, 210, 632, 131, 22683, 131, 923, 131, 393, 131, 23919, 131, 21799, 131, 923, 131, 393, 9, 64704, 9, 140, 9, 90, 9, 40, 9999, 2000, 499, 4000, 1999, 2000, 249, 1000, 249, 500, 280, 24777, 2249, 2250, 280, 845, 280, 281, 280, 20255, 4499, 2250, 280, 845, 280, 281, 280, 48669, 280, 23652, 2249, 2250, 280, 845, 280, 281, 280, 48358, 280, 20257, 4499, 2250, 4499, 1125, 280, 845, 280, 281, 280, 48358, 280, 22510, 4499, 2250, 4499, 1125, 280, 845, 280, 281, 280, 47253, 280, 11916, 4499, 2250, 280, 845, 280, 281, 266, 60990, 266, 10298, 266, 1335, 266, 534, 266, 267, 266, 60990, 266, 10298, 266, 1335, 533, 534, 266, 534, 266, 267, 266, 60990, 266, 10298, 242, 1335, 533, 534, 533, 267, 266, 534, 266, 267, 444, 45311, 889, 445, 444, 445, 444, 45311, 889, 445, 444, 890, 444, 445, 444, 45311, 889, 890, 889, 445, 444, 890, 444, 445, 9, 65535, 9, 7777, 9, 6222, 9, 4664, 9, 3106, 9, 1548, 9, 31589, 9, 4300, 9, 2860, 107, 65535, 107, 7679, 107, 6124, 107, 4566, 107, 3008, 107, 1450, 19, 31579, 19, 4290, 19, 2850};
    private final int[] romIndexA = new int[]{48, 56, 64, 74, 86, 8, 98, 16, 22, 30, 144, 150, 158, 108, 118, 130, 0, 38, 168, 170, 180, 186, 188, 198};
    private final int[] romPeriodsA = new int[]{18, 18, 20};
    private final int[] romBurstsB = new int[]{352, 24777, 2736, 2250, 352, 845, 352, 281, 352, 20255, 5472, 2250, 352, 845, 352, 281, 352, 48669, 352, 23652, 2736, 2250, 352, 845, 352, 281, 352, 48358, 352, 20257, 5472, 2250, 5472, 1125, 352, 845, 352, 281, 352, 48358, 352, 22510, 5472, 2250, 5472, 1125, 352, 845, 352, 281, 256, 44812, 256, 17671, 768, 211, 256, 632, 336, 47253, 336, 11916, 5456, 2250, 336, 845, 336, 281, 160, 22683, 160, 923, 160, 393, 160, 23919, 160, 21799, 160, 923, 160, 393, 160, 64704, 160, 140, 160, 90, 160, 40, 512, 45311, 1024, 445, 512, 445, 512, 45311, 1024, 445, 512, 890, 512, 445, 512, 45311, 1024, 890, 1024, 445, 512, 890, 512, 445, 256, 60990, 256, 10298, 256, 1335, 256, 534, 256, 267, 256, 60990, 256, 10298, 256, 1335, 512, 534, 256, 534, 256, 267, 256, 60990, 256, 10298, 256, 1335, 512, 534, 512, 267, 256, 534, 256, 267, 768, 19073, 3072, 1680, 768, 1270, 768, 420, 18192, 2000, 896, 4000, 3632, 2000, 448, 1000, 448, 500, 160, 44217, 160, 2670, 160, 1785, 160, 48629, 160, 20528, 160, 6740, 160, 5615, 160, 1116, 160, 552, 160, 65535, 160, 7777, 160, 6222, 160, 4664, 160, 3106, 160, 1548, 160, 7777, 160, 6222, 160, 4664, 160, 3106, 160, 1548, 160, 31589, 160, 4300, 160, 2860, 160, 21016, 160, 87, 160, 70, 160, 52, 160, 35, 160, 20448, 160, 87, 160, 68, 160, 52, 160, 34, 160, 16021, 160, 3776, 160, 2515, 160, 16111, 160, 499, 160, 246, 160, 12899, 160, 6373, 160, 1054, 160, 523, 160, 65535, 160, 62508, 160, 510, 160, 419, 160, 330, 160, 243, 160, 62508, 160, 510, 160, 419, 160, 330, 160, 243, 160, 17090, 160, 7802, 160, 6240, 160, 4677, 160, 3115, 160, 1552, 160, 25028, 160, 7802, 160, 6240, 160, 4677, 160, 3115, 160, 1552, 256, 44223, 256, 2660, 256, 1775, 4096, 48358, 4096, 20257, 61712, 2250, 61712, 1125, 4096, 845, 4096, 281, 1601, 18959, 1600, 7679, 1600, 6124, 1600, 4566, 1600, 3008, 1600, 1450, 1600, 7679, 1600, 6124, 1600, 4566, 1600, 3008, 1600, 1450, 160, 31579, 160, 4290, 160, 2850, 208, 21011, 208, 82, 208, 65, 208, 47, 208, 30, 272, 20440, 272, 79, 272, 60, 272, 44, 272, 26, 176, 16019, 176, 3774, 176, 2513, 1520, 16019, 1520, 407, 1520, 154, 8528, 12643, 65520, 2127, 8528, 798, 8528, 267, 262, 14284, 256, 62500, 256, 502, 256, 411, 256, 322, 256, 233, 256, 62500, 256, 502, 256, 411, 256, 322, 256, 233, 1472, 17000, 1472, 7712, 1472, 6150, 1472, 4587, 1472, 3025, 1472, 1462, 1984, 24938, 1472, 7712, 1472, 6150, 1472, 4587, 1472, 3025, 1472, 1462};
    private final int[] romIndexB = new int[]{0, 8, 16, 26, 38, 50, 58, 68, 74, 82, 90, 96, 104, 114, 124, 136, 150, 158, 168, 174, 186, 198, 208, 214, 224, 234, 240, 246, 254, 266, 276, 288, 300, 306, 318, 330, 340, 346, 356, 366, 372, 378, 386, 398, 408, 420};
    private final int[] romPeriodsB = new int[]{20, 18, 18, 18, 20, 18, 18, 18, 18, 8, 18, 18, 18, 18};
    public static final int[] clockMHz = new int[]{8, 12, 4, 10, 8};
    public static final int[] zeroPeriods = new int[]{0, 16, 8, 20, 0};

    public UnpackLearned(Hex hex, int format) {
        if (format > 4) {
            this.ok = false;
            this.error = "Format=" + format + " not supported";
            return;
        }
        this.ok = true;
        this.error = "";
        if (hex == null || hex.length() < 5) {
            this.ok = false;
            this.error = "hex learned signal too short to unpack";
            return;
        }
        int period = hex.get(format == 3 ? 1 : 0);
        this.frequency = period == 0 || period == zeroPeriods[format] ? 0 : (int)((double)clockMHz[format] * 1000000.0 / (double)period + 0.5);
        int offset = this.loadBurstTable(hex, format);
        if (this.ok) {
            this.loadDurations(hex, offset);
        }
    }

    public UnpackLearned(IrSignal signal) {
        this.frequency = (int)signal.getFrequency().longValue();
        this.oneTime = signal.getIntroLength();
        this.repeat = signal.getRepeatLength();
        this.extra = signal.getEndingLength();
        this.durations = new int[this.oneTime + this.repeat + this.extra];
        System.arraycopy(signal.getIntroInts(), 0, this.durations, 0, this.oneTime);
        System.arraycopy(signal.getRepeatInts(), 0, this.durations, this.oneTime, this.repeat);
        System.arraycopy(signal.getEndingInts(), 0, this.durations, this.oneTime + this.repeat, this.extra);
        this.error = "";
        this.bursts = new int[0];
        this.ok = true;
    }

    public String toString() {
        return UnpackLearned.durationsToString(this.bursts, "");
    }

    public static String durationsToString(int[] data, String sep) {
        StringBuilder str = new StringBuilder();
        if (data != null && data.length != 0) {
            boolean isSigned = false;
            for (int d : data) {
                if (d >= 0) continue;
                isSigned = true;
                break;
            }
            for (int i = 0; i < data.length; ++i) {
                if (i > 0) {
                    str.append(' ');
                }
                if (!isSigned) {
                    str.append((i & 1) == 0 ? "+" : "-");
                } else if (data[i] > 0) {
                    str.append('+');
                }
                str.append(data[i]);
                if (i <= 0 || i % 2 != 1) continue;
                str.append(sep);
            }
        }
        if (str.length() == 0) {
            return "** No signal **";
        }
        return str.toString();
    }

    public static double[] getBurstUnits(int format, int freq) {
        if (freq == 0) {
            double mult = format == 1 ? 1.3333333333333333 : 2.0;
            return new double[]{mult, mult};
        }
        double multOn = format == 0 || format == 4 ? 2.0 : 1000000.0 / (double)freq;
        double multOff = (new double[]{2.0, 1.3333333333333333, multOn, 2.0, 2.0})[format];
        return new double[]{multOn, multOff};
    }

    private int[] getBurstTimes(int[] val, int format) {
        int[] times = new int[2];
        boolean split35 = format == 1 || format == 2 || format == 3;
        double[] mult = UnpackLearned.getBurstUnits(format, this.frequency);
        int on = val[0] >> (split35 ? 4 : 0);
        times[0] = (int)((double)on * mult[0] + 0.5);
        int off = val[1] + (split35 ? (val[0] & 0xF) << 16 : 0);
        times[1] = (int)((double)off * mult[1] + 0.5);
        return times;
    }

    private int loadBurstTable(Hex hex, int format) {
        int result;
        int mask;
        int burstNum = hex.getData()[format == 3 ? 0 : 2];
        int n = mask = format == 3 ? 64 : 128;
        if ((burstNum & mask) != 0) {
            int count;
            result = 3;
            int[] romBursts = format == 0 ? this.romBurstsA : this.romBurstsB;
            int[] romIndex = format == 0 ? this.romIndexA : this.romIndexB;
            int[] romPeriods = format == 0 ? this.romPeriodsA : this.romPeriodsB;
            if (format == 0 && (burstNum &= 0x1F) >= 21) {
                this.ok = false;
                this.error = "ROM burst index out of range";
                return 0;
            }
            if (burstNum >= 18) {
                this.frequency = (int)(8000000.0 / (double)romPeriods[burstNum - 18] + 0.5);
                burstNum += format == 0 ? 3 : 14;
            }
            if ((count = romBursts.length - (burstNum = romIndex[burstNum])) > 32) {
                count = 32;
            }
            this.bursts = new int[count];
            while (count > 1) {
                int[] val = new int[]{romBursts[(count -= 2) + burstNum], romBursts[count + burstNum + 1]};
                int[] times = this.getBurstTimes(val, romBursts == this.romBurstsA ? 0 : 3);
                this.bursts[count] = times[0];
                this.bursts[count + 1] = times[1];
            }
        } else {
            if ((burstNum & 0xE0) != 0) {
                this.ok = false;
                this.error = "burst number byte has unexpected flag";
                return 0;
            }
            if (burstNum != 0) {
                result = burstNum * 4 + 3;
                if (result >= hex.length()) {
                    this.ok = false;
                    this.error = "burst table extends beyond end of hex";
                    return 0;
                }
                this.bursts = new int[burstNum * 2];
                for (int i = 0; i < burstNum; ++i) {
                    int[] val = new int[]{hex.get(4 * i + 3), hex.get(4 * i + 5)};
                    int[] times = this.getBurstTimes(val, format);
                    this.bursts[2 * i] = times[0];
                    this.bursts[2 * i + 1] = times[1];
                }
            } else {
                this.ok = false;
                this.error = "00 found where burst table expected";
                return 0;
            }
        }
        return result;
    }

    private void loadDurations(Hex hex, int offset) {
        int count;
        int partNdx = 0;
        int total = 0;
        int ndx = offset;
        while (ndx != hex.length()) {
            count = hex.getData()[ndx] & 0x7F;
            if (count == 0) {
                this.ok = false;
                this.error = "burst index count is zero";
                return;
            }
            total += count * 2;
            if ((ndx += count + 3 >> 1) > hex.length()) {
                this.ok = false;
                this.error = "duration list extends beyonds hex data";
                return;
            }
            ++partNdx;
        }
        this.durations = new int[total];
        this.parts = new int[partNdx];
        this.partTypes = new boolean[partNdx];
        total = 0;
        partNdx = 0;
        ndx = offset;
        while (ndx != hex.length()) {
            count = hex.getData()[ndx];
            this.partTypes[partNdx] = (count & 0x80) != 0;
            this.parts[partNdx] = count &= 0x7F;
            ++ndx;
            for (int n = 0; n < count; ++n) {
                int x = hex.getData()[(n >> 1) + ndx];
                x = ((n & 1) == 0 ? x >> 4 : x & 0xF) * 2;
                if (x >= this.bursts.length) {
                    this.error = "burst index out of range";
                    this.durations[total++] = 0;
                    this.durations[total++] = 0;
                    continue;
                }
                this.durations[total++] = this.bursts[x];
                this.durations[total++] = this.bursts[x + 1];
            }
            ndx += count + 1 >> 1;
            ++partNdx;
        }
        this.repeat = 0;
        this.extra = 0;
        for (int n = 0; n < partNdx; ++n) {
            if (this.partTypes[n] && this.repeat == 0) {
                this.repeat = 2 * this.parts[n];
                continue;
            }
            if (this.repeat <= 0) continue;
            this.extra += 2 * this.parts[n];
        }
        this.oneTime = total - this.repeat - this.extra;
    }

    private int roundTo(int value, int r) {
        return (int)Math.round((double)value / (double)r) * r;
    }

    public int[] getBursts() {
        return this.getBursts(1);
    }

    public int[] getBursts(int r) {
        int[] temp = new int[this.bursts.length];
        for (int i = 0; i < this.bursts.length; ++i) {
            temp[i] = this.roundTo(this.bursts[i], r);
        }
        return temp;
    }

    public int[] getDurations(int r, boolean signed) {
        return this.durations == null ? new int[]{} : this.getDurations(0, this.durations.length, r, signed);
    }

    public int[] getOneTimeDurations(int r, boolean signed) {
        return this.getDurations(0, this.oneTime, r, signed);
    }

    public int[] getRepeatDurations(int r, boolean signed) {
        return this.getDurations(this.oneTime, this.oneTime + this.repeat, r, signed);
    }

    public int[] getExtraDurations(int r, boolean signed) {
        return this.getDurations(this.oneTime + this.repeat, this.oneTime + this.repeat + this.extra, r, signed);
    }

    private int[] getDurations(int start, int end, int r, boolean signed) {
        int[] temp = new int[end - start];
        int t = 0;
        for (int i = start; i < end; ++i) {
            temp[t++] = (signed && i % 2 == 1 ? -1 : 1) * this.roundTo(this.durations[i], r);
        }
        return temp;
    }
}

