/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

public class UnsignedByte {
    private short value;

    private static void check(short val) {
        if (val < 0 || val > 255) {
            throw new NumberFormatException("Value must be between 0 and FF");
        }
    }

    public UnsignedByte(short value) {
        UnsignedByte.check(value);
        this.value = value;
    }

    public UnsignedByte(String text) {
        this.value = UnsignedByte.parseUnsignedByte(text);
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        UnsignedByte.check(value);
        this.value = value;
    }

    public String toString() {
        return UnsignedByte.toString(this.value);
    }

    public static String toString(short val) {
        return Integer.toHexString(0x100 | val).substring(1).toUpperCase();
    }

    public static short parseUnsignedByte(String text) {
        short rc = Short.parseShort(text, 16);
        UnsignedByte.check(rc);
        return rc;
    }
}

