/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.UnsignedByte;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class UnsignedByteRenderer
extends DefaultTableCellRenderer {
    private int offset;
    private RemoteConfiguration remoteConfig = null;
    private Component component = null;
    private HashMap<Integer, Integer> settingAddresses = null;
    private Color[] highlight = null;
    private short[] normalData = null;
    private short[] savedData = null;
    private short[] baselineData = null;
    private int eepromSize = 0;
    private Font baseFont = this.getFont();
    private Font boldFont = this.baseFont.deriveFont(1);

    public UnsignedByteRenderer() {
        this.setHorizontalAlignment(0);
    }

    public void setSavedData(short[] savedData) {
        this.savedData = savedData;
    }

    public void setRemoteConfig(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        this.remoteConfig = remoteConfig;
        this.normalData = remoteConfig.getData();
        this.savedData = remoteConfig.getSavedData();
        this.baselineData = remoteConfig.getBaselineData();
        this.settingAddresses = remoteConfig.hasSegments() ? remoteConfig.getSettingMap() : remote.getSettingAddresses();
        this.highlight = remoteConfig.getHighlight();
        this.eepromSize = remote.getEepromSize();
    }

    public void setEepromSize(int eepromSize) {
        this.eepromSize = eepromSize;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.component = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
        this.offset = 16 * row + col - 1;
        boolean reserved = this.offset > this.eepromSize - 1;
        short cellValue = ((UnsignedByte)value).getValue();
        if (this.savedData != null && cellValue != this.savedData[this.offset]) {
            this.component.setFont(this.boldFont);
        } else {
            this.component.setFont(this.baseFont);
        }
        if (!isSelected) {
            this.component.setForeground(reserved ? Color.LIGHT_GRAY : (this.changed() ? Color.YELLOW : (this.useSavedData() ? Color.BLUE : Color.BLACK)));
        }
        return this.component;
    }

    @Override
    public void paint(Graphics g) {
        if (this.remoteConfig != null && !this.useSavedData()) {
            Dimension d = this.component.getSize();
            int end = this.highlight.length - 1;
            if (this.changed()) {
                g.setColor(Color.RED);
                g.fillRect(0, 0, d.width, d.height);
            } else if (this.remoteConfig.allowHighlighting()) {
                if (this.settingAddresses.containsKey(this.offset) && this.highlight[this.offset] == Color.WHITE) {
                    for (int i = 0; i < 8; ++i) {
                        g.setColor(this.highlight[end - 8 * this.settingAddresses.get(this.offset) - i]);
                        g.fillRect(d.width - 3 * i - 3, 0, 2, d.height);
                    }
                } else {
                    g.setColor(this.highlight[this.offset]);
                    g.fillRect(0, 0, d.width, d.height);
                }
            }
        }
        super.paint(g);
    }

    private boolean useSavedData() {
        return this.remoteConfig != null ? this.remoteConfig.getOwner().useSavedData() : false;
    }

    private boolean changed() {
        return this.baselineData != null && !this.useSavedData() && this.normalData[this.offset] != this.baselineData[this.offset];
    }
}

