/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class UpdateChecker {
    private static Desktop desktop = null;

    public static void checkUpdateAvailable(JP1Frame frame) throws IOException {
        int minLen;
        int test;
        String currentVersion;
        URL url = new URL("https://controlremote.sourceforge.io/version.dat");
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        String fullLatestVersion = in.readLine();
        in.close();
        String latestVersion = fullLatestVersion;
        int latestBuild = 0;
        boolean usesBuildForm = false;
        int pos = latestVersion.indexOf("build");
        int pos2 = 0;
        if (pos < 0) {
            int count = 0;
            for (int n = 0; n < latestVersion.length(); ++n) {
                if (latestVersion.charAt(n) != '.' || ++count != 2) continue;
                pos = n;
                pos2 = pos + 1;
                break;
            }
        } else {
            usesBuildForm = true;
            pos2 = pos + 5;
        }
        if (pos >= 0) {
            String buildStr = latestVersion.substring(pos2).trim();
            latestVersion = latestVersion.substring(0, pos).trim();
            try {
                latestBuild = Integer.parseInt(buildStr);
            }
            catch (NumberFormatException nfe) {
                latestBuild = 0;
            }
        }
        if (!(currentVersion = "3.2").startsWith("v")) {
            currentVersion = "v" + currentVersion;
        }
        test = (test = currentVersion.substring(0, minLen = Math.min(currentVersion.length(), latestVersion.length())).compareTo(latestVersion.substring(0, minLen))) == 0 ? latestVersion.length() - currentVersion.length() : test;
        String displayVersion = RemoteMaster.getDisplayVersion();
        if (!displayVersion.startsWith("v")) {
            displayVersion = "v" + displayVersion;
        }
        String text = null;
        if (test > 0 || test == 0 && 3 >= latestBuild) {
            text = "You are using the latest version (" + displayVersion + ") of RemoteMaster.";
        } else {
            text = "<html>";
            text = text + (usesBuildForm ? "Build " + latestBuild + " of version " + latestVersion : "Version " + fullLatestVersion);
            text = text + " of RemoteMaster is available, but you are still using " + displayVersion + ".";
            fullLatestVersion = fullLatestVersion.replaceAll("\\s", "");
            text = text + "<p>The new version is available for download from<br><a href=\"https://sourceforge.net/projects/controlremote/";
            text = text + "files/RemoteMaster/" + fullLatestVersion;
            text = text + "\">https://sourceforge.net/projects/controlremote/";
            text = text + "files/RemoteMaster/" + fullLatestVersion + "</a></html>";
        }
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
        }
        JEditorPane pane = new JEditorPane("text/html", text);
        pane.setEditable(false);
        pane.setBackground(frame.getContentPane().getBackground());
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (desktop != null) {
                    try {
                        desktop.browse(event.getURL().toURI());
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        });
        new TextPopupMenu(pane);
        JOptionPane.showMessageDialog(frame, pane, "RemoteMaster Version Check", 1);
    }
}

