/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class UpgradeSourceSelector
extends JDialog
implements ActionListener {
    private Remote remote = null;
    private JTextField fileField = new JTextField(20);
    JRadioButton defaultBtn = new JRadioButton("System upgrade");
    JRadioButton otherBtn = new JRadioButton("File:");
    private JButton browseBtn = new JButton("Browse");
    private JButton okBtn = new JButton("OK");
    private JButton cancelBtn = new JButton("Cancel");
    private JFileChooser chooser = null;
    private File inFile = null;
    private File outFile = null;
    private RMIRSetup.LanguageDescriptor selectedLanguage = null;
    private JComboBox<RMIRSetup.LanguageDescriptor> languageBox = null;
    private DefaultComboBoxModel<RMIRSetup.LanguageDescriptor> comboModel = null;

    public UpgradeSourceSelector(JFrame owner, Remote remote, File current, RMIRSetup.LanguageDescriptor upgradeLanguage) {
        super(owner, "Upgrade Source Selector", true);
        this.remote = remote;
        this.createGui(owner, current, upgradeLanguage);
    }

    private void createGui(Component owner, File inFile, RMIRSetup.LanguageDescriptor lang) {
        this.setLocationRelativeTo(owner);
        this.inFile = inFile;
        this.outFile = inFile;
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonGroup group = new ButtonGroup();
        group.add(this.defaultBtn);
        group.add(this.otherBtn);
        this.defaultBtn.addActionListener(this);
        this.otherBtn.addActionListener(this);
        this.browseBtn.addActionListener(this);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.defaultBtn.setSelected(inFile == null);
        this.otherBtn.setSelected(inFile != null);
        this.otherBtn.setEnabled(RemoteMaster.admin);
        this.otherBtn.setToolTipText(JTableX.getHtmlToolTip("This option is not currently available.  It allows for the<br>possibility of modified firmware being created in future."));
        this.browseBtn.setEnabled(inFile != null);
        this.fileField.setText(inFile != null ? inFile.getName() : null);
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Select the source for XSight upgrade:"));
        box.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.defaultBtn);
        box.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.otherBtn);
        panel.add(this.fileField);
        panel.add(this.browseBtn);
        box.add(panel);
        if (!this.remote.getSignature().equals("USB0007")) {
            panel = new JPanel(new FlowLayout(0));
            panel.add(new JLabel("Select the additional language support required:"));
            box.add(panel);
            panel = new JPanel(new FlowLayout(0));
            panel.add(Box.createHorizontalStrut(20));
            this.comboModel = new DefaultComboBoxModel();
            this.languageBox = new JComboBox<RMIRSetup.LanguageDescriptor>(this.comboModel);
            this.languageBox.setToolTipText(JTableX.getHtmlToolTip("The setting \"Current\" keeps, for the upgrade, the same additional<br>language (if any) as in the current firmware.  \"None\" removes any<br>installed additional language and any other choice installs the named<br>language, replacing the current addition if any.  English, Spanish,<br>French, German and Italian are permanently installed and not affected<br>by this selection"));
            Dimension d = this.languageBox.getPreferredSize();
            d.width = 100;
            this.languageBox.setPreferredSize(d);
            panel.add(this.languageBox);
            box.add(panel);
            box.add(Box.createVerticalStrut(5));
            this.setLanguageBox();
            this.selectedLanguage = lang != null ? lang : RMIRSetup.defaultLanguage;
            this.languageBox.setSelectedItem(this.selectedLanguage);
        }
        panel = new JPanel(new FlowLayout(2));
        panel.add(this.okBtn);
        panel.add(this.cancelBtn);
        box.add(panel);
        this.add((Component)box, "First");
        this.pack();
    }

    private void setLanguageBox() {
        this.comboModel.removeAllElements();
        this.comboModel.addElement(RMIRSetup.defaultLanguage);
        if (this.defaultBtn.isSelected()) {
            this.comboModel.addElement(RMIRSetup.getLanguage(0));
            this.comboModel.addElement(RMIRSetup.getLanguage(9));
        } else {
            String name = this.outFile.getName();
            int bar = name.lastIndexOf(95);
            int dot = name.lastIndexOf(46);
            String versionStr = name.substring(bar + 1, dot);
            int langNdx = -1;
            if (versionStr.length() > 7) {
                langNdx = Integer.parseInt(versionStr.substring(7, 8));
            }
            if (langNdx >= 0) {
                this.comboModel.addElement(RMIRSetup.getLanguage(langNdx));
            }
            this.languageBox.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okBtn) {
            if (this.languageBox != null) {
                this.selectedLanguage = (RMIRSetup.LanguageDescriptor)this.languageBox.getSelectedItem();
            }
            this.setVisible(false);
        } else if (source == this.cancelBtn) {
            this.outFile = this.inFile;
            this.setVisible(false);
        } else if (source == this.defaultBtn) {
            this.browseBtn.setEnabled(false);
            this.setLanguageBox();
        } else if (source == this.otherBtn) {
            this.browseBtn.setEnabled(true);
            this.comboModel.removeAllElements();
        } else if (source == this.browseBtn) {
            block16: {
                int returnVal;
                File inputDir = new File(RemoteMaster.getWorkDir(), "XSight");
                if (this.chooser == null) {
                    this.chooser = new JFileChooser(inputDir);
                }
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return RMIRSetup.isValidUpgradeSource(f, UpgradeSourceSelector.this.remote);
                    }

                    @Override
                    public String getDescription() {
                        return "Available source files";
                    }
                };
                this.chooser.setFileFilter(filter);
                if (this.outFile != null) {
                    this.chooser.setSelectedFile(this.outFile);
                }
                while ((returnVal = this.chooser.showOpenDialog(this)) == 0) {
                    this.outFile = this.chooser.getSelectedFile();
                    if (!this.outFile.exists()) {
                        JOptionPane.showMessageDialog(this, this.outFile.getName() + " doesn't exist.", "File doesn't exist.", 0);
                        continue;
                    }
                    if (this.outFile.isDirectory()) {
                        JOptionPane.showMessageDialog(this, this.outFile.getName() + " is a directory.", "File doesn't exist.", 0);
                        continue;
                    }
                    break block16;
                }
                return;
            }
            if (this.outFile != null) {
                String name = this.outFile.getName();
                this.fileField.setText(name);
                this.setLanguageBox();
            }
        }
    }

    public File getSource() {
        if (this.defaultBtn.isSelected()) {
            return null;
        }
        return this.outFile;
    }

    public RMIRSetup.LanguageDescriptor getSelectedLanguage() {
        return this.selectedLanguage;
    }
}

