/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class XSightFileDataPanel
extends RMPanel
implements ListSelectionListener,
ActionListener {
    private static final String[][] itemNames = new String[][]{{"name8", "Name", "0"}, {"devices", "FileName", "0"}, {"profiles", "FileName", "0"}, {"favorites", "FileName", "0"}, {"macros", "FileName", "0"}, {"activities", "FileName", "0"}, {"brand", "Brand", "0"}, {"model", "Model", "0"}, {"remotemodel", "RemoteModel", "0"}, {"language", "Language", "0"}, {"region", "Region", "0"}, {"filename", "FileName", "0"}, {"codeset", "DeviceUpgrade", "1"}, {"prefix", "FixedData", "2"}, {"keyflags", "KeyFlags", "2"}, {"irdata", "Hex", "2"}, {"directv_rf", "RFSetting", "2"}, {"executor", "PID", "3"}, {"keygid", "KeyGID", "3"}, {"keydef", "KeyCode", "4"}, {"device", "Dev", "5"}, {"activity", "Activity", "5"}, {"profile", "Profile", "5"}, {"favorite", "Favorite", "5"}, {"learnedkey", "Learned", "6"}, {"softpage", "SoftPage", "7"}, {"favoritewidth", "FavoriteWidth", "7"}, {"iconref", "IconRef", "7"}, {"issystemmacro", "Style", "7"}, {"punchthruspec", "Punchthru", "8"}, {"profileindex", "Profile", "9"}, {"deviceid", "Device", "10"}, {"channelnumber", "ChannelNumber", "11"}, {"macro", "MacroRef", "12"}, {"irdef", "FunctionRef", "12"}, {"name16", "MacroName", "13"}, {"sendir", "SendFunction", "14"}, {"irref", "Function", "14"}, {"macroref", "Macro", "15"}, {"sendhardkey", "SendKey", "16"}, {"sendsoftkey", "SendKey", "16"}, {"hardkey", "Key", "16"}, {"softkey", "Key", "16"}, {"volumemaster", "VolumeLock", "17"}, {"volumelock", "VolumeLock", "17"}, {"enterkey", "FinalKey", "18"}, {"duration", "Hold(secs)", "19"}, {"delay", "Pause(secs)", "20"}, {"pictureinputs", "PictureAssist", "21"}, {"audioinputs", "AudioAssist", "21"}, {"powerkeys", "PowerKeysAssist", "21"}, {"assistant", "Assists", "22"}, {"objcode", "S3F80code", "23"}};
    private String helpText = "This panel displays two types of user files.  The xcf files have an XML-style structure of nested items each with a start and end tag.  The two bytes within a start tag are the tag start code and data length, the byte within an end tag is its end code.  Bold text at line ends is an interpretation of the tag data and not part of the file itself.  The non-displayed metadata gives the correspondence between tag codes and tag names needed to parse the raw hex. The pkg files hold the system and user icons.  Each icon is displayed as its integer iconref used in xcf files followed by the icon image.  The panel displays current or original data according to the setting of menu item Advanced > Preserve original data.  When original data is displayed, the text color is blue instead of black.";
    private RemoteConfiguration remoteConfig = null;
    private JList<RemoteConfiguration.SSDFileInfo> fileList = new JList();
    private JPanel filePanel = null;
    private JPanel dataPanel = null;
    private JTextPane dataPane = null;
    private DefaultListModel<RemoteConfiguration.SSDFileInfo> fileModel = new DefaultListModel();
    private List<RemoteConfiguration.SSDFileInfo> fileInfoToShow = null;
    private short[] dataToShow = null;
    private Color foregroundColor = null;
    private List<Integer[]> itemTextData = null;
    private List<Integer> tags = null;
    private List<String> tagNames = null;
    private boolean lastWasStart = false;
    private boolean isVolumeMaster = false;
    private int itemStart = 0;
    private int docIndex = 0;
    private int textStart = 0;
    private int softPage = 0;
    private int fileIndex = 0;
    private JScrollPane dataScroll = null;
    private DefaultStyledDocument docu = null;
    private HashMap<String, String> itemMap = null;
    private HashMap<String, Integer> interpretMap = null;
    private HashMap<Integer, String> functionMap = null;
    private HashMap<Integer, String> deviceMap = null;
    private HashMap<Integer, String> profileMap = null;
    private HashMap<Integer, Integer> favWidthMap = null;
    private HashMap<Integer, MacroData> macroMap = null;
    private HashMap<Integer, Integer> macroRefMap = null;
    private JComboBox<Integer> fontBox = null;
    private int xcfFontSize = 12;
    private int pkgFontSize = 16;
    private int tabSpacing = 150;
    private int favDevSerial = -1;
    private int currentFileIndex = -1;
    private int currentDeviceSerial = -1;
    private int currentKeyCode = -1;
    private int currentSoftPage = 0;
    private JLabel searchLbl = null;
    private JTextField searchFor = null;
    private JButton btnNext = null;
    private JButton btnPrevious = null;
    private String docuText = null;
    private MacroData macroData = null;
    private List<MacroData> assistsList = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> userIcons = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> sysIcons = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> iconMap = null;

    public XSightFileDataPanel() {
        this.filePanel = new JPanel(new BorderLayout());
        this.filePanel.setBorder(BorderFactory.createTitledBorder(" User Files "));
        this.filePanel.add(Box.createHorizontalStrut(200), "First");
        this.fileList.addListSelectionListener(this);
        this.fileList.setSelectionMode(0);
        this.filePanel.add(this.fileList, "Center");
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createTitledBorder(" File Data "));
        this.dataPane = new JTextPane();
        this.dataPane.setEditable(false);
        this.dataScroll = new JScrollPane(this.dataPane);
        this.dataPanel.add((Component)this.dataScroll, "Center");
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.setBorder(BorderFactory.createTitledBorder(" Settings: "));
        this.add((Component)topPanel, "First");
        Integer[] sizes = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.fontBox = new JComboBox<Integer>(sizes);
        Dimension d = this.fontBox.getPreferredSize();
        d.width += 10;
        this.fontBox.setPreferredSize(d);
        this.fontBox.setSelectedItem(this.xcfFontSize);
        this.fontBox.addActionListener(this);
        topPanel.add(new JLabel("Font size: "));
        topPanel.add(this.fontBox);
        topPanel.add(Box.createHorizontalStrut(20));
        this.searchLbl = new JLabel("Search for: ");
        topPanel.add(this.searchLbl);
        this.searchFor = new JTextField(20);
        this.searchFor.addActionListener(this);
        this.searchLbl.setLabelFor(this.searchFor);
        topPanel.add(this.searchFor);
        this.btnNext = new JButton("Next");
        this.btnNext.addActionListener(this);
        this.btnPrevious = new JButton("Previous");
        this.btnPrevious.addActionListener(this);
        this.searchLbl.setEnabled(false);
        this.searchFor.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.btnPrevious.setEnabled(false);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.btnNext);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.btnPrevious);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createTitledBorder(" Notes: "));
        this.add((Component)bottomPanel, "Last");
        ProtocolDataPanel.DisplayArea notes = new ProtocolDataPanel.DisplayArea(this.helpText, null);
        bottomPanel.add(notes);
        this.itemTextData = new ArrayList<Integer[]>();
        this.tags = new ArrayList<Integer>();
        JSplitPane splitPane = new JSplitPane(1, this.filePanel, this.dataPanel);
        this.add((Component)splitPane, "Center");
        this.itemMap = new HashMap();
        this.interpretMap = new HashMap();
        this.functionMap = new HashMap();
        this.deviceMap = new HashMap();
        this.profileMap = new HashMap();
        this.favWidthMap = new HashMap();
        this.macroMap = new HashMap();
        this.macroRefMap = new HashMap();
        this.assistsList = new ArrayList<MacroData>();
        for (String[] strData : itemNames) {
            this.itemMap.put(strData[0], strData[1]);
        }
        for (String[] strData : itemNames) {
            this.interpretMap.put(strData[0], Integer.valueOf(strData[2]));
        }
    }

    private void preProcess(RemoteConfiguration.SSDFileInfo info, short[] data) {
        block59: {
            short len;
            Remote remote;
            String tagName;
            int pos;
            List<String> tagNames;
            block60: {
                block58: {
                    tagNames = this.remoteConfig.getBXMLtagnames(null, data, info.fileStart);
                    pos = info.xcfStart;
                    tagName = null;
                    remote = this.remoteConfig.getRemote();
                    len = 0;
                    if (info.index != 2) break block58;
                    String irName = null;
                    int devSerial = -1;
                    int irSerial = -1;
                    boolean inCodeset = false;
                    boolean inIrdefs = false;
                    while (true) {
                        short tag = data[pos++];
                        tagName = tagNames.get(tag & 0x7F);
                        if ((tag & 0x80) == 0) {
                            len = data[pos++];
                            if (tagName.equals("device")) {
                                this.currentDeviceSerial = devSerial = data[pos];
                                String devName = this.remoteConfig.getString16(data, pos + 1, len - 1);
                                this.deviceMap.put(devSerial, devName);
                            } else if (tagName.equals("codeset")) {
                                inCodeset = true;
                            } else if (inCodeset && tagName.equals("irdefs")) {
                                inIrdefs = true;
                            } else if (devSerial >= 0 && tagName.equals("favoritewidth")) {
                                short width = data[pos];
                                if (width > 0) {
                                    this.favWidthMap.put(devSerial, Integer.valueOf(width));
                                }
                            } else if (tagName.equals("softpage")) {
                                this.currentSoftPage = data[pos];
                            } else if (tagName.equals("keydef")) {
                                this.currentKeyCode = data[pos] + 6 * this.currentSoftPage;
                            } else if (tagName.equals("macroref") && this.currentDeviceSerial >= 0 && this.currentKeyCode >= 0) {
                                int devKey = this.currentDeviceSerial << 16 | this.currentKeyCode;
                                this.macroRefMap.put(devKey, data[pos] + 256 * data[pos + 1]);
                            }
                            if (devSerial >= 0 && inCodeset && inIrdefs) {
                                if (tagName.equals("irdef")) {
                                    irSerial = data[pos] + 256 * data[pos + 1];
                                } else if (tagName.equals("name8")) {
                                    irName = this.remoteConfig.getString8(data, pos - 1);
                                    this.functionMap.put(devSerial << 16 | irSerial, irName);
                                }
                            }
                            this.tags.add(0, Integer.valueOf(tag));
                            pos += len;
                            continue;
                        }
                        if (tagName.equals("device")) {
                            devSerial = -1;
                        } else if (tagName.equals("codeset")) {
                            inCodeset = false;
                        } else if (tagName.equals("irdefs")) {
                            inIrdefs = false;
                        } else if (tagName.equals("irdef")) {
                            irSerial = -1;
                        } else if (tagName.equals("name8")) {
                            irName = null;
                        } else if (tagName.equals("device")) {
                            this.currentDeviceSerial = -1;
                        } else if (tagName.equals("keydef")) {
                            this.currentKeyCode = -1;
                        } else if (tagName.equals("softpage")) {
                            this.currentSoftPage = 0;
                        }
                        this.tags.remove(0);
                        if (this.tags.isEmpty()) break;
                    }
                    break block59;
                }
                if (info.index != 4) break block60;
                while (true) {
                    short tag = data[pos++];
                    tagName = tagNames.get(tag & 0x7F);
                    if ((tag & 0x80) == 0) {
                        len = data[pos++];
                        if (tagName.equals("profile")) {
                            short profileSerial = data[pos];
                            String profileName = this.remoteConfig.getString16(data, pos + 1, len - 1);
                            this.profileMap.put(Integer.valueOf(profileSerial), profileName);
                        }
                        this.tags.add(0, Integer.valueOf(tag));
                        pos += len;
                        continue;
                    }
                    this.tags.remove(0);
                    if (this.tags.isEmpty()) break;
                }
                break block59;
            }
            if (info.index != 6) break block59;
            while (true) {
                short tag = data[pos++];
                tagName = tagNames.get(tag & 0x7F);
                if ((tag & 0x80) == 0) {
                    len = data[pos++];
                    if (tagName.equals("macro")) {
                        int macroref = data[pos] + 256 * data[pos + 1];
                        this.macroData = new MacroData();
                        this.macroMap.put(macroref, this.macroData);
                    } else if (tagName.equals("name16")) {
                        this.macroData.name = this.remoteConfig.getString16(data, pos, len);
                    } else if (tagName.equals("issystemmacro")) {
                        this.macroData.isSystemMacro = data[pos] == 1;
                    } else if (tagName.equals("sendir")) {
                        MacroItem item = new MacroItem();
                        this.macroData.items.add(item);
                        item.type = MacroType.IR;
                        short devSerial = data[pos];
                        int irSerial = data[pos + 1] + 100 * data[pos + 2];
                        String fName = this.functionMap.get(devSerial << 16 | irSerial);
                        item.str = this.deviceMap.get(devSerial) + "/" + fName;
                    } else if (tagName.equals("sendhardkey") || tagName.equals("sendsoftkey")) {
                        MacroItem item = new MacroItem();
                        this.macroData.items.add(item);
                        item.type = MacroType.KEY;
                        int incr = len == 3 ? 1 : 0;
                        DeviceButton db = remote.getDeviceButton(data[pos] + 80);
                        short softp = len == 3 ? data[pos + 1] : (short)0;
                        Button b = remote.getButton(data[pos + incr + 1] + 6 * softp);
                        item.str = db.getName() + "/" + b.getName();
                    } else if (tagName.equals("duration")) {
                        List<MacroItem> items = this.macroData.items;
                        if (items.size() > 0) {
                            MacroItem item = this.macroData.items.get(items.size() - 1);
                            item.duration = (data[pos] + 256 * data[pos + 1]) / 100;
                        }
                    } else if (tagName.equals("delay")) {
                        List<MacroItem> items = this.macroData.items;
                        if (items.size() > 0) {
                            MacroItem item = this.macroData.items.get(items.size() - 1);
                            item.delay = data[pos];
                        }
                    } else if (Arrays.asList("pictureinputs", "audioinputs", "powerkeys").contains(tagName) && !this.assistsList.contains(this.macroData)) {
                        this.assistsList.add(this.macroData);
                    }
                    this.tags.add(0, Integer.valueOf(tag));
                    pos += len;
                    continue;
                }
                if (tagName.equals("macro")) {
                    this.macroData = null;
                }
                this.tags.remove(0);
                if (this.tags.isEmpty()) break;
            }
        }
    }

    private void setIconMap(int type) {
        if (type == 5) {
            this.iconMap = this.sysIcons;
        } else {
            this.iconMap = new LinkedHashMap();
            for (int ref : this.userIcons.keySet()) {
                GeneralFunction.RMIcon icon = this.userIcons.get(ref);
                if (icon.type != type) continue;
                this.iconMap.put(ref, icon);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object source = e.getSource();
        if (source == this.fileList) {
            RemoteConfiguration.SSDFileInfo info = this.fileList.getSelectedValue();
            this.fileIndex = info.index;
            this.docu = (DefaultStyledDocument)this.dataPane.getDocument();
            if (info.index <= 6) {
                this.searchLbl.setEnabled(true);
                this.searchFor.setEnabled(true);
                this.btnNext.setEnabled(true);
                this.btnPrevious.setEnabled(true);
                this.fontBox.setSelectedItem(this.xcfFontSize);
                this.remoteConfig.getOwner().setInterfaceState("PROCESSING...");
                new TranslateTask(this.fileList.getSelectedValue()).execute();
            } else {
                int[] nArray;
                this.searchLbl.setEnabled(false);
                this.searchFor.setEnabled(false);
                this.btnNext.setEnabled(false);
                this.btnPrevious.setEnabled(false);
                this.fontBox.setSelectedItem(this.pkgFontSize);
                this.dataPane.setText("");
                TabStop[] tabs = new TabStop[]{new TabStop(this.tabSpacing, 0, 0), new TabStop(2 * this.tabSpacing, 0, 0), new TabStop(3 * this.tabSpacing, 0, 0), new TabStop(4 * this.tabSpacing, 0, 0)};
                TabSet tabset = new TabSet(tabs);
                SimpleAttributeSet iconSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(iconSet, "Monospaced");
                StyleConstants.setFontSize(iconSet, this.pkgFontSize);
                StyleConstants.setBold(iconSet, true);
                StyleConstants.setForeground(iconSet, this.foregroundColor);
                StyleConstants.setTabSet(iconSet, tabset);
                this.dataPane.setParagraphAttributes(iconSet, false);
                int[] iconTypes = new int[]{5, 6, 8, 9};
                String[] iconDescs = new String[]{"Device and Activity", "Favorite", "Profile", "Button"};
                if (info.index == 8) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 1;
                    nArray2[1] = 2;
                    nArray = nArray2;
                    nArray2[2] = 3;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = 0;
                }
                int[] indexes = nArray;
                ArrayList<Integer> iconKeys = new ArrayList<Integer>();
                try {
                    int fileStart;
                    String format = info.index == 9 ? "NOTE:  The sysicons.pkg file is not actually a user file.  It is downloaded by RMIR so that RMIR can display system icons, but it cannot be changed and is not included in an upload.%n%n" : "";
                    format = format + "Icon file start: %05X, end %05X%n%nThe memory usage by icon is given below the lists of icon images.%n%n";
                    this.docu.insertString(0, String.format(format, info.fileStart, info.fileEnd - 1), iconSet);
                    for (int index : indexes) {
                        this.setIconMap(iconTypes[index]);
                        iconKeys.clear();
                        iconKeys.addAll(this.iconMap.keySet());
                        iconKeys.sort(null);
                        format = index > 1 ? "%n%n%s Icons:%n%n" : "%s Icons:%n%n";
                        this.docu.insertString(this.docu.getLength(), String.format(format, iconDescs[index]), iconSet);
                        if (iconKeys.size() == 0) {
                            this.docu.insertString(this.docu.getLength(), "None", iconSet);
                            continue;
                        }
                        for (int i = 0; i < iconKeys.size(); ++i) {
                            int ref = (Integer)iconKeys.get(i);
                            GeneralFunction.RMIcon icon = this.iconMap.get(ref);
                            this.docu.insertString(this.docu.getLength(), String.format("%d: ", ref), iconSet);
                            this.dataPane.insertIcon(icon.image);
                            if (i == iconKeys.size() - 1) continue;
                            this.docu.insertString(this.docu.getLength(), ",\t", iconSet);
                            if ((i + 1) % 5 != 0) continue;
                            this.docu.insertString(this.docu.getLength(), "\n", iconSet);
                        }
                    }
                    short[] data = this.dataToShow;
                    StringBuilder sb = new StringBuilder();
                    String str = "The following address lists by IconRef give the start addresses for the RGB data, and the transparency data when applicable, for each icon together with the icon end address:";
                    sb.append(String.format("%n%n%s%n", str));
                    int pos = fileStart = info.fileStart;
                    int numIcons = data[pos + 12] + 256 * data[pos + 13];
                    int numEntries = data[pos + 14] + 256 * data[pos + 15];
                    int startIndex = (pos += 16) + 28 * numIcons;
                    int iconEnd = 16 + 28 * numIcons + numEntries;
                    str = String.format("%nFile metadata %05X-%05X", fileStart, fileStart + iconEnd - 1);
                    sb.append(str);
                    for (int i = 0; i < numEntries; ++i) {
                        int start2;
                        short j = data[startIndex + i];
                        if (j == 0) continue;
                        int k = pos + 28 * (j - 1);
                        int width = data[k + 8] + 256 * data[k + 9];
                        int height = data[k + 10] + 256 * data[k + 11];
                        int start = data[k + 16] + 256 * data[k + 17] + 65536 * data[k + 18];
                        int excess = (start2 = data[k + 20] + 256 * data[k + 21] + 65536 * data[k + 22]) == 0 ? 256 : 512;
                        int baseSize = data[k + 24] + 256 * data[k + 25] - excess;
                        iconEnd = start + baseSize;
                        if (start2 == iconEnd) {
                            iconEnd += height * width;
                        }
                        str = start2 == 0 ? String.format("%n%3d: %05X,  N/A,  %05X", i, fileStart + start, fileStart + iconEnd - 1) : String.format("%n%3d: %05X, %05X, %05X", i, fileStart + start, fileStart + start2, fileStart + iconEnd - 1);
                        sb.append(str);
                    }
                    this.docu.insertString(this.docu.getLength(), sb.toString(), iconSet);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XSightFileDataPanel.this.dataScroll.getVerticalScrollBar().setValue(0);
                        XSightFileDataPanel.this.dataPane.grabFocus();
                        XSightFileDataPanel.this.dataPane.setCaretPosition(0);
                    }
                });
            }
        }
    }

    private String translateItem(int tag, int indent, short[] data, int pos) {
        if (this.fileIndex < 0 || this.fileIndex > 6) {
            return null;
        }
        char[] chars = new char[indent * 2 + 2];
        Arrays.fill(chars, ' ');
        String sPos = String.format("%05X%s", pos - 1, new String(chars));
        String str = null;
        String tagName = this.tagNames.get(tag & 0x7F);
        String itemText = null;
        boolean start = (tag & 0x80) == 0;
        int lastTextStart = 0;
        if (start) {
            lastTextStart = this.textStart;
            itemText = this.lastWasStart ? this.interpretItem(this.tagNames.get(data[this.itemStart - 1]), data, this.itemStart) : "";
            this.itemStart = pos;
            short len = data[pos++];
            String format = this.lastWasStart ? (!itemText.isEmpty() ? "  %s%n%s<%s %02X %02X> %s" : "%s%n%s<%s %02X %02X> %s") : "%s%s<%s %02X %02X> %s";
            str = String.format(format, itemText, sPos, tagName, tag, (int)len, Hex.toString(data, pos, len));
            this.textStart = this.docIndex + str.length() + 2;
        } else {
            if (tagName.equals("softpage")) {
                this.softPage = 0;
            } else if (tagName.equals("device")) {
                this.isVolumeMaster = false;
            } else if (tagName.equals("macro")) {
                this.macroData = null;
            } else if (tagName.equals("device")) {
                this.currentDeviceSerial = -1;
            } else if (tagName.equals("keydef")) {
                this.currentKeyCode = -1;
            }
            String s = this.lastWasStart ? " " : sPos;
            itemText = this.lastWasStart ? this.interpretItem(tagName, data, this.itemStart) : "";
            String format = !itemText.isEmpty() ? "%s</%s %02X>  %s%n" : "%s</%s %02X>%s%n";
            str = String.format(format, s, tagName, tag, itemText);
            this.textStart = this.docIndex + str.length() - itemText.length() - 2;
        }
        if (!itemText.isEmpty()) {
            Integer[] itemTextParams = new Integer[]{start ? lastTextStart : this.textStart, itemText.length()};
            this.itemTextData.add(itemTextParams);
        }
        this.lastWasStart = start;
        return str;
    }

    private String interpretItem(String tagName, short[] data, int pos) {
        String itemName = this.itemMap.get(tagName);
        if (itemName != null) {
            Remote remote = this.remoteConfig.getRemote();
            short len = 0;
            DeviceButton db = null;
            String devName = null;
            int keyCode = 0;
            int ref = 0;
            switch (this.interpretMap.get(tagName)) {
                case 0: {
                    String prefix = "";
                    if (this.tags.size() > 0 && tagName.equals("name8")) {
                        int devKey;
                        Integer macroref;
                        String previousTag = this.tagNames.get(this.tags.get(0));
                        if (previousTag.equals("keydef") && this.currentDeviceSerial >= 0 && this.currentKeyCode >= 0 && (macroref = this.macroRefMap.get(devKey = this.currentDeviceSerial << 16 | this.currentKeyCode)) != null) {
                            MacroData macroData = this.macroMap.get(macroref);
                            if (macroData.isSystemMacro) {
                                return "Alias=" + this.remoteConfig.getString8(data, pos);
                            }
                        }
                        if (previousTag.equals("keydef") || previousTag.equals("irdef")) {
                            prefix = "Function";
                        } else if (previousTag.equals("learnedkey")) {
                            prefix = "Learned";
                        }
                    }
                    return prefix + itemName + "=" + this.remoteConfig.getString8(data, pos);
                }
                case 1: {
                    len = data[pos];
                    short typeIndex = data[pos + 1];
                    DeviceType devType = remote.getDeviceTypeByIndex(typeIndex);
                    String typeName = devType.getName();
                    short[] codeData = Arrays.copyOfRange(data, pos + 1, pos + len + 1);
                    codeData[0] = (short)(len - 1);
                    String s = this.remoteConfig.getString8(codeData, 0);
                    return itemName + "=" + typeName + "/" + s;
                }
                case 2: {
                    return itemName + "=" + Hex.toString(data, pos + 1, data[pos]);
                }
                case 3: {
                    return itemName + "=" + this.getReverseHex(data, pos);
                }
                case 4: {
                    this.currentKeyCode = keyCode = data[pos + 1] + 6 * this.softPage;
                    return String.format("%s=$%02X, %s", itemName, keyCode, remote.getButton(keyCode).getName());
                }
                case 5: {
                    len = data[pos];
                    int index = data[pos + 1];
                    String item = itemName + (index + (itemName.equals("Dev") ? (short)1 : 0));
                    if (itemName.equals("Dev")) {
                        this.currentDeviceSerial = index;
                        db = remote.getDeviceButton(index + 80);
                    }
                    String name = this.remoteConfig.getString16(data, pos + 2, len - 1);
                    return item + "=" + name;
                }
                case 6: {
                    len = data[pos];
                    String header = Hex.toString(data, pos + 1, 9);
                    String learned = Hex.toString(data, pos + 10, data[pos + 9]);
                    return "LearnedHeader=" + header + ", LearnedSignal=" + learned;
                }
                case 7: {
                    int val = data[pos + 1];
                    if (tagName.equals("softpage")) {
                        this.softPage = val;
                    }
                    String valStr = tagName.equals("issystemmacro") ? (val == 1 ? "KeyMove" : "RealTimeMacro") : (!tagName.equals("favoritewidth") || val > 0 ? String.valueOf(val) : "");
                    return !valStr.isEmpty() ? itemName + "=" + valStr : "";
                }
                case 8: {
                    len = data[pos++];
                    devName = this.deviceMap.get(data[pos++]);
                    Button target = remote.getButton(data[pos++] + 6 * this.softPage);
                    Button source = remote.getButton(data[pos++] + 6 * this.softPage);
                    return itemName + ":Device=" + devName + "/Target=" + target.getName() + "/Source=" + source.getName();
                }
                case 9: {
                    short profileIndex = data[pos + 1];
                    String profileName = this.profileMap.get(profileIndex);
                    return itemName + "=" + profileName;
                }
                case 10: {
                    len = data[pos++];
                    this.favDevSerial = data[pos];
                    return itemName + "=" + this.deviceMap.get(this.favDevSerial);
                }
                case 11: {
                    if (this.favDevSerial >= 0) {
                        if (this.favWidthMap.get(this.favDevSerial) == null) {
                            return "ChannelNumber error: favWidthMap is null for Favorites device " + this.deviceMap.get(this.favDevSerial);
                        }
                        int favWidth = this.favWidthMap.get(this.favDevSerial);
                        this.favDevSerial = -1;
                        if (favWidth > 0) {
                            return itemName + "=" + this.remoteConfig.getChannel(data, pos, favWidth);
                        }
                    }
                    return "";
                }
                case 12: {
                    ref = data[pos + 1] + 100 * data[pos + 2];
                    this.macroData = this.macroMap.get(ref);
                    return itemName + "=" + ref;
                }
                case 13: {
                    len = data[pos++];
                    return itemName + "=" + this.remoteConfig.getString16(data, pos, len);
                }
                case 14: {
                    len = data[pos++];
                    short devSerial = data[pos++];
                    int irSerial = data[pos] + 100 * data[pos + 1];
                    String fName = this.functionMap.get(devSerial << 16 | irSerial);
                    return itemName + "=" + this.deviceMap.get(devSerial) + "/" + fName;
                }
                case 15: {
                    ref = data[pos + 1] + 100 * data[pos + 2];
                    MacroData md = this.macroMap.get(ref);
                    if (md == null) {
                        return "Macro error: macroMap is null for macroref = " + ref;
                    }
                    if (md.isSystemMacro) {
                        if (md.items.size() == 1) {
                            MacroItem mi = md.items.get(0);
                            if (mi.type == MacroType.IR) {
                                return "Function=" + mi.str + ", FunctionName=" + md.name;
                            }
                        }
                        return "";
                    }
                    return itemName + "=" + md.toString();
                }
                case 16: {
                    len = data[pos++];
                    db = remote.getDeviceButton(data[pos++] + 80);
                    short softp = len == 3 ? data[pos++] : (short)0;
                    Button b = remote.getButton(data[pos++] + 6 * softp);
                    return itemName + "=" + db.getName() + "/" + b.getName();
                }
                case 17: {
                    if (tagName.equals("volumemaster")) {
                        this.isVolumeMaster = true;
                        return itemName + "=Master";
                    }
                    if (!this.isVolumeMaster) {
                        return itemName + "=On";
                    }
                    return "";
                }
                case 18: {
                    keyCode = data[pos + 1] + 6 * this.softPage;
                    return itemName + "=" + remote.getButton(keyCode).getName();
                }
                case 19: {
                    double duration = (double)(data[pos + 1] + 256 * data[pos + 2]) / 1000.0;
                    return String.format("%s=%3.1f;", itemName, duration);
                }
                case 20: {
                    double pause = (double)data[pos + 1] / 10.0;
                    String intro = this.fileIndex == 5 ? "Interdigit" : "";
                    return String.format("%s%s=%2.1f;", intro, itemName, pause);
                }
                case 21: {
                    return itemName;
                }
                case 22: {
                    if (this.assistsList.contains(this.macroData)) {
                        return itemName;
                    }
                    return "";
                }
                case 23: {
                    len = data[pos++];
                    Hex hex = new Hex(Arrays.copyOfRange(data, pos, pos + len));
                    RemoteConfiguration.decryptObjcode(hex);
                    return itemName + "=" + hex;
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        if (!remoteConfig.getRemote().isSSD()) {
            return;
        }
        this.remoteConfig = remoteConfig;
        this.deviceMap.clear();
        this.favWidthMap.clear();
        this.functionMap.clear();
        this.profileMap.clear();
        this.macroMap.clear();
        this.macroRefMap.clear();
        RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
        if (rm == null) {
            return;
        }
        if (rm.useSavedData()) {
            this.fileInfoToShow = remoteConfig.getSavedSSDFileData();
            this.dataToShow = remoteConfig.getSavedData();
            this.foregroundColor = Color.BLUE;
            this.userIcons = remoteConfig.getSavedUserIcons();
            this.sysIcons = remoteConfig.getSysIcons();
        } else {
            this.fileInfoToShow = remoteConfig.getSsdFileData();
            this.dataToShow = remoteConfig.getData();
            this.foregroundColor = Color.BLACK;
            this.userIcons = remoteConfig.getUserIcons();
            this.sysIcons = remoteConfig.getSysIcons();
        }
        RemoteConfiguration.SSDFileInfo selectedInfo = this.fileList.getSelectedValue();
        if (selectedInfo != null) {
            this.currentFileIndex = selectedInfo.index;
        }
        this.fileList.removeListSelectionListener(this);
        this.fileModel.clear();
        if (this.fileInfoToShow != null) {
            for (RemoteConfiguration.SSDFileInfo info : this.fileInfoToShow) {
                this.fileModel.addElement(info);
            }
        }
        this.fileList.setModel(this.fileModel);
        this.fileList.addListSelectionListener(this);
        this.assistsList.clear();
        for (RemoteConfiguration.SSDFileInfo info : this.fileInfoToShow) {
            if (info.index > 6) continue;
            this.preProcess(info, this.dataToShow);
        }
        for (int i = 0; i < this.fileModel.getSize(); ++i) {
            RemoteConfiguration.SSDFileInfo fileInfo = this.fileModel.getElementAt(i);
            if (fileInfo.index != this.currentFileIndex) continue;
            this.fileList.setSelectedIndex(i);
            break;
        }
    }

    private String getReverseHex(short[] data, int pos) {
        int len = data[pos];
        short[] revData = new short[len];
        for (int i = 0; i < len; ++i) {
            revData[i] = data[pos + len - i];
        }
        return Hex.toString(revData);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.fontBox) {
            SimpleAttributeSet fontSet = new SimpleAttributeSet();
            if (this.fileIndex <= 6) {
                this.xcfFontSize = (Integer)this.fontBox.getSelectedItem();
                StyleConstants.setFontSize(fontSet, this.xcfFontSize);
            } else {
                this.pkgFontSize = (Integer)this.fontBox.getSelectedItem();
                StyleConstants.setFontSize(fontSet, this.pkgFontSize);
            }
            if (this.docu != null) {
                this.docu.setCharacterAttributes(0, this.docu.getLength(), fontSet, false);
            }
        } else if (source == this.btnNext || source == this.btnPrevious) {
            int txtPos;
            String s = this.searchFor.getText();
            int pos = this.dataPane.getCaretPosition();
            int startPos = source == this.btnNext ? pos : 0;
            String subStr = source == this.btnNext ? this.docuText.substring(startPos) : this.docuText.substring(startPos, pos - 1);
            int n = txtPos = source == this.btnNext ? subStr.indexOf(s) + pos : subStr.lastIndexOf(s);
            if (txtPos >= startPos) {
                this.dataPane.grabFocus();
                this.dataPane.setSelectionStart(txtPos);
                this.dataPane.setSelectionEnd(txtPos + s.length());
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.dataPane.grabFocus();
                this.dataPane.setCaretPosition(pos);
            }
        }
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener listener) {
    }

    private class MacroData {
        String name = null;
        boolean isSystemMacro = false;
        List<MacroItem> items = new ArrayList<MacroItem>();

        private MacroData() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (MacroItem mi : this.items) {
                if (!first) {
                    sb.append(";");
                }
                sb.append(mi.type == MacroType.IR ? "Fn:" : "Key:");
                sb.append(mi.toString());
                first = false;
            }
            return sb.toString();
        }
    }

    private static class MacroItem {
        MacroType type = null;
        String str = null;
        int duration = 0;
        int delay = 0;

        private MacroItem() {
        }

        public String toString() {
            String s = "";
            if (this.duration > 0) {
                s = s + String.format("Hold(%3.1f)", (double)this.duration * 0.1);
            }
            s = s + this.str;
            if (this.delay > 0) {
                s = s + String.format("(%3.1f)", (double)this.delay * 0.1);
            }
            return s;
        }
    }

    private static enum MacroType {
        KEY,
        IR;

    }

    private class TranslateTask
    extends SwingWorker<Void, Void> {
        private RemoteConfiguration.SSDFileInfo info = null;

        public TranslateTask(RemoteConfiguration.SSDFileInfo info) {
            this.info = info;
        }

        @Override
        protected Void doInBackground() throws Exception {
            XSightFileDataPanel.this.itemTextData.clear();
            XSightFileDataPanel.this.tags.clear();
            XSightFileDataPanel.this.docIndex = 0;
            if (this.info == null) {
                XSightFileDataPanel.this.dataPane.setText("");
                XSightFileDataPanel.this.remoteConfig.getOwner().setInterfaceState(null);
                return null;
            }
            short[] data = XSightFileDataPanel.this.dataToShow;
            XSightFileDataPanel.this.tagNames = XSightFileDataPanel.this.remoteConfig.getBXMLtagnames(null, data, this.info.fileStart);
            int pos = this.info.xcfStart;
            int fileIndex = this.info.index;
            StringBuilder sb = new StringBuilder();
            SimpleAttributeSet set = new SimpleAttributeSet();
            SimpleAttributeSet textSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(set, "Monospaced");
            StyleConstants.setFontSize(set, XSightFileDataPanel.this.xcfFontSize);
            StyleConstants.setBold(set, false);
            StyleConstants.setBold(textSet, true);
            StyleConstants.setForeground(set, XSightFileDataPanel.this.foregroundColor);
            StyleConstants.setForeground(textSet, Color.BLACK);
            XSightFileDataPanel.this.dataPane.setText("");
            XSightFileDataPanel.this.docu = (DefaultStyledDocument)XSightFileDataPanel.this.dataPane.getDocument();
            String str = String.format("%05X-%05X: Metadata (not displayed)%n%n", this.info.fileStart, this.info.xcfStart - 1);
            sb.append(str);
            XSightFileDataPanel.this.docIndex += str.length();
            while (true) {
                short tag;
                if (((tag = data[pos++]) & 0x80) == 0) {
                    if (fileIndex == 0 && tag > 1 && XSightFileDataPanel.this.tags.size() == 3) {
                        XSightFileDataPanel.this.tags.remove(0);
                    }
                    if ((str = XSightFileDataPanel.this.translateItem(tag, XSightFileDataPanel.this.tags.size(), data, pos)) != null) {
                        sb.append(str);
                        XSightFileDataPanel.this.docIndex += str.length();
                    }
                    XSightFileDataPanel.this.tags.add(0, Integer.valueOf(tag));
                    short len = data[pos++];
                    pos += len;
                    continue;
                }
                int last = (Integer)XSightFileDataPanel.this.tags.remove(0);
                if (tag != (last | 0x80)) {
                    System.err.println("XCF file nesting error at " + Integer.toHexString(pos - 1));
                    break;
                }
                str = XSightFileDataPanel.this.translateItem(tag, XSightFileDataPanel.this.tags.size(), data, pos);
                if (str != null) {
                    sb.append(str);
                    XSightFileDataPanel.this.docIndex += str.length();
                }
                if (XSightFileDataPanel.this.tags.isEmpty()) break;
            }
            XSightFileDataPanel.this.docuText = sb.toString();
            try {
                XSightFileDataPanel.this.docu.insertString(XSightFileDataPanel.this.docu.getLength(), XSightFileDataPanel.this.docuText, set);
                for (Integer[] itemParams : XSightFileDataPanel.this.itemTextData) {
                    XSightFileDataPanel.this.docu.setCharacterAttributes(itemParams[0], itemParams[1], textSet, false);
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            XSightFileDataPanel.this.remoteConfig.getOwner().setInterfaceState(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XSightFileDataPanel.this.dataScroll.getVerticalScrollBar().setValue(0);
                    XSightFileDataPanel.this.dataPane.grabFocus();
                    XSightFileDataPanel.this.dataPane.setCaretPosition(0);
                }
            });
            return null;
        }
    }
}

