/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.CheckSum;

public class Xor16CheckSum
extends CheckSum {
    public Xor16CheckSum(int addr, AddressRange range, boolean comp) {
        super(addr, range, comp);
    }

    @Override
    public String toString() {
        return "*" + super.toString();
    }

    @Override
    public short calculateCheckSum(short[] data, int start, int end) {
        int rounding = this.addressRange.getRoundTo() - 1;
        end |= rounding < 0 ? 3 : rounding;
        short sum = 0;
        for (int i = start; i <= end - 1; i += 2) {
            sum = (short)(sum ^ (data[i] << 8 | data[i + 1]) & 0xFFFF);
        }
        return sum;
    }

    @Override
    public void setCheckSum(short[] data) {
        short sum = this.calculateCheckSum(data, this.addressRange.getStart(), this.addressRange.getEnd());
        if (this.complement) {
            sum = (short)(~sum & 0xFFFF);
        }
        data[this.checkSumAddress] = (short)(sum >> 8 & 0xFF);
        data[this.checkSumAddress + 1] = (short)(~sum & 0xFF);
    }

    @Override
    public int getCheckSum(short[] data) {
        short sum = this.calculateCheckSum(data, this.addressRange.getStart(), this.addressRange.getEnd());
        if (this.complement) {
            sum = (short)(~sum & 0xFFFF);
        }
        return (sum ^ 0xFF) & 0xFFFF;
    }
}

