/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.ble;

import com.fazecast.jSerialComm.SerialPort;
import com.hifiremote.jp1.io.UEIPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JOptionPane;
import org.thingml.bglib.BDAddr;
import org.thingml.bglib.BGAPI;
import org.thingml.bglib.BGAPIDefaultListener;
import org.thingml.bglib.BGAPIListener;
import org.thingml.bglib.BGAPIPacket;
import org.thingml.bglib.BGAPITransport;
import rmirwin10ble.IBleInterface;

public class BlueGiga
implements IBleInterface {
    BGAPIListener bgl = new BGAPIDefaultListener(){

        @Override
        public void receive_system_get_info(int major, int minor, int patch, int build, int ll_version, int protocol_version, int hw) {
            BlueGiga.this.bledConn = true;
        }

        @Override
        public void receive_attributes_value(int connection, int reason, int handle, int offset, byte[] value) {
            BlueGiga.access$102(BlueGiga.this, value);
        }

        @Override
        public void receive_connection_status(int conn, int flags, BDAddr address, int address_type, int conn_interval, int timeout, int latency, int bonding) {
            System.err.println("[" + address.toString() + "] Conn = " + conn + " Flags = " + flags);
            if (flags != 0) {
                BlueGiga.this.connection = conn;
            } else {
                System.err.println("Connection lost!");
                BlueGiga.this.connection = -1;
            }
        }

        @Override
        public void receive_connection_update(int connection, int result) {
        }

        @Override
        public void receive_connection_get_rssi(int connection, int rssi) {
            BlueGiga.this.signalStrength = rssi;
        }

        @Override
        public void receive_connection_disconnected(int conn, int reason) {
            BlueGiga.this.connection = -1;
            System.err.println("Disconnected with reason code 0x" + Integer.toHexString(reason));
            if (!BlueGiga.this.disconnecting) {
                BlueGiga.this.disconnecting = true;
            }
        }

        @Override
        public void receive_attclient_read_by_group_type(int connection, int result) {
        }

        @Override
        public void receive_attclient_procedure_completed(int connection, int result, int chrhandle) {
            if (BlueGiga.this.discovery_state != 0) {
                if (BlueGiga.this.discovery_state == 1) {
                    BlueGiga.this.stage = 3;
                    BlueGiga.this.discovery_it = BlueGiga.this.services.values().iterator();
                    BlueGiga.this.discovery_state = 2;
                }
                if (BlueGiga.this.discovery_state == 2) {
                    if (BlueGiga.this.discovery_it.hasNext()) {
                        BlueGiga.this.stage = 4;
                        BlueGiga.this.discovery_srv = (BLEService)BlueGiga.this.discovery_it.next();
                        BlueGiga.this.bgapi.send_attclient_find_information(connection, BlueGiga.this.discovery_srv.getStart(), BlueGiga.this.discovery_srv.getEnd());
                    } else {
                        BlueGiga.this.discovery_state = 0;
                    }
                }
            } else {
                BlueGiga.this.completed = true;
            }
            if (result != 0) {
                // empty if block
            }
        }

        @Override
        public void receive_attclient_group_found(int connection, int start, int end, byte[] uuid) {
            BLEService srv = new BLEService(uuid, start, end);
            BlueGiga.this.services.put(srv.getUuidString(), srv);
        }

        @Override
        public void receive_attclient_find_information_found(int connection, int chrhandle, byte[] uuid) {
            if (BlueGiga.this.discovery_state == 2 && BlueGiga.this.discovery_srv != null) {
                BLEAttribute att = new BLEAttribute(uuid, chrhandle);
                BlueGiga.this.discovery_srv.getAttributes().add(att);
                BlueGiga.this.attributeHandles.put(att.getUuidString(), chrhandle);
            }
        }

        @Override
        public void receive_attclient_attribute_value(int connection, int atthandle, int type, byte[] value) {
            Integer inHandle = (Integer)BlueGiga.this.attributeHandles.get("0xFFE2");
            if (inHandle != null && atthandle == inHandle) {
                BlueGiga.this.inCount++;
                BlueGiga.this.synced = false;
                BlueGiga.this.inData.add(value);
                BlueGiga.this.synced = true;
            } else {
                BlueGiga.access$102(BlueGiga.this, value);
            }
        }

        @Override
        public void receive_attclient_write_command(int connection, int result) {
            BlueGiga.this.sentState = 1 + result;
        }

        @Override
        public void receive_gap_connect_direct(int result, int connection_handle) {
            System.err.println("Connect direct returned result " + result + ", handle " + connection_handle);
            BlueGiga.this.reserved_connection = connection_handle;
        }

        @Override
        public void receive_gap_end_procedure(int result) {
            if (result == 0) {
                BlueGiga.this.scanning = false;
            }
        }

        @Override
        public void receive_gap_scan_response(int rssi, int packet_type, BDAddr sender, int address_type, int bond, byte[] data) {
            byte[] b = sender.getByteAddr();
            String addr = String.format("%02x:%02x:%02x:%02x:%02x:%02x", b[5], b[4], b[3], b[2], b[1], b[0]);
            if (BlueGiga.this.fullAddressList.indexOf(addr) < 0) {
                BlueGiga.this.fullAddressList.add(addr);
                String ueiName = BlueGiga.this.getNameFromScanData(data).trim();
                if (BlueGiga.this.getAllBT || ueiName.length() == 5 && ueiName.toLowerCase().substring(1).equals("mart")) {
                    BlueGiga.this.addressList.add(addr);
                    BlueGiga.this.nameList.add(ueiName);
                    BlueGiga.this.rssiList.add(rssi);
                    if (BlueGiga.this.getAllBT) {
                        String found = "Found BT address " + addr;
                        if (!ueiName.isEmpty()) {
                            found = found + ", name = " + ueiName;
                        }
                        System.err.println(found);
                    }
                }
            }
        }
    };
    private static final int IDLE = 0;
    private static final int SERVICES = 1;
    private static final int ATTRIBUTES = 2;
    private Iterator<BLEService> discovery_it = null;
    private BLEService discovery_srv = null;
    private int discovery_state = 0;
    private LinkedHashMap<String, BLEService> services = new LinkedHashMap();
    private LinkedHashMap<String, Integer> attributeHandles = new LinkedHashMap();
    private int signalStrength;
    private boolean bledConn = false;
    private boolean scanning = false;
    private boolean hasCCCD = false;
    private String subscription = null;
    private BGAPI bgapi;
    private boolean synced = true;
    private boolean getAllBT = false;
    private BGAPITransport transport = null;
    private int sentState = 0;
    public int reserved_connection = -1;
    public int connection = -1;
    private int stage = 0;
    private int inCount = 0;
    private boolean disconnecting = false;
    protected SerialPort port = null;
    private ArrayList<UEIPacket> incoming = new ArrayList();
    private byte[] receivedValue = null;
    private boolean completed = false;
    public String win10n = "Win10 Native";
    private ArrayList<String> addressList = new ArrayList();
    private ArrayList<String> fullAddressList = new ArrayList();
    private ArrayList<String> nameList = new ArrayList();
    private ArrayList<Integer> rssiList = new ArrayList();
    private ArrayList<byte[]> inData = new ArrayList();

    public static SerialPort connectSerial(String portName) {
        try {
            SerialPort serialPort = SerialPort.getCommPort(portName);
            if (!serialPort.openPort()) {
                System.err.println("Error: Can't open port " + portName + ".");
                return null;
            }
            serialPort.setComPortParameters(115200, 8, 1, 0);
            serialPort.setComPortTimeouts(1, 0, 0);
            return serialPort;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String ConnectBLE(String portName) {
        this.port = BlueGiga.connectSerial(portName);
        String message = null;
        if (this.port != null) {
            try {
                this.transport = new BGAPITransport(this.port.getInputStream(), this.port.getOutputStream());
                this.bgapi = new BGAPI(this.transport);
                System.err.println("Trying to connect to BLED on port " + portName);
                this.bgapi.addListener(this.bgl);
                Thread.sleep(250L);
                this.bledConn = false;
                this.bgapi.send_system_get_info();
                long waitStart = Calendar.getInstance().getTimeInMillis();
                long delay = 0L;
                while (!this.bledConn) {
                    delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                    if (delay <= 1000L) continue;
                    message = "Connection request timed out after 1000ms";
                    this.DisconnectBLE();
                    break;
                }
                if (this.bledConn) {
                    System.err.println("Connected to BLED after " + delay + "ms");
                }
            }
            catch (Exception ex) {
                System.err.println("Exception while connecting to " + this.port);
                message = "Error in connecting to BLED";
            }
        } else {
            System.err.println("Failed to find port " + portName);
            message = "Failed to find port " + portName;
        }
        if (message != null) {
            JOptionPane.showMessageDialog(null, message, "Connection error", 0);
            return null;
        }
        return portName;
    }

    @Override
    public void DisconnectBLE() {
        if (this.bgapi != null) {
            this.bgapi.removeListener(this.bgl);
            this.bgapi.send_system_reset(0);
            this.bgapi.disconnect();
        }
        if (this.port != null) {
            this.port.closePort();
        }
        this.bgapi = null;
        this.port = null;
        this.connection = -1;
    }

    @Override
    public void DiscoverUEI(boolean start, boolean getAll) {
        if (start) {
            this.addressList.clear();
            this.fullAddressList.clear();
            this.nameList.clear();
            this.rssiList.clear();
            this.scanning = true;
            this.getAllBT = getAll;
            this.bgapi.send_gap_set_scan_parameters(10, 250, 1);
            this.bgapi.send_gap_discover(2);
        } else {
            this.bgapi.send_gap_end_procedure();
            long waitStart = Calendar.getInstance().getTimeInMillis();
            long delay = 0L;
            while (this.scanning) {
                delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                if (delay <= 1000L) continue;
                this.scanning = false;
                break;
            }
        }
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean DiscoverServices() {
        this.discovery_state = 1;
        long waitStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        this.bgapi.send_attclient_read_by_group_type(this.connection, 1, 65535, new byte[]{0, 40});
        int i = 0;
        while (this.discovery_state != 0) {
            delay = Calendar.getInstance().getTimeInMillis() - waitStart;
            if (i < 3 && this.discovery_state == 1 && this.services.isEmpty() && delay > 2000L) {
                System.err.println("Attempt " + ++i + " to discover services failed");
                this.sleep(50);
                waitStart = Calendar.getInstance().getTimeInMillis();
                this.bgapi.send_attclient_read_by_group_type(this.connection, 1, 65535, new byte[]{0, 40});
            }
            if (delay > 10000L) {
                System.err.println("Service discovery failed to end");
                this.discovery_state = 0;
                return false;
            }
            this.sleep(20);
        }
        return true;
    }

    @Override
    public boolean GetFeatures() {
        this.stage = 5;
        int handle = this.findDescriptor("0xFFE0", "0xFFE2", "0x2902", false);
        if (handle != 0) {
            this.hasCCCD = true;
            long waitStart = Calendar.getInstance().getTimeInMillis();
            this.completed = false;
            this.bgapi.send_attclient_attribute_write(this.connection, handle, new byte[]{1, 0});
            while (!this.completed) {
                long delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                if (delay <= 2000L) continue;
                return false;
            }
            this.findDescriptor("0xFFE0", "0xFFE2", "0x2902", true);
            int val = (this.receivedValue[1] << 8) + this.receivedValue[0];
            String[] cccdValues = new String[]{"None", "Notify", "Indicate"};
            this.subscription = "CCCD state: " + cccdValues[val];
        } else {
            this.subscription = "CCCD absent";
        }
        return true;
    }

    public String getGATTDescription() {
        String result = this.toString();
        for (BLEService s : this.services.values()) {
            result = result + "\n" + s.getDescription();
        }
        return result;
    }

    @Override
    public boolean IsConnected() {
        return this.connection >= 0;
    }

    @Override
    public boolean ConnectUEI(String address) {
        this.reserved_connection = -1;
        this.connection = -1;
        this.stage = 1;
        this.incoming.clear();
        System.err.println("About to send gap_connect_direct");
        BDAddr addr = BDAddr.fromString(address);
        this.bgapi.send_gap_connect_direct(addr, 0, 20, 100, 1000, 0);
        System.err.println("Sent gap_connect_direct");
        long waitStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        while (this.connection == -1) {
            delay = Calendar.getInstance().getTimeInMillis() - waitStart;
            if (delay <= 5000L) continue;
            return false;
        }
        this.stage = 2;
        return true;
    }

    @Override
    public String DisconnectUEI() {
        long delay;
        if (this.connection < 0) {
            return "Already disconnected";
        }
        this.disconnecting = true;
        this.bgapi.send_connection_disconnect(this.connection);
        long waitStart = Calendar.getInstance().getTimeInMillis();
        while (this.connection >= 0 && (delay = Calendar.getInstance().getTimeInMillis() - waitStart) <= 1000L) {
        }
        return this.connection >= 0 ? "Disconnection failed" : "Disconnection succeeded";
    }

    private int findDescriptor(String uuidServ, String uuidChstic, String uuidDesc, boolean doRead) {
        int handle = 0;
        boolean atChstic = false;
        BLEService ueiService = this.services.get(uuidServ);
        for (BLEAttribute att : ueiService.getAttributes()) {
            if (!atChstic && !att.getUuidString().equals(uuidChstic)) continue;
            atChstic = true;
            if (!att.getUuidString().equals(uuidDesc)) continue;
            handle = att.getHandle();
            break;
        }
        if (!doRead) {
            return handle;
        }
        this.receivedValue = null;
        if (handle != 0) {
            long waitStart = Calendar.getInstance().getTimeInMillis();
            long delay = 0L;
            this.receivedValue = null;
            this.bgapi.send_attclient_read_by_handle(this.connection, handle);
            while (this.receivedValue == null) {
                delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                if (delay <= 2000L) continue;
                return 0;
            }
        }
        return handle;
    }

    @Override
    public boolean IsScanning() {
        return this.scanning;
    }

    @Override
    public void WritePacket(byte[] pkt) {
        int ueiOut = this.attributeHandles.get("0xFFE1");
        BGAPIPacket bpkt = new BGAPIPacket(0, 4, 6);
        bpkt.w_uint8(this.connection);
        bpkt.w_uint16(ueiOut);
        bpkt.w_uint8array(pkt);
        this.transport.sendPacket(bpkt);
    }

    @Override
    public int GetListSize() {
        int size = Math.min(this.addressList.size(), this.nameList.size());
        return Math.min(size, this.rssiList.size());
    }

    @Override
    public String GetListItem(int ndx) {
        return this.addressList.get(ndx);
    }

    @Override
    public String GetItemName(int ndx) {
        return this.nameList.get(ndx);
    }

    @Override
    public int GetRssi(int ndx) {
        return this.rssiList.get(ndx);
    }

    @Override
    public int GetInDataSize() {
        return this.inData.size();
    }

    @Override
    public byte[] GetInData(int ndx) {
        while (!this.synced) {
        }
        return this.inData.remove(ndx);
    }

    private String getNameFromScanData(byte[] data) {
        byte adSize;
        String name = "";
        for (int pos = 0; pos < data.length - 1; pos += adSize - 1) {
            byte adType;
            adSize = data[pos++];
            if ((adType = data[pos++]) != 8 && adType != 9) continue;
            name = new String(Arrays.copyOfRange(data, pos, pos + adSize - 1));
            break;
        }
        return name;
    }

    @Override
    public boolean IsDisconnecting() {
        return this.disconnecting;
    }

    @Override
    public void SetDisconnecting(boolean disconnecting) {
        this.disconnecting = disconnecting;
    }

    @Override
    public int ReadSignalStrength() {
        this.signalStrength = 0;
        long waitStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        this.bgapi.send_connection_get_rssi(this.connection);
        while (this.signalStrength == 0) {
            delay = Calendar.getInstance().getTimeInMillis() - waitStart;
            if (delay <= 1000L) continue;
            return 0;
        }
        return this.signalStrength;
    }

    @Override
    public void SetSentState(int state) {
        this.sentState = state;
    }

    @Override
    public int GetSentState() {
        return this.sentState;
    }

    @Override
    public String GetSubscription() {
        return this.subscription;
    }

    @Override
    public int GetStage() {
        return this.stage;
    }

    @Override
    public boolean HasCCCD() {
        return this.hasCCCD;
    }

    @Override
    public boolean NeedsCCCD() {
        return false;
    }

    @Override
    public int GetInCount() {
        return this.inCount;
    }

    @Override
    public String GetBLEStack() {
        return "Texas Instruments";
    }

    @Override
    public void UpdateConnection(int interval_min, int interval_max, int latency, int timeout) {
        this.bgapi.send_connection_update(this.connection, interval_min, interval_max, latency, timeout);
    }

    @Override
    public byte[] ReadUserDescription(String uuid) {
        int handle = this.findDescriptor("0xFFE0", "0x" + uuid.toUpperCase(), "0x2901", true);
        return handle != 0 ? this.receivedValue : null;
    }

    static /* synthetic */ byte[] access$102(BlueGiga x0, byte[] x1) {
        x0.receivedValue = x1;
        return x1;
    }

    public static class BLEService {
        protected int start;
        protected int end;
        protected byte[] uuid;
        protected ArrayList<BLEAttribute> attributes = new ArrayList();

        public BLEService(byte[] uuid, int start, int end) {
            this.uuid = uuid;
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public byte[] getUuid() {
            return this.uuid;
        }

        public ArrayList<BLEAttribute> getAttributes() {
            return this.attributes;
        }

        public String getUuidString() {
            String result = "";
            for (int i = 0; i < this.uuid.length; ++i) {
                result = String.format("%02X", this.uuid[i]) + result;
            }
            result = "0x" + result;
            return result;
        }

        public String toString() {
            return "BLEService " + this.getUuidString() + " (" + this.start + ".." + this.end + ")";
        }

        public String getDescription() {
            String result = this.toString();
            for (BLEAttribute a : this.attributes) {
                result = result + "\n\t" + a.toString();
            }
            return result;
        }
    }

    public static class BLEAttribute {
        protected byte[] uuid;
        private int handle;

        public BLEAttribute(byte[] uuid, int handle) {
            this.uuid = uuid;
            this.setHandle(handle);
        }

        public byte[] getUuid() {
            return this.uuid;
        }

        public String getUuidString() {
            String result = "";
            for (int i = 0; i < this.uuid.length; ++i) {
                result = String.format("%02X", this.uuid[i]) + result;
            }
            result = "0x" + result;
            return result;
        }

        public String toString() {
            return "ATT " + this.getUuidString() + " => 0x" + Integer.toHexString(this.getHandle()).toUpperCase();
        }

        public int getHandle() {
            return this.handle;
        }

        public void setHandle(int handle) {
            this.handle = handle;
        }
    }
}

