/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.clipboard;

import com.hifiremote.jp1.clipboard.ClipboardReader;
import com.hifiremote.jp1.clipboard.HTMLClipboardReader;
import com.hifiremote.jp1.clipboard.PlainTextClipboardReader;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ClipboardReaderFactory {
    public static ClipboardReader getClipboardReader(Transferable transferable, boolean fromIE) throws UnsupportedFlavorException, IOException {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        ClipboardReader reader = null;
        for (DataFlavor tentative : flavors) {
            Class<?> clazz;
            if (!tentative.getPrimaryType().equals("text") || (clazz = tentative.getRepresentationClass()) != Reader.class && clazz != InputStream.class) continue;
            String subType = tentative.getSubType();
            if (fromIE && subType.equals("html")) {
                reader = new HTMLClipboardReader(tentative.getReaderForText(transferable));
                break;
            }
            if (!subType.equals("plain")) continue;
            reader = new PlainTextClipboardReader(tentative.getReaderForText(transferable));
        }
        return reader;
    }
}

