/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.clipboard;

import com.hifiremote.jp1.clipboard.ClipboardReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class HTMLClipboardReader
extends ClipboardReader {
    private PushbackReader rdr = null;
    boolean ignore = true;

    public HTMLClipboardReader(Reader in) {
        this.rdr = new PushbackReader(in);
    }

    protected String nextToken() throws IOException {
        StringBuffer buff = new StringBuffer();
        int i = this.rdr.read();
        if (i < 0) {
            return null;
        }
        if (i >= 0) {
            char ch = (char)i;
            buff.append(ch);
            boolean pushback = false;
            char term = '>';
            if (i != 60) {
                term = '<';
                pushback = true;
            }
            i = this.rdr.read();
            while (i > 0) {
                ch = (char)i;
                if (ch == term) {
                    if (pushback) {
                        this.rdr.unread(i);
                        break;
                    }
                    buff.append(ch);
                    break;
                }
                buff.append(ch);
                i = this.rdr.read();
            }
        }
        return buff.toString().trim();
    }

    @Override
    public List<String> readNextLine() throws IOException {
        String token = null;
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inRow = false;
        boolean inCell = false;
        while ((token = this.nextToken()) != null) {
            String lowerToken = token.toLowerCase();
            if (lowerToken.equals("<!--startfragment-->")) {
                this.ignore = false;
                continue;
            }
            if (this.ignore) continue;
            if (lowerToken.equals("<!--endfragment-->")) {
                this.ignore = true;
                continue;
            }
            if (lowerToken.startsWith("<tr")) {
                inRow = true;
                continue;
            }
            if (!inRow) continue;
            if (lowerToken.equals("</tr>")) {
                inRow = false;
                break;
            }
            if (lowerToken.startsWith("<td") || lowerToken.startsWith("<th")) {
                inCell = true;
                continue;
            }
            if (lowerToken.equals("</td>") || lowerToken.equals("</th>")) {
                inCell = false;
                continue;
            }
            if (!inCell) continue;
            tokens.add(token);
        }
        if (token == null) {
            return null;
        }
        return tokens;
    }

    @Override
    public void close() throws IOException {
        this.rdr.close();
    }
}

