/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.IrHex;
import com.hifiremote.jp1.extinstall.IrHexConfig;

public class AdvItem {
    short m_Key;
    short m_Device;
    short m_Type;
    short m_Length;
    short m_HdrSize;
    short m_Multiplier;
    short[] m_Data;
    String m_commentText;

    public AdvItem() {
    }

    public AdvItem(ErrorLogger Erl, IrHexConfig HexConfig, int start, String CommentText) {
        this.m_Key = ((IrHex)HexConfig.get(start++)).get();
        short b2 = ((IrHex)HexConfig.get(start++)).get();
        if (HexConfig.m_AdvCodeType == 0) {
            this.m_Device = (short)(b2 >> 4);
            if (this.m_Device == 1) {
                this.m_Type = (short)8;
            } else if (this.m_Device == 3) {
                this.m_Type = (short)3;
            } else {
                this.m_Type = 1;
                this.m_Device = (short)(this.m_Device >> 1);
            }
            this.m_Length = (short)(b2 & 0xF);
            this.m_HdrSize = (short)2;
            this.m_Multiplier = (short)HexConfig.Multiplier(this.m_Type);
        } else {
            this.m_Device = (short)(b2 & 0xF);
            this.m_Type = (short)(b2 >> 4);
            this.m_Length = ((IrHex)HexConfig.get(start++)).get();
            this.m_HdrSize = (short)3;
            this.m_Multiplier = 1;
        }
        this.m_commentText = CommentText;
        this.m_Data = new short[this.m_Length];
        int n = 0;
        while (n < this.m_Length) {
            if (HexConfig.IsValid(start)) {
                this.m_Data[n] = ((IrHex)HexConfig.get(start)).get();
            } else {
                this.m_Data[n] = 0;
                Erl.Error("Data missing at %X", start);
            }
            ++n;
            ++start;
        }
    }

    int Key() {
        return this.m_Key;
    }

    int Dev() {
        return this.m_Device;
    }

    int Type() {
        return this.m_Type;
    }

    int Length() {
        return this.m_Length;
    }

    int FullSize() {
        return this.m_Length + this.m_HdrSize;
    }

    boolean IsMacro() {
        return this.Type() == 8 || this.Type() == 3;
    }

    boolean Match(AdvItem X) {
        return this.m_Key == X.m_Key && this.m_Device == X.m_Device && this.m_Type == X.m_Type;
    }

    boolean equals(AdvItem X) {
        if (this.m_Key == X.m_Key && this.m_Type == X.m_Type && this.m_Length == X.m_Length && this.m_Device == X.m_Device && this.m_Multiplier == X.m_Multiplier) {
            int n = this.m_Length * this.m_Multiplier;
            do {
                if (--n >= 0) continue;
                return true;
            } while (this.m_Data[n] == X.m_Data[n]);
        }
        return false;
    }

    static enum Flag {
        eKeyMoveCollideNew,
        eMacroCollideNew;

    }
}

