/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.extinstall.AdvItem;
import com.hifiremote.jp1.extinstall.AdvList;
import com.hifiremote.jp1.extinstall.CrudeErrorLogger;
import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.IrHexConfig;
import com.hifiremote.jp1.extinstall.Rdf;
import com.hifiremote.jp1.extinstall.UpgradeList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;

public class ExtInstall {
    private String hexName;
    private String oldName;
    private String newName;
    private int sigAddr;

    public static void main(String[] argv) throws IOException, CloneNotSupportedException {
        String version = ExtInstall.class.getPackage().getImplementationVersion();
        System.out.print("Java ExtInstall");
        if (version != null) {
            System.out.println(", version " + version);
        } else {
            System.out.println();
        }
        int SigAddr = 2;
        if (argv.length < 3 || argv.length > 4) {
            System.err.println("Usage:");
            System.err.println();
            System.err.println("java -jar ExtInstall.jar Extender.hex Unextended.ir Extended.ir [-sig=$nnnn]");
            System.err.println();
            System.err.println("where:");
            System.err.println("\t- Extender.hex is the hex file containing the extender to tbe installed");
            System.err.println("\t- Unextended.ir is your existing IR file without the extender");
            System.err.println("\t- Extended.ir is the new file created by combining your unextended");
            System.err.println("\t\tIR file and the extender hex file");
            System.err.println("\t- nnnn is the optional offset of the remote signature, use only if");
            System.err.println("\t\tinstructed to do so by the extender's documentation.");
            System.exit(1);
        }
        if (argv.length == 4) {
            String[] parts = argv[3].split("=");
            String part1 = parts[0];
            if (parts.length > 1) {
                part1 = part1.toLowerCase();
                String part2 = parts[1];
                if (part1.substring(0, 2).equals("-s")) {
                    if (part2.charAt(0) == '$') {
                        part2 = part2.substring(1);
                    }
                    SigAddr = Integer.parseInt(part2, 16);
                }
            }
        }
        ExtInstall installer = new ExtInstall(argv[0], argv[1], argv[2], SigAddr);
        installer.install();
    }

    public ExtInstall(String hexName, String oldName, String newName, int sigAddr) {
        this.hexName = hexName;
        this.oldName = oldName;
        this.newName = newName;
        this.sigAddr = sigAddr;
    }

    public void install() throws IOException, CloneNotSupportedException {
        CrudeErrorLogger Erl = new CrudeErrorLogger();
        IrHexConfig ExtHex = new IrHexConfig();
        AdvList ExtAdv = new AdvList();
        UpgradeList ExtUpgrade = new UpgradeList();
        Rdf ExtRdf = new Rdf();
        System.out.printf("Loading %s data and comments \n \n", this.hexName);
        ExtInstall.LoadHex(Erl, this.hexName, ExtHex, ExtAdv, ExtUpgrade, ExtRdf, this.sigAddr);
        IrHexConfig OldHex = new IrHexConfig();
        AdvList OldAdv = new AdvList();
        UpgradeList OldUpgrade = new UpgradeList();
        Rdf OldRdf = new Rdf();
        System.out.printf("Loading %s data and comments \n \n", this.oldName);
        ExtInstall.LoadHex(Erl, this.oldName, OldHex, OldAdv, OldUpgrade, OldRdf, this.sigAddr);
        if (ExtHex.IsValid(0)) {
            OldAdv.Merge(ExtAdv, EnumSet.of(AdvItem.Flag.eMacroCollideNew, AdvItem.Flag.eKeyMoveCollideNew));
            OldUpgrade.Merge(Erl, ExtUpgrade, EnumSet.of(UpgradeList.Flag.eProtocolCollideNew, UpgradeList.Flag.eDeviceCollideNew));
            String generalComment = OldHex.GetComment(0);
            OldHex.RemoveComments();
            OldHex.SetComment(0, generalComment);
            OldHex.PostAdvList(Erl, OldAdv);
            OldHex.PostUpgradeList(Erl, OldUpgrade);
            File OutFile = new File(this.newName);
            PrintWriter pw = new PrintWriter(new FileWriter(OutFile));
            OldRdf.DoCheckSums(OldHex);
            OldHex.Dump(pw);
            pw.close();
        } else {
            ExtAdv.Merge(OldAdv, EnumSet.of(AdvItem.Flag.eMacroCollideNew));
            ExtUpgrade.Merge(Erl, OldUpgrade, EnumSet.noneOf(UpgradeList.Flag.class));
            String generalComment = OldHex.GetComment(0);
            ExtHex.RemoveComments();
            if (generalComment != null && !generalComment.equals("")) {
                ExtHex.SetComment(0, generalComment);
            }
            ExtHex.PostAdvList(Erl, ExtAdv);
            ExtHex.PostUpgradeList(Erl, ExtUpgrade);
            File OutFile = new File(this.newName);
            PrintWriter pw = new PrintWriter(new FileWriter(OutFile));
            ExtHex.Merge(OldHex);
            ExtRdf.DoCheckSums(ExtHex);
            ExtHex.Dump(pw);
            pw.close();
        }
    }

    public static File FindFile(String Name2, String Ext) {
        File file = new File(Name2);
        if (!file.exists() && !(file = new File(String.valueOf(Name2) + Ext)).exists()) {
            return null;
        }
        return file;
    }

    public static void LoadHex(ErrorLogger Erl, String arg, IrHexConfig Config2, AdvList Adv, UpgradeList Upgrade, Rdf rdf, int sigaddr) throws IOException {
        File Directory;
        File file = ExtInstall.FindFile(arg, ".txt");
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        if (!Config2.Load(Erl, rdr)) {
            System.exit(1);
        }
        if ((Directory = file.getParentFile()) == null) {
            Directory = new File(".");
        }
        char[] Sig = new char[8];
        int ndx = 0;
        while (ndx < Sig.length) {
            Sig[ndx] = (char)Config2.Get(ndx + sigaddr);
            ++ndx;
        }
        String signature = new String(Sig);
        rdf.Load(Erl, signature, Directory);
        boolean NeededDefaults = false;
        if (rdf.m_AdvCodeAddr.end < 0) {
            NeededDefaults = true;
            rdf.m_AdvCodeAddr.begin = 27;
            rdf.m_AdvCodeAddr.end = 255;
        }
        if (rdf.m_UpgradeAddr.end < 0) {
            NeededDefaults = true;
            rdf.m_UpgradeAddr.begin = 256;
            rdf.m_UpgradeAddr.end = 1022;
        }
        if (NeededDefaults) {
            Erl.Error("RDF not found for %s, Signature: %s", arg, Sig);
            System.exit(-1);
        }
        Config2.m_pRdf = rdf;
        Config2.SetAdvMem(rdf.m_AdvCodeAddr.begin, rdf.m_AdvCodeAddr.end);
        Config2.SetUpgradeMem(rdf.m_UpgradeAddr.begin, rdf.m_UpgradeAddr.end);
        Config2.SetBaseAddr(rdf.m_BaseAddr);
        Config2.SetAdvCodeType(rdf.m_AdvCodeType);
        Config2.SetSectionTerminator(rdf.m_SectionTerminator);
        if (rdf.m_LearnedAddr.begin != 0) {
            int last = rdf.m_LearnedAddr.begin;
            while (last < rdf.m_LearnedAddr.end && Config2.IsValid(last)) {
                ++last;
            }
            while (last < rdf.m_LearnedAddr.end && !Config2.IsValid(last)) {
                ++last;
            }
            rdf.m_LearnedAddr.end = last;
        }
        Config2.SetLearnMem(rdf.m_LearnedAddr.begin, rdf.m_LearnedAddr.end);
        Config2.FillAdvList(Erl, Adv);
        Config2.FillUpgradeList(Erl, Upgrade);
    }
}

