/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.ProgressUpdater;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

class IRToWav {
    static String nameWav = "Upgrade.WAV";
    private String sig = "";
    private int maxSize = 4096;
    private int[] img = new int[65536];
    private int word = 9;
    private int[] res = new int[10 * (this.maxSize + 2000)];
    private int[] wk = new int[65536];
    private int upStart = -1;
    private int upSize = 0;
    private int offset = 0;
    private int cur = 0;
    private int blockSize = 40;
    private int pageSize = 512;
    private int[] riff = new int[]{82, 73, 70, 70};
    private int[] wavHead = new int[]{87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 34, 86, 0, 0, 34, 86, 0, 0, 1, 0, 8, 0, 100, 97, 116, 97};
    private int samplefreq = 22050;
    private int carrierfreq = 2400;
    private double sampling = 6.283185308 * (double)this.carrierfreq / (double)this.samplefreq;
    private boolean isHCS08 = false;
    private ProgressUpdater progressUpdater = null;

    public IRToWav(String sig, int upStart, int upSize, int offset, boolean isHCS08, int[] img) {
        this.sig = sig;
        this.upStart = upStart;
        this.upSize = upSize;
        this.offset = offset;
        this.isHCS08 = isHCS08;
        this.img = img;
    }

    public static void main(String[] args) {
        int i;
        String nameImg = "";
        String sig = "";
        boolean isHCS08 = false;
        int startAdr = -1;
        int endAdr = -1;
        int[] img = new int[65536];
        int upSize = 0;
        int upStart = -1;
        int offset = 0;
        byte[] sigBytes = new byte[4];
        block9: for (i = 0; i < args.length; ++i) {
            switch (i) {
                case 0: {
                    nameImg = args[i];
                    continue block9;
                }
                case 1: {
                    sig = args[i];
                    if (sig.length() != 5 || sig.charAt(4) != '+') continue block9;
                    isHCS08 = true;
                    sig = sig.substring(0, 4);
                    continue block9;
                }
                case 2: {
                    startAdr = Integer.parseInt(args[i], 16);
                    continue block9;
                }
                case 3: {
                    endAdr = Integer.parseInt(args[i], 16);
                    continue block9;
                }
            }
        }
        if (endAdr >= 0 && endAdr < startAdr) {
            System.err.println("Starting address " + startAdr + " must be smaller than ending address " + endAdr + " !");
            System.exit(0);
        }
        if (sig.length() != 4 & sig != "") {
            System.err.println("Invalid signature #" + sig + "#. It must be exactly 4 characters long !");
            System.exit(0);
        }
        try {
            FileReader image = new FileReader(nameImg);
            int readByte = image.read();
            i = 0;
            boolean inAdr = true;
            int curData = 0;
            while (readByte > -1) {
                if (inAdr) {
                    if (readByte >= 48 & readByte <= 57) {
                        curData = curData * 16 + readByte - 48;
                    } else if (readByte >= 65 & readByte <= 70) {
                        curData = curData * 16 + readByte - 65 + 10;
                    } else if (readByte >= 97 & readByte <= 102) {
                        curData = curData * 16 + readByte - 97 + 10;
                    } else if (readByte == 58) {
                        if (upStart == -1) {
                            upStart = curData;
                        }
                        inAdr = false;
                        curData = -1;
                    }
                } else if (readByte >= 48 & readByte <= 57) {
                    curData = curData == -1 ? readByte - 48 : curData * 16 + readByte - 48;
                } else if (readByte >= 65 & readByte <= 70) {
                    curData = curData == -1 ? readByte - 65 + 10 : curData * 16 + readByte - 65 + 10;
                } else if (readByte >= 97 & readByte <= 102) {
                    curData = curData == -1 ? readByte - 97 + 10 : curData * 16 + readByte - 97 + 10;
                } else if (readByte == 32) {
                    if (curData != -1) {
                        img[i] = curData;
                        curData = -1;
                        ++i;
                    }
                } else {
                    if (curData != -1) {
                        img[i] = curData;
                        ++i;
                    }
                    inAdr = true;
                    curData = 0;
                }
                readByte = image.read();
            }
            img[i] = curData;
            upSize = ++i;
            if (endAdr == -1) {
                endAdr = upStart + upSize;
            }
            image.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open IR file");
        }
        catch (IOException e) {
            System.err.println("Could not close IR file");
        }
        if (upStart <= 2 & upStart + upSize >= 6 & (sig.compareTo("none") == 0 | sig == "")) {
            sigBytes[0] = (byte)img[2 - upStart];
            sigBytes[1] = (byte)img[3 - upStart];
            sigBytes[2] = (byte)img[4 - upStart];
            sigBytes[3] = (byte)img[5 - upStart];
            sig = new String(sigBytes);
        }
        if (sig == "") {
            sig = "EBV0";
        }
        System.err.print("Signature " + sig);
        offset = 0;
        if (endAdr < upStart + upSize & endAdr > upStart) {
            upSize = endAdr - upStart + 1;
        }
        if (startAdr > upStart & startAdr < upStart + upSize) {
            upSize = upSize - startAdr + upStart;
            offset = startAdr - upStart;
            upStart = startAdr;
        }
        IRToWav irToWav = new IRToWav(sig, upStart, upSize, offset, isHCS08, img);
        irToWav.generate(new File(nameWav));
    }

    void generate(File wavFile) {
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        try {
            int k;
            int i;
            int j;
            this.cur = 0;
            for (j = 0; j < 4; ++j) {
                for (i = 0; i < 8; ++i) {
                    this.addByte(168);
                }
                this.addByte(0);
                this.addByte(3);
                this.addByte(255);
                this.addByte(253);
            }
            for (i = 0; i < 8; ++i) {
                this.addByte(168);
            }
            this.addByte(0);
            this.addByte(5);
            this.addByte(0);
            this.addByte(0);
            this.addByte(255);
            this.addByte(251);
            for (i = 0; i < 8; ++i) {
                this.addByte(168);
            }
            this.addByte(0);
            int dataStart = this.addByte(11);
            this.addByte(86);
            this.addByte(6);
            this.addByte(this.sig.charAt(0));
            this.addByte(this.sig.charAt(1));
            this.addByte(this.sig.charAt(2));
            this.addByte(this.sig.charAt(3));
            int blockCount = this.upSize / (this.blockSize - 3) + 1;
            int dataEnd = this.addByte(blockCount);
            i = this.sum(dataStart + 1, dataEnd);
            dataEnd = this.addByte(i % 256);
            i = this.sum(dataStart - 1, dataEnd);
            i = 65536 - i;
            this.addWord(i);
            int pageCount = this.isHCS08 ? (this.upSize - 1) / this.pageSize + 1 : 0;
            for (int curPage = 0; curPage < pageCount; ++curPage) {
                for (i = 0; i < 8; ++i) {
                    this.addByte(168);
                }
                this.addByte(0);
                dataStart = this.addByte(9);
                this.addByte(67);
                this.addWord(this.upStart + curPage * this.pageSize);
                this.addByte(0);
                dataEnd = this.addByte(1);
                i = this.sum(dataStart + 1, dataEnd);
                dataEnd = this.addByte(i % 256);
                i = this.sum(dataStart - 1, dataEnd);
                i = 65536 - i;
                this.addWord(i);
            }
            int dataPos = 0;
            for (j = 0; j < blockCount; ++j) {
                for (i = 0; i < 8; ++i) {
                    this.addByte(168);
                }
                this.addByte(0);
                int blockLen = j < blockCount - 1 ? this.blockSize : this.upSize % (this.blockSize - 3) + 3;
                dataStart = this.addByte(blockLen + 5);
                this.addByte(83);
                this.addByte(blockLen);
                this.addWord(this.upStart + dataPos);
                for (k = 0; k < blockLen - 3; ++k) {
                    dataEnd = this.addByte(this.img[dataPos + this.offset]);
                    ++dataPos;
                }
                i = this.sum(dataStart + 1, dataEnd);
                dataEnd = this.addByte(i % 256);
                i = this.sum(dataStart - 1, dataEnd);
                i = 65536 - i;
                this.addWord(i);
            }
            for (k = 0; k < 8; ++k) {
                this.addByte(168);
            }
            this.addByte(0);
            this.addByte(4);
            this.addByte(69);
            this.addByte(255);
            this.addByte(183);
            int maxwk = this.cur;
            this.cur = 0;
            while (this.cur <= maxwk & false) {
                System.err.print(IRToWav.toHex2(this.wk[this.cur]) + " ");
                ++this.cur;
            }
            this.cur = 0;
            int prevbit = 1;
            for (int pos = 0; pos < maxwk; ++pos) {
                int curbyte = this.wk[pos];
                int curbit = curbyte % 2;
                curbyte /= 2;
                this.res[this.cur] = curbit == prevbit ? 1 : 0;
                ++this.cur;
                this.res[this.cur] = 1;
                ++this.cur;
                prevbit = curbit;
                for (j = 0; j < this.word - 2; ++j) {
                    curbit = curbyte % 2;
                    curbyte /= 2;
                    this.res[this.cur] = curbit == prevbit ? 0 : 1;
                    ++this.cur;
                    prevbit = curbit;
                }
            }
            int maxcount = this.cur;
            System.err.println();
            i = 0;
            while (i < maxcount & false) {
                switch (this.res[i]) {
                    case -1: {
                        System.err.print("-");
                        break;
                    }
                    case 0: {
                        System.err.print("0");
                        break;
                    }
                    case 1: {
                        System.err.print("+");
                    }
                }
                if ((i + 1) % this.word == 0) {
                    System.err.print(" ");
                }
                ++i;
            }
            FileOutputStream wav = new FileOutputStream(wavFile);
            for (i = 0; i < this.riff.length; ++i) {
                wav.write(this.riff[i]);
            }
            int samplecount = maxcount * 147 / 2 + 1;
            long lcounter = samplecount + this.wavHead.length + 4;
            wav.write((int)(lcounter % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            for (i = 0; i < this.wavHead.length; ++i) {
                wav.write(this.wavHead[i]);
            }
            lcounter = samplecount;
            wav.write((int)(lcounter % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            wav.write((int)((lcounter /= 256L) % 256L));
            wav.write(0);
            long smpcount = 0L;
            int flip = 0;
            int prog = 0;
            int newProg = 0;
            int incr = maxcount / 100 + 1;
            for (j = 0; j <= maxcount; ++j) {
                if (this.progressUpdater != null && (newProg = j / incr) > prog) {
                    this.progressUpdater.updateProgress(newProg);
                    prog = newProg;
                }
                if (this.res[j] == 1) {
                    flip = 1 - flip;
                }
                do {
                    double sine = Math.sin((double)smpcount * this.sampling);
                    if (flip != 0) {
                        sine = -sine;
                    }
                    sine = (sine + 1.0) * 126.0 + 2.0;
                    wav.write((int)sine);
                } while (10L * ++smpcount % 735L >= 9L);
            }
            for (lcounter = smpcount + 1L; lcounter < (long)samplecount; ++lcounter) {
                wav.write(128);
            }
            wav.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open .wav file");
        }
        catch (IOException e) {
            System.err.println("Could not close .wav file");
        }
    }

    public String toHex4(int value) {
        return Integer.toHexString(0x10000 | value).substring(1).toUpperCase();
    }

    public String toHex3(int value) {
        return Integer.toHexString(0x1000 | value).substring(1).toUpperCase();
    }

    public String toHex32(int value) {
        return Integer.toHexString(0x100 | value).substring(1).toUpperCase();
    }

    public void skipSep() {
        while (this.wk[this.cur] == 168) {
            ++this.cur;
        }
    }

    public int addByte(int value) {
        this.wk[this.cur] = value;
        ++this.cur;
        return this.cur;
    }

    public int addWord(int value) {
        this.wk[this.cur] = value / 256;
        this.wk[this.cur + 1] = value % 256;
        this.cur += 2;
        return this.cur;
    }

    public int sum(int start, int end) {
        int i = 0;
        for (int j = start; j < end; ++j) {
            i += this.wk[j];
        }
        return i;
    }

    public void setProgressUpdater(ProgressUpdater progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    public static String toHex2(int value) {
        return Integer.toHexString(0x100 | value).substring(1).toUpperCase();
    }
}

