/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.extinstall.AdvItem;
import com.hifiremote.jp1.extinstall.AdvList;
import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.IrHex;
import com.hifiremote.jp1.extinstall.IrHexArray;
import com.hifiremote.jp1.extinstall.Rdf;
import com.hifiremote.jp1.extinstall.UpgradeDataItem;
import com.hifiremote.jp1.extinstall.UpgradeDevice;
import com.hifiremote.jp1.extinstall.UpgradeItem;
import com.hifiremote.jp1.extinstall.UpgradeList;
import com.hifiremote.jp1.extinstall.UpgradeProtocol;
import com.hifiremote.jp1.extinstall.UpgradeTable;
import com.hifiremote.jp1.extinstall.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

class IrHexConfig
extends IrHexArray {
    int m_AdvStart = 0;
    int m_AdvLimit = 0;
    int m_UpgradeStart = 0;
    int m_UpgradeLimit = 0;
    int m_LearnStart = 0;
    int m_LearnLimit = 0;
    int m_AdvCodeType;
    int m_SectionTerminator;
    int m_BaseAddr;
    Rdf m_pRdf;
    HashMap<Integer, String> comments = new HashMap();

    public IrHexConfig() {
        super(0);
    }

    int Multiplier(int Type2) {
        return this.m_pRdf.Multiplier(Type2);
    }

    void SetAdvMem(int start, int last) {
        this.m_AdvStart = start;
        this.m_AdvLimit = last + 1;
    }

    void SetUpgradeMem(int start, int last) {
        this.m_UpgradeStart = start;
        this.m_UpgradeLimit = last + 1;
    }

    void SetLearnMem(int start, int last) {
        this.m_LearnStart = start;
        this.m_LearnLimit = last + 1;
    }

    void SetSectionTerminator(int term) {
        this.m_SectionTerminator = term;
    }

    void SetAdvCodeType(int type) {
        this.m_AdvCodeType = type;
    }

    void SetBaseAddr(int address) {
        this.m_BaseAddr = address;
    }

    boolean Load(ErrorLogger Erl, BufferedReader rdr) throws IOException {
        String Line;
        boolean foundnotes = false;
        HexParser parser = new HexParser();
        while ((Line = rdr.readLine()) != null) {
            if (Line.isEmpty()) continue;
            parser.setText(Line);
            int Addr = parser.ParseAddr();
            if (Addr < 0) {
                if (Addr == -2) continue;
                if (Line.indexOf("[Notes]") != -1) {
                    foundnotes = true;
                    Addr = 0;
                } else if (!foundnotes) {
                    Erl.Error("Unrecognised Line %s", Line);
                    return false;
                }
            }
            if (!foundnotes) {
                short Data;
                while ((Data = parser.ParseHex()) != -1) {
                    if (Addr < this.size()) {
                        if (this.get(Addr) != null) {
                            Erl.Error("OverLapping data at %X", Addr);
                            return false;
                        }
                    } else {
                        int i = this.size();
                        while (i <= Addr) {
                            this.add(i, null);
                            ++i;
                        }
                    }
                    this.Set(Addr++, Data);
                }
                if (parser.pos <= 0) continue;
                Erl.Error("Invalid data in line %s", Line);
                return false;
            }
            String[] parts = Util.Parse1(Line, "=");
            String referenceID = parts[0];
            if (parts.length <= 1) continue;
            this.comments.put(Integer.valueOf(referenceID.substring(1), 16), parts[1]);
        }
        return true;
    }

    void FillAdvList(ErrorLogger Erl, AdvList Adv) {
        boolean finished = false;
        int counter = 0;
        int addr = this.m_AdvStart + this.m_BaseAddr;
        while (addr < this.m_AdvLimit + this.m_BaseAddr && this.IsValid(addr) && !finished) {
            if (this.Get(addr) == this.m_SectionTerminator) {
                finished = true;
                continue;
            }
            int refid = 4096 + counter;
            String text = this.comments.get(refid);
            AdvItem Temp = new AdvItem(Erl, this, addr, text);
            Adv.add(Temp);
            addr += Temp.FullSize();
            ++counter;
        }
    }

    void FillUpgradeList(ErrorLogger Erl, UpgradeList Upgrade) {
        Upgrade.m_Addr = this.m_UpgradeStart + this.m_BaseAddr + 4;
        Upgrade.m_Limit = this.m_UpgradeLimit + this.m_BaseAddr;
        int DevAddr = (this.Get(this.m_UpgradeStart + this.m_BaseAddr) << 8) + this.Get(this.m_UpgradeStart + this.m_BaseAddr + 1);
        if (DevAddr + 1 >= this.size()) {
            Erl.Error("Upgrade pointer at address $%04X points to $%04X, which is out of range", this.m_UpgradeStart, DevAddr);
            System.exit(-1);
        }
        int DevCount = (this.Get(DevAddr) << 8) + this.Get(DevAddr + 1);
        Upgrade.m_DeviceTable = new UpgradeTable();
        Upgrade.m_DeviceTable.m_Address = DevAddr;
        Upgrade.m_DeviceTable.m_Size = (DevCount + 1) * 2;
        Upgrade.add(Upgrade.m_DeviceTable);
        int n = 0;
        while (n < DevCount) {
            String temp;
            UpgradeDevice pNew = new UpgradeDevice();
            pNew.m_ID = (this.Get(DevAddr + 2 * n + 2) << 8) + this.Get(DevAddr + 2 * n + 3);
            pNew.m_Address = (this.Get(DevAddr + 2 * (n + DevCount) + 2) << 8) + this.Get(DevAddr + 2 * (n + DevCount) + 3);
            int refid = 12288 + n;
            pNew.m_CommentText = temp = this.comments.get(refid);
            Upgrade.add(pNew);
            ++n;
        }
        Upgrade.m_NewDevs = Upgrade.size();
        int ProAddr = (this.Get(this.m_UpgradeStart + this.m_BaseAddr + 2) << 8) + this.Get(this.m_UpgradeStart + this.m_BaseAddr + 3);
        int ProCount = (this.Get(ProAddr) << 8) + this.Get(ProAddr + 1);
        Upgrade.m_ProtocolTable = new UpgradeTable();
        Upgrade.m_ProtocolTable.m_Address = ProAddr;
        Upgrade.m_ProtocolTable.m_Size = (ProCount + 1) * 2;
        Upgrade.add(Upgrade.m_ProtocolTable);
        int n2 = 0;
        while (n2 < ProCount) {
            String temp;
            UpgradeProtocol pNew = new UpgradeProtocol();
            pNew.m_ID = (this.Get(ProAddr + 2 * n2 + 2) << 8) + this.Get(ProAddr + 2 * n2 + 3);
            pNew.m_Address = (this.Get(ProAddr + 2 * (n2 + ProCount) + 2) << 8) + this.Get(ProAddr + 2 * (n2 + ProCount) + 3);
            int refid = 16384 + n2;
            pNew.m_CommentText = temp = this.comments.get(refid);
            Upgrade.add(pNew);
            ++n2;
        }
        n2 = 0;
        while (n2 < Upgrade.size()) {
            if (((UpgradeItem)Upgrade.get((int)n2)).m_Size == 0) {
                UpgradeDataItem pItem = (UpgradeDataItem)Upgrade.get(n2);
                Upgrade.ComputeItemSize(n2);
                int Size = pItem.m_Size;
                if (Size != 0) {
                    Util.extend(pItem.m_Data, Size);
                    int i = 0;
                    while (i < Size) {
                        pItem.m_Data.set(i, ((IrHex)this.get(pItem.m_Address + i)).get());
                        ++i;
                    }
                }
            }
            ++n2;
        }
    }

    void Merge(IrHexConfig pNew) {
        int n = pNew.size();
        if (n < this.size()) {
            n = this.size();
        }
        while (--n >= 0) {
            if (this.IsValid(n)) continue;
            if (!(n >= this.m_AdvStart && n < this.m_AdvLimit || n >= this.m_UpgradeStart && n < this.m_UpgradeLimit || !pNew.IsValid(n))) {
                this.Set(n, pNew.Get(n));
                continue;
            }
            this.Set(n, (short)this.m_SectionTerminator);
        }
    }

    void PostTable(int Addr, UpgradeList Upgrade, int ItemCount, EnumSet<UpgradeItem.Classification> table) {
        this.SetW(Addr, ItemCount);
        int index = 0;
        int n = 0;
        while (n < Upgrade.size()) {
            UpgradeItem pUp = (UpgradeItem)Upgrade.get(n);
            if (pUp.m_Size > 0 && table.contains((Object)pUp.Classify()) && pUp.m_Address < Addr) {
                UpgradeDataItem p2 = (UpgradeDataItem)pUp;
                this.SetW(Addr + 2 * index + 2, p2.m_ID);
                this.SetW(Addr + 2 * index + 2 * ItemCount + 2, p2.m_Address);
                ++index;
            }
            ++n;
        }
    }

    void PrintComments() {
        Set<Integer> keySet = this.comments.keySet();
        Object[] keys = new Integer[keySet.size()];
        keys = this.comments.keySet().toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            System.out.printf("Comment ID: %02X(%04X),  %s\n ", i, keys[i], this.comments.get(keys[i]));
            ++i;
        }
    }

    void RemoveComments() {
        this.comments.clear();
    }

    String GetComment(int refid) {
        return this.comments.get(refid);
    }

    void SetComment(int refid, String comment) {
        this.comments.put(refid, comment);
    }

    void PostAdvList(ErrorLogger Erl, AdvList Adv) {
        int Addr = this.m_AdvStart + this.m_BaseAddr;
        int n = 0;
        while (n < Adv.size()) {
            AdvItem item = (AdvItem)Adv.get(n);
            if (item.FullSize() + Addr + 1 >= this.m_AdvLimit + this.m_BaseAddr) {
                Erl.Error("AdvCode memory overflow", new Object[0]);
            } else {
                short type = item.m_Type;
                short dev = item.m_Device;
                short length = item.m_Length;
                if (item.m_commentText != null) {
                    this.SetComment(4096 + n, item.m_commentText);
                }
                this.Set(Addr++, item.m_Key);
                if (this.m_AdvCodeType == 0) {
                    if (type == 1) {
                        this.Set(Addr++, (short)((dev << 5) + length));
                    } else {
                        if (type == 8) {
                            this.Set(Addr++, (short)(16 + length));
                        }
                        if (type == 3) {
                            this.Set(Addr++, (short)((type << 4) + length));
                        }
                    }
                } else {
                    this.Set(Addr++, (short)((type << 4) + dev));
                    this.Set(Addr++, length);
                }
                int size = item.m_Length * item.m_Multiplier;
                int i = 0;
                while (i < size) {
                    this.Set(Addr++, item.m_Data[i]);
                    ++i;
                }
            }
            ++n;
        }
        this.Set(Addr, (short)this.m_SectionTerminator);
    }

    void PostUpgradeList(ErrorLogger Erl, UpgradeList Upgrade) {
        int Addr = this.m_UpgradeStart + this.m_BaseAddr + 4;
        int DTS = 2;
        int PTS = 2;
        int devnum = 0;
        int protonum = 0;
        EnumSet<UpgradeItem.Classification> deviceOrProtocol = EnumSet.of(UpgradeItem.Classification.eDevice, UpgradeItem.Classification.eProtocol);
        int n = 0;
        while (n < Upgrade.size()) {
            UpgradeItem pUp = (UpgradeItem)Upgrade.get(n);
            if (pUp.m_Size > 0 && deviceOrProtocol.contains((Object)pUp.Classify())) {
                UpgradeDataItem p2 = (UpgradeDataItem)pUp;
                if (Addr + DTS + PTS + 4 + p2.m_Size > this.m_UpgradeLimit + this.m_BaseAddr) {
                    Erl.Error("Couldn't fit upgrade ID 0x%X (%d)", p2.m_ID, p2.m_ID & 0x7FF);
                    p2.m_Address = this.m_UpgradeLimit - 1;
                } else {
                    p2.m_Address = Addr;
                    int i = 0;
                    while (i < p2.m_Size) {
                        this.Set(Addr + i, p2.m_Data.get(i));
                        ++i;
                    }
                    Addr += p2.m_Size;
                    if (p2.Classify() == UpgradeItem.Classification.eDevice) {
                        DTS += 4;
                        if (pUp.m_CommentText != null) {
                            this.SetComment(12288 + devnum, pUp.m_CommentText);
                        }
                        ++devnum;
                    } else {
                        PTS += 4;
                        if (pUp.m_CommentText != null) {
                            this.SetComment(16384 + protonum, pUp.m_CommentText);
                        }
                        ++protonum;
                    }
                }
            }
            ++n;
        }
        this.SetW(this.m_UpgradeStart + this.m_BaseAddr, Addr);
        this.PostTable(Addr, Upgrade, DTS >> 2, EnumSet.of(UpgradeItem.Classification.eDevice));
        this.SetW(this.m_UpgradeStart + this.m_BaseAddr + 2, Addr + DTS);
        this.PostTable(Addr + DTS, Upgrade, PTS >> 2, EnumSet.of(UpgradeItem.Classification.eProtocol));
    }

    void Dump(PrintWriter pw) {
        int t = this.size();
        int n = this.m_BaseAddr;
        while (n < t) {
            if ((n & 0xF) == 0) {
                if (n > 0) {
                    pw.println();
                }
                pw.print(String.format("%04X:", n));
            }
            pw.print(String.format("  %02X", this.Get(n)));
            ++n;
        }
        pw.println();
        if (!this.comments.isEmpty()) {
            pw.println("[Notes]");
            Set<Integer> keySet = this.comments.keySet();
            Object[] keys = new Integer[keySet.size()];
            keySet.toArray(keys);
            Arrays.sort(keys);
            Object[] objectArray = keys;
            int n2 = keys.length;
            int n3 = 0;
            while (n3 < n2) {
                Object key = objectArray[n3];
                pw.println(String.format("$%04X=%s", key, this.comments.get(key)));
                ++n3;
            }
        }
    }

    private class HexParser {
        private char[] text;
        public int pos;
        private static final String HexChars = "0123456789ABCDEF";
        private boolean intelHex = false;
        private int addrHigh = 0;
        private int parseLen = 0;
        private int byteCount = 256;
        private int byteIndex = 0;
        private int intelType = 0;

        private HexParser() {
        }

        void setText(String line) {
            this.text = line.toCharArray();
            this.pos = 0;
            boolean bl = this.intelHex = this.text[0] == ':';
            if (this.intelHex) {
                this.byteCount = 256;
                this.byteIndex = 0;
                this.pos = 7;
                this.intelType = this.ParseHex();
                if (this.intelType == 4) {
                    this.pos = 9;
                    this.addrHigh = this.ParseHex() << 24;
                    this.addrHigh |= this.ParseHex() << 16;
                }
                this.pos = 1;
                this.byteCount = this.ParseHex();
            }
        }

        short ParseHex() {
            this.parseLen = this.intelHex ? 2 : 8;
            return (short)this.parse();
        }

        private int parse() {
            char ch = '\u0000';
            while (this.pos < this.text.length && (ch = this.text[this.pos]) <= ' ') {
                ++this.pos;
            }
            if (this.pos == this.text.length || this.intelHex && this.parseLen == 2 && this.byteIndex >= this.byteCount) {
                this.pos = 0;
                return -1;
            }
            int hex = HexChars.indexOf(ch);
            if (hex == -1) {
                return -1;
            }
            int Result2 = 0;
            int count = 0;
            while (this.pos < this.text.length) {
                hex = HexChars.indexOf(this.text[this.pos]);
                if (hex == -1 || ++count > this.parseLen) break;
                ++this.pos;
                Result2 = (Result2 << 4) + hex;
            }
            ++this.byteIndex;
            return Result2;
        }

        /*
         * Unable to fully structure code
         */
        int ParseAddr() {
            if (this.intelHex && this.intelType != 0) {
                return -2;
            }
            this.parseLen = this.intelHex != false ? 4 : 8;
            hex = this.parse();
            if (hex != -1) ** GOTO lbl8
            return -1;
lbl-1000:
            // 1 sources

            {
                ++this.pos;
lbl8:
                // 2 sources

                ** while (this.pos < this.text.length && this.text[this.pos] <= ' ')
            }
lbl9:
            // 1 sources

            if (this.text[this.pos] == ':') {
                ++this.pos;
                return hex;
            }
            if (this.intelHex) {
                this.pos = 9;
                this.byteIndex = 0;
                return this.addrHigh | hex;
            }
            return -1;
        }
    }
}

