/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.extinstall.AdvItem;
import com.hifiremote.jp1.extinstall.AdvList;
import com.hifiremote.jp1.extinstall.CrudeErrorLogger;
import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.ExtInstall;
import com.hifiremote.jp1.extinstall.IrHex;
import com.hifiremote.jp1.extinstall.IrHexConfig;
import com.hifiremote.jp1.extinstall.Rdf;
import com.hifiremote.jp1.extinstall.UpgradeDevice;
import com.hifiremote.jp1.extinstall.UpgradeItem;
import com.hifiremote.jp1.extinstall.UpgradeList;
import com.hifiremote.jp1.extinstall.UpgradeProtocol;
import com.hifiremote.jp1.io.JPS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class RMExtInstall
extends ExtInstall {
    public static RemoteConfiguration remoteConfig;
    private static String errorMsg;
    private static Remote extenderRemote;
    private static boolean extenderMerge;
    private JPS io = null;
    private static boolean isSimpleset;
    private String hexName;
    private int sigAddr;
    private List<Integer> devUpgradeCodes = new ArrayList<Integer>();
    private List<Integer> protUpgradeIDs = new ArrayList<Integer>();

    public RMExtInstall(String hexName, RemoteConfiguration remoteConfig) {
        super(hexName, null, null, remoteConfig.getRemote().getSigAddress());
        RMExtInstall.remoteConfig = remoteConfig;
        this.hexName = hexName;
        this.sigAddr = remoteConfig.getRemote().getSigAddress();
        this.io = remoteConfig.getOwner().binLoaded();
        errorMsg = null;
        extenderRemote = null;
        extenderMerge = true;
        isSimpleset = false;
    }

    @Override
    public void install() throws IOException, CloneNotSupportedException {
        CrudeErrorLogger Erl = new CrudeErrorLogger();
        IrHexConfig ExtHex = new IrHexConfig();
        if (this.io != null) {
            File file = RMExtInstall.FindFile(this.hexName, ".txt");
            BufferedReader rdr = new BufferedReader(new FileReader(file));
            if (!ExtHex.Load(Erl, rdr)) {
                rdr.close();
                System.exit(1);
            }
            String title = "Simpleset Patching";
            String message = "You are about to apply patches to a settings.bin file for a Simpleset\nremote.  If you continue, these patches will be applied immediately,\nwithout any Save step or any further opportunity to abort the process.\n\nYou are strongly advised NOT to do so directly with the file on the\nexternal drive of the remote, but only on a copy on your PC.\n\nDo you wish to proceed?";
            if (JOptionPane.showConfirmDialog(remoteConfig.getOwner(), message, title, 0, 2) == 1) {
                message = "Operation cancelled.";
                JOptionPane.showMessageDialog(remoteConfig.getOwner(), message, title, 1);
                return;
            }
            int start = 0;
            int len = 0;
            for (int i = 0; i <= ExtHex.size(); ++i) {
                IrHex val;
                IrHex irHex = val = i < ExtHex.size() ? (IrHex)ExtHex.get(i) : null;
                if (val == null || !val.isValid()) {
                    if (len > 0) {
                        short[] buffer = new short[len];
                        for (int n = 0; n < len; ++n) {
                            buffer[n] = ExtHex.Get(start + n);
                        }
                        this.io.writeRemote(start, buffer);
                    }
                    start = i + 1;
                    len = 0;
                    continue;
                }
                ++len;
            }
            XorCheckSum cs = new XorCheckSum(0, new AddressRange(2, this.io.getCodeSize() - 1), false);
            short[] code = new short[this.io.getCodeSize()];
            this.io.readRemote(this.io.getCodeAddress(), code);
            short c = cs.calculateCheckSum(code, 2, this.io.getCodeSize() - 1);
            short[] buffer = new short[]{c, ~c};
            this.io.writeRemote(this.io.getCodeAddress(), buffer);
            cs = new XorCheckSum(0, new AddressRange(2, this.io.getSigSize() - 1), false);
            code = new short[this.io.getSigSize()];
            this.io.readRemote(this.io.getSigAddress(), code);
            buffer[0] = c = cs.calculateCheckSum(code, 2, this.io.getSigSize() - 1);
            buffer[1] = ~c;
            this.io.writeRemote(this.io.getSigAddress(), buffer);
            cs = new XorCheckSum(0, new AddressRange(2, this.io.getIRdbSize() - 1), false);
            code = new short[this.io.getIRdbSize()];
            this.io.readRemote(this.io.getIRdbAddress(), code);
            buffer[0] = c = cs.calculateCheckSum(code, 2, this.io.getIRdbSize() - 1);
            buffer[1] = ~c;
            this.io.writeRemote(this.io.getIRdbAddress(), buffer);
            message = "Patching complete.";
            JOptionPane.showMessageDialog(remoteConfig.getOwner(), message, title, 1);
            rdr.close();
            return;
        }
        AdvList ExtAdv = new AdvList();
        UpgradeList ExtUpgrade = new UpgradeList();
        Rdf ExtRdf = new Rdf();
        Remote newRemote = null;
        RMExtInstall.LoadHex(Erl, this.hexName, ExtHex, ExtAdv, ExtUpgrade, ExtRdf, 0);
        if (isSimpleset) {
            if (extenderRemote == null) {
                remoteConfig = null;
                this.showError();
            }
            return;
        }
        if (ExtRdf.m_AdvCodeAddr.end < 0 || ExtRdf.m_UpgradeAddr.end < 0) {
            remoteConfig = null;
            this.showError();
            return;
        }
        for (UpgradeItem item : ExtUpgrade) {
            if (item.Classify() == UpgradeItem.Classification.eDevice) {
                this.devUpgradeCodes.add(((UpgradeDevice)item).m_ID);
                continue;
            }
            if (item.Classify() != UpgradeItem.Classification.eProtocol) continue;
            this.protUpgradeIDs.add(((UpgradeProtocol)item).m_ID);
        }
        IrHexConfig OldHex = new IrHexConfig();
        AdvList OldAdv = new AdvList();
        UpgradeList OldUpgrade = new UpgradeList();
        Rdf OldRdf = new Rdf();
        RMExtInstall.LoadHex(Erl, null, OldHex, OldAdv, OldUpgrade, OldRdf, this.sigAddr);
        if (OldRdf.m_AdvCodeAddr.end < 0 || OldRdf.m_UpgradeAddr.end < 0) {
            remoteConfig = null;
            this.showError();
            return;
        }
        System.err.println("Merging.");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (!extenderMerge) {
            newRemote = remoteConfig.getRemote();
            OldAdv.Merge(ExtAdv, EnumSet.of(AdvItem.Flag.eMacroCollideNew, AdvItem.Flag.eKeyMoveCollideNew));
            OldUpgrade.Merge(Erl, ExtUpgrade, EnumSet.of(UpgradeList.Flag.eProtocolCollideNew, UpgradeList.Flag.eDeviceCollideNew));
            String generalComment = OldHex.GetComment(0);
            OldHex.RemoveComments();
            if (generalComment != null && !generalComment.equals("")) {
                OldHex.SetComment(0, generalComment);
            }
            OldHex.PostAdvList(Erl, OldAdv);
            OldHex.PostUpgradeList(Erl, OldUpgrade);
            OldRdf.DoCheckSums(OldHex);
            OldHex.Dump(pw);
        } else {
            newRemote = extenderRemote;
            ExtAdv.Merge(OldAdv, EnumSet.of(AdvItem.Flag.eMacroCollideNew));
            ExtUpgrade.Merge(Erl, OldUpgrade, EnumSet.noneOf(UpgradeList.Flag.class));
            String generalComment = OldHex.GetComment(0);
            ExtHex.RemoveComments();
            if (generalComment != null && !generalComment.equals("")) {
                ExtHex.SetComment(0, generalComment);
            }
            ExtHex.PostAdvList(Erl, ExtAdv);
            ExtHex.PostUpgradeList(Erl, ExtUpgrade);
            ExtHex.Merge(OldHex);
            ExtRdf.DoCheckSums(ExtHex);
            ExtHex.Dump(pw);
        }
        String out = sw.toString();
        pw.close();
        ProtocolManager.getProtocolManager().reset(this.protUpgradeIDs);
        remoteConfig = new RemoteConfiguration(out, remoteConfig.getOwner(), newRemote);
    }

    public static void LoadHex(ErrorLogger Erl, String arg, IrHexConfig Config2, AdvList Adv, UpgradeList Upgrade, Rdf rdf, int sigAddr) throws IOException {
        int oldSetupMax = SetupCode.getMax();
        int eepromSize = 0;
        Remote remote = null;
        short[] sigData = null;
        BufferedReader rdr = null;
        if (arg != null) {
            File file = RMExtInstall.FindFile(arg, ".txt");
            System.err.println("Loading data from file.");
            rdr = new BufferedReader(new FileReader(file));
        } else {
            System.err.println("Exporting present configuration as string in .ir file format.");
            String ir = remoteConfig.exportIR();
            System.err.println("Loading data from exported string.");
            rdr = new BufferedReader(new StringReader(ir));
            remote = remoteConfig.getRemote();
        }
        if (!Config2.Load(Erl, rdr)) {
            errorMsg = "Loading of ";
            errorMsg = errorMsg + (arg == null ? "main" : "merge");
            errorMsg = errorMsg + " data failed.";
            rdr.close();
            return;
        }
        rdr.close();
        if (remote == null) {
            int baseAddr;
            if (!Config2.IsValid(2)) {
                for (baseAddr = 0; baseAddr < Config2.size() && !Config2.IsValid(baseAddr); baseAddr += 256) {
                }
            }
            if (baseAddr >= Config2.size()) {
                errorMsg = "Unable to locate a valid signature.";
                return;
            }
            int n = sigAddr = baseAddr == 0 ? 2 : baseAddr;
            boolean bl = baseAddr == 0 ? !Config2.IsValid(0) : (extenderMerge = !Config2.IsValid(baseAddr + 8));
            if (Config2.IsValid(sigAddr) && Config2.IsValid(sigAddr + 1) && Config2.Get(sigAddr) + Config2.Get(sigAddr + 1) == 255) {
                isSimpleset = true;
                extenderMerge = true;
                System.err.println("Extender is for a Simpleset remote");
                sigData = new short[64];
                for (int i = 0; i < sigData.length; ++i) {
                    if (!Config2.IsValid(sigAddr + i)) {
                        errorMsg = "Incomplete sig block in extender data.";
                        return;
                    }
                    sigData[i] = Config2.Get(sigAddr + i);
                }
                sigAddr += 6;
                baseAddr += 256;
                while (baseAddr < Config2.size() && !Config2.IsValid(baseAddr)) {
                    baseAddr += 256;
                }
                if (baseAddr >= Config2.size()) {
                    errorMsg = "Unable to locate a valid EEPROM area.";
                    return;
                }
            }
            if (extenderMerge && !isSimpleset && baseAddr != remoteConfig.getRemote().getBaseAddress()) {
                errorMsg = "EEPROM area is located differently in extended and base remotes";
                return;
            }
            eepromSize = remoteConfig.getRemote().getEepromSize() + remoteConfig.getRemote().getBaseAddress() - baseAddr;
            if (Config2.size() > baseAddr + eepromSize) {
                errorMsg = "Extender data extends beyond EEPROM size.";
                return;
            }
            StringBuilder sb = new StringBuilder();
            int sigLen = isSimpleset ? 6 : 8;
            for (int ndx = 0; Config2.IsValid(ndx + sigAddr) && ndx < sigLen; ++ndx) {
                sb.append((char)Config2.Get(ndx + sigAddr));
            }
            String signature = sb.toString();
            String signature2 = null;
            RemoteManager rm = RemoteManager.getRemoteManager();
            List<Remote> remotes = null;
            for (int len = signature.length(); len > 3 && (remotes = rm.findRemoteBySignature(signature2 = signature.substring(0, len))).isEmpty(); --len) {
            }
            signature = signature2;
            short[] data = new short[eepromSize];
            for (int i = 0; i < eepromSize; ++i) {
                data[i] = i < Config2.size() - baseAddr && Config2.IsValid(i + baseAddr) ? (int)Config2.Get(i + baseAddr) : 256;
            }
            remote = remoteConfig.getOwner().filterRemotes(remotes, signature, eepromSize, data, sigData, false);
            if (remote == null) {
                errorMsg = "No remote found that matches the merge file.";
                return;
            }
            remote.load();
            if (baseAddr != remote.getBaseAddress()) {
                errorMsg = "Merge data and its RDF have conflicting base addresses.";
                return;
            }
            if (isSimpleset && remote.getOemSignatures() != null && !remote.getOemSignatures().contains(remoteConfig.getRemote().getSignature()) && !remoteConfig.getRemote().getSignature().equals(remote.getSignature())) {
                if (remoteConfig.getRemote().getOemSignatures() != null) {
                    String message = "This remote already has an extender installed which has a different signature from\nthat of the extender you are about to install.  This may mean that the new extender\nis not compatible with the exiting one.  If you continue with the installation you\nmay finish up with a corrupt setup.\n\nAre you sure that you wish to continue?";
                    String title = "Apparent extender incompatibility";
                    if (RMIRSetup.NegativeDefaultButtonJOptionPane.showConfirmDialog(null, message, title, 0, 2) == 1) {
                        errorMsg = "Aborting installation.";
                        return;
                    }
                } else {
                    errorMsg = "Extender is not for this remote.";
                    return;
                }
            }
            int extSetupMax = SetupCode.getMax();
            if (isSimpleset && oldSetupMax > extSetupMax) {
                int maxUpgSetup = 0;
                for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                    maxUpgSetup = Math.max(maxUpgSetup, du.getSetupCode());
                }
                if (maxUpgSetup > extSetupMax) {
                    String message = "<html>The maximum setup code supported by this extender is " + extSetupMax + ".  There are device upgrades<br>in the unextended configuration with setup codes that exceed this limit.  Please use the<br>Devices panel to change these to lower values, or to delete affected upgrades if they are<br>unused, and then start the extender installation again.  Your new setup codes can be chosen<br>freely, but you may wish to open the Code Selector on the toolbar to choose values that <br>do not conflict with built-in codes.</html>";
                    String title = "Setup codes out of range";
                    JOptionPane.showMessageDialog(null, message, title, 1);
                    errorMsg = "Aborting installation.";
                    return;
                }
            }
            extenderRemote = remote;
        }
        if (isSimpleset) {
            RemoteConfiguration extConfig = new RemoteConfiguration(remote, remoteConfig.getOwner());
            extConfig.setSigData(sigData);
            int baseAddr = remote.getBaseAddress();
            for (int i = 0; i < extConfig.getData().length; ++i) {
                extConfig.getData()[i] = i < Config2.size() - baseAddr && Config2.IsValid(i + baseAddr) ? (int)Config2.Get(i + baseAddr) : 255;
            }
            extConfig.loadSegments(true);
            extConfig.setDeviceButtonSegments();
            ArrayList<Integer> missingDev = new ArrayList<Integer>();
            for (int i = 0; i < remote.getDeviceButtons().length; ++i) {
                DeviceButton db = remote.getDeviceButtons()[i];
                if (remoteConfig.getRemote().getDeviceButton(db.getButtonIndex()) != null) continue;
                remoteConfig.getSegments().get(0).add(db.getSegment());
                missingDev.add(i);
            }
            int dataEnd = remoteConfig.getRemote().getCheckSums()[0].getAddressRange().getEnd();
            if (dataEnd >= eepromSize) {
                int maxAddress = remoteConfig.getRemote().getBaseAddress() + eepromSize;
                String message = "<html>The current setup is too large to fit into the reduced data area of the extended remote.<br>If you still wish to install the extender, please delete some data so that all the values<br>shown on the Raw Data tab beyond address " + Integer.toHexString(maxAddress) + " are FF.</html>";
                String title = "Data too large to fit";
                JOptionPane.showMessageDialog(null, message, title, 1);
                errorMsg = "Aborting installation.";
                return;
            }
            remoteConfig.setRemote(remote);
            for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                du.setNewRemote(remote);
            }
            remoteConfig.setSigData(sigData);
            remoteConfig.setDeviceButtonSegments();
            if (remoteConfig.getData().length != eepromSize) {
                remoteConfig.resizeData(eepromSize);
            }
            ArrayList<Activity> list = new ArrayList<Activity>();
            LinkedHashMap<Button, Activity> activities = remoteConfig.getActivities();
            if (activities != null) {
                for (Activity activity : remoteConfig.getActivities().values()) {
                    ArrayList<ActivityGroup> missingGroups = new ArrayList<ActivityGroup>();
                    Button btn = remote.getButton(activity.getButton().getKeyCode());
                    Activity extActivity = extConfig.getActivities().get(btn);
                    for (ActivityGroup group : extActivity.getActivityGroups()) {
                        if (activity.getGroupMap().get(group.getIndex()) != null) continue;
                        missingGroups.add(group);
                    }
                    if (missingGroups.size() > 0) {
                        int oldLen = activity.getActivityGroups().length;
                        int newLen = oldLen + missingGroups.size();
                        ActivityGroup[] newGroups = Arrays.copyOf(activity.getActivityGroups(), newLen);
                        for (int i = 0; i < missingGroups.size(); ++i) {
                            ActivityGroup group;
                            newGroups[oldLen + i] = group = (ActivityGroup)missingGroups.get(i);
                            activity.getGroupMap().put(group.getIndex(), group);
                        }
                        activity.setActivityGroups(newGroups);
                    }
                    activity.set(remote);
                    if (activity.getMacro() != null) {
                        Macro macro = activity.getMacro();
                        remote.correctType04Macro(macro);
                        for (Integer i : missingDev) {
                            macro.getData().set((short)remote.getDeviceButtons()[i].getButtonIndex(), 2 * i);
                        }
                    }
                    list.add(activity);
                }
                activities.clear();
                for (Activity activity : list) {
                    activities.put(activity.getButton(), activity);
                }
                for (Button btn : extConfig.getActivities().keySet()) {
                    if (activities.get(btn) != null) continue;
                    activities.put(btn, extConfig.getActivities().get(btn));
                }
            }
            remoteConfig.setDeviceButtonNotes(Arrays.copyOf(remoteConfig.getDeviceButtonNotes(), remote.getDeviceButtons().length));
            return;
        }
        File rdfFile = remote.getFile();
        try {
            rdf.rdr = new BufferedReader(new FileReader(rdfFile));
        }
        catch (FileNotFoundException fnfe) {
            errorMsg = "Can't read file " + rdfFile.getAbsolutePath() + ".";
            return;
        }
        String message = "Loading RDF " + rdfFile.getCanonicalPath();
        message = message + " for " + (arg == null ? "main" : "merge") + " file";
        System.err.println(message);
        rdf.Load();
        if (rdf.m_AdvCodeAddr.end < 0 || rdf.m_UpgradeAddr.end < 0) {
            errorMsg = "RDF file " + rdfFile + " not valid.";
            return;
        }
        Config2.m_pRdf = rdf;
        Config2.SetAdvMem(rdf.m_AdvCodeAddr.begin, rdf.m_AdvCodeAddr.end);
        Config2.SetUpgradeMem(rdf.m_UpgradeAddr.begin, rdf.m_UpgradeAddr.end);
        Config2.SetBaseAddr(rdf.m_BaseAddr);
        Config2.SetAdvCodeType(rdf.m_AdvCodeType);
        Config2.SetSectionTerminator(rdf.m_SectionTerminator);
        if (rdf.m_LearnedAddr.begin != 0) {
            int last;
            for (last = rdf.m_LearnedAddr.begin; last < rdf.m_LearnedAddr.end && Config2.IsValid(last); ++last) {
            }
            while (last < rdf.m_LearnedAddr.end && !Config2.IsValid(last)) {
                ++last;
            }
            rdf.m_LearnedAddr.end = last;
        }
        Config2.SetLearnMem(rdf.m_LearnedAddr.begin, rdf.m_LearnedAddr.end);
        Config2.FillAdvList(Erl, Adv);
        Config2.FillUpgradeList(Erl, Upgrade);
    }

    public void showError() {
        String title = "ExtInstall error";
        errorMsg = errorMsg + "\nExtInstall terminating.";
        JOptionPane.showMessageDialog(null, errorMsg, title, 0);
        System.err.println(errorMsg);
    }

    public List<Integer> getDevUpgradeCodes() {
        return this.devUpgradeCodes;
    }

    public List<Integer> getProtUpgradeIDs() {
        return this.protUpgradeIDs;
    }

    public boolean isExtenderMerge() {
        return extenderMerge;
    }

    static {
        errorMsg = null;
        extenderRemote = null;
        extenderMerge = true;
        isSimpleset = false;
    }
}

