/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ProgressUpdater;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.extinstall.CrudeErrorLogger;
import com.hifiremote.jp1.extinstall.IRToWav;
import com.hifiremote.jp1.extinstall.IrHex;
import com.hifiremote.jp1.extinstall.IrHexConfig;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;

public class RMWavConverter {
    private int bitNum = 0;
    private int bitValue = 1;
    private byte byteValue = 0;
    private int byteNum = 0;
    private int byteCount = 2048;
    private int numBytes = 0;
    private short[] data = null;
    private int filePos = 0;
    private int lastPhasePos = 1;
    private int lowPos = 46;
    private int highPos = 56;
    private WavePeak wp = WavePeak.WPNONE;
    private RMIRSetup owner = null;
    private RemoteConfiguration config = null;
    private Remote remote = null;
    private List<Remote> remotes = null;
    private String sigString = null;
    private IrHexConfig wavConfig = null;
    private String progressName = null;
    private ProgressUpdater progressUpdater = null;

    public RMWavConverter(RMIRSetup RMIRSetup2, RemoteConfiguration config) {
        this.owner = RMIRSetup2;
        this.config = config;
        this.remote = config != null ? config.getRemote() : null;
    }

    public void exportWav(File file, AddressRange range) {
        int baseAddr = this.remote.getBaseAddress();
        int offset = range.getStart();
        short[] data = this.config.getData();
        int len = data.length;
        int[] img = new int[len];
        for (int i = 0; i < len; ++i) {
            img[i] = data[i];
        }
        boolean isHCS08 = this.remote.getProcessor().getName().equals("HCS08");
        if (isHCS08 && this.needsCheckSum(range, img)) {
            offset -= 2;
        }
        int upStart = baseAddr + offset;
        int upSize = range.getFreeStart() - offset;
        String sig = this.remote.getSignature().substring(0, 4);
        IRToWav irToWav = new IRToWav(sig, upStart, upSize, offset, isHCS08, img);
        irToWav.setProgressUpdater(this.progressUpdater);
        this.progressName = "SAVING WAV SOUND FILE:";
        irToWav.generate(file);
    }

    private boolean needsCheckSum(AddressRange range, int[] img) {
        for (CheckSum ckSum : this.remote.getCheckSums()) {
            AddressRange ckRange = ckSum.getAddressRange();
            int addr = ckSum.getCheckSumAddress();
            if (ckRange.getStart() != range.getStart() || ckRange.getStart() != addr + 2 || !(ckSum instanceof XorCheckSum)) continue;
            short val = ((XorCheckSum)ckSum).calculateCheckSum(this.config.getData(), range.getStart(), range.getFreeStart() - 1);
            if ((range.getEnd() - range.getFreeStart()) % 2 == 0) {
                val = (short)(val ^ 0xFF);
            }
            img[addr] = val;
            img[addr + 1] = val ^ 0xFF;
            return true;
        }
        return false;
    }

    public void importWav(File file) {
        int baseAddress = 0;
        BufferedInputStream in = null;
        this.progressName = "IMPORTING WAV FILE:";
        try {
            this.data = new short[this.byteCount];
            in = new BufferedInputStream(new FileInputStream(file));
            in.skip(45L);
            int val = 0;
            int prog = 0;
            int newProg = 0;
            int incr = (int)(file.length() / 100L + 1L);
            this.filePos = 45;
            while ((long)this.filePos < file.length()) {
                if (this.progressUpdater != null && (newProg = this.filePos / incr) > prog) {
                    this.progressUpdater.updateProgress(newProg);
                    prog = newProg;
                }
                if ((val = in.read()) > 240) {
                    this.wp = WavePeak.WPHIGH;
                } else if (val < 16) {
                    this.wp = WavePeak.WPLOW;
                } else {
                    if (this.wp == WavePeak.WPHIGH) {
                        if (this.filePos - this.highPos < 6) {
                            this.phaseChange();
                        }
                        this.highPos = this.filePos;
                    } else if (this.wp == WavePeak.WPLOW) {
                        if (this.filePos - this.lowPos < 6) {
                            this.phaseChange();
                        }
                        this.lowPos = this.filePos;
                    }
                    this.wp = WavePeak.WPNONE;
                }
                ++this.filePos;
            }
            this.setBit();
        }
        catch (Exception e) {
            System.err.println("Error interpreting WAV file " + file.getAbsolutePath());
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.progressName = "DECODING WAV IMPORT:";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean isJP12 = false;
        String message = null;
        String title = "WAV import";
        int prog = 0;
        int newProg = 0;
        while (this.byteNum < this.numBytes) {
            if (this.progressUpdater != null && (newProg = this.byteNum * 100 / this.numBytes) > prog) {
                this.progressUpdater.updateProgress(newProg);
                prog = newProg;
            }
            while (this.data[this.byteNum++] == 168) {
            }
            short blockLen = this.data[this.byteNum++];
            short val = this.data[this.byteNum];
            switch (val) {
                case 0: 
                case 255: {
                    break;
                }
                case 69: {
                    break;
                }
                case 67: {
                    isJP12 = true;
                    break;
                }
                case 86: {
                    char[] ch = new char[4];
                    for (int i = 0; i < 4; ++i) {
                        ch[i] = (char)this.data[this.byteNum + 2 + i];
                    }
                    this.sigString = new String(ch);
                    if (this.remote != null && !this.remote.getSignature().substring(0, 4).equals(this.sigString) || this.remote == null) {
                        if (this.remote != null) {
                            message = "The data being merged comes from a different model of\n remote.  Depending on how different that remote is,\nmerging may cause the remote to operate incorrectly\nor not at all.  Are you sure you want to do this?";
                            if (message != null && JOptionPane.showConfirmDialog(null, message, title, 0, 2) != 0) {
                                return;
                            }
                            this.remote = null;
                        }
                        this.remotes = new ArrayList<Remote>();
                        RemoteManager rm = RemoteManager.getRemoteManager();
                        for (Remote r : rm.getRemotes()) {
                            if (!r.getSignature().substring(0, 4).equals(this.sigString) || !r.supportWaveUpgrade()) continue;
                            this.remotes.add(r);
                        }
                        if (this.remotes.isEmpty()) {
                            message = "No remote found for signature starting " + this.sigString + " from WAV file.";
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            return;
                        }
                        this.remote = this.remotes.get(0);
                    }
                    baseAddress = this.remote.getBaseAddress();
                    break;
                }
                case 83: {
                    int addr = (this.data[this.byteNum + 2] << 8) + this.data[this.byteNum + 3];
                    if (isJP12) {
                        addr -= baseAddress;
                    }
                    String s = String.format("%04X: ", addr) + new Hex(Arrays.copyOfRange(this.data, this.byteNum + 4, this.byteNum + this.data[this.byteNum + 1] + 1));
                    pw.println(s);
                    break;
                }
                default: {
                    message = "Unknown block type in WAV file";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                    return;
                }
            }
            this.byteNum += blockLen - 1;
        }
        CrudeErrorLogger erl = new CrudeErrorLogger();
        this.wavConfig = new IrHexConfig();
        StringReader sr = new StringReader(sw.toString());
        BufferedReader bsr = new BufferedReader(sr);
        try {
            this.wavConfig.Load(erl, bsr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String importedSig = this.getImportedSignature();
        if (importedSig != null && !importedSig.substring(0, 4).equals(this.sigString)) {
            message = "The imported data contains inconsistent signatures.";
            JOptionPane.showMessageDialog(null, message, title, 0);
            return;
        }
    }

    private void setBit() {
        if (this.bitNum < 8) {
            if (this.bitValue != 0) {
                this.byteValue = (byte)(this.byteValue | this.bitValue << this.bitNum);
            }
            ++this.bitNum;
        } else {
            if (this.numBytes >= this.byteCount) {
                this.byteCount += 2048;
                this.data = Arrays.copyOf(this.data, this.byteCount);
            }
            this.data[this.numBytes++] = (short)(this.byteValue & 0xFF);
            this.byteValue = 0;
            this.bitNum = 0;
        }
    }

    private void phaseChange() {
        int phaseBits = (this.filePos - this.lastPhasePos) / 70;
        this.lastPhasePos = this.filePos;
        if (phaseBits > 0) {
            for (int i = 0; i < phaseBits - 1; ++i) {
                this.setBit();
            }
            this.bitValue ^= 1;
            this.setBit();
        }
    }

    public void mergeData(short[] data) {
        for (int i = 0; i < data.length && i < this.wavConfig.size(); ++i) {
            IrHex irh = (IrHex)this.wavConfig.get(i);
            if (irh == null || !irh.isValid()) continue;
            data[i] = irh.get();
        }
    }

    public String getImportedSignature() {
        int[] vals = new int[10];
        for (int i = 0; i < 10; ++i) {
            vals[i] = this.wavConfig.get(i) == null ? -1 : ((IrHex)this.wavConfig.get(i)).get() & 0xFF;
        }
        int start = vals[0] == -1 || vals[1] == -1 || vals[0] + vals[1] == 255 ? 2 : 0;
        short[] sigData = new short[8];
        for (int i = 0; i < 8; ++i) {
            if (vals[start + i] == -1) {
                return null;
            }
            sigData[i] = (short)vals[start + i];
        }
        return Hex.getRemoteSignature(sigData);
    }

    public Remote getRemote() {
        if (this.remotes != null) {
            this.remote = this.owner.filterRemotes(this.remotes, this.sigString, this.wavConfig.size(), null, null, true);
            this.remotes = null;
        }
        return this.remote;
    }

    public void setProgressUpdater(ProgressUpdater progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    public String getProgressName() {
        return this.progressName;
    }

    private static enum WavePeak {
        WPLOW,
        WPNONE,
        WPHIGH;

    }
}

