/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.RMIRSetup;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RMWavPlayer
implements LineListener {
    private Clip audioClip = null;
    private boolean playCompleted = false;
    private static boolean consoleApp = false;
    private RMIRSetup.TimingTask timer = null;

    public void open(File audioFile) {
        try {
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(audioFile);
            AudioFormat format = audioStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.audioClip = (Clip)AudioSystem.getLine(info);
            this.audioClip.addLineListener(this);
            this.audioClip.open(audioStream);
        }
        catch (UnsupportedAudioFileException ex) {
            System.err.println("The specified audio file is not supported.");
            ex.printStackTrace();
        }
        catch (LineUnavailableException ex) {
            System.err.println("Audio line for playing back is unavailable.");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.err.println("Error playing the audio file.");
            ex.printStackTrace();
        }
    }

    public int getDuration() {
        long duration = this.audioClip.getMicrosecondLength();
        return (int)(duration / 100000L);
    }

    public void play() {
        if (this.timer != null) {
            this.timer.execute();
        }
        this.audioClip.start();
        if (consoleApp) {
            while (!this.playCompleted) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (type == LineEvent.Type.START) {
            System.err.println("Playback started.");
        } else if (type == LineEvent.Type.STOP) {
            if (!this.playCompleted) {
                System.err.println("Playback completed.");
            }
            this.playCompleted = true;
            this.close();
            if (this.timer != null) {
                this.timer.setCancelled(true);
            }
        }
    }

    public void close() {
        if (!this.playCompleted) {
            System.err.println("Playback cancelled by user.");
        }
        this.playCompleted = true;
        this.audioClip.close();
    }

    public RMIRSetup.TimingTask getTimer() {
        return this.timer;
    }

    public void setTimer(RMIRSetup.TimingTask timer) {
        this.timer = timer;
    }

    public static void main(String[] args) {
        consoleApp = true;
        File audioFile = new File(args[0]);
        RMWavPlayer player = new RMWavPlayer();
        player.open(audioFile);
        player.play();
    }
}

