/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.IrHexArray;
import com.hifiremote.jp1.extinstall.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;

public class Rdf {
    String m_Name;
    String m_Processor;
    int m_EepromSize = -1;
    int m_RAMAddr = -1;
    int m_RDFSync = -1;
    int m_SectionTerminator = 0;
    int m_AdvCodeType = 0;
    int m_BaseAddr = 0;
    Range m_AdvCodeAddr = new Range();
    Range m_UpgradeAddr = new Range();
    Range m_LearnedAddr = new Range();
    int[] m_FavData = new int[0];
    ArrayList<Checksum> m_Checksums = new ArrayList();
    ErrorLogger m_pErl;
    BufferedReader rdr;
    String m_Line;

    Rdf() {
    }

    boolean Load(ErrorLogger Erl, String signature, File Dir) throws IOException {
        this.m_pErl = Erl;
        int SigLen = 8;
        while (SigLen >= 4) {
            final String prefix = signature.substring(0, SigLen);
            String postfix = ".rdf";
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File path, String name) {
                    return name.startsWith(prefix) && name.endsWith(".rdf");
                }
            };
            File[] files = Dir.listFiles(filter);
            if (files.length > 0) {
                File file = files[0];
                if (!(file.exists() && file.isFile() && file.canRead())) {
                    Erl.Error("Can't read %s", file.getAbsolutePath());
                    return false;
                }
                try {
                    this.rdr = new BufferedReader(new FileReader(file));
                }
                catch (FileNotFoundException fnfe) {
                    Erl.Error("Can't read %s", file.getAbsolutePath());
                    return false;
                }
                return this.Load();
            }
            --SigLen;
        }
        return false;
    }

    boolean Load() throws IOException {
        while ((this.m_Line = this.rdr.readLine()) != null) {
            String section;
            if (this.m_Line.isEmpty() || (section = this.IsStartOfSection()) == null) continue;
            if (section.equalsIgnoreCase("general")) {
                this.LoadGeneral();
                continue;
            }
            if (!section.equalsIgnoreCase("checksums")) continue;
            this.LoadCheckSums();
        }
        return true;
    }

    void LoadCheckSums() throws IOException {
        while ((this.m_Line = this.rdr.readLine()) != null) {
            if (this.IsStartOfSection() != null) break;
            String[] parts = Util.Parse1(this.m_Line, ":");
            if (parts.length <= 1 || parts[0].isEmpty()) continue;
            Checksum chk = new Checksum();
            chk.bXor = false;
            char ch = parts[0].charAt(0);
            if (ch == '^') {
                chk.bXor = true;
            } else if (ch != '+') continue;
            chk.addr = Util.ParseNumber(parts[0].substring(1));
            chk.range = Util.ParseRange(parts[1]);
            this.m_Checksums.add(chk);
        }
    }

    void DoCheckSums(IrHexArray Hex2) {
        int n = 0;
        while (n < this.m_Checksums.size()) {
            int i;
            short sum = 0;
            Checksum chk = this.m_Checksums.get(n);
            if (chk.bXor) {
                i = chk.range.begin + this.m_BaseAddr;
                while (i <= chk.range.end + this.m_BaseAddr) {
                    sum = (short)(sum ^ Hex2.Get(i));
                    ++i;
                }
            } else {
                i = chk.range.begin;
                while (i <= chk.range.end) {
                    sum = (short)(sum + Hex2.Get(i));
                    ++i;
                }
            }
            Hex2.Set(chk.addr + this.m_BaseAddr, sum);
            Hex2.Set(chk.addr + this.m_BaseAddr + 1, (short)(255 - sum));
            ++n;
        }
    }

    void LoadGeneral() throws IOException {
        while ((this.m_Line = this.rdr.readLine()) != null) {
            if (this.IsStartOfSection() != null) break;
            String[] parts = Util.Parse1(this.m_Line, "=");
            if (parts.length <= 1) continue;
            if (parts[0].equalsIgnoreCase("Name")) {
                this.m_Name = parts[1];
                continue;
            }
            if (parts[0].equalsIgnoreCase("Processor")) {
                this.m_Processor = parts[1];
                continue;
            }
            if (parts[0].equalsIgnoreCase("EepromSize")) {
                this.m_EepromSize = Util.ParseNumber(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("SectionTerminator")) {
                this.m_SectionTerminator = Util.ParseNumber(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("AdvCodeBindFormat")) {
                if (!parts[1].equalsIgnoreCase("LONG")) continue;
                this.m_AdvCodeType = 1;
                continue;
            }
            if (parts[0].equalsIgnoreCase("BaseAddr")) {
                this.m_BaseAddr = Util.ParseNumber(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("RAMAddr")) {
                this.m_RAMAddr = Util.ParseNumber(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("RDFSync")) {
                this.m_RDFSync = Util.ParseNumber(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("AdvCodeAddr")) {
                this.m_AdvCodeAddr = Util.ParseRange(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("UpgradeAddr")) {
                this.m_UpgradeAddr = Util.ParseRange(parts[1]);
                continue;
            }
            if (parts[0].equalsIgnoreCase("LearnedAddr")) {
                this.m_LearnedAddr = Util.ParseRange(parts[1]);
                continue;
            }
            if (!parts[0].equalsIgnoreCase("FavKey")) continue;
            this.m_FavData = Util.ParseNumbers(parts[1]);
        }
    }

    String IsStartOfSection() {
        if (this.m_Line.startsWith("[") && this.m_Line.endsWith("]")) {
            return this.m_Line.substring(1, this.m_Line.length() - 1);
        }
        return null;
    }

    int Multiplier(int Type2) {
        if (Type2 != 3 || this.m_FavData.length < 4) {
            return 1;
        }
        return this.m_FavData[3];
    }

    public class BitRef {
        int offset;
        int bit;
    }

    public class Checksum {
        boolean bXor;
        int addr;
        Range range;
    }

    public static class Range {
        int begin = 0;
        int end = -1;
    }
}

