/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.extinstall;

import com.hifiremote.jp1.extinstall.ErrorLogger;
import com.hifiremote.jp1.extinstall.UpgradeItem;
import com.hifiremote.jp1.extinstall.UpgradeTable;
import java.util.ArrayList;
import java.util.EnumSet;

class UpgradeList
extends ArrayList<UpgradeItem> {
    int m_Addr;
    int m_Limit;
    int m_NewDevs;
    UpgradeTable m_DeviceTable;
    UpgradeTable m_ProtocolTable;

    UpgradeList() {
    }

    void ComputeItemSize(int n) {
        UpgradeItem Item = (UpgradeItem)this.get(n);
        if (Item.m_Address < this.m_Addr || Item.m_Address >= this.m_Limit) {
            Item.m_Size = 0;
            return;
        }
        int Limit = this.m_Limit;
        int i = 0;
        while (i < this.size()) {
            int a = ((UpgradeItem)this.get((int)i)).m_Address;
            if (a >= Item.m_Address && a < Limit && i != n) {
                Limit = a;
            }
            ++i;
        }
        Item.m_Size = Limit - Item.m_Address;
    }

    void Merge(ErrorLogger Erl, UpgradeList New, EnumSet<Flag> Flags2) throws CloneNotSupportedException {
        int n = 0;
        while (n < New.size()) {
            UpgradeItem item = (UpgradeItem)New.get(n);
            int found = this.Find(item);
            if (found >= 0) {
                if (Flags2.contains((Object)(item.Classify() == UpgradeItem.Classification.eDevice ? Flag.eDeviceCollideNew : Flag.eProtocolCollideNew))) {
                    this.set(found, item.clone());
                }
            } else {
                UpgradeItem pNew = item.clone();
                if (pNew.Classify() == UpgradeItem.Classification.eDevice) {
                    this.add(this.m_NewDevs++, pNew);
                    String cfr_ignored_0 = pNew.m_CommentText;
                } else {
                    this.add(pNew);
                }
            }
            ++n;
        }
    }

    int Find(UpgradeItem pItem) {
        int n = 0;
        while (n < this.size()) {
            if (pItem.Match((UpgradeItem)this.get(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void Print(UpgradeList New) {
        int n = 0;
        while (n < New.size()) {
            ++n;
        }
    }

    public static enum Flag {
        eProtocolCollideNew,
        eDeviceCollideNew;

    }
}

