/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.initialize;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceCmdParm;
import com.hifiremote.jp1.ChoiceEditor;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.initialize.Initializer;

public class ParmInitializer
extends Initializer {
    private int cmdNdx = 0;
    private int devNdx = 0;
    private int bitPos = 0;
    private int bitCnt = 1;

    public ParmInitializer(String[] parms) {
        if (parms.length != 4) {
            throw new IllegalArgumentException("ParmInitializer requires exactly four values");
        }
        this.cmdNdx = Integer.parseInt(parms[0]);
        this.devNdx = Integer.parseInt(parms[1]);
        this.bitPos = Integer.parseInt(parms[2]);
        this.bitCnt = Integer.parseInt(parms[3]);
    }

    @Override
    public void initialize(DeviceParameter[] devParms, CmdParameter[] cmdParms) {
        int step = 1 << this.bitPos;
        int count = 1 << this.bitCnt;
        int mask = -step * (count - 1) - 1;
        int deflt = (Integer)devParms[this.devNdx].getValueOrDefault();
        ChoiceCmdParm devCmdParm = (ChoiceCmdParm)cmdParms[this.cmdNdx];
        Choice[] choices = devCmdParm.getChoices();
        for (int i = 0; i < choices.length && i < count; ++i) {
            int value = (deflt & mask) + i * step;
            Choice choice = choices[i];
            choice.setText(Integer.toString(value));
            if (value != deflt) continue;
            devCmdParm.setDefault(i);
        }
        ((ChoiceEditor)devCmdParm.getEditor()).initialize();
    }
}

