/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.initialize;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceCmdParm;
import com.hifiremote.jp1.ChoiceEditor;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.initialize.Initializer;
import java.util.StringTokenizer;

public class PickInitializer
extends Initializer {
    private int index;
    private int[] sources;
    private final int noDefault = 65536;
    private final int noChange = 131072;
    private final int indexPart = 65535;
    private String[] separators;

    public PickInitializer(String[] parms) {
        this.index = Integer.parseInt(parms[0]);
        this.sources = new int[parms.length - 1];
        this.separators = new String[this.sources.length];
        for (int i = 0; i < parms.length - 1; ++i) {
            String str = parms[i + 1].trim().toUpperCase();
            this.sources[i] = 0;
            if (str.length() != 0 && str.charAt(0) == 'N') {
                this.sources[i] = 65536;
                str = str.substring(1).trim();
            }
            if (str.length() == 0) {
                this.sources[i] = 131072;
                continue;
            }
            StringTokenizer st = new StringTokenizer(str, "./-\\,:;~", true);
            if (st.countTokens() > 1) {
                int main = Integer.parseInt(st.nextToken());
                this.separators[i] = st.nextToken();
                int sub = Integer.parseInt(st.nextToken());
                int n = i;
                this.sources[n] = this.sources[n] | (main << 8 | sub);
                continue;
            }
            int v = Integer.parseInt(str);
            int n = i;
            this.sources[n] = this.sources[n] | v;
        }
    }

    private String getParm(int index, DeviceParameter[] parms, boolean useDefault) {
        if (index >= parms.length) {
            return null;
        }
        Object parm = parms[index].getValue();
        if (parm == null && useDefault) {
            parm = parms[index].getDefaultValue();
        }
        if (parm == null) {
            return null;
        }
        return parm.toString();
    }

    @Override
    public void initialize(DeviceParameter[] devParms, CmdParameter[] cmdParms) {
        Choice[] choices = ((ChoiceCmdParm)cmdParms[this.index]).getChoices();
        for (int i = 0; i < choices.length && i < this.sources.length; ++i) {
            int s = this.sources[i];
            boolean useDefault = (s & 0x10000) == 0;
            String text = null;
            if (s == 131072) continue;
            int j = s & 0xFFFF;
            int k = 0;
            if (this.separators[i] != null) {
                k = j & 0xFF;
                String text1 = this.getParm(j >>= 8, devParms, useDefault);
                String text2 = this.getParm(k, devParms, useDefault);
                if (text1 != null) {
                    text = text2 != null ? text1 + this.separators[i] + text2 : text1;
                }
            } else {
                text = this.getParm(j, devParms, useDefault);
            }
            Choice choice = choices[i];
            if (text == null) {
                choice.setText("n/a");
                choice.setHidden(true);
                continue;
            }
            choice.setText(text);
            choice.setHidden(false);
        }
        ((ChoiceEditor)((ChoiceCmdParm)cmdParms[this.index]).getEditor()).initialize();
    }
}

