/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.initialize;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceCmdParm;
import com.hifiremote.jp1.ChoiceEditor;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.initialize.Initializer;

public class RC5Initializer
extends Initializer {
    protected int devOffset = 0;

    public RC5Initializer(String[] textParms) {
        int parmIndex = 0;
        for (int i = 0; i < textParms.length; ++i) {
            String text = textParms[i].trim();
            if (text.isEmpty()) continue;
            int val = Integer.parseInt(text);
            switch (parmIndex) {
                case 0: {
                    this.devOffset = val;
                    break;
                }
            }
            ++parmIndex;
        }
    }

    @Override
    public void initialize(DeviceParameter[] devParms, CmdParameter[] cmdParms) {
        Choice[] choices = ((ChoiceCmdParm)cmdParms[0]).getChoices();
        for (int i = 0; i < choices.length; ++i) {
            int devIndex = 2 * i + this.devOffset;
            Integer device = null;
            if (devParms[devIndex] != null && devParms[devIndex].getValue() != null) {
                device = (Integer)devParms[devIndex].getValue();
            }
            Choice choice = choices[i];
            if (device == null) {
                choice.setText("n/a");
                choice.setHidden(true);
                continue;
            }
            String extra = null;
            int flag = (Integer)devParms[devIndex + 1].getValue();
            extra = flag == 0 ? "OBC<64" : "OBC>63";
            choice.setText(device.toString() + ',' + extra);
            choice.setHidden(false);
        }
        ((ChoiceEditor)((ChoiceCmdParm)cmdParms[0]).getEditor()).initialize();
    }
}

