/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.jp1.io.UEIPacket;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BLERemote {
    public String address;
    public String name;
    public String ueiName;
    public int regIndex = -1;
    public boolean found = false;
    public int rssi = 0;
    public boolean supportsUpload = false;
    public boolean hasFinder = false;
    public String signature = null;
    public int firmwareAddress = 0;
    public int firmwareSize = 0;
    public int infoAddress = 0;
    public int infoSize = 0;
    public int irdbAddress = 0;
    public int irdbSize = 0;
    public int E2address = 0;
    public int E2size = 0;
    public int batteryBars = 0;
    public int batteryPercent = 0;
    public double batteryVoltage = 0.0;
    public int signalStrength = 0;
    public byte[] jp2info = null;
    public byte[] icinfo = null;

    public BLERemote(String name, String ueiName, String address) {
        this.name = name;
        this.ueiName = ueiName;
        this.address = address;
    }

    public boolean interpret(String cmd, UEIPacket upkt) {
        if (cmd == null) {
            byte[] payload = upkt.getPayload();
            block1 : switch (upkt.getAppCode()) {
                case 0: {
                    if (payload.length != payload[0] + 1) {
                        return false;
                    }
                    this.hasFinder = false;
                    for (int i = 1; i < payload.length; ++i) {
                        if (payload[i] != 37) continue;
                        this.hasFinder = true;
                        break block1;
                    }
                    break;
                }
                case 67: {
                    if (payload.length != 4) {
                        return false;
                    }
                    this.batteryBars = 3 - payload[0];
                    this.batteryPercent = payload[1];
                    this.batteryVoltage = (float)(payload[2] + (payload[3] << 8)) / 2048.0f;
                    break;
                }
                default: {
                    System.err.println("App code " + upkt.getAppCode() + " returned " + upkt.toString());
                }
            }
            return true;
        }
        int cmdCode = UEIPacket.getCmdCode(cmd);
        if (upkt.getAppCode() != 17) {
            System.err.println("UEI packet is not a remote command response");
            return false;
        }
        if (upkt.isValidCmd() != 0) {
            System.err.println("Incoming remote command packet is invalid");
            return false;
        }
        byte[] cmdArgs = upkt.getCmdArgs();
        switch (cmdCode) {
            case 80: {
                this.icinfo = upkt.getPayload();
                break;
            }
            case 139: {
                try {
                    this.signature = new String(cmdArgs, 8, 6, "UTF-8");
                    System.err.println("Signature = " + this.signature);
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("Error in reading signature block");
                    return false;
                }
                this.firmwareAddress = this.intFromBytes(cmdArgs, 46);
                this.infoAddress = this.intFromBytes(cmdArgs, 50);
                this.irdbAddress = this.intFromBytes(cmdArgs, 54);
                this.E2address = this.intFromBytes(cmdArgs, 58);
                this.firmwareSize = this.intFromBytes(cmdArgs, 70);
                this.infoSize = this.intFromBytes(cmdArgs, 74);
                this.irdbSize = this.intFromBytes(cmdArgs, 78);
                this.E2size = this.intFromBytes(cmdArgs, 82);
                this.jp2info = Arrays.copyOfRange(cmdArgs, 2, 86);
                System.err.println("E2 address = " + String.format("%04X", this.E2address));
                System.err.println("E2 size = " + String.format("%04X", this.E2size));
            }
        }
        return true;
    }

    public String toString() {
        return this.name + " [" + this.address + "] (" + this.rssi + " dBm)";
    }

    private int intFromBytes(byte[] bArray, int offset) {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val = val << 8 | bArray[offset + i] & 0xFF;
        }
        return val;
    }
}

