/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.LibraryLoader;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.io.IO;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public abstract class CommHID
extends IO {
    Remote remote = null;
    int thisPID;
    String deviceID;
    String signature;
    int firmwareAddress;
    int infoAddress;
    int E2address;
    int E2size;
    int internalFlashSize;
    int externalFlashSize;
    int addrSize;
    RemoteType remoteType = null;
    byte[] dataRead = new byte[1056];
    byte[] icinfo = null;
    byte[] jp2info = null;
    byte[] ssdIn = new byte[62];
    byte[] ssdOut = new byte[62];
    int interfaceType = -1;
    int firmwareFileCount = 0;
    int powerStatus = -1;
    boolean upgradeSuccess = true;
    boolean isAppInfo2 = false;
    boolean newAppInfo2 = false;
    boolean forceUpgrade = false;
    boolean isPortUpg = false;
    LinkedHashMap<String, Hex> firmwareFileVersions = new LinkedHashMap();
    LinkedHashMap<String, Hex> upgradeFileVersions = new LinkedHashMap();
    LinkedHashMap<String, FileData> upgradeData = new LinkedHashMap();
    List<String> sysNames = null;
    File sysFile = null;
    int runningTotal = 0;
    public static final List<String> xziteSysNames = Arrays.asList("MCUFirmware", "BlasterFirmware", "AC_conn.xmg", "Asia.rgn", "Buttons.btn", "ConnectUSB.xmg", "Europe.rgn", "irdb.bin", "lang.dk", "lang.en", "lang.fi", "lang.fr", "lang.ge", "lang.it", "lang.nl", "lang.no", "lang.se", "lang.sp", "Latin.rgn", "Learning.xmg", "MidEast.rgn", "NAmerica.rgn", "Pacific.rgn", "SetupBtn.btn", "Splash.xmg", "SysIcons.pkg", "USB_conn.xmg", "X01tour.xmg", "X02tour.xmg", "X03tour.xmg", "X04tour.xmg", "X05tour.xmg", "X06tour.xmg", "X07tour.xmg");
    static final List<String> digitalSysNames = Arrays.asList("app.img", "alf.img");
    static final List<String> avlSysNames = Arrays.asList("app.img");
    private static final String alphas = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz_-+() .";
    private static final String[] prefixes = new String[]{"XZITE_X3", "XZITE_X2", "AVL_MONSTER", "XZITE_AR_X2_AR", "XZITE_AR_X3_AR", "XZITE_NEVO_C2", "XZITE_NEVO_C3", "DIGITAL_OFA_DIGITAL_OFA", "DIGITAL_PLUS_OFA_DIGITAL_PLUS_OFA", "DIGITAL_AR_DIGITAL_AR", "DIGITAL_PLUS_AR_DIGITAL_PLUS_AR"};
    private static final String[] blockNames = new String[]{"Application", "Library", "Fdra", "ALF", "DLF", "Graphics", "Screen"};
    private static final int chunkSize = 16384;
    public static String[] lastRegistryKey = null;

    @Override
    public String getInterfaceName() {
        return "CommHID";
    }

    @Override
    public String[] getPortNames() {
        String[] portNames = new String[]{"HID"};
        return portNames;
    }

    public int getRemotePID() {
        return this.thisPID;
    }

    @Override
    public boolean getIcInfo(byte[] buffer, int length) {
        if (this.icinfo == null) {
            return false;
        }
        Arrays.fill(buffer, (byte)0);
        System.arraycopy(this.icinfo, 0, buffer, 0, Math.min(this.icinfo.length, buffer.length));
        return true;
    }

    @Override
    public boolean getJP2info(byte[] buffer, int length) {
        if (this.jp2info == null) {
            return false;
        }
        Arrays.fill(buffer, (byte)0);
        System.arraycopy(this.jp2info, 0, buffer, 0, Math.min(this.jp2info.length, buffer.length));
        return true;
    }

    byte jp12ComputeCheckSum(byte[] data, int start, int length) {
        int sum = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            sum ^= data[i] & 0xFF;
        }
        return (byte)sum;
    }

    void assembleFDRAreadAddress(int address, int addrSize, int blockLength, byte[] cmdBuff) {
        cmdBuff[0] = 0;
        cmdBuff[1] = (byte)(4 + addrSize);
        cmdBuff[2] = 1;
        cmdBuff[3] = (byte)(address >> 24 & 0xFF);
        cmdBuff[4] = (byte)(address >> 16 & 0xFF);
        cmdBuff[addrSize + 1] = (byte)(address >> 8 & 0xFF);
        cmdBuff[addrSize + 2] = (byte)(address & 0xFF);
        cmdBuff[addrSize + 3] = (byte)(blockLength >> 8 & 0xFF);
        cmdBuff[addrSize + 4] = (byte)(blockLength & 0xFF);
        cmdBuff[addrSize + 5] = this.jp12ComputeCheckSum(cmdBuff, 0, addrSize + 5);
    }

    void assembleFDRAeraseCmd(int startAddress, int endAddress, byte[] cmdBuff) {
        cmdBuff[0] = 0;
        cmdBuff[1] = (byte)(2 * this.addrSize + 2);
        cmdBuff[2] = 3;
        cmdBuff[3] = (byte)(startAddress >> 24 & 0xFF);
        cmdBuff[4] = (byte)(startAddress >> 16 & 0xFF);
        cmdBuff[this.addrSize + 1] = (byte)(startAddress >> 8 & 0xFF);
        cmdBuff[this.addrSize + 2] = (byte)(startAddress & 0xFF);
        cmdBuff[this.addrSize + 3] = (byte)(endAddress >> 24 & 0xFF);
        cmdBuff[this.addrSize + 4] = (byte)(endAddress >> 16 & 0xFF);
        cmdBuff[2 * this.addrSize + 1] = (byte)(endAddress >> 8 & 0xFF);
        cmdBuff[2 * this.addrSize + 2] = (byte)(endAddress & 0xFF);
        cmdBuff[2 * this.addrSize + 3] = this.jp12ComputeCheckSum(cmdBuff, 0, 2 * this.addrSize + 3);
    }

    int enterService() {
        byte[] cmdBuff = new byte[]{0, 4, 81, 85, -86, -86};
        int result = 0;
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            result = 1;
        } else if (!this.readFDRAreport()) {
            result = 2;
        } else if (this.dataRead[0] != 0 || this.dataRead[1] < 2 || this.dataRead[2] != 0) {
            result = 3;
        }
        if (RemoteMaster.admin) {
            System.err.println("Enter service returned " + result);
        }
        return result;
    }

    int exitBootstrap() {
        byte[] cmdBuff = new byte[]{0, 2, 82, 80};
        int result = 0;
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            result = 1;
        } else if (!this.readFDRAreport()) {
            result = 2;
        } else if (this.dataRead[0] != 0 || this.dataRead[1] < 2 || this.dataRead[2] != 0) {
            result = 3;
        }
        if (RemoteMaster.admin) {
            System.err.println("Exit bootstrap returned " + result);
        }
        return result;
    }

    abstract boolean writeFDRAcmdReport(byte[] var1);

    abstract boolean readFDRAreport();

    abstract Hex getVersionFromFDRAremote(int var1);

    abstract boolean eraseFDRA(int var1, int var2);

    abstract boolean writeFDRAblock(int var1, int var2, byte[] var3, int var4);

    abstract int readFDRAchunk(int var1, int var2, byte[] var3, int var4, int var5);

    abstract boolean waitForReconnection(int var1);

    abstract int readXZITEUSBReport(byte[] var1, int var2);

    abstract int writeXZITEUSBReport(byte[] var1, int var2);

    public abstract int getEnhancedPowerManagementStatus();

    @Override
    public abstract String getInterfaceVersion();

    boolean reopenFDRARemote() {
        byte[] cmdBuff = new byte[]{0, 2, 81, 83};
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            return false;
        }
        return this.readFDRAreport() && this.dataRead[0] == 0;
    }

    int addrFromBytes(byte[] bArray, int offset) {
        int addr = 0;
        for (int i = 0; i < this.addrSize; ++i) {
            addr = addr << 8 | bArray[offset + i] & 0xFF;
        }
        return addr;
    }

    int addrFromEntry(int entry) {
        if (entry >= 0) {
            return entry;
        }
        byte[] buffer = new byte[4];
        if (this.readFDRAnoUpdate(entry & Integer.MAX_VALUE, buffer, this.addrSize) != this.addrSize) {
            return -1;
        }
        return this.addrFromBytes(buffer, 0);
    }

    boolean getFDRAInfoAndSig() {
        int sigStart;
        byte[] cmdBuff = new byte[]{0, 2, 80, 82};
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            return false;
        }
        if (!this.readFDRAreport() || this.dataRead[0] != 0 || this.dataRead[1] != this.addrSize + 4 || this.dataRead[2] != 0) {
            return false;
        }
        this.icinfo = new byte[10];
        System.arraycopy(this.dataRead, 0, this.icinfo, 0, 10);
        System.err.println("Info read is:");
        System.err.println(Hex.toString(this.dataRead, 32, 0, this.addrSize + 6));
        int eBootVersion = this.dataRead[3] & 0xFF;
        int icType = this.dataRead[4] & 0xFF;
        System.err.println("IC type = $" + Integer.toHexString(icType));
        this.isAppInfo2 = (eBootVersion & 0x80) == 128;
        this.newAppInfo2 = true;
        int infoOffset = this.isAppInfo2 ? 42 : 26;
        int infoCount = this.isAppInfo2 ? 10 : 8;
        int infoSize = infoOffset + infoCount * this.addrSize + 2;
        this.infoAddress = this.addrFromBytes(this.dataRead, 5);
        int n = this.isAppInfo2 ? (this.newAppInfo2 ? 6 : 16) : (sigStart = 0);
        if (this.readFDRAnoUpdate(this.infoAddress, this.dataRead, infoSize) != infoSize) {
            return false;
        }
        System.err.println("Sig block read is:");
        System.err.println(Hex.toString(this.dataRead, 32, 0, infoSize));
        try {
            this.signature = new String(this.dataRead, sigStart, 6, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Error in reading signature block");
            return false;
        }
        if (this.isAppInfo2 && this.newAppInfo2) {
            infoCount = this.dataRead[42] & 0xFF;
            if (infoCount > 16) {
                System.err.println("Error: number of signature block entries " + infoCount + " is too big");
                return false;
            }
            infoSize = infoOffset + infoCount * this.addrSize + 1;
            this.jp2info = new byte[infoSize];
            System.arraycopy(this.dataRead, 0, this.jp2info, 0, infoOffset + 1);
            for (int i = 0; i < infoCount; ++i) {
                int pos = infoOffset + 1 + i * this.addrSize;
                int entry = this.addrFromBytes(this.dataRead, pos);
                int addr = this.addrFromEntry(entry);
                for (int j = 0; j < this.addrSize; ++j) {
                    this.jp2info[pos + j] = (byte)(addr >> 8 * (this.addrSize - j - 1) & 0xFF);
                }
            }
            this.firmwareAddress = this.addrFromBytes(this.jp2info, infoOffset + 1);
            this.E2address = this.addrFromBytes(this.jp2info, infoOffset + 1 + 2 * this.addrSize);
            int temp = 0;
            if (infoCount < 4) {
                this.E2size = 12288;
            } else {
                int ALFStartEntry = this.addrFromBytes(this.jp2info, infoOffset + 1 + 3 * this.addrSize);
                temp = this.addrFromEntry(ALFStartEntry);
                this.E2size = temp - this.E2address;
            }
            if (this.E2address < 0 || temp < 0) {
                return false;
            }
        } else {
            infoSize = infoOffset + 6 * this.addrSize;
            this.jp2info = new byte[infoSize];
            System.arraycopy(this.dataRead, 0, this.jp2info, 0, infoSize);
            int firmwareEntry = this.addrFromBytes(this.dataRead, infoOffset);
            int E2StartEntry = this.addrFromBytes(this.dataRead, infoOffset + 4 * this.addrSize);
            int E2EndEntry = this.addrFromBytes(this.dataRead, infoOffset + 5 * this.addrSize);
            this.firmwareAddress = firmwareEntry;
            this.E2address = E2StartEntry;
            this.E2size = E2EndEntry - E2StartEntry + 1;
        }
        return true;
    }

    @Override
    public String getRemoteSignature() {
        return "USB" + String.format("%04X", this.thisPID);
    }

    @Override
    public int getRemoteEepromAddress() {
        return this.E2address;
    }

    @Override
    public int getRemoteEepromSize() {
        return this.E2size;
    }

    @Override
    public boolean remoteUsesSSD() {
        return this.remoteType == RemoteType.XZITE;
    }

    @Override
    public int getInterfaceType() {
        return this.interfaceType;
    }

    public String getXZITEVersion(Hex version) {
        Hex hex = this.firmwareFileVersions.get("MCUFirmware");
        if (hex == null && this.getVersionsFromRemote(false)) {
            hex = this.firmwareFileVersions.get("MCUFirmware");
        }
        if (hex != null) {
            short[] v;
            if (version != null) {
                version.put(hex.subHex(2));
            }
            return (v = hex.getData()) == null ? "Unknown" : "" + v[5] + "." + v[4] + "." + v[2];
        }
        return null;
    }

    public LinkedHashMap<String, Integer> getXZITEfileList() {
        LinkedHashMap<String, Integer> listing = new LinkedHashMap<String, Integer>();
        ArrayList<String> fileList = new ArrayList<String>();
        int written = this.writeXZITEUSBReport(new byte[]{23}, 1);
        if (written != 65 || this.readXZITEUSBReport(this.ssdIn) < 0) {
            System.err.println("List files failed to initiate");
            return null;
        }
        System.err.println("File list data:");
        byte[] o = new byte[2];
        o[0] = 1;
        boolean more = true;
        int count = 0;
        while (more) {
            if (this.readXZITEUSBReport(this.ssdIn) < 0) {
                System.err.println("Read of file list failed");
                return null;
            }
            if (this.ssdIn[0] == 24) {
                short nameLen;
                if (count != (this.ssdIn[2] & 0xFF | (this.ssdIn[3] & 0xFF) << 8)) {
                    System.err.println("Sequence error in reading file list");
                    return null;
                }
                int dataLen = this.ssdIn[4] & 0xFF;
                more = this.ssdIn[5] != 0;
                Hex hex = new Hex(this.ssdIn);
                for (int pos = 6; pos < dataLen + 6; pos += nameLen) {
                    nameLen = hex.getData()[pos++];
                    String name = hex.subString(pos, nameLen);
                    fileList.add(name);
                }
            }
            o[1] = this.ssdIn[1];
            this.writeXZITEUSBReport(o, 2);
            ++count;
        }
        Collections.sort(fileList);
        for (String name : fileList) {
            byte[] sizeData = this.readXZITEFileBytes(name, true);
            Integer size = sizeData.length == 4 ? Integer.valueOf(this.intFromHex(new Hex(sizeData), 0, true)) : null;
            listing.put(name, size);
        }
        return listing;
    }

    public boolean reformatXZITE() {
        this.setProgressName("FORMATTING:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        String title = "Formatting XSight";
        int written = this.writeXZITEUSBReport(new byte[]{22}, 1);
        this.upgradeSuccess = written == 65;
        int read = this.readXZITEUSBReport(this.ssdIn, 5000);
        if (read != 64 || this.ssdIn[2] != 0) {
            this.upgradeSuccess = false;
        }
        if (!this.upgradeSuccess) {
            System.err.println("Formatting of file system failed");
            String message = "Formatting of file system failed.\nAborting the rebuild.";
            JOptionPane.showMessageDialog(null, message, title, 0);
            return false;
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(40);
        }
        System.err.println("Formatting of file system succeeded");
        LinkedHashMap<String, Integer> fileList = this.getXZITEfileList();
        System.err.println("List of remaining files (should be empty):");
        for (String name : fileList.keySet()) {
            System.err.println(name);
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(100);
        }
        File sysFile = RemoteMaster.getRmirSys();
        ArrayList<String> filesToWrite = new ArrayList<String>();
        for (String name : this.sysNames) {
            if (name.indexOf(46) <= 0) continue;
            filesToWrite.add(name);
        }
        this.writeSystemFiles(sysFile, filesToWrite, 3);
        String message = this.upgradeSuccess ? "System files successfully recreated.\nReformatting and rebuild complete." : "Error in reinstalling system files.  Rebuild failed.";
        JOptionPane.showMessageDialog(null, message, title, 1);
        return this.upgradeSuccess;
    }

    public List<String> verifyXZITEfiles() {
        LinkedHashMap<String, Integer> fileMap = this.getXZITEfileList();
        ArrayList<String> ucSysNames = new ArrayList<String>();
        ArrayList<String> ucRemNames = new ArrayList<String>();
        ArrayList<String> comments = new ArrayList<String>();
        for (String name : xziteSysNames) {
            ucSysNames.add(name.toUpperCase());
        }
        File sysFile = RemoteMaster.getRmirSys();
        if (!this.setFileData(sysFile)) {
            comments.add("Unable to verify file content.");
        } else {
            try {
                ZipFile zipfile = new ZipFile(sysFile);
                this.setProgressName("VERIFYING SYSTEM FILES:");
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(0);
                }
                int total = fileMap.size();
                int index = 0;
                for (String name : fileMap.keySet()) {
                    ++index;
                    if (this.progressUpdater != null) {
                        this.progressUpdater.updateProgress((int)((double)index / (double)total * 100.0));
                    }
                    if (!ucSysNames.contains(name.toUpperCase())) continue;
                    if (RemoteMaster.admin && !this.sysNames.contains(name)) {
                        int ndx = ucSysNames.indexOf(name.toUpperCase());
                        String s = "Case error in name: file " + name + " should be " + this.sysNames.get(ndx);
                        comments.add(s);
                    }
                    ucRemNames.add(name.toUpperCase());
                    String zName = this.upgradeData.get((Object)name.toUpperCase()).zName;
                    ZipEntry entry = zipfile.getEntry(zName);
                    int length = (int)entry.getSize();
                    if (length < 0) {
                        String s = "No data available to verify file " + name + ".";
                        comments.add(s);
                        continue;
                    }
                    InputStream zip = zipfile.getInputStream(entry);
                    byte[] sysData = RMIRSetup.readBinary(zip, length);
                    Hex sysHex = new Hex(sysData);
                    RemoteConfiguration.decryptObjcode(sysHex);
                    byte[] remData = this.readSystemFile(name);
                    if (remData == null) {
                        String s = "Unable to read file " + name + " from remote.";
                        comments.add(s);
                        continue;
                    }
                    Hex remHex = new Hex(remData);
                    if (!sysHex.equals(remHex)) {
                        String s = "File " + name + " is corrupt.";
                        comments.add(s);
                        continue;
                    }
                    System.err.println("File " + name + " verified");
                }
                for (int i = 0; i < ucSysNames.size(); ++i) {
                    String ucName = (String)ucSysNames.get(i);
                    if (ucName.indexOf(46) <= 0 || ucRemNames.contains(ucName)) continue;
                    String s = "System file " + this.sysNames.get(i) + " is missing.";
                    comments.add(s);
                }
                zipfile.close();
                if (comments.isEmpty()) {
                    comments.add("All system files are correct.");
                }
            }
            catch (Exception e) {
                String s = "Error in verification process.  Ending verification.";
                comments.add(s);
            }
        }
        System.err.println("File verification complete");
        return comments;
    }

    public String saveFDRAfirmware() {
        Hex appVersion = null;
        Hex alfVersion = null;
        if (this.enterService() != 0) {
            return null;
        }
        appVersion = this.getVersionFromFDRAremote(0);
        if (appVersion == null || this.remoteType == RemoteType.DIGITAL && (alfVersion = this.getVersionFromFDRAremote(3)) == null) {
            appVersion = new Hex(new short[]{48, 48, 48, 48, 48, 48});
        }
        if (!this.getFDRAInfoAndSig()) {
            this.firmwareAddress = this.remoteType == RemoteType.DIGITAL ? 5632 : 2118;
        }
        int firmwareSize = Math.min(this.internalFlashSize, this.E2address) - this.firmwareAddress;
        String name = String.format("Sys%04X", this.thisPID) + "_" + appVersion.subString(0, 6);
        if (alfVersion != null) {
            name = name + "." + alfVersion.subString(3, 3);
        }
        name = name + ".bin";
        File outputDir = new File(RemoteMaster.getWorkDir(), "XSight");
        outputDir.mkdirs();
        File file = new File(outputDir, name);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file, false));
            byte[] buffer = new byte[this.internalFlashSize];
            int read = this.readFDRAfirmware(this.firmwareAddress, buffer, firmwareSize);
            if (read != firmwareSize) {
                out.close();
                return null;
            }
            out.write(buffer, 0, firmwareSize);
            if (this.E2address > this.internalFlashSize) {
                int size = this.E2address - this.internalFlashSize;
                read = this.readFDRAfirmware(this.internalFlashSize, buffer, size);
                if (read != size) {
                    out.close();
                    return null;
                }
                out.write(buffer, 0, size);
                Arrays.fill(buffer, 0, this.E2size, (byte)-1);
                out.write(buffer, 0, this.E2size);
                size = this.internalFlashSize + this.externalFlashSize - this.E2address - this.E2size;
                read = this.readFDRAfirmware(this.E2address + this.E2size, buffer, size);
                if (read != size) {
                    out.close();
                    return null;
                }
                out.write(buffer, 0, size);
            }
            out.close();
        }
        catch (Exception e) {
            return null;
        }
        return name;
    }

    int testRemote(byte[] buffer, int length) {
        if (RemoteMaster.admin) {
            System.err.println("Read dialog starts:");
        }
        String title = "Unknown remote";
        String message = null;
        System.err.println();
        System.err.println("Starting diagnostics for unknown USB remote with PID = " + String.format("%04X", this.thisPID));
        boolean identified = false;
        if (this.thisPID > 32768 && this.thisPID <= 32775) {
            if (this.getVersionsFromRemote(false)) {
                identified = true;
                message = "RMIR has found an XSight Touch style of remote with the following data:\n    Signature = " + this.getRemoteSignature() + "\n    Processor = S3F80\n    Firmware version = " + this.getXZITEVersion(null);
                if (RemoteMaster.admin && RMIRSetup.NegativeDefaultButtonJOptionPane.showConfirmDialog(null, message = message + "\n\nDo you want to run further tests in Upgrade mode?", title, 0, 2) == 0) {
                    LinkedHashMap<String, Integer> listing = this.getXZITEfileList();
                    if (listing == null) {
                        return 0;
                    }
                    for (String name : listing.keySet()) {
                        System.err.println(name + "   " + listing.get(name));
                    }
                    return length;
                }
            }
        } else if (this.thisPID > 32775 && this.thisPID <= 32785 || this.thisPID == 7) {
            System.err.println("XSight FDRA remote");
            this.enterService();
            if (this.getFDRAInfoAndSig() && this.E2address > 0) {
                identified = true;
                Hex version = this.getVersionFromFDRAremote(0);
                String versionString = "Unknown";
                if (version != null) {
                    versionString = version.subString(0, 4) + "." + version.subString(4, 2);
                }
                message = "RMIR has found an XSight FDRA style of remote with the following data:\n    Signature = " + this.getRemoteSignature() + "\n    Processor = " + (this.remoteType == RemoteType.DIGITAL ? "MAXQ622" : "HCS08") + "\n    Firmware version = " + versionString + "\n    Firmware address = $" + Integer.toHexString(this.firmwareAddress).toUpperCase() + "\n    EEPROM address = $" + Integer.toHexString(this.E2address).toUpperCase() + "\n    EEPROM size = $" + Integer.toHexString(this.E2size).toUpperCase();
            }
        }
        if (!identified) {
            message = "RMIR has found a remote with USB PID " + String.format("%04X", this.thisPID) + "\nbut cannot identify it further.";
        }
        if (!RemoteMaster.admin) {
            message = message + "\n\nYou may wish to post a message in the JP1 forums to seek help in\ncreating an RDF for this remote.  If so, please post the rmaster.err\nfile that you will find in the RMIR installation folder and include a\nlink to that file in your message.";
        }
        JOptionPane.showMessageDialog(null, message, title, 1);
        return length;
    }

    int readFDRA(int address, byte[] buffer, int length) {
        this.setProgressName(this.getUse() == RMIRSetup.Use.DOWNLOAD ? "DOWNLOADING:" : "VERIFYING UPLOAD:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        return this.readFDRAnoUpdate(address, buffer, length);
    }

    private int readFDRAfirmware(int address, byte[] buffer, int length) {
        this.setProgressName("READING FIRMWARE:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        return this.readFDRAnoUpdate(address, buffer, length);
    }

    int readFDRAnoUpdate(int address, byte[] buffer, int length) {
        int size;
        byte[] chunkBuffer = new byte[16384];
        int pos = 0;
        for (int remaining = length; remaining > 0; remaining -= size) {
            this.waitForMillis(100);
            size = remaining > 16384 ? 16384 : remaining;
            int numRead = this.readFDRAchunk(address, pos, chunkBuffer, size, length);
            if (numRead != size) break;
            System.arraycopy(chunkBuffer, 0, buffer, pos, size);
            pos += size;
        }
        return pos;
    }

    int writeFDRA(int address, byte[] buffer, int length, boolean erase) {
        int size;
        if (length == 0) {
            return 0;
        }
        if (erase && (address < this.E2address || address + length > this.E2address + this.E2size)) {
            return -1;
        }
        this.setProgressName(erase ? "UPLOADING:" : "WRITING NEW FIRMWARE:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        byte[] chunkBuffer = new byte[16384];
        int pos = 0;
        for (int remaining = length; remaining > 0; remaining -= size) {
            size = remaining > 16384 ? 16384 : remaining;
            System.arraycopy(buffer, pos, chunkBuffer, 0, size);
            int numWritten = this.writeFDRAchunk(address, pos, chunkBuffer, size, length, erase);
            if (numWritten != size) break;
            pos += size;
        }
        if (RemoteMaster.admin) {
            System.err.println("writeFDRA lengths: In " + length + ", Out " + pos);
        }
        return pos;
    }

    int writeFDRAchunk(int address, int delta, byte[] buffer, int length, int total, boolean erase) {
        System.err.println();
        System.err.println("Starting FDRA write of $" + Integer.toHexString(length).toUpperCase() + " bytes at $" + String.format("%05X", address += delta));
        int writeBlockSize = 60 - this.addrSize;
        int erasePageSize = 512;
        int blockLength = writeBlockSize;
        byte[] tempBuf = new byte[65];
        if (erase && (length % erasePageSize != 0 || address % erasePageSize != 0)) {
            return -1;
        }
        int endAdr = address + length - 1;
        if (erase && !this.eraseFDRA(address, endAdr)) {
            return -1;
        }
        int offset = 0;
        do {
            if (offset + blockLength > length) {
                blockLength = length - offset;
            }
            System.arraycopy(buffer, offset, tempBuf, 0, blockLength);
            if (!this.writeFDRAblock(address + offset, this.addrSize, tempBuf, blockLength)) {
                return -1;
            }
            if (!this.readFDRAreport() || this.dataRead[2] != 0) {
                return -1;
            }
            offset += blockLength;
            if (this.progressUpdater == null) continue;
            this.progressUpdater.updateProgress((int)((double)(delta + offset) / (double)total * 100.0));
        } while (offset < length);
        return offset;
    }

    @Override
    public int readRemote(int address, byte[] buffer, int length) {
        boolean noUpgrade;
        int bytesRead = -1;
        if (this.remoteType == RemoteType.UNKNOWN || this.remote == null) {
            String message = "This remote is not recognised by RMIR but appears to be of the\nXSight type.  RMIR can run further diagnostics to help identify\nit further.  This will typically take less than 30 seconds but in\nexceptional circumstances can take up to 10 minutes or so.\n\nWould you like to run these diagnostics now?";
            String title = "Unknown remote";
            if (RMIRSetup.NegativeDefaultButtonJOptionPane.showConfirmDialog(null, message, title, 0, 2) == 0) {
                bytesRead = this.testRemote(buffer, length);
                return bytesRead;
            }
            return -1;
        }
        this.forceUpgrade = false;
        boolean bl = noUpgrade = RMIRSetup.noUpgradeItem.isSelected() || this.isPortUpg;
        if (this.getUse() == RMIRSetup.Use.DOWNLOAD && !noUpgrade) {
            if (RemoteMaster.admin) {
                System.err.println("Read dialog starts:");
            }
            this.forceUpgrade = this.remoteType == RemoteType.XZITE && RMIRSetup.forceUpgradeItem.isSelected() || this.remoteType != RemoteType.XZITE && RMIRSetup.forceFDRAUpgradeItem.isSelected();
            String title = this.forceUpgrade ? "Forced upgrade" : "Firmware upgrade";
            this.sysFile = RMIRSetup.getUpgradeSource();
            if (this.sysFile == null) {
                this.sysFile = RemoteMaster.getRmirSys();
            } else {
                title = title + " from " + this.sysFile.getName();
            }
            this.setProgressName("CHECKING FOR UPGRADE:");
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(0);
            }
            this.firmwareFileVersions.clear();
            if (!this.forceUpgrade && !this.getVersionsFromRemote(true)) {
                return 0;
            }
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(30);
            }
            boolean doUpgradeTest = false;
            if (this.sysFile.exists()) {
                System.err.println("Version numbers from remote:");
                for (String name : this.firmwareFileVersions.keySet()) {
                    System.err.println("  " + this.firmwareFileVersions.get(name) + "  " + name);
                }
                if (this.setFileData(this.sysFile)) {
                    if (this.progressUpdater != null) {
                        this.progressUpdater.updateProgress(40);
                    }
                    if (this.verifyFileVersions(this.sysFile)) {
                        if (this.progressUpdater != null) {
                            this.progressUpdater.updateProgress(50);
                        }
                        doUpgradeTest = true;
                    }
                }
                if (!doUpgradeTest) {
                    String message = "The file RMIR.sys appears to be corrupt, so unable to\ntest for firmware upgrade.  Press OK to continue without\nthis test, otherwise press Cancel.";
                    if (JOptionPane.showConfirmDialog(null, message, title, 2, 2) == 2) {
                        return 0;
                    }
                    if (this.progressUpdater != null) {
                        this.progressUpdater.updateProgress(70);
                    }
                }
            }
            if (doUpgradeTest) {
                ArrayList<String> changed = new ArrayList<String>();
                ArrayList<String> newFiles = new ArrayList<String>();
                int[] upgNeeds = this.testForUpgrade(changed, newFiles);
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(100);
                }
                if (upgNeeds[0] > 0) {
                    Object[] buttons;
                    int response;
                    String message = upgNeeds[2] == 1 ? "There is a firmware upgrade available for this remote.  You may\ninstall it now or you can continue the current operation without\ninstalling it.\n\n" : (upgNeeds[2] == 0 ? "You already have the latest firmware installed but may perform\na reinstallation if you wish.\n\n" : (upgNeeds[2] == -1 ? "It appears that the current firmware in your remote is a later\nversion than is available here as an upgrade, but you may install\nthe upgrade version if you wish.\n\n" : "There is a firmware revision available that will upgrade some files\nbut downgrade others.  You should take advice from the JP1 forum\nbefore installing it, but you may do so if you wish.\n\n"));
                    message = message + "A firmware upgrade should preserve the current setup, but it is\nrecommended that you save the current setup as a .rmir file before\nupgrading.\n\n";
                    if (RMIRSetup.ioNeedsPowerManagementCheck(this)) {
                        message = message + "You appear to be using Windows 8.1 or later, which support Enhanced\nPower Management.  This may cause issues during a firmware upgrade.\nYou should make sure that you know how to use regedit to edit the\nWindows registry before proceeding.  If registry changes are needed\nthen messages will pop up to tell you exactly what change to make and\nhow to proceed after making them.\n\n";
                    }
                    if ((response = JOptionPane.showOptionDialog(null, message = message + "What action do you want to take?", title, -1, -1, null, buttons = new String[]{"<html>Continue without installation</html>", "<html>Install the firmware</html>"}, buttons[0])) == 1) {
                        if (this.remoteType == RemoteType.XZITE) {
                            message = "A firmware upgrade involves updating both the firmware of the central\nprocessor and a series of support files.  Sometimes that of the central\nprocessor is already up to date and only the support files need updating.\nIn that case the upgrade runs to completion as a single process.  If the\nprocessor firmware needs upgrading, however, the upgrade takes place as a\nseries of stages, during which the remote will restart twice.  Each restart\ninvolves the remote disconnecting from the PC then reconnecting.  Usually\nthis reconnection takes place automatically. However, with some remotes\nand/or PCs a pop-up will ask the user to disconnect and then reconnect the USB\ncable in the course of the upgrade and to press OK to continue when you have\ndone so.  Please follow any such instructions that appear on the PC.\n\nIf you get a message from Windows saying \"USB device not recognised\" or\nsomething similar while the progress bar is saying \"Waiting for reconnection\",\nplease wait for the progress bar to reach its end, taking at most one minute.\nThe pop-up about disconnection and reconnection will then appear, and doing so\nwill resolve the problem.\n\nDo you still want to continue with the firmware upgrade?";
                            response = JOptionPane.showConfirmDialog(null, message, title, 0, 3);
                        } else if (this.remoteType == RemoteType.DIGITAL && !newFiles.isEmpty()) {
                            String defaultFile = (String)newFiles.get(0);
                            changed.add(defaultFile);
                            int defaultLangCode = Integer.parseInt(defaultFile.substring(3, 4));
                            String defaultStr = defaultLangCode == 0 ? "without additional" : "with " + RMIRSetup.getLanguage((int)defaultLangCode).name;
                            message = "The additional language support currently installed is not available\nfor this firmware upgrade.  If you continue, the upgrade will be\ninstalled " + defaultStr + " language support.\n\nDo you want to continue with the upgrade?";
                            response = RMIRSetup.NegativeDefaultButtonJOptionPane.showConfirmDialog(null, message, title, 0, 2);
                        } else {
                            response = 0;
                        }
                    } else {
                        message = "To stop the firmware upgrade being offered in future without\ninstalling it, check the item \"No XSight Firmware Upgrade\"\nin the Options menu.  This will remain checked each time you\nopen RMIR until you specifically uncheck it.";
                        JOptionPane.showMessageDialog(null, message, title, 1);
                        response = 1;
                    }
                    if (response == 0) {
                        int reply;
                        message = null;
                        if (this.remoteType == RemoteType.XZITE) {
                            if (!this.upgradeXZITE(upgNeeds, changed, newFiles)) {
                                message = "Upgrade failed.";
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                return 0;
                            }
                        } else if (this.remoteType == RemoteType.DIGITAL || this.remoteType == RemoteType.AVL) {
                            if (!this.upgradeFDRA(upgNeeds, changed)) {
                                message = "Upgrade failed.";
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                return 0;
                            }
                        } else {
                            RMIRSetup.forceUpgradeItem.setSelected(false);
                            message = "Firmware upgrade for this remote is not yet implemented.\n\n";
                        }
                        if (message == null) {
                            message = "Upgrade succeeded.\n\n";
                        }
                        if ((reply = JOptionPane.showConfirmDialog(null, message = message + "Do you want to continue with a normal download?", title, 0, 3)) != 0) {
                            return 0;
                        }
                    }
                }
            }
        }
        if (this.remoteType == RemoteType.DIGITAL) {
            bytesRead = this.readFDRA(address, buffer, length);
        } else if (this.remoteType == RemoteType.XZITE) {
            bytesRead = this.readXZITE(buffer);
        } else if (this.remoteType == RemoteType.AVL) {
            bytesRead = this.readFDRA(address, buffer, length);
        }
        return bytesRead;
    }

    private boolean upgradeXZITE(int[] upgNeeds, List<String> changed, List<String> newFiles) {
        System.err.println("Proceeding with firmware revision");
        String title = "Firmware upgrade";
        String message = null;
        this.upgradeSuccess = true;
        if (upgNeeds[1] > 0) {
            this.setProgressName("ENTERING UPGRADE MODE:");
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(0);
            }
            try {
                ZipFile zipIn = new ZipFile(this.sysFile);
                String zName = this.upgradeData.get((Object)"MCUFIRMWARE").zName;
                ZipEntry entry = zipIn.getEntry(zName);
                int eLength = (int)entry.getSize();
                if (eLength != 262152) {
                    System.err.println("MCUFirmware file has invalid length");
                    zipIn.close();
                    return false;
                }
                InputStream zip = zipIn.getInputStream(entry);
                byte[] data = RMIRSetup.readBinary(zip, eLength);
                zipIn.close();
                Hex hex = new Hex(data);
                RemoteConfiguration.decryptObjcode(hex);
                data = hex.toByteArray();
                int crc = 0;
                crc = this.verifyCRC(data, 8);
                if (crc < 0) {
                    System.err.println("MCUFirmware file has invalid CRC checksum");
                    return false;
                }
                if (!this.getVersionsFromRemote(true)) {
                    return false;
                }
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(20);
                }
                this.writeXZITEUSBReport(new byte[]{32}, 1);
                if (this.readXZITEUSBReport(this.ssdIn) < 0 || this.ssdIn[2] != 0) {
                    System.err.println("Request to disconnect failed");
                    message = "Upgrade failed.  Request to disconnect failed.\nAborting firmware upgrade.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                    return false;
                }
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(40);
                }
                this.waitForMillis(7000);
                boolean success = false;
                if (this.waitForReconnection() && this.writeXZITEFirmwareFile(data)) {
                    this.setProgressName("CLOSING UPGRADE MODE:");
                    if (this.progressUpdater != null) {
                        this.progressUpdater.updateProgress(0);
                    }
                    Arrays.fill(this.ssdOut, (byte)0);
                    this.ssdOut[0] = 35;
                    this.ssdOut[2] = (byte)(crc & 0xFF);
                    this.ssdOut[3] = (byte)(crc >> 8 & 0xFF);
                    int n = -1;
                    do {
                        int written;
                        success = (written = this.writeXZITEUSBReport(this.ssdOut, 62)) == 65;
                        int read = this.readXZITEUSBReport(this.ssdIn);
                        if (read != 64 || this.ssdIn[2] != 0) {
                            success = false;
                        }
                        this.waitForMillis(500);
                    } while (!success && ++n < 20);
                }
                if (!success) {
                    if (this.powerStatus != 1) {
                        System.err.println("Writing of upgraded MCU firmware failed");
                        message = "Unable to write MCU firmware.\n\nPlease disconnect the remote, remove the batteries, put them\nback in, reconnect the remote and repeat the upgrade process.";
                        JOptionPane.showMessageDialog(null, message, title, 0);
                    }
                    return false;
                }
                System.err.println("Exited upgrade mode");
            }
            catch (Exception e) {
                System.err.println("MCU firmware upgrade error");
                return false;
            }
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(100);
            }
            this.waitForMillis(7000);
        }
        if ((upgNeeds[1] == 0 || this.waitForReconnection()) && this.getVersionsFromRemote(false) && this.testForUpgrade(changed, newFiles) != null && this.writeSystemFiles(this.sysFile, changed, 1) && this.waitForMillis(300) && this.getVersionsFromRemote(false) && this.testForUpgrade(changed, newFiles) != null && this.writeSystemFiles(this.sysFile, newFiles, 2) && this.waitForMillis(300) && this.getVersionsFromRemote(false) && this.upgradeSuccess) {
            return true;
        }
        if (this.powerStatus != 1) {
            message = "Upgrade failed. Unable to update all support files.\n\nPlease disconnect and reconnect the remote, then repeat the\nupgrade process";
            JOptionPane.showMessageDialog(null, message, title, 0);
        }
        return false;
    }

    private boolean upgradeFDRA(int[] upgNeeds, List<String> changed) {
        block52: {
            System.err.println("Proceeding with firmware revision");
            this.upgradeSuccess = true;
            int firmwareAddress = 0;
            int firmwareSize = 0;
            int alfStart = 0;
            byte[] data = null;
            byte[] alfData = null;
            if (upgNeeds[0] > 0) {
                this.setProgressName("PREPARING THE UPGRADE:");
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(0);
                }
                try {
                    short sum;
                    Hex calc;
                    Hex stored;
                    int eLength = 0;
                    InputStream in = null;
                    ZipFile zipIn = null;
                    if (this.sysFile.getName().endsWith(".sys")) {
                        zipIn = new ZipFile(this.sysFile);
                        String zName = this.upgradeData.get((Object)"app.img").zName;
                        ZipEntry entry = zipIn.getEntry(zName);
                        eLength = (int)entry.getSize();
                        in = zipIn.getInputStream(entry);
                        data = RMIRSetup.readBinary(in, eLength);
                        if (!changed.isEmpty() && !changed.get(0).equals("alf0.img") && (zName = this.upgradeData.get((Object)changed.get((int)0)).zName) != null) {
                            entry = zipIn.getEntry(zName);
                            int alfLength = (int)entry.getSize();
                            in = zipIn.getInputStream(entry);
                            alfData = RMIRSetup.readBinary(in, alfLength);
                        }
                        zipIn.close();
                    } else {
                        eLength = (int)this.sysFile.length();
                        in = new FileInputStream(this.sysFile);
                        data = RMIRSetup.readBinary(in, eLength);
                        ((InputStream)in).close();
                    }
                    firmwareSize = eLength - this.externalFlashSize;
                    firmwareAddress = Math.min(this.internalFlashSize, this.E2address) - firmwareSize;
                    Hex hex = new Hex(data);
                    if (this.sysFile.getName().endsWith(".sys")) {
                        RemoteConfiguration.decryptObjcode(hex);
                        data = hex.toByteArray();
                        if (alfData != null) {
                            Hex alfHex = new Hex(alfData);
                            RemoteConfiguration.decryptObjcode(alfHex);
                            alfData = alfHex.toByteArray();
                            alfStart = this.upgradeData.get((Object)CommHID.blockNames[3]).address;
                            System.arraycopy(alfData, 0, data, alfStart - firmwareAddress, alfData.length);
                            hex = new Hex(data);
                        }
                    }
                    if (alfData == null && this.upgradeData.get(blockNames[4]) != null) {
                        alfStart = this.upgradeData.get((Object)CommHID.blockNames[3]).address;
                        int alfEnd = this.upgradeData.get((Object)CommHID.blockNames[4]).address;
                        alfData = Arrays.copyOfRange(data, alfStart - firmwareAddress, alfEnd - firmwareAddress);
                    }
                    int pos = 0;
                    while (pos < firmwareSize + this.externalFlashSize) {
                        Hex calc2;
                        if (pos == this.E2address - firmwareAddress) {
                            pos += this.E2size;
                            continue;
                        }
                        int len = this.intFromHex(hex, pos + 2, false);
                        short sum2 = 0;
                        stored = hex.subHex(pos, 2);
                        if (this.remoteType == RemoteType.AVL && pos == 0) {
                            sum2 = this.jp12ComputeCheckSum(data, pos + 2, 6144 - firmwareAddress - pos - 2);
                            pos += 6188 - firmwareAddress - 2;
                            len -= 6144 - firmwareAddress - 2;
                        }
                        if (!(calc2 = new Hex(new short[]{sum2 = (short)(sum2 ^ this.jp12ComputeCheckSum(data, pos + 2, len - 2)), (short)(~sum2 & 0xFF)})).equals(stored)) {
                            return false;
                        }
                        pos += len;
                    }
                    if (alfData != null && !(calc = new Hex(new short[]{sum = (short)this.jp12ComputeCheckSum(alfData, 2, alfData.length - 2), (short)(~sum & 0xFF)})).equals(stored = new Hex(Arrays.copyOf(alfData, 2)))) {
                        return false;
                    }
                }
                catch (Exception e) {
                    System.err.println("Error in firmware upgrade data");
                    return false;
                }
            }
            RMIRSetup.forceFDRAUpgradeItem.setSelected(false);
            if (upgNeeds[1] > 0) {
                try {
                    byte[] dataE2 = null;
                    boolean success = false;
                    int i = 0;
                    while (!(success = this.enterService() == 0) && i++ < 3 && this.waitForReconnection(7000)) {
                    }
                    System.err.println("Enter service on attempt " + (i + 1) + " : " + success);
                    if (!success) {
                        return false;
                    }
                    if (this.remoteType == RemoteType.DIGITAL) {
                        i = 0;
                        dataE2 = new byte[this.E2size];
                        while (!(success = this.readFDRAnoUpdate(this.E2address, dataE2, this.E2size) == this.E2size) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Read E2 on attempt " + (i + 1) + " : " + success);
                        if (!success) {
                            return false;
                        }
                        i = 0;
                        while (!(success = this.eraseFDRA(this.internalFlashSize, this.internalFlashSize + this.externalFlashSize - 1)) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Erase external flash on attempt " + (i + 1) + " : " + success);
                        if (!success) {
                            return false;
                        }
                        i = 0;
                        while (!(success = this.eraseFDRA(firmwareAddress, firmwareAddress + firmwareSize - 1)) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Erase MCU firmware on attempt " + (i + 1) + " : " + success);
                    } else {
                        while (!(success = this.eraseFDRA(firmwareAddress, 6143)) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Erase MCU lower firmware on attempt " + (i + 1) + " : " + success);
                        if (!success) {
                            return false;
                        }
                        i = 0;
                        while (!(success = this.eraseFDRA(6188, firmwareAddress + firmwareSize - 1)) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Erase MCU upper firmware on attempt " + (i + 1) + " : " + success);
                    }
                    if (!success) {
                        return false;
                    }
                    byte[] dataFirmware = new byte[firmwareSize];
                    System.arraycopy(data, 0, dataFirmware, 0, firmwareSize);
                    i = 0;
                    while (!(success = this.writeFDRA(firmwareAddress, dataFirmware, firmwareSize, false) == firmwareSize) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                    }
                    System.err.println("Write MCU firmware on attempt " + (i + 1) + " : " + success);
                    if (!success) {
                        return false;
                    }
                    if (this.remoteType == RemoteType.DIGITAL) {
                        byte[] dataExtFlash = new byte[this.externalFlashSize];
                        System.arraycopy(data, this.internalFlashSize - firmwareAddress, dataExtFlash, 0, this.externalFlashSize);
                        i = 0;
                        while (!(success = this.writeFDRA(this.internalFlashSize, dataExtFlash, this.externalFlashSize, false) == this.externalFlashSize) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Write external flash on attempt " + (i + 1) + " : " + success);
                        if (!success) {
                            return false;
                        }
                        i = 0;
                        while (!(success = this.writeFDRA(this.E2address, dataE2, this.E2size, false) == this.E2size) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                        }
                        System.err.println("Write E2 on attempt " + (i + 1) + " : " + success);
                        if (!success) {
                            return false;
                        }
                    } else {
                        this.setProgressName("COMPLETING UPGRADE:");
                        if (this.progressUpdater != null) {
                            this.progressUpdater.updateProgress(0);
                        }
                        for (i = 0; i < 90; ++i) {
                            this.waitForMillis(200, true);
                            if (this.progressUpdater == null) continue;
                            this.progressUpdater.updateProgress((int)((double)(i + 1) / 90.0 * 100.0));
                        }
                    }
                    i = 0;
                    while (!(success = this.exitBootstrap() == 0 && this.waitForReconnection(7000)) && i++ < 3) {
                    }
                    System.err.println("Exit upgrade on attempt " + (i + 1) + " : " + success);
                    this.reopenFDRARemote();
                    if (!success) {
                        return false;
                    }
                    break block52;
                }
                catch (Exception e) {
                    System.err.println("Firmware upgrade error");
                    return false;
                }
            }
            if (!changed.isEmpty() && changed.get(0).startsWith("alf") && alfData != null) {
                boolean success = false;
                int i = 0;
                while (!(success = this.enterService() == 0) && i++ < 3 && this.waitForReconnection(7000)) {
                }
                System.err.println("Enter service on attempt " + (i + 1) + " : " + success);
                if (!success) {
                    return false;
                }
                i = 0;
                while (!(success = this.eraseFDRA(alfStart, alfStart + alfData.length - 1)) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                }
                System.err.println("Erase ALF block on attempt " + (i + 1) + " : " + success);
                if (!success) {
                    return false;
                }
                i = 0;
                while (!(success = this.writeFDRA(alfStart, alfData, alfData.length, false) == alfData.length) && i++ < 3 && this.waitForReconnection(7000) && this.enterService() == 0) {
                }
                System.err.println("Write ALF block on attempt " + (i + 1) + " : " + success);
                if (!success) {
                    return false;
                }
                i = 0;
                while (!(success = this.exitBootstrap() == 0 && this.waitForReconnection(7000)) && i++ < 3) {
                }
                System.err.println("Exit upgrade on attempt " + (i + 1) + " : " + success);
                this.reopenFDRARemote();
                if (!success) {
                    return false;
                }
            }
        }
        return true;
    }

    private int getEndPKG(int fileStart, byte[] buffer) {
        int pos = fileStart;
        int numIcons = (buffer[pos + 12] & 0xFF) + 256 * (buffer[pos + 13] & 0xFF);
        int numEntries = (buffer[pos + 14] & 0xFF) + 256 * (buffer[pos + 15] & 0xFF);
        int startIndex = (pos += 16) + 28 * numIcons;
        int iconEnd = 16 + 28 * numIcons + numEntries;
        for (int i = 0; i < numEntries; ++i) {
            int j = buffer[startIndex + i] & 0xFF;
            if (j == 0) continue;
            int k = pos + 28 * (j - 1);
            int width = (buffer[k + 8] & 0xFF) + 256 * (buffer[k + 9] & 0xFF);
            int height = (buffer[k + 10] & 0xFF) + 256 * (buffer[k + 11] & 0xFF);
            int start = (buffer[k + 16] & 0xFF) + 256 * (buffer[k + 17] & 0xFF) + 65536 * (buffer[k + 18] & 0xFF);
            int start2 = (buffer[k + 20] & 0xFF) + 256 * (buffer[k + 21] & 0xFF) + 65536 * (buffer[k + 22] & 0xFF);
            int excess = start2 == 0 ? 256 : 512;
            int baseSize = (buffer[k + 24] & 0xFF) + 256 * (buffer[k + 25] & 0xFF) - excess;
            int pixSize = height * width;
            int byteWidth = baseSize / pixSize;
            int bufferSize = pixSize * byteWidth;
            iconEnd = start2 == (start += bufferSize) ? start + pixSize : start;
        }
        return fileStart + iconEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getEndBXML(int fileStart, byte[] buffer) {
        int pos = fileStart;
        int itemsLength = buffer[pos + 14] & 0xFF | (buffer[pos + 15] & 0xFF) << 8;
        pos += 17 + itemsLength;
        ArrayList<Integer> tags = new ArrayList<Integer>();
        while (true) {
            int tag;
            if (((tag = buffer[pos++] & 0xFF) & 0x80) == 0) {
                tags.add(0, tag);
                pos += (buffer[pos] & 0xFF) + 1;
                continue;
            }
            int last = (Integer)tags.remove(0);
            if (tag != (last | 0x80)) {
                System.err.println("XCF file nesting error at " + Integer.toHexString(pos - 1));
                return pos;
            }
            if (tags.isEmpty()) return pos;
        }
    }

    private int ssdInCheck() {
        boolean res = this.ssdIn[0] == 1 && this.ssdIn[1] == 0;
        for (int i = 3; i < 62; ++i) {
            res &= this.ssdIn[i] == 0;
        }
        if (!res) {
            System.err.println("Input packet failure: " + this.ssdIn[0] + "" + this.ssdIn[1] + "" + this.ssdIn[2] + "" + this.ssdIn[3] + "" + this.ssdIn[4] + "" + this.ssdIn[5]);
            return -1;
        }
        return this.ssdIn[2];
    }

    int writeXZITE(byte[] buffer) {
        if (RemoteMaster.admin) {
            System.err.println("Write dialog starts:");
        }
        this.setProgressName("PREPARING TO UPLOAD");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        int mask = 4095;
        int total = Remote.userFilenames.length;
        for (int index = 0; index < total; ++index) {
            String name;
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress((int)((double)(index + 1) / (double)total * 100.0));
            }
            if ((name = Remote.userFilenames[index]).equalsIgnoreCase("SysIcons.pkg")) {
                mask ^= 1 << index;
                continue;
            }
            System.err.println("Deleting file " + name);
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 21;
            this.ssdOut[2] = (byte)name.length();
            for (int i = 0; i < name.length(); ++i) {
                this.ssdOut[4 + i] = (byte)name.charAt(i);
            }
            this.writeXZITEUSBReport(this.ssdOut, 62);
            int check = -1;
            if (this.readXZITEUSBReport(this.ssdIn) < 0 || (check = this.ssdInCheck()) < 0 || (check & 0xEF) != 0) {
                System.err.println("Deletion failed.  Aborting upload");
                return 0;
            }
            System.err.println(check == 0 ? "  File present and deleted" : "  File absent");
        }
        int status = (buffer[0] & 0xFF | (buffer[1] & 0xF) << 8) & mask;
        int dataEnd = buffer[2] & 0xFF | (buffer[3] & 0xFF) << 8 | (buffer[1] & 0xF0) << 12;
        int pos = 4;
        int index = -1;
        this.setProgressName("UPLOADING:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        while (pos < dataEnd) {
            boolean success;
            while (index < 12 && (status & 1 << ++index) == 0) {
            }
            if (index == 12) break;
            String name = Remote.userFilenames[index];
            System.err.println("Sending file " + name);
            int count = 0;
            int end = name.endsWith(".xcf") ? this.getEndBXML(pos, buffer) : this.getEndPKG(pos, buffer);
            System.err.println("File start: " + Integer.toHexString(pos) + ", end: " + Integer.toHexString(end));
            int len = end - pos;
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 19;
            this.ssdOut[2] = (byte)(len & 0xFF);
            this.ssdOut[3] = (byte)(len >> 8 & 0xFF);
            this.ssdOut[6] = (byte)name.length();
            for (int i = 0; i < name.length(); ++i) {
                this.ssdOut[7 + i] = (byte)name.charAt(i);
            }
            int written = this.writeXZITEUSBReport(this.ssdOut, 62);
            System.err.println("File header packet sent");
            int read = this.readXZITEUSBReport(this.ssdIn, 5000);
            boolean bl = success = written == 65 && read == 64 && this.ssdInCheck() == 0;
            if (!success) {
                System.err.println("Error: File header packet failed");
                return 0;
            }
            while (pos < end) {
                int size = Math.min(end - pos, 56);
                Arrays.fill(this.ssdOut, (byte)0);
                this.ssdOut[0] = 20;
                this.ssdOut[2] = (byte)(count & 0xFF);
                this.ssdOut[3] = (byte)(count >> 8 & 0xFF);
                this.ssdOut[4] = (byte)size;
                System.arraycopy(buffer, pos, this.ssdOut, 6, size);
                if (!this.writeXZITEBufferOut()) {
                    System.err.println("Error: terminating at hex position " + Integer.toHexString(pos));
                    return pos;
                }
                pos += size;
                ++count;
                if (this.progressUpdater == null) continue;
                this.progressUpdater.updateProgress((int)((double)(pos + 1) / (double)dataEnd * 100.0));
            }
        }
        if (RemoteMaster.admin) {
            System.err.println("Write dialog ends");
        }
        return buffer.length;
    }

    public boolean writeSystemFiles(File sysFile, List<String> names, int type) {
        String typeName;
        byte[] data = null;
        String string = type == 1 ? "UPDATING CHANGED FILES:" : (type == 2 ? "WRITING NEW FILES:" : (typeName = type == 3 ? "REBUILDING FILE SYSTEM:" : "UNKNOWN:"));
        if (type > 0 && !names.isEmpty()) {
            this.setProgressName(typeName);
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(0);
            }
        }
        try {
            ZipFile zipfile = new ZipFile(sysFile);
            int total = names.size();
            int count = 0;
            for (String name : names) {
                String zName = this.upgradeData.get((Object)name.toUpperCase()).zName;
                ZipEntry entry = zipfile.getEntry(zName);
                int length = (int)entry.getSize();
                if (length < 0) {
                    System.err.println("File " + name + " has unknown length and could not be updated");
                    this.upgradeSuccess = false;
                    continue;
                }
                InputStream zip = zipfile.getInputStream(entry);
                data = RMIRSetup.readBinary(zip, length);
                Hex hex = new Hex(data);
                RemoteConfiguration.decryptObjcode(hex);
                data = hex.toByteArray();
                System.err.println("Writing file " + name + " to remote");
                if (!this.writeSystemFile(name, data)) {
                    System.err.println("Failed to write system file " + name);
                    this.upgradeSuccess = false;
                }
                ++count;
                if (type <= 0 || this.progressUpdater == null) continue;
                this.progressUpdater.updateProgress((int)((double)count / (double)total * 100.0));
            }
            if (zipfile != null) {
                zipfile.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error in writing system support files");
            return false;
        }
        return true;
    }

    public boolean deleteSystemFiles(List<String> forDeletion) {
        boolean result = true;
        for (String name : forDeletion) {
            System.err.println("Deleting system file " + name);
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 21;
            this.ssdOut[2] = (byte)name.length();
            for (int i = 0; i < name.length(); ++i) {
                this.ssdOut[4 + i] = (byte)name.charAt(i);
            }
            this.writeXZITEUSBReport(this.ssdOut, 62);
            int check = -1;
            if (this.readXZITEUSBReport(this.ssdIn) < 0 || (check = this.ssdInCheck()) < 0 || (check & 0xEF) != 0) {
                System.err.println("  Deletion of file " + name + " failed");
                result = false;
            }
            System.err.println("  File " + name + (check == 0 ? " present and deleted" : " absent"));
        }
        return result;
    }

    public boolean writeSystemFile(String name, byte[] data) {
        boolean success;
        if (data == null) {
            System.err.println("Write System File aborting.  No data available for file " + name);
            return false;
        }
        int len = data.length;
        int pos = 0;
        int count = 0;
        Arrays.fill(this.ssdOut, (byte)0);
        this.ssdOut[0] = 19;
        this.ssdOut[2] = (byte)(len & 0xFF);
        this.ssdOut[3] = (byte)(len >> 8 & 0xFF);
        this.ssdOut[4] = (byte)(len >> 16 & 0xFF);
        this.ssdOut[6] = (byte)name.length();
        for (int i = 0; i < name.length(); ++i) {
            this.ssdOut[7 + i] = (byte)name.charAt(i);
        }
        int written = this.writeXZITEUSBReport(this.ssdOut, 62);
        System.err.println("File header packet sent");
        int read = this.readXZITEUSBReport(this.ssdIn, 5000);
        boolean bl = success = written == 65 && read == 64 && this.ssdInCheck() == 0;
        if (!success) {
            System.err.println("Error: File header packet failed");
            return false;
        }
        while (pos < len) {
            if (this.ssdInCheck() < 0) {
                System.err.println("Error: Write of file " + name + " terminating at hex position " + Integer.toHexString(pos));
                return false;
            }
            int size = Math.min(len - pos, 56);
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 20;
            this.ssdOut[2] = (byte)(count & 0xFF);
            this.ssdOut[3] = (byte)(count >> 8 & 0xFF);
            this.ssdOut[4] = (byte)size;
            System.arraycopy(data, pos, this.ssdOut, 6, size);
            if (!this.writeXZITEBufferOut()) {
                System.err.println("Error: terminating at hex position " + Integer.toHexString(pos));
                return false;
            }
            pos += size;
            ++count;
        }
        System.err.println("Bytes written to " + name + ": " + pos);
        return true;
    }

    private boolean writeXZITEFirmwareFile(byte[] data) {
        if (data == null) {
            System.err.println("Write Firmware File aborting.  No data available.");
            return false;
        }
        RMIRSetup.forceUpgradeItem.setSelected(false);
        int len = data.length - 8;
        int pos = 0;
        int count = 0;
        Arrays.fill(this.ssdOut, (byte)0);
        this.ssdOut[0] = 33;
        this.ssdOut[2] = (byte)(len & 0xFF);
        this.ssdOut[3] = (byte)(len >> 8 & 0xFF);
        this.ssdOut[4] = (byte)(len >> 16 & 0xFF);
        this.ssdOut[5] = (byte)(len >> 24 & 0xFF);
        int n = 0;
        boolean success = false;
        while (n < 2) {
            this.setProgressName("WRITING NEW FIRMWARE:");
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(0);
            }
            long waitStart = Calendar.getInstance().getTimeInMillis();
            for (int i = 0; i < 4; ++i) {
                int written = this.writeXZITEUSBReport(this.ssdOut, 62);
                System.err.println("Firmware header packet " + (i + 1) + " sent");
                int read = this.readXZITEUSBReport(this.ssdIn, 5000);
                long delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                System.err.println("Response to header " + (i + 1) + " received after wait of " + delay + "ms");
                if (written != 65 || read != 64 || this.ssdIn[2] != 0) continue;
                success = true;
                break;
            }
            if (success) break;
            if (++n >= 2) continue;
            String title = "Writing updated firmware";
            String message = "Please disconnect the USB cable from the remote,\nconnect it again and then press OK to continue";
            JOptionPane.showMessageDialog(null, message, title, 1);
            this.waitForReconnection();
        }
        if (!success) {
            System.err.println("Error: Firmware header packet failed");
            return false;
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(20);
        }
        while (pos < len) {
            int size = Math.min(len - pos, 56);
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 34;
            this.ssdOut[2] = (byte)(count & 0xFF);
            this.ssdOut[3] = (byte)(count >> 8 & 0xFF);
            this.ssdOut[5] = (byte)size;
            System.arraycopy(data, pos + 8, this.ssdOut, 6, size);
            if (!this.writeXZITEBufferOut()) {
                System.err.println("Error: Write of firmware terminating at hex position " + Integer.toHexString(pos));
                return false;
            }
            pos += size;
            ++count;
            if (this.progressUpdater == null) continue;
            this.progressUpdater.updateProgress(20 + (int)((double)pos / (double)len * 80.0));
        }
        System.err.println("Bytes written to firmware: " + pos);
        return true;
    }

    boolean waitForMillis(int waitTime) {
        return this.waitForMillis(waitTime, false);
    }

    boolean waitForMillis(int waitTime, boolean quiet) {
        if (!quiet) {
            System.err.println("Waiting for " + waitTime + "ms");
        }
        long waitStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        while (delay < (long)waitTime) {
            delay = Calendar.getInstance().getTimeInMillis() - waitStart;
        }
        return true;
    }

    boolean waitForReconnection() {
        return this.waitForReconnection(2000);
    }

    public String[] getRegistryKey() {
        return new String[]{"HKEY_LOCAL_MACHINE", "SYSTEM", "CurrentControlSet", "Enum", "USB", "VID_06E7&PID_" + String.format("%04X", this.thisPID), this.deviceID, "Device Parameters"};
    }

    public static String displayRegistryKey() {
        StringBuilder sb = new StringBuilder();
        String spaces = "";
        for (String s : lastRegistryKey) {
            if (!spaces.isEmpty()) {
                sb.append("\n");
                sb.append(spaces);
            }
            sb.append(s);
            spaces = spaces + "  ";
        }
        return sb.toString();
    }

    public static Response setEnhancedPowerManagementEnabled(boolean status) {
        if (lastRegistryKey == null) {
            return null;
        }
        Response response = new Response();
        try {
            StringBuilder sb = new StringBuilder();
            int n = 0;
            for (String s : lastRegistryKey) {
                if (n++ > 0) {
                    sb.append("\\");
                }
                sb.append(s);
            }
            String key = sb.toString();
            Object[] cmd = new String[]{"reg", "add", key, "/v", "EnhancedPowerManagementEnabled", "/t", "REG_DWORD", "/d", status ? "1" : "0", "/f"};
            System.err.println("Setting Enhanced Power Management status with command array:");
            System.err.println("  " + Arrays.toString(cmd));
            Process process = Runtime.getRuntime().exec((String[])cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            process.waitFor();
            String line = null;
            int count = 0;
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (count > 0) {
                    sb.append("\n");
                }
                sb.append(line);
                if (++count <= 5) continue;
            }
            response.output = sb.toString();
            reader.close();
            count = 0;
            sb = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                if (count > 0) {
                    sb.append("\n");
                }
                sb.append(line);
                if (++count <= 5) continue;
            }
            response.error = sb.toString();
            if (response.error.trim().isEmpty()) {
                response.error = null;
            }
            errorReader.close();
        }
        catch (Exception e) {
            response.output = null;
            response.error = e.getMessage();
        }
        return response;
    }

    private String getFDRAlangFile() {
        Integer langCode = RMIRSetup.getUpgradeLanguage().code;
        if (langCode == null) {
            langCode = this.firmwareFileVersions.get(blockNames[3]).getData()[3] - 48;
        }
        return "alf" + langCode + ".img";
    }

    int[] testForUpgrade(List<String> changed, List<String> newFiles) {
        changed.clear();
        newFiles.clear();
        if (this.forceUpgrade) {
            if (this.remoteType == RemoteType.XZITE) {
                changed.addAll(Arrays.asList("lang.en", "lang.fr", "lang.ge", "lang.it", "lang.sp", "lang.no", "lang.se", "Splash.xmg"));
                newFiles.addAll(Arrays.asList("lang.dk", "lang.fi", "lang.nl"));
            }
            return new int[]{1, 1, 1};
        }
        int[] out = new int[]{0, 0, 0};
        int upgradeType = 0;
        ArrayList<String> fwNames = new ArrayList<String>();
        for (String name : this.firmwareFileVersions.keySet()) {
            fwNames.add(name.toUpperCase());
            if (name.equalsIgnoreCase("BlasterFirmware")) continue;
            Hex currentVersion = this.firmwareFileVersions.get(name);
            String fdName = name;
            int currentOffset = 2;
            int[] testOrder = new int[]{0, 1, 2, 3, 4, 5};
            if (this.remoteType == RemoteType.XZITE) {
                fdName = name.toUpperCase();
                testOrder = new int[]{3, 2, 1, 0};
            } else {
                currentOffset = 0;
                if (name.equals(blockNames[3])) {
                    String langFile;
                    name = fdName = (langFile = this.getFDRAlangFile());
                    if (this.upgradeData.get(langFile) == null) {
                        int appImgLangCode = this.upgradeData.get((Object)CommHID.blockNames[3]).version.getData()[3] - 48;
                        String defaultFile = "alf" + appImgLangCode + ".img";
                        newFiles.add(defaultFile);
                        out[0] = 1;
                        upgradeType = upgradeType >= 0 ? 1 : -2;
                        continue;
                    }
                    changed.add(langFile);
                    int currentLangCode = this.firmwareFileVersions.get(blockNames[3]).getData()[3] - 48;
                    String currentLangFile = "alf" + currentLangCode + ".img";
                    if (!langFile.equals(currentLangFile)) {
                        out[0] = 1;
                        upgradeType = upgradeType >= 0 ? 1 : -2;
                        continue;
                    }
                }
            }
            FileData fd = this.upgradeData.get(fdName);
            if (fd == null) {
                System.err.println("File " + name + " missing from upgrade data and so will\nbe retained unchanged");
                continue;
            }
            Hex upgradeVersion = fd.version;
            int diff = 0;
            for (int i : testOrder) {
                diff = upgradeVersion.getData()[i] - currentVersion.getData()[i + currentOffset];
                if (diff == 0) continue;
                out[0] = 1;
                if (name.equalsIgnoreCase("MCUFirmware") || this.remoteType != RemoteType.XZITE && !name.startsWith("alf")) {
                    out[1] = 1;
                    break;
                }
                changed.add(name);
                break;
            }
            if (diff == 0) continue;
            upgradeType = diff > 0 && upgradeType >= 0 ? 1 : (diff > 0 && upgradeType < 0 ? -2 : (diff < 0 && upgradeType > 0 ? -2 : (diff < 0 && upgradeType > -2 ? -1 : -2)));
        }
        if (this.remoteType == RemoteType.XZITE) {
            for (String name : this.sysNames) {
                FileData fd = null;
                if (fwNames.contains(name.toUpperCase()) || name.indexOf(46) <= 0 || (fd = this.upgradeData.get(name.toUpperCase())) == null || fd.versionNum <= 0L) continue;
                newFiles.add(name);
                out[0] = 1;
                upgradeType = upgradeType >= 0 ? 1 : -2;
            }
        }
        out[2] = upgradeType;
        return out;
    }

    int readXZITE(byte[] buffer) {
        int ndx;
        int status = 0;
        this.setProgressName(this.getUse() == RMIRSetup.Use.DOWNLOAD ? "DOWNLOADING:" : "VERIFYING UPLOAD:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        System.err.println();
        System.err.println("User file length data:");
        for (String name : Remote.userFilenames) {
            Arrays.fill(this.ssdOut, (byte)0);
            this.ssdOut[0] = 25;
            this.ssdOut[2] = (byte)name.length();
            for (int i = 0; i < name.length(); ++i) {
                this.ssdOut[4 + i] = (byte)name.charAt(i);
            }
            this.writeXZITEUSBReport(this.ssdOut, 62);
            if (this.readXZITEUSBReport(this.ssdIn) < 0) {
                System.err.println("Length of file " + name + " is unavailable");
                return 0;
            }
            Hex hex = new Hex(8);
            for (int i = 0; i < 8; ++i) {
                hex.set(this.ssdIn[i], i);
            }
            System.err.println("  " + name + ((this.ssdIn[2] & 0x10) == 16 ? " (absent):" : ":") + hex);
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(10);
        }
        this.runningTotal = ndx = 4;
        if (RemoteMaster.admin) {
            System.err.println("Read user files:");
        }
        int total = Remote.userFilenames.length;
        for (int n = 0; n < total; ++n) {
            String name;
            name = Remote.userFilenames[n];
            byte[] data = this.readXZITEFileBytes(name, false);
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(10 + (int)((double)(n + 1) / (double)total * 90.0));
            }
            if (data == null) {
                return ndx - 4;
            }
            int len = data.length;
            if (len == 0) continue;
            if (ndx + len < buffer.length) {
                status |= 1 << n;
                System.arraycopy(data, 0, buffer, ndx, len);
                ndx += len;
                continue;
            }
            System.err.println("RDF EEPROM size not large enough to hold the data of this remote");
            return ndx - 4;
        }
        Arrays.fill(buffer, ndx, buffer.length, (byte)-1);
        buffer[0] = (byte)(status & 0xFF);
        buffer[1] = (byte)(status >> 8 & 0xF | ndx >> 12 & 0xF0);
        buffer[2] = (byte)(ndx & 0xFF);
        buffer[3] = (byte)(ndx >> 8 & 0xFF);
        if (RMIRSetup.getSystemFiles()) {
            this.readSystemFiles();
        }
        if (RemoteMaster.admin) {
            System.err.println("Read dialog ends");
        }
        return buffer.length;
    }

    public short[] readXZITEFile(String name) {
        this.runningTotal = 0;
        byte[] bBuffer = this.readXZITEFileBytes(name, false);
        if (bBuffer == null) {
            return null;
        }
        short[] sBuffer = new short[bBuffer.length];
        for (int i = 0; i < bBuffer.length; ++i) {
            sBuffer[i] = (short)(bBuffer[i] & 0xFF);
        }
        return sBuffer;
    }

    public byte[] readXZITEFileBytes(String name, boolean sizeOnly) {
        int attempt = 0;
        byte[] result = null;
        while (result == null && attempt++ < 4) {
            result = this.readXZITEFileBytesOnce(name, sizeOnly);
        }
        if (attempt > 1 && result != null) {
            System.err.println("File " + name + " took " + attempt + " attempts to read");
        }
        return result;
    }

    private byte[] readXZITEFileBytesOnce(String name, boolean sizeOnly) {
        boolean needsAckDelay = LibraryLoader.getLibraryFolderName().equals("Linux-arm");
        Arrays.fill(this.ssdOut, (byte)0);
        this.ssdOut[0] = (byte)(sizeOnly ? 25 : 18);
        this.ssdOut[2] = (byte)name.length();
        int offset = sizeOnly ? 4 : 3;
        for (int i = 0; i < name.length(); ++i) {
            this.ssdOut[offset + i] = (byte)name.charAt(i);
        }
        this.writeXZITEUSBReport(this.ssdOut, 62);
        if (this.readXZITEUSBReport(this.ssdIn) < 0) {
            System.err.println("Unable to read file \"" + name + "\"");
            return null;
        }
        if ((this.ssdIn[2] & 0x10) == 16) {
            System.err.println("File " + name + " is absent");
            return new byte[0];
        }
        if (sizeOnly) {
            byte[] sizeData = new byte[4];
            System.arraycopy(this.ssdIn, 3, sizeData, 0, 4);
            return sizeData;
        }
        int count = (this.ssdIn[3] & 0xFF) + 256 * (this.ssdIn[4] & 0xFF) + 65536 * (this.ssdIn[5] & 0xFF);
        int total = 0;
        this.ssdOut[0] = 1;
        this.ssdOut[2] = 0;
        int ndx = 0;
        byte[] buffer = new byte[count];
        byte packetID = 0;
        while (total < count) {
            if (this.readXZITEUSBReport(this.ssdIn) < 0) {
                System.err.println("Read error before end of file \"" + name + "\"");
                return null;
            }
            packetID = this.ssdIn[1];
            byte len = this.ssdIn[4];
            total += len;
            System.arraycopy(this.ssdIn, 6, buffer, ndx, len);
            ndx += len;
            this.ssdOut[1] = packetID;
            if (needsAckDelay) {
                this.waitForMillis(10);
            }
            this.writeXZITEUSBReport(this.ssdOut, 62);
        }
        if (this.runningTotal >= 0) {
            System.err.println("File " + name + " has reported length " + count + ", actual length " + total);
            System.err.println("  Start = " + Integer.toHexString(this.runningTotal) + ", end = " + Integer.toHexString(this.runningTotal + total - 1));
            this.runningTotal += total;
        }
        return buffer;
    }

    public byte[] readSystemFile(String name) {
        this.runningTotal = -1;
        return this.readXZITEFileBytes(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSystemFiles() {
        this.setProgressName("SAVING SYSTEM FILES:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        System.err.println();
        System.err.println("Saving system files to XSight subfolder of installation folder:");
        FileOutputStream output = null;
        ZipOutputStream zip = null;
        File outputDir = new File(RemoteMaster.getWorkDir(), "XSight");
        outputDir.mkdirs();
        boolean result = true;
        String zipName = RMIRSetup.getSystemZipName(this.remote);
        if (zipName == null) {
            return false;
        }
        try {
            output = new FileOutputStream(new File(outputDir, zipName), false);
            zip = new ZipOutputStream(output);
            int total = this.firmwareFileVersions.size();
            int count = 0;
            for (String name : this.firmwareFileVersions.keySet()) {
                if (name.indexOf(".") > 0) {
                    byte[] filedata = this.readSystemFile(name);
                    if (filedata == null || filedata.length == 0) continue;
                    System.err.println("  Saving " + name);
                    zip.putNextEntry(new ZipEntry(name));
                    zip.write(filedata);
                }
                ++count;
                if (this.progressUpdater == null) continue;
                this.progressUpdater.updateProgress((int)((double)count / (double)total * 100.0));
            }
        }
        catch (Exception e) {
            result = false;
            System.err.println(e);
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {}
        }
        String message = result ? "Firmware saved to " + zipName + " in XSight subfolder of \nthe RMIR installation folder" : "Firmware saving failed.  Download aborting.";
        String title = "Firmware operation";
        JOptionPane.showMessageDialog(null, message, title, 1);
        return result;
    }

    boolean getVersionsFromRemote(boolean getSerial) {
        this.firmwareFileVersions.clear();
        if (this.remoteType == RemoteType.DIGITAL || this.remoteType == RemoteType.AVL) {
            int limit = this.remoteType == RemoteType.AVL ? 3 : 7;
            for (int index = 0; index < limit; ++index) {
                if (index == 2) continue;
                Hex hex = this.getVersionFromFDRAremote(index);
                if (hex == null) {
                    return false;
                }
                this.firmwareFileVersions.put(blockNames[index], hex);
            }
            return true;
        }
        byte[] o = new byte[2];
        o[0] = 1;
        int count = this.writeXZITEUSBReport(new byte[]{4}, 1);
        System.err.println("Count of bytes written: " + count);
        count = this.readXZITEUSBReport(this.ssdIn);
        if (count < 0) {
            System.err.println("Read versions from remote failed to initiate, error code " + count);
            return false;
        }
        this.firmwareFileCount = this.ssdIn[3];
        System.err.println("Firmware file version data:");
        for (int i = 0; i < this.firmwareFileCount; ++i) {
            if (this.readXZITEUSBReport(this.ssdIn) < 0) {
                System.err.println("Read versions from remote failed on file " + (i + 1) + " of " + this.firmwareFileCount);
                return false;
            }
            this.saveXZITEVersionData();
            o[1] = this.ssdIn[1];
            this.writeXZITEUSBReport(o, 2);
        }
        if (!getSerial) {
            return true;
        }
        this.writeXZITEUSBReport(new byte[]{39}, 1);
        if (this.readXZITEUSBReport(this.ssdIn) < 0) {
            System.err.println("Reading of serial number failed");
            return false;
        }
        Hex serial = new Hex(6);
        for (int i = 0; i < serial.length(); ++i) {
            serial.set((short)(~this.ssdIn[i + 3] & 0xFF), i);
        }
        System.err.println("Hex serial number: " + serial);
        return true;
    }

    void saveXZITEVersionData() {
        boolean absent = true;
        Hex hex = new Hex(12);
        for (int i = 0; i < 12; ++i) {
            short b = (short)(this.ssdIn[i] & 0xFF);
            hex.set(b, i);
            if (i <= 1 || i >= 6 || b <= 0) continue;
            absent = false;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 12; i < this.ssdIn.length && this.ssdIn[i] != 0; ++i) {
            sb.append((char)this.ssdIn[i]);
        }
        String name = sb.toString();
        this.firmwareFileVersions.put(name, hex);
        System.err.println("  " + name + " : " + hex.toString() + (absent ? " (absent)" : ""));
    }

    @Override
    public int writeRemote(int address, byte[] buffer, int length) {
        int bytesWritten = -1;
        if (this.interfaceType == 6 || this.interfaceType == 262) {
            bytesWritten = this.writeFDRA(address, buffer, length, true);
        } else if (this.interfaceType == 513) {
            bytesWritten = this.writeXZITE(buffer);
        }
        return bytesWritten;
    }

    int readXZITEUSBReport(byte[] buffer) {
        return this.readXZITEUSBReport(buffer, 3000);
    }

    boolean writeXZITEBufferOut() {
        int n = 0;
        boolean success = false;
        do {
            int written;
            success = (written = this.writeXZITEUSBReport(this.ssdOut, 62)) == 65;
            int read = this.readXZITEUSBReport(this.ssdIn);
            if (read != 64) {
                success = false;
            }
            if (success && this.ssdIn[2] == 35) {
                this.waitForMillis(10);
                success = false;
                continue;
            }
            ++n;
        } while (!success && n < 5);
        if (this.ssdIn[2] != 0) {
            success = false;
        }
        return success;
    }

    String bytesToString(byte[] buffer) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (byte b : buffer) {
            sb.append(String.format(count++ > 0 ? " %02X" : "%02X", b & 0xFF));
        }
        return sb.toString();
    }

    int CalcCRC(byte[] inBuf, int start, int end) {
        int poly = 33800;
        int crc = 65535;
        for (int i = start; i <= end; ++i) {
            int byteVal = inBuf[i] & 0xFF;
            crc ^= byteVal;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) == 1) {
                    crc = crc >> 1 ^ poly;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }

    int CalcCRCofReport(byte[] inBuf) {
        return this.CalcCRC(inBuf, 1, 62);
    }

    public CommHID(String libraryName) throws UnsatisfiedLinkError {
        super(libraryName);
    }

    public CommHID(File folder, String libraryName) throws UnsatisfiedLinkError {
        super(folder, libraryName);
    }

    public static String convertName(String name, int offset, boolean to, boolean csv) {
        int pos = name.lastIndexOf(46);
        name = name.substring(0, pos);
        int len = name.length();
        char[] ca = new char[len];
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            int ndx = alphas.indexOf(c);
            int mod = alphas.length() - 1;
            int[] key = RemoteConfiguration.encryptionKey;
            int diff = key[(i + offset) % key.length];
            ndx = c == '.' || i == name.length() - 1 ? ndx : (to ? (ndx + diff) % mod : (ndx + 10 * mod - diff) % mod);
            ca[i] = alphas.charAt(ndx);
        }
        String str = String.valueOf(ca);
        return str + (!to && csv ? ".csv" : ".bin");
    }

    public static File convertZipFile(String inName, String outName, boolean to, boolean csv) {
        byte[] data = null;
        File zipOut = new File(RemoteMaster.getWorkDir(), "src");
        zipOut = new File(zipOut, "main");
        zipOut = new File(zipOut, "config");
        zipOut = new File(zipOut, outName);
        String nameIn = null;
        try {
            ZipFile zipIn = new ZipFile(new File(RemoteMaster.getWorkDir(), inName));
            ZipOutputStream streamOut = new ZipOutputStream(new FileOutputStream(zipOut));
            Enumeration<? extends ZipEntry> zipEnum = zipIn.entries();
            int i = 0;
            while (zipEnum.hasMoreElements()) {
                ZipEntry entryIn = zipEnum.nextElement();
                nameIn = entryIn.getName();
                String nameOut = CommHID.convertName(nameIn, i, to, csv);
                System.err.println(nameIn + ", index " + i);
                System.err.println(nameOut);
                ZipEntry entryOut = new ZipEntry(nameOut);
                streamOut.putNextEntry(entryOut);
                long length = entryIn.getSize();
                if (length < 0L) {
                    System.err.println("File " + nameIn + " has unknown length and could not be converted");
                    continue;
                }
                InputStream zip = zipIn.getInputStream(entryIn);
                data = RMIRSetup.readBinary(zip, (int)length);
                Hex hex = new Hex(data);
                RemoteConfiguration.decryptObjcode(hex);
                streamOut.write(hex.toByteArray());
                streamOut.closeEntry();
                ++i;
            }
            streamOut.close();
            zipIn.close();
        }
        catch (Exception e) {
            System.err.println("Zip conversion failed at " + nameIn);
        }
        return zipOut;
    }

    public static Hex getFirmwareFile(String signature) {
        block4: {
            try {
                ZipFile zipIn = new ZipFile(RemoteMaster.getRmpbSys());
                Enumeration<? extends ZipEntry> zipEnum = zipIn.entries();
                int i = 0;
                System.err.println("Reconverted names:");
                while (zipEnum.hasMoreElements()) {
                    ZipEntry entryIn = zipEnum.nextElement();
                    String nameIn = entryIn.getName();
                    String nameOut = CommHID.convertName(nameIn, i, false, true);
                    ++i;
                    if (!nameOut.startsWith(signature)) continue;
                    InputStream zip = zipIn.getInputStream(entryIn);
                    long length = entryIn.getSize();
                    if (length < 0L) {
                        System.err.println("File " + nameIn + " has unknown length and could not be converted");
                        return null;
                    }
                    byte[] data = RMIRSetup.readBinary(zip, (int)length);
                    Hex hex = new Hex(data);
                    RemoteConfiguration.decryptObjcode(hex);
                    return hex;
                }
            }
            catch (Exception e) {
                if (!RemoteMaster.admin) break block4;
                System.err.println("Unable to obtain firmware for signature " + signature);
            }
        }
        return null;
    }

    public static List<String> getCSVlines(Remote remote) {
        block5: {
            String signature = null;
            signature = remote.getOemSignatures() != null && !remote.getOemSignatures().isEmpty() ? remote.getOemSignatures().get(0) : (remote.getFirmwareSignature() != null ? remote.getFirmwareSignature() : remote.getSignature());
            try {
                ZipFile zipIn = new ZipFile(RemoteMaster.getRmduSys());
                Enumeration<? extends ZipEntry> zipEnum = zipIn.entries();
                int i = 0;
                while (zipEnum.hasMoreElements()) {
                    char delim;
                    ZipEntry entryIn = zipEnum.nextElement();
                    String nameIn = entryIn.getName();
                    String nameOut = CommHID.convertName(nameIn, i, false, true);
                    ++i;
                    if (!nameOut.startsWith(signature) || Character.digit(delim = nameOut.charAt(signature.length()), 10) >= 0) continue;
                    InputStream zip = zipIn.getInputStream(entryIn);
                    long length = entryIn.getSize();
                    if (length < 0L) {
                        System.err.println("File " + nameIn + " has unknown length and could not be converted");
                        return null;
                    }
                    byte[] data = RMIRSetup.readBinary(zip, (int)length);
                    Hex hex = new Hex(data);
                    RemoteConfiguration.decryptObjcode(hex);
                    StringBuilder sb = new StringBuilder(hex.length());
                    for (short n : hex.getData()) {
                        sb.append((char)n);
                    }
                    return Arrays.asList(sb.toString().split("\\R"));
                }
            }
            catch (Exception e) {
                if (!RemoteMaster.admin) break block5;
                System.err.println("Unable to create CSV file for remote " + remote.getName());
            }
        }
        return null;
    }

    public boolean setFileData(File sysFile) {
        ArrayList<String> ucSysNames = new ArrayList<String>();
        this.upgradeData.clear();
        for (String name : this.sysNames) {
            ucSysNames.add(name.toUpperCase());
        }
        try {
            if (sysFile.getName().endsWith(".sys")) {
                ZipFile zipIn = new ZipFile(sysFile);
                Enumeration<? extends ZipEntry> zipEnum = zipIn.entries();
                String prefix = CommHID.getPrefix(this.getRemoteSignature());
                int i = 0;
                while (zipEnum.hasMoreElements()) {
                    ZipEntry entryIn = zipEnum.nextElement();
                    String nameIn = entryIn.getName();
                    String nameOut = CommHID.convertName(nameIn, i, false, false);
                    ++i;
                    if (!nameOut.startsWith(prefix)) continue;
                    nameOut = nameOut.substring(prefix.length() + 1);
                    int pos = nameOut.lastIndexOf(95);
                    String versionStr = nameOut.substring(pos + 1, nameOut.length() - 4);
                    if (!ucSysNames.contains((nameOut = nameOut.substring(0, pos)).toUpperCase())) {
                        System.err.println("File " + nameOut + " in upgrade but not in sysNames");
                    }
                    if (nameOut.equals("alf.img")) {
                        nameOut = "alf" + versionStr.substring(3, 4) + ".img";
                    }
                    FileData fileData = new FileData();
                    fileData.zName = nameIn;
                    this.setFileVersion(fileData, versionStr);
                    this.upgradeData.put(nameOut, fileData);
                }
                zipIn.close();
            } else if (sysFile.getName().endsWith(".bin")) {
                FileData fileData = new FileData();
                String nameOut = sysFile.getName();
                int pos = nameOut.lastIndexOf(95);
                String versionStr = nameOut.substring(pos + 1, nameOut.length() - 4);
                this.setFileVersion(fileData, versionStr.substring(0, 6));
                this.upgradeData.put("app.img", fileData);
                if (versionStr.length() > 7) {
                    fileData = new FileData();
                    String aux = versionStr.substring(7);
                    versionStr = "500000".substring(0, 6 - aux.length()) + aux;
                    this.setFileVersion(fileData, versionStr.substring(0, 6));
                    nameOut = "alf" + versionStr.substring(3, 4) + ".img";
                    this.upgradeData.put(nameOut, fileData);
                }
            }
        }
        catch (Exception e) {
            System.err.println("File data creation failed");
            return false;
        }
        boolean ok = true;
        for (String name : ucSysNames) {
            if (this.remoteType != RemoteType.XZITE) {
                name = name.toLowerCase();
            }
            if (this.upgradeData.containsKey(name) || name.equals("alf.img")) continue;
            System.err.println("File " + name + " in sysNames but not in upgrade");
            if (name.equals("BLASTERFIRMWARE")) continue;
            ok = false;
        }
        return ok;
    }

    private void setFileVersion(FileData fileData, String versionStr) {
        long versionNum;
        fileData.versionNum = versionNum = Long.parseLong(versionStr);
        if (this.remoteType == RemoteType.XZITE) {
            short[] versionShort = new short[4];
            for (int k = 0; k < 4; ++k) {
                versionShort[k] = (short)(versionNum & 0xFFL);
                versionNum >>= 8;
            }
            fileData.version = new Hex(versionShort);
        } else {
            short[] versionShort = new short[6];
            for (int k = 0; k < 6; ++k) {
                versionShort[5 - k] = (short)(48L + versionNum % 10L);
                versionNum /= 10L;
            }
            fileData.version = new Hex(versionShort);
        }
    }

    public LinkedHashMap<String, FileData> getUpgradeData() {
        return this.upgradeData;
    }

    private int intFromHex(Hex hex, int offset, boolean littleEndian) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int ndx = littleEndian ? 3 - i : i;
            n = n << 8 | hex.getData()[offset + ndx];
        }
        return n;
    }

    private LinkedHashMap<String, FileData> setFileContentData(Hex appImg) {
        if (this.remoteType == RemoteType.XZITE) {
            return null;
        }
        LinkedHashMap<String, FileData> additions = new LinkedHashMap<String, FileData>();
        int sigOffset = this.intFromHex(appImg, 2, false);
        if (this.remoteType == RemoteType.AVL) {
            sigOffset += 44;
        }
        int numEntries = appImg.getData()[sigOffset + 42] & 0xFF;
        byte[] data = appImg.toByteArray();
        int start = this.addrFromBytes(data, sigOffset + 43);
        for (int i = 0; i < numEntries; ++i) {
            if (i == 2) continue;
            FileData fd = new FileData();
            int addr = this.addrFromBytes(data, sigOffset + 43 + i * this.addrSize);
            if (addr < 0) {
                addr = this.intFromHex(appImg, (addr & Integer.MAX_VALUE) - start, false);
            }
            fd.address = addr;
            fd.version = appImg.subHex(addr - start + 6, 6);
            additions.put(blockNames[i], fd);
            if (i != 3) continue;
            int appLangCode = fd.version.getData()[3] - 48;
            String appLangName = "alf" + appLangCode + ".img";
            if (this.upgradeData.containsKey(appLangName)) continue;
            additions.put(appLangName, fd);
        }
        return additions;
    }

    int verifyCRC(byte[] data, int offset) {
        int length = data.length;
        int crc = this.CalcCRC(data, offset, length - 3);
        if ((data[length - 1] & 0xFF) != (crc >> 8 & 0xFF) || (data[length - 2] & 0xFF) != (crc & 0xFF)) {
            crc |= Integer.MIN_VALUE;
        }
        return crc;
    }

    private boolean verifyFileVersions(File sysFile) {
        LinkedHashMap<String, FileData> additions = null;
        try {
            if (sysFile.getName().endsWith(".sys")) {
                ZipFile zipIn = new ZipFile(sysFile);
                for (String name : this.upgradeData.keySet()) {
                    FileData fd = this.upgradeData.get(name);
                    if (fd.zName == null) continue;
                    ZipEntry entry = zipIn.getEntry(fd.zName);
                    InputStream zip = zipIn.getInputStream(entry);
                    Hex fileVersion = null;
                    Hex hex = null;
                    if (this.remoteType == RemoteType.XZITE) {
                        byte[] data = RMIRSetup.readBinary(zip, 4, true);
                        fileVersion = new Hex(data);
                        RemoteConfiguration.decryptObjcode(fileVersion);
                    } else if (this.remoteType == RemoteType.DIGITAL || this.remoteType == RemoteType.AVL) {
                        int len = name.equals("app.img") ? (int)entry.getSize() : 12;
                        byte[] data = RMIRSetup.readBinary(zip, len, true);
                        hex = new Hex(data);
                        RemoteConfiguration.decryptObjcode(hex);
                        fileVersion = hex.subHex(6, 6);
                    }
                    if (!fileVersion.equals(fd.version)) {
                        zipIn.close();
                        return false;
                    }
                    if (!name.equals("app.img")) continue;
                    additions = this.setFileContentData(hex);
                }
                System.err.println("Upgrade file versions verified");
                zipIn.close();
            } else if (sysFile.getName().endsWith(".bin")) {
                FileInputStream fileIn = new FileInputStream(sysFile);
                int len = (int)sysFile.length();
                byte[] data = RMIRSetup.readBinary(fileIn, len, true);
                fileIn.close();
                Hex hex = new Hex(data);
                Hex fileVersion = hex.subHex(6, 6);
                FileData fd = this.upgradeData.get("app.img");
                if (!fileVersion.equals(fd.version)) {
                    return false;
                }
                additions = this.setFileContentData(hex);
                FileData alfFile = additions.get(blockNames[3]);
                FileData alfImg = null;
                for (String s : this.upgradeData.keySet()) {
                    if (!s.startsWith("alf")) continue;
                    alfImg = this.upgradeData.get(s);
                    break;
                }
                if (alfImg != null && !alfImg.version.equals(alfFile.version)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Upgrade file version error");
            return false;
        }
        if (additions != null) {
            this.upgradeData.putAll(additions);
        }
        System.err.println("Version numbers from upgrade:");
        for (String name : this.upgradeData.keySet()) {
            FileData fd = this.upgradeData.get(name);
            System.err.println("  " + fd.version + "  " + name);
        }
        return true;
    }

    private static String getPrefix(String signature) {
        int index = signature.equals("USB0007") ? 3 : Integer.parseInt(signature.substring(5));
        return prefixes[index - 1];
    }

    static enum RemoteType {
        AVL,
        DIGITAL,
        XZITE,
        UNKNOWN;

    }

    public class FileData {
        public String zName = null;
        public Hex version = null;
        public long versionNum = -1L;
        public int address = -1;
    }

    public static class Response {
        public String output = null;
        public String error = null;
    }
}

