/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.io.CommHID;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.swing.JOptionPane;
import org.hid4java.HidDevice;
import org.hid4java.HidServices;

public class CommHIDB
extends CommHID {
    List<HidDevice> attachedDevices = null;
    byte[] outReport = new byte[64];
    byte[] inReport = new byte[64];
    HidServices hidServices = null;
    HidDevice hidDevice = null;
    private static final String libraryName = "hidB";

    int getPIDofAttachedRemote() {
        this.hidServices = new HidServices();
        this.attachedDevices = this.hidServices.getAttachedHidDevices();
        for (HidDevice dev : this.attachedDevices) {
            if (this.hidDevice != null || dev.getVendorId() != 1767) continue;
            this.hidDevice = dev;
            break;
        }
        if (this.hidDevice != null) {
            String manString = this.hidDevice.getManufacturer();
            String prodString = this.hidDevice.getProduct();
            this.thisPID = this.hidDevice.getProductId();
            this.addrSize = (this.thisPID & 0x8000) == 0 ? 2 : 4;
            System.err.println("Remote found: Manufacturer = " + manString + ", Product = " + prodString + ", Product ID = " + String.format("%04X", this.thisPID));
            return this.thisPID;
        }
        System.err.println("No USB device found that is a UEI remote");
        return 0;
    }

    @Override
    boolean eraseFDRA(int startAddress, int endAddress) {
        if (startAddress > endAddress) {
            return true;
        }
        byte[] cmdBuff = new byte[2 * this.addrSize + 4];
        this.assembleFDRAeraseCmd(startAddress, endAddress, cmdBuff);
        System.arraycopy(cmdBuff, 0, this.outReport, 0, cmdBuff.length);
        if (RemoteMaster.admin) {
            System.err.println(this.bytesToString(this.outReport).substring(2));
        }
        try {
            this.hidDevice.write(this.outReport, this.outReport.length, (byte)0);
        }
        catch (Exception e) {
            return false;
        }
        return this.readFDRAreport() && this.dataRead[2] == 0;
    }

    @Override
    boolean writeFDRAblock(int address, int addrSize, byte[] buffer, int blockLength) {
        byte[] cmdBuff = new byte[addrSize + 3];
        if (blockLength > 60 - addrSize) {
            return false;
        }
        int pkgLen = blockLength + addrSize + 2;
        cmdBuff[0] = (byte)(pkgLen >> 8);
        cmdBuff[1] = (byte)(pkgLen & 0xFF);
        cmdBuff[2] = 2;
        cmdBuff[3] = (byte)(address >> 24 & 0xFF);
        cmdBuff[4] = (byte)(address >> 16 & 0xFF);
        cmdBuff[addrSize + 1] = (byte)(address >> 8 & 0xFF);
        cmdBuff[addrSize + 2] = (byte)(address & 0xFF);
        System.arraycopy(cmdBuff, 0, this.outReport, 0, cmdBuff.length);
        System.arraycopy(buffer, 0, this.outReport, cmdBuff.length, blockLength);
        this.outReport[blockLength + cmdBuff.length] = this.jp12ComputeCheckSum(this.outReport, 0, blockLength + cmdBuff.length);
        if (RemoteMaster.admin) {
            System.err.println(this.bytesToString(this.outReport).substring(2));
        }
        try {
            this.hidDevice.write(this.outReport, this.outReport.length, (byte)0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    boolean writeFDRAcmdReport(byte[] cmdBuff) {
        if (RemoteMaster.admin) {
            System.err.println(this.bytesToString(cmdBuff));
        }
        try {
            this.hidDevice.write(cmdBuff, cmdBuff.length, (byte)0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    boolean readFDRAreport() {
        try {
            if (this.hidDevice.read(this.inReport, 15000) <= 0) {
                return false;
            }
            System.arraycopy(this.inReport, 0, this.dataRead, 0, 64);
            if (RemoteMaster.admin) {
                System.err.println("   " + this.bytesToString(this.inReport));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String openRemote(String portName) {
        this.setProgressName("PREPARING:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        this.isPortUpg = portName != null && portName.equalsIgnoreCase("UPG");
        try {
            List<Remote> remotes;
            if (this.hidDevice != null && this.hidDevice.isOpen()) {
                System.err.println("Closing current device");
                this.hidDevice.close();
                this.waitForMillis(200);
            }
            if (this.hidDevice != null) {
                if (this.hidDevice.open()) {
                    System.err.println("Open existing device succeeded");
                } else {
                    System.err.println("Open existing device failed");
                    this.hidDevice = null;
                }
            }
            if (this.hidDevice == null) {
                this.getPIDofAttachedRemote();
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(30);
                }
                if (this.hidDevice != null) {
                    System.err.println("Path of found device is: " + this.hidDevice.getPath());
                    if (this.hidDevice.open()) {
                        System.err.println("Open found device succeeded");
                    } else {
                        System.err.println("Open found device failed");
                        this.hidDevice = null;
                    }
                }
            }
            if (this.hidDevice == null) {
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(-1);
                }
                System.err.println("Failed to open remote");
                return "";
            }
            this.hidDevice.setNonBlocking(false);
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(50);
            }
            if ((remotes = RemoteManager.getRemoteManager().findRemoteBySignature(this.getRemoteSignature())).size() > 0) {
                this.remote = remotes.get(0);
            }
            if (this.remote != null) {
                File upgSource = RMIRSetup.getUpgradeSource();
                if (upgSource != null && !RMIRSetup.isValidUpgradeSource(upgSource, this.remote)) {
                    RMIRSetup.clearUpgradeSource();
                }
                if (this.thisPID == 7) {
                    this.interfaceType = 6;
                    this.remoteType = CommHID.RemoteType.AVL;
                    this.sysNames = avlSysNames;
                    this.internalFlashSize = 65536;
                    this.externalFlashSize = 0;
                    this.isAppInfo2 = true;
                    this.newAppInfo2 = true;
                } else if (this.thisPID >= 32769 && this.thisPID <= 32775 && this.thisPID != 32771) {
                    this.interfaceType = 513;
                    this.remoteType = CommHID.RemoteType.XZITE;
                    this.sysNames = xziteSysNames;
                } else if (this.thisPID == 32776 || this.thisPID == 32777 || this.thisPID == 32784 || this.thisPID == 32785) {
                    this.interfaceType = 262;
                    this.remoteType = CommHID.RemoteType.DIGITAL;
                    this.sysNames = digitalSysNames;
                    this.internalFlashSize = 131072;
                    this.externalFlashSize = 131072;
                }
            } else {
                this.E2address = 0;
                this.E2size = 1024;
                this.interfaceType = 16;
                this.remoteType = CommHID.RemoteType.UNKNOWN;
                return "HID";
            }
            if (this.interfaceType == 262 || this.interfaceType == 6) {
                if (this.interfaceType == 262 && portName != null && portName.equals("UPG")) {
                    return this.reopenFDRARemote() ? "UPG" : "";
                }
                this.reopenFDRARemote();
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress(70);
                }
                this.waitForMillis(200);
                if (this.interfaceType != 6 && this.getFDRAInfoAndSig() && this.E2address > 0) {
                    System.err.println("GetInfoAndSig succeeded.");
                } else {
                    if (this.interfaceType != 6) {
                        System.err.println("GetInfoAndSig failed.  Taking E2 data from RDF.");
                    }
                    this.E2address = this.remote.getBaseAddress();
                    this.E2size = this.remote.getEepromSize();
                }
            } else {
                this.E2address = 0;
                this.E2size = 524288;
            }
            if (this.interfaceType == 513 && portName != null && portName.equals("UPG")) {
                return "UPG";
            }
        }
        catch (Exception e) {
            return "";
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(100);
        }
        return "HID";
    }

    @Override
    public void closeRemote() {
        try {
            this.hidDevice.close();
            System.err.println("closeRemote() succeeded");
        }
        catch (Exception e) {
            System.err.println("closeRemote() failed");
        }
    }

    @Override
    Hex getVersionFromFDRAremote(int index) {
        if (!this.isAppInfo2 || !this.newAppInfo2) {
            return null;
        }
        byte[] cmdBuff = new byte[]{0, 3, 83, (byte)index, (byte)(0x50 ^ index)};
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            return null;
        }
        if (!this.readFDRAreport() || this.dataRead[0] != 0) {
            return null;
        }
        Hex hex = new Hex(6);
        for (int i = 0; i < 6; ++i) {
            hex.set((short)(this.inReport[i + 3] & 0xFF), i);
        }
        return hex;
    }

    @Override
    int readFDRAchunk(int address, int delta, byte[] buffer, int length, int total) {
        System.err.println();
        System.err.println("Starting FDRA read of $" + Integer.toHexString(length).toUpperCase() + " bytes at $" + String.format("%05X", address += delta));
        byte[] cmdBuff = new byte[10];
        this.assembleFDRAreadAddress(address, this.addrSize, length, cmdBuff);
        int numToRead = length + 4;
        if (!this.writeFDRAcmdReport(cmdBuff)) {
            System.err.println("Failed to initiate FDRA read");
            return -1;
        }
        Arrays.fill(buffer, (byte)0);
        int numReports = 1 + numToRead / 64;
        int dataIdx = 0;
        int totalRead = 0;
        int reportOffset = 3;
        boolean success = true;
        for (int i = 0; i < numReports; ++i) {
            try {
                Arrays.fill(this.inReport, (byte)-1);
                int timeout = this.remoteType == CommHID.RemoteType.UNKNOWN ? 200 : 3000;
                int numRead = this.hidDevice.read(this.inReport, timeout);
                if (RemoteMaster.admin) {
                    System.err.println("   " + this.bytesToString(this.inReport));
                }
                if (numRead == 0) {
                    System.err.println("Read attempt timed out for FDRA report " + (i + 1) + " of " + numReports);
                    success = false;
                    break;
                }
                if (numRead != 64) {
                    System.err.println("Incomplete read of FDRA report " + (i + 1) + " of " + numReports + ", " + numRead + " bytes of 64 read");
                    success = false;
                } else if (i == 0 && this.inReport[2] != 0) {
                    System.err.println("Read of $" + Integer.toHexString(length).toUpperCase() + " bytes at $" + String.format("%05X", address) + " returned error code " + this.inReport[2] + "; full error report is:");
                    int size = this.inReport.length;
                    short[] e2Data = new short[size];
                    for (int j = 0; j < size; ++j) {
                        e2Data[j] = (short)(this.inReport[j] & 0xFF);
                    }
                    System.err.println(Hex.toString(e2Data, 32));
                    success = false;
                }
                System.arraycopy(this.inReport, reportOffset, buffer, dataIdx, Math.min(length - dataIdx, 64 - reportOffset));
                totalRead += numRead;
            }
            catch (Exception e) {
                System.err.println("Failed at read of FDRA report " + i + " of " + numReports);
                return -1;
            }
            reportOffset = 0;
            int progress = Math.min(dataIdx += 64 - reportOffset, length);
            if (this.progressUpdater == null) continue;
            this.progressUpdater.updateProgress((int)((double)(delta + progress) / (double)total * 100.0));
        }
        return success ? length : totalRead - 3;
    }

    @Override
    boolean waitForReconnection(int wait) {
        this.powerStatus = -1;
        this.setProgressName("WAITING FOR RECONNECTION:");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(0);
        }
        long delay = 0L;
        if (this.hidDevice != null) {
            this.hidDevice.close();
        }
        this.hidDevice = null;
        this.waitForMillis(wait);
        int n = 0;
        long timeOut = 60000L;
        block0: while (!(n & true)) {
            long waitStart = Calendar.getInstance().getTimeInMillis();
            while (this.hidDevice == null) {
                delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                if (delay > timeOut) {
                    if (n < 2) {
                        String title = "Reconnection";
                        String message = "Please disconnect the USB cable from the remote,\nconnect it again and then press OK to continue";
                        JOptionPane.showMessageDialog(null, message, title, 1);
                        n += 2;
                        continue block0;
                    }
                    System.err.println("Reconnection maximum wait exceeded");
                    return false;
                }
                if (this.progressUpdater != null) {
                    this.progressUpdater.updateProgress((int)((double)delay / (double)timeOut * 100.0));
                }
                this.attachedDevices = this.hidServices.getAttachedHidDevices();
                if (this.attachedDevices != null) {
                    for (HidDevice dev : this.attachedDevices) {
                        if (dev.getVendorId() != 1767) continue;
                        this.hidDevice = dev;
                        if (!this.hidDevice.open()) {
                            System.err.println("Error in reopen attempt");
                            return false;
                        }
                        this.hidDevice.setNonBlocking(false);
                        ++n;
                        break;
                    }
                }
                if (this.hidDevice != null) continue;
                this.waitForMillis(3000);
            }
        }
        if (this.hidDevice != null) {
            System.err.println("Reopened device after wait of " + delay + "ms");
            if (RMIRSetup.ioNeedsPowerManagementCheck(this) && (this.powerStatus = this.getEnhancedPowerManagementStatus()) == 1) {
                String title = "Firmware upgrade";
                String message = "The remote has opened in a new mode in which Enhanced Power Management\nis still enabled.  Please use regedit to disable it. The key that needs\nto be changed is at:\n\n" + CommHIDB.displayRegistryKey() + "\n\nwhere EnhancedPowerManagementEnabled needs to be changed from 1 to 0.\nRight-click the entry and select Modify, enter the new value 0 and press\nOK.  After making this change, you need to disconnect and reconnect the\nremote and run the upgrade process again.\n\nIf the remote is still in Update Mode then remove and reinsert the\nbatteries to exit Update Mode.  The remote will then be as it was before\nyou started the upgrade procedure.  You may repeat the upgrade process now\nor at a later time.\n\nIf the remote has exited Update Mode then the upgrade process has started\nbut is incomplete.  You should not need to remove and reinsert the batteries\nbut you do need to repeat the upgrade process to allow it to complete.";
                JOptionPane.showMessageDialog(null, message, title, 1);
                return false;
            }
            if (this.powerStatus == -1) {
                System.err.println("Enhanced Power Management is not supported in this mode");
            } else if (this.powerStatus == 0) {
                System.err.println("Enhanced Power Management is disabled in this mode");
            }
        } else {
            System.err.println("Reopen attempt gave null device after wait of " + delay + "ms");
            return false;
        }
        return true;
    }

    @Override
    public int getEnhancedPowerManagementStatus() {
        int enabled;
        block11: {
            if (this.hidDevice == null) {
                return -1;
            }
            enabled = -1;
            String containerGUID = null;
            String deviceKey = null;
            try {
                String line;
                BufferedReader output;
                Process reg;
                ProcessBuilder builder;
                String key;
                String path = this.hidDevice.getPath();
                int pos1 = path.indexOf("hid");
                int pos2 = path.lastIndexOf(35);
                if (pos1 >= 0 && pos2 >= 0) {
                    path = path.substring(pos1, pos2);
                    pos2 = path.lastIndexOf(35);
                    path = path.substring(0, pos2).toUpperCase() + path.substring(pos2);
                    path = path.replace("#", "\\");
                    key = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Enum\\" + path;
                    builder = new ProcessBuilder("reg", "query", key);
                    reg = builder.start();
                    output = new BufferedReader(new InputStreamReader(reg.getInputStream()));
                    reg.waitFor();
                    line = null;
                    while ((line = output.readLine()) != null) {
                        if (!line.contains("ContainerID")) continue;
                        pos1 = line.indexOf(123);
                        pos2 = line.indexOf(125);
                        if (pos1 <= 0 || pos2 <= 0) break;
                        containerGUID = line.substring(pos1, pos2 + 1);
                        break;
                    }
                }
                if (containerGUID != null) {
                    key = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\DeviceContainers\\" + containerGUID + "\\BaseContainers\\" + containerGUID;
                    builder = new ProcessBuilder("reg", "query", key);
                    reg = builder.start();
                    output = new BufferedReader(new InputStreamReader(reg.getInputStream()));
                    reg.waitFor();
                    String hidPid = String.format("%04X", this.thisPID);
                    String line2 = null;
                    while ((line2 = output.readLine()) != null) {
                        pos1 = line2.indexOf("USB\\VID_06E7&PID_" + hidPid);
                        if (pos1 < 0) continue;
                        pos2 = (line2 = line2.substring(pos1)).indexOf(" ");
                        if (pos2 > 0) {
                            line2 = line2.substring(0, pos2);
                        }
                        deviceKey = line2;
                        break;
                    }
                }
                if (deviceKey == null) break block11;
                this.deviceID = deviceKey.substring(deviceKey.lastIndexOf(92) + 1);
                key = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Enum\\" + deviceKey + "\\Device Parameters";
                builder = new ProcessBuilder("reg", "query", key);
                reg = builder.start();
                output = new BufferedReader(new InputStreamReader(reg.getInputStream()));
                reg.waitFor();
                line = null;
                while ((line = output.readLine()) != null) {
                    if (!line.contains("EnhancedPowerManagementEnabled")) continue;
                    int pos = line.indexOf("0x");
                    if (pos >= 0) {
                        if ((pos = (line = line.substring(pos + 2)).indexOf(" ")) > 0) {
                            line = line.substring(0, pos);
                        }
                        enabled = Integer.parseInt(line, 16);
                        System.err.println("Enhanced Power Management is " + (enabled > 0 ? "enabled" : "disabled"));
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("Error in accessing Enhanced Power Management Status");
                return -1;
            }
        }
        lastRegistryKey = this.getRegistryKey();
        return enabled;
    }

    @Override
    int readXZITEUSBReport(byte[] buffer, int timeout) {
        int bytesRead = -1;
        try {
            Arrays.fill(this.inReport, (byte)-1);
            bytesRead = this.hidDevice.read(this.inReport, timeout);
            if (RemoteMaster.admin) {
                long delayStart = Calendar.getInstance().getTimeInMillis();
                System.err.println("readXZITEUSBreport bytes read: " + bytesRead);
                System.err.println("   " + this.bytesToString(this.inReport));
                long delayEnd = Calendar.getInstance().getTimeInMillis();
                System.err.println("Delay duration (ms): " + (delayEnd - delayStart));
            }
            if (this.inReport[0] == -1) {
                return -2;
            }
            if (bytesRead == 64 && this.verifyCRC(this.inReport, 0) < 0) {
                return -3;
            }
            System.arraycopy(this.inReport, 0, buffer, 0, 62);
            if (RemoteMaster.admin) {
                System.err.println("   " + this.bytesToString(buffer));
            }
        }
        catch (Exception e) {
            return -1;
        }
        return bytesRead;
    }

    @Override
    int writeXZITEUSBReport(byte[] buffer, int length) {
        if (RemoteMaster.admin) {
            System.err.println(this.bytesToString(buffer));
        }
        System.arraycopy(buffer, 0, this.outReport, 0, length);
        if (length > 62) {
            return -1;
        }
        Arrays.fill(this.outReport, length, 62, (byte)0);
        int crc = this.CalcCRC(this.outReport, 0, 61);
        int bytesWritten = -1;
        this.outReport[62] = (byte)(crc & 0xFF);
        this.outReport[63] = (byte)(crc >> 8);
        try {
            bytesWritten = this.hidDevice.write(this.outReport, this.outReport.length, (byte)0);
        }
        catch (Exception e) {
            return -1;
        }
        return bytesWritten;
    }

    @Override
    public String getInterfaceVersion() {
        return "2.0 (B)";
    }

    public CommHIDB() throws UnsatisfiedLinkError {
        super(libraryName);
    }

    public CommHIDB(File folder) throws UnsatisfiedLinkError {
        super(folder, libraryName);
    }
}

