/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.LibraryLoader;
import com.hifiremote.jp1.ProgressUpdater;
import com.hifiremote.jp1.RMIRSetup;
import java.io.File;

public abstract class IO {
    private int eraseSize = 0;
    private RMIRSetup.Use use = null;
    private String progressName = null;
    protected ProgressUpdater progressUpdater = null;

    protected IO(File homeFolder, String libraryName) throws UnsatisfiedLinkError {
        if (libraryName != null) {
            LibraryLoader.loadLibrary(homeFolder, libraryName);
        } else {
            System.err.println("Loading internal library " + this.getInterfaceName());
        }
    }

    protected IO(String libraryName) throws UnsatisfiedLinkError {
        if (libraryName != null) {
            LibraryLoader.loadLibrary(libraryName);
        } else {
            System.err.println("Loading internal library " + this.getInterfaceName());
        }
    }

    public abstract String getInterfaceName();

    public abstract String getInterfaceVersion();

    public int getInterfaceType() {
        return 0;
    }

    public boolean getJP2info(byte[] buffer, int length) {
        return false;
    }

    public boolean getIcInfo(byte[] buffer, int length) {
        return false;
    }

    public abstract String[] getPortNames();

    public abstract String openRemote(String var1);

    public abstract void closeRemote();

    public void clear() {
    }

    public abstract String getRemoteSignature();

    public abstract int getRemoteEepromAddress();

    public abstract int getRemoteEepromSize();

    public boolean remoteUsesSSD() {
        return false;
    }

    public String openRemote() {
        return this.openRemote(null);
    }

    public int readRemote(int address, short[] sBuffer) {
        return this.readRemote(address, sBuffer, sBuffer.length);
    }

    public int readRemote(int address, short[] sBuffer, int length) {
        byte[] buffer = new byte[length];
        int len = this.readRemote(address, buffer, length);
        for (int i = 0; i < len; ++i) {
            sBuffer[i] = (short)(buffer[i] & 0xFF);
        }
        return len;
    }

    public int readRemote(int address, byte[] buffer) {
        return this.readRemote(address, buffer, buffer.length);
    }

    public abstract int readRemote(int var1, byte[] var2, int var3);

    public int writeRemote(int address, short[] sBuffer) {
        return this.writeRemote(address, sBuffer, sBuffer.length);
    }

    public int writeRemote(int address, short[] sBuffer, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)(sBuffer[i] & 0xFF);
        }
        return this.writeRemote(address, buffer, length);
    }

    public int writeRemote(int address, byte[] buffer) {
        return this.writeRemote(address, buffer, buffer.length);
    }

    public abstract int writeRemote(int var1, byte[] var2, int var3);

    public RMIRSetup.Use getUse() {
        return this.use;
    }

    public void setUse(RMIRSetup.Use use) {
        this.use = use;
    }

    public String getProgressName() {
        return this.progressName;
    }

    public void setProgressName(String progressName) {
        this.progressName = progressName;
    }

    public ProgressUpdater getProgressUpdater() {
        return this.progressUpdater;
    }

    public void setProgressUpdater(ProgressUpdater progressUpdater) {
        this.progressUpdater = progressUpdater;
    }

    public int getEraseSize() {
        return this.eraseSize;
    }

    public void setEraseSize(int eraseSize) {
        this.eraseSize = eraseSize;
    }
}

