/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.io.IO;
import java.io.File;

public class JP12Serial
extends IO {
    private static boolean isLoaded = false;
    private static final String libraryName = "jp12serial";

    @Override
    public native String getInterfaceName();

    @Override
    public native String getInterfaceVersion();

    private native int getJP12InterfaceType();

    @Override
    public int getInterfaceType() {
        int type = 0;
        if (this.getInterfaceVersion().compareTo("0.18a") > 0) {
            type = this.getJP12InterfaceType();
        }
        return type;
    }

    @Override
    public native boolean getJP2info(byte[] var1, int var2);

    @Override
    public native boolean getIcInfo(byte[] var1, int var2);

    @Override
    public native String[] getPortNames();

    @Override
    public native String openRemote(String var1);

    public native String openRemoteJP11(String var1);

    public native void setOption(int var1);

    @Override
    public native void closeRemote();

    @Override
    public native String getRemoteSignature();

    @Override
    public native int getRemoteEepromAddress();

    @Override
    public native int getRemoteEepromSize();

    @Override
    public native int readRemote(int var1, byte[] var2, int var3);

    @Override
    public native int writeRemote(int var1, byte[] var2, int var3);

    public JP12Serial() throws UnsatisfiedLinkError {
        super(libraryName);
    }

    public JP12Serial(File folder) throws UnsatisfiedLinkError {
        super(folder, libraryName);
    }

    public static void main(String[] args) {
        JP12Serial test = new JP12Serial();
        String portName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-port") || i + 1 >= args.length) continue;
            portName = args[++i];
            System.err.println("Using port " + portName);
        }
        if ((portName = test.openRemote(portName)) != null) {
            System.err.println("Found remote on port " + portName);
            System.err.println("signature=" + test.getRemoteSignature());
            int address = test.getRemoteEepromAddress();
            System.err.println("address=" + Integer.toHexString(address).toUpperCase());
            int size = test.getRemoteEepromSize();
            System.err.println("size=" + size);
            short[] buffer = new short[32];
            int len = test.readRemote(address, buffer);
            if (len < 0) {
                System.err.println("Error reading from remote!");
            } else {
                System.err.println("Start of EEPROM:");
                System.err.print(' ');
                System.err.println(Hex.toString(buffer, 16));
            }
            test.closeRemote();
        } else {
            System.err.println("No JP1.2 compatible remote found!");
        }
    }
}

