/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.fazecast.jSerialComm.SerialPort;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.ble.BlueGiga;
import com.hifiremote.jp1.io.BLEDisconnecter;
import com.hifiremote.jp1.io.BLERemote;
import com.hifiremote.jp1.io.IO;
import com.hifiremote.jp1.io.UEIPacket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jni4net.Bridge;
import rmirwin10ble.IBleInterface;
import rmirwin10ble.WCLble;
import rmirwin10ble.Win10BLE;

public class JP2BT
extends IO {
    private long ueiInStart = 0L;
    private LinkedHashMap<Integer, UEIPacket> ueiIn = new LinkedHashMap();
    private BLERemote bleRemote = null;
    public int sequence = 1;
    private RMIRSetup owner = null;
    private ArrayList<UEIPacket> incoming = new ArrayList();
    private IBleInterface blei = null;
    private BLEDisconnecter disconnecter = null;
    public String win10n = "Win10 Native";
    public String winWcl = "Windows WCL";

    public JP2BT() throws UnsatisfiedLinkError {
        super(null);
    }

    public JP2BT(File folder) throws UnsatisfiedLinkError {
        super(folder, null);
    }

    @Override
    public String getInterfaceName() {
        return "JP2BT";
    }

    @Override
    public String getInterfaceVersion() {
        return "1.3";
    }

    @Override
    public int getInterfaceType() {
        return 1537;
    }

    @Override
    public String[] getPortNames() {
        ArrayList<String> portList = new ArrayList<String>();
        String osName = System.getProperty("os.name");
        File wcl = new File(RemoteMaster.getWorkDir(), "rmirwin10ble\\wclBluetoothFramework.dll");
        if (osName.startsWith("Windows")) {
            if (RemoteMaster.admin && RMIRSetup.testWindowsVersion("10.0.15063")) {
                portList.add(this.win10n);
            }
            if (wcl.exists()) {
                portList.add(this.winWcl);
            }
        }
        for (SerialPort serialPort : SerialPort.getCommPorts()) {
            portList.add(serialPort.getSystemPortName());
        }
        String[] portNames = portList.toArray(new String[0]);
        return portNames;
    }

    @Override
    public String openRemote(String portName) {
        return portName;
    }

    @Override
    public void closeRemote() {
    }

    @Override
    public String getRemoteSignature() {
        return this.bleRemote.signature;
    }

    @Override
    public int getRemoteEepromAddress() {
        return this.bleRemote.E2address;
    }

    @Override
    public int getRemoteEepromSize() {
        return this.bleRemote.E2size;
    }

    @Override
    public int readRemote(int address, byte[] buffer, int length) {
        boolean segmentsOnly;
        int progress = 0;
        int blockSize = 128;
        int erasePageSize = 2048;
        int extraSize = 0;
        if (this.getRemoteEepromSize() % erasePageSize != 0) {
            extraSize = erasePageSize - this.getRemoteEepromSize() % erasePageSize;
        }
        if (address < this.getRemoteEepromAddress() || address + length > this.getRemoteEepromAddress() + this.getRemoteEepromSize() + extraSize) {
            return -1;
        }
        int extraStart = this.getRemoteEepromAddress() + this.getRemoteEepromSize();
        extraSize = Math.max(0, address + length - extraStart);
        boolean bl = segmentsOnly = address == this.getRemoteEepromAddress();
        if (this.progressUpdater != null && (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.UPLOAD)) {
            this.setProgressName(this.getUse() == RMIRSetup.Use.DOWNLOAD ? "DOWNLOADING:" : (segmentsOnly ? "VERIFYING:" : "PREPARING:"));
            this.progressUpdater.updateProgress(progress);
        }
        int segPos = segmentsOnly ? 20 : 0xFFFFFF;
        int segSize = 0;
        int remaining = length;
        int pos = 0;
        int extraIncs = extraSize > 0 ? 3 : 2;
        int progressIncrement = 100 / ((length - 1) / blockSize + extraIncs);
        Arrays.fill(buffer, (byte)-1);
        if (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.RAWDOWNLOAD) {
            if (!this.updateConnData(this.sequence++)) {
                return -1;
            }
            if (this.bleRemote.batteryBars < 2) {
                String message = "Battery level too low to download.";
                JOptionPane.showMessageDialog(null, message, "Download error", 0);
                return -1;
            }
        }
        progress += progressIncrement;
        if (this.progressUpdater != null && (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.UPLOAD)) {
            this.progressUpdater.updateProgress(progress);
        }
        while (remaining > 0) {
            while (pos >= segPos + 2 && (segSize = (buffer[segPos] << 8 & 0xFF00) + (buffer[segPos + 1] & 0xFF)) != 65535) {
                segPos += segSize;
            }
            if (segSize == 65535 && pos > segPos) break;
            int size = remaining > blockSize ? blockSize : remaining;
            byte[] block = this.readRemoteBlock(address + pos, size);
            if (block == null) {
                return pos;
            }
            progress += progressIncrement;
            if (this.progressUpdater != null && (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.UPLOAD)) {
                this.progressUpdater.updateProgress(progress);
            }
            System.arraycopy(block, 0, buffer, pos, size);
            pos += size;
            remaining -= size;
        }
        if (segmentsOnly && extraSize > 0) {
            byte[] block = this.readRemoteBlock(extraStart, extraSize);
            if (block == null) {
                return pos;
            }
            progress += progressIncrement;
            if (this.progressUpdater != null && (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.UPLOAD)) {
                this.progressUpdater.updateProgress(progress);
            }
            System.arraycopy(block, 0, buffer, this.getRemoteEepromSize(), extraSize);
        }
        return buffer.length;
    }

    @Override
    public int writeRemote(int address, byte[] buffer, int length) {
        int erasePageSize = 2048;
        int writeWordSize = 4;
        int extraSize = 0;
        if (length == 0) {
            return 0;
        }
        if (this.getRemoteEepromSize() % erasePageSize != 0) {
            extraSize = erasePageSize - this.getRemoteEepromSize() % erasePageSize;
        }
        if (address != this.getRemoteEepromAddress() || length > this.getRemoteEepromSize() + extraSize) {
            return -1;
        }
        int extraStart = address + this.getRemoteEepromSize();
        extraSize = Math.max(0, address + length - extraStart);
        int eraseLength = this.bleRemote.E2size;
        Remote remote = this.owner.getRemoteConfiguration().getRemote();
        int dataEnd = (remote.getCheckSums()[0].getAddressRange().getEnd() | writeWordSize - 1) + 1;
        length = Math.min(length, dataEnd);
        System.err.println("Length of segment data is $" + Integer.toHexString(length).toUpperCase());
        boolean writeExtraBytes = false;
        for (int i = length; i < buffer.length; ++i) {
            if ((buffer[i] & 0xFF) == 255) continue;
            if (i < this.getRemoteEepromSize()) {
                System.err.println("There are bytes beyond the segments that are not $FF");
                return -1;
            }
            writeExtraBytes = true;
            break;
        }
        int progress = 0;
        if (this.progressUpdater != null && this.getUse() == RMIRSetup.Use.UPLOAD) {
            this.setProgressName("UPLOADING:");
            this.progressUpdater.updateProgress(progress);
        }
        int blockSize = 128;
        int remaining = length;
        int extraIncs = writeExtraBytes ? 3 : 2;
        int pos = 0;
        int progressIncrement = 100 / ((length - 1) / blockSize + extraIncs);
        if (this.getUse() == RMIRSetup.Use.UPLOAD) {
            if (!this.updateConnData(this.sequence++)) {
                return -1;
            }
            if (this.bleRemote.batteryBars < 3) {
                String message = "Battery level too low to upload.";
                JOptionPane.showMessageDialog(null, message, "Upload error", 0);
                return -1;
            }
        }
        progress += progressIncrement;
        if (this.progressUpdater != null && (this.getUse() == RMIRSetup.Use.DOWNLOAD || this.getUse() == RMIRSetup.Use.UPLOAD)) {
            this.progressUpdater.updateProgress(progress);
        }
        if (this.erase(address, address + eraseLength - 1) != 0) {
            return -1;
        }
        while (remaining > 0) {
            int size;
            int n = size = remaining > blockSize ? blockSize : remaining;
            if (this.writeRemoteBlock(address + pos, Arrays.copyOfRange(buffer, pos, pos + size)) != 0) {
                return pos;
            }
            progress += progressIncrement;
            if (this.progressUpdater != null && this.getUse() == RMIRSetup.Use.UPLOAD) {
                this.progressUpdater.updateProgress(progress);
            }
            pos += size;
            remaining -= size;
        }
        if (writeExtraBytes) {
            if (this.writeRemoteBlock(extraStart, Arrays.copyOfRange(buffer, this.getRemoteEepromSize(), this.getRemoteEepromSize() + extraSize)) != 0) {
                return pos;
            }
            progress += progressIncrement;
            if (this.progressUpdater != null && this.getUse() == RMIRSetup.Use.UPLOAD) {
                this.progressUpdater.updateProgress(progress);
            }
        }
        return buffer.length;
    }

    public void setBleInterface(String port) {
        if (port.equals(this.win10n)) {
            File workdir = new File(RemoteMaster.getWorkDir(), "rmirwin10ble");
            try {
                Bridge.init(workdir);
                Bridge.LoadAndRegisterAssemblyFrom(new File(workdir, "RMIRWin10BLE.j4n.dll"));
                this.blei = new Win10BLE();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (port.equals(this.winWcl)) {
            File workdir = new File(RemoteMaster.getWorkDir(), "rmirwin10ble");
            try {
                Bridge.init(workdir);
                Bridge.LoadAndRegisterAssemblyFrom(new File(workdir, "RMIRWCLble.j4n.dll"));
                this.blei = new WCLble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.blei = new BlueGiga();
        }
    }

    public String connectBLE(String portName) {
        return this.blei.ConnectBLE(portName);
    }

    public void disconnectBLE() {
        this.blei.DisconnectBLE();
    }

    public boolean connectUEI() throws InterruptedException {
        long delay;
        UEIPacket upkt;
        long waitStart;
        int rptCount;
        System.err.println("Starting connectUEI()");
        Thread.sleep(1000L);
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(10);
        }
        if (!this.blei.ConnectUEI(this.bleRemote.address)) {
            System.err.println("Failed at stage " + this.blei.GetStage());
            return false;
        }
        System.err.println("Basic connection to remote succeeded");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(20);
        }
        Thread.sleep(50L);
        if (!this.blei.DiscoverServices()) {
            System.err.println("Failed at stage " + this.blei.GetStage());
            return false;
        }
        System.err.println("Services discovered");
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(50);
        }
        if (!this.blei.GetFeatures()) {
            System.err.println("Failed at stage " + this.blei.GetStage());
            return false;
        }
        if (this.progressUpdater != null) {
            this.progressUpdater.updateProgress(55);
        }
        System.err.println("FFE1 description = \"" + this.readUserDescription("ffe1") + "\"");
        System.err.println("FFE2 description = \"" + this.readUserDescription("ffe2") + "\"");
        if (this.needsCCCD() && !this.hasCCCD()) {
            String title = "Interface issue";
            String message = "RMIR cannot communicate with this remote through this Bluetooth interface.\nThis is due to an issue with the remote that can be corrected with an\nextender.  However, the extender needs a JP1.x cable to install it.  Once\nthe extender is installed, all future communication can be made with the\nBluetooth interface without any further need for the cable.";
            JOptionPane.showMessageDialog(this.owner, message, title, 2);
            return false;
        }
        System.err.println(this.blei.GetSubscription());
        Thread.sleep(200L);
        boolean didread = false;
        for (rptCount = 1; rptCount < 4; ++rptCount) {
            waitStart = Calendar.getInstance().getTimeInMillis();
            upkt = new UEIPacket(0, this.sequence++, 67, 66, null);
            if ((upkt = this.getUEIPacketResponse(upkt, 60, 1500)) == null) continue;
            didread = true;
            delay = Calendar.getInstance().getTimeInMillis() - waitStart;
            System.err.println("Battery read on attempt " + rptCount + " in " + delay + "ms");
            break;
        }
        if (!didread) {
            System.err.println("Battery read failed");
            return false;
        }
        didread = false;
        for (rptCount = 0; rptCount < 3; ++rptCount) {
            System.err.println("Reading ICINFO");
            long wStart = Calendar.getInstance().getTimeInMillis();
            UEIPacket upkt0 = new UEIPacket.CmdPacket("ICINFO", new byte[0]).getUEIPacket(this.sequence++);
            System.err.println("icinfo pkt: " + upkt0);
            upkt0 = this.getUEIPacketResponse(upkt0, 0, 3000);
            if (upkt0 != null && this.bleRemote.interpret("ICINFO", upkt0)) {
                System.err.println("icinfo rsp: " + upkt0);
                long delay0 = Calendar.getInstance().getTimeInMillis() - wStart;
                System.err.println("Read of icinfo took " + delay0 + "ms");
                break;
            }
            System.err.println("Failed to read icinfo");
        }
        for (rptCount = 1; rptCount < 3; ++rptCount) {
            System.err.println("Reading info and sig");
            waitStart = Calendar.getInstance().getTimeInMillis();
            upkt = new UEIPacket.CmdPacket("APPINFOGET", new byte[0]).getUEIPacket(this.sequence++);
            upkt = this.getUEIPacketResponse(upkt, 75, 3000);
            if (upkt != null && this.bleRemote.interpret("APPINFOGET", upkt)) {
                didread = true;
                delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                System.err.println("Successful read of info and sig took " + delay + "ms");
                break;
            }
            System.err.println("Failed to read info and sig");
        }
        if (!didread) {
            return false;
        }
        if (!this.updateConnData(this.sequence++)) {
            return false;
        }
        UEIPacket upkt2 = new UEIPacket(0, this.sequence++, 0, 68, null);
        if ((upkt2 = this.getUEIPacketResponse(upkt2, 85)) == null || !this.bleRemote.interpret(null, upkt2)) {
            System.err.println("Failed to read AppInfoRequest");
            return false;
        }
        System.err.println(this.bleRemote.hasFinder ? "Remote has finder" : "Remote does not have finder");
        this.blei.UpdateConnection(104, 120, 4, 550);
        this.bleRemote.supportsUpload = this.erase(-16769280, 0) == 3;
        System.err.println(this.bleRemote.supportsUpload ? "Remote supports uploading" : "Remote does not support uploading");
        this.disconnecter = new BLEDisconnecter(this);
        return true;
    }

    public void disconnectUEI() {
        if (this.disconnecter != null) {
            this.disconnecter.stop();
        }
        String result = this.blei.DisconnectUEI();
        System.err.println(this.blei.GetSubscription());
        System.err.println(result);
    }

    public int sendUEIPacket(UEIPacket upkt) {
        int n = 0;
        List<byte[]> bleList = upkt.toBLEpackets();
        for (byte[] bleData : bleList) {
            ++n;
            this.blei.SetSentState(0);
            this.blei.WritePacket(bleData);
            long waitStart = Calendar.getInstance().getTimeInMillis();
            long delay = 0L;
            while (this.blei.GetSentState() == 0) {
                delay = Calendar.getInstance().getTimeInMillis() - waitStart;
                if (delay <= 2000L) continue;
                System.err.println("Sending UEI packet timed out at BPI packet " + n + " of " + bleList.size());
                return -1;
            }
            if (this.blei.GetSentState() > 1) {
                System.err.println("Sending UEI packet returned error code " + (this.blei.GetSentState() - 1) + " at BPI packet " + n + " of " + bleList.size());
            }
            if (n >= bleList.size()) continue;
            this.ueiInStart = Calendar.getInstance().getTimeInMillis();
            UEIPacket sendNext = null;
            while (sendNext == null || sendNext.getFrameType() != 4) {
                sendNext = this.getUEIPacketIn();
                delay = Calendar.getInstance().getTimeInMillis() - this.ueiInStart;
                if (delay <= 6000L) continue;
                System.err.println("Wait for request for next fragment timed out after " + delay + "ms");
                return -1;
            }
        }
        return this.blei.GetSentState() - 1;
    }

    public UEIPacket getUEIPacketResponse(UEIPacket upkt, int progress) {
        return this.getUEIPacketResponse(upkt, progress, 6000);
    }

    public UEIPacket getUEIPacketResponse(UEIPacket upkt, int progress, int maxDelay) {
        UEIPacket upktRcvd;
        if (this.sendUEIPacket(upkt) != 0) {
            return null;
        }
        if (this.progressUpdater != null && progress > 0) {
            this.progressUpdater.updateProgress(progress);
        }
        if ((upktRcvd = this.getUEIPacketIn(maxDelay)) == null) {
            return null;
        }
        if (this.progressUpdater != null && progress > 0) {
            this.progressUpdater.updateProgress(progress + 2);
        }
        return upktRcvd;
    }

    public UEIPacket getUEIPacketIn() {
        return this.getUEIPacketIn(6000);
    }

    public UEIPacket getUEIPacketIn(int maxDelay) {
        this.ueiInStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        int pktCount = -1;
        while (true) {
            int bCount;
            if (pktCount != (bCount = this.blei.GetInCount())) {
                pktCount = bCount;
            }
            if (this.blei.GetInDataSize() > 0) {
                byte[] value = this.blei.GetInData(0);
                UEIPacket upkt = null;
                boolean ueiInOk = true;
                byte frameType = value[0];
                byte sequence = value[1];
                int state = frameType & UEIPacket.getFrameType("FragmentStart");
                if (state == 0) {
                    this.ueiInStart = Calendar.getInstance().getTimeInMillis();
                    upkt = new UEIPacket(frameType, sequence, value[2], value[3], Arrays.copyOfRange(value, 4, value.length));
                    this.incoming.add(upkt);
                    break;
                }
                if (state == UEIPacket.getFrameType("FragmentStart")) {
                    ueiInOk = true;
                    this.ueiInStart = Calendar.getInstance().getTimeInMillis();
                    upkt = new UEIPacket(frameType, sequence, value[2], value[4], value[3], Arrays.copyOfRange(value, 5, value.length));
                    this.ueiIn.put(Integer.valueOf(sequence), upkt);
                } else if (state == UEIPacket.getFrameType("Fragmented")) {
                    this.ueiInStart = Calendar.getInstance().getTimeInMillis();
                    upkt = this.ueiIn.get(sequence);
                    if (ueiInOk && (upkt == null || !upkt.update(frameType, sequence, value[2], value[3], Arrays.copyOfRange(value, 4, value.length)))) {
                        System.err.println("Error in incoming packet fragment");
                        this.ueiIn.remove(sequence);
                        ueiInOk = false;
                        break;
                    }
                } else if (state == UEIPacket.getFrameType("FragmentEnd")) {
                    this.ueiInStart = Calendar.getInstance().getTimeInMillis();
                    upkt = (UEIPacket)this.ueiIn.remove(sequence);
                    if (ueiInOk && (upkt == null || !upkt.update(frameType, sequence, value[2], value[3], Arrays.copyOfRange(value, 4, value.length)))) {
                        ueiInOk = false;
                        break;
                    }
                    if (ueiInOk) {
                        this.incoming.add(upkt);
                        break;
                    }
                }
            }
            if ((delay = Calendar.getInstance().getTimeInMillis() - this.ueiInStart) > (long)maxDelay) {
                System.err.println("Incoming UEI packet timed out, incoming queue size " + this.incoming.size());
                return null;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        UEIPacket upkt = this.incoming.remove(0);
        return upkt;
    }

    public void finderOn(boolean setOn) {
        UEIPacket p;
        byte[] args = new byte[]{5, setOn ? (byte)-96 : 8, 0};
        if (this.getUEIPacketResponse(p = new UEIPacket(0, this.sequence++, 37, 68, args), 0) != null) {
            System.err.println("Finder turned " + (setOn ? "On" : "Off"));
        } else {
            System.err.println("Error in setting finder " + (setOn ? "On" : "Off"));
        }
    }

    public byte[] readRemoteBlock(int address, int length) {
        int i;
        byte[] args = new byte[6];
        for (i = 0; i < 4; ++i) {
            args[3 - i] = (byte)(address >> 8 * i & 0xFF);
        }
        for (i = 0; i < 2; ++i) {
            args[5 - i] = (byte)(length >> 8 * i & 0xFF);
        }
        UEIPacket.CmdPacket cpkt = new UEIPacket.CmdPacket("DATAREAD", args);
        if (this.sendUEIPacket(cpkt.getUEIPacket(this.sequence++)) != 0) {
            System.err.println("Outgoing UEI packet failed to send");
            return null;
        }
        UEIPacket upkt = null;
        this.ueiInStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        while (upkt == null || upkt.getFrameType() == 4 || upkt.getOpCode() != 64 || upkt.getPayload().length == 4) {
            upkt = this.getUEIPacketIn();
            if (upkt != null && (upkt.getFrameType() == 4 || upkt.getOpCode() != 64 || upkt.getPayload().length == 4)) {
                System.err.println("Unexpected " + upkt.toString());
            }
            if ((delay = Calendar.getInstance().getTimeInMillis() - this.ueiInStart) <= 6000L) continue;
            System.err.println("Read Block timed out after delay of " + delay + "ms");
            return null;
        }
        if (upkt == null || upkt.isValidCmd() != 0) {
            return null;
        }
        byte[] result = upkt.getCmdArgs();
        return result;
    }

    public int erase(int start, int end) {
        int i;
        byte[] args = new byte[8];
        for (i = 0; i < 4; ++i) {
            args[3 - i] = (byte)(start >> 8 * i & 0xFF);
        }
        for (i = 0; i < 4; ++i) {
            args[7 - i] = (byte)(end >> 8 * i & 0xFF);
        }
        UEIPacket.CmdPacket cpkt = new UEIPacket.CmdPacket("DATAERASE", args);
        if (this.sendUEIPacket(cpkt.getUEIPacket(this.sequence++)) != 0) {
            System.err.println("Outgoing UEI packet failed to send");
            return -1;
        }
        UEIPacket upkt = this.getUEIPacketIn();
        if (upkt == null) {
            return -2;
        }
        int n = upkt.isValidCmd();
        return n;
    }

    public int sendRecord(Hex record) {
        byte[] args = new byte[record.length() + 2];
        args[1] = 0;
        args[0] = 0;
        System.arraycopy(record.toByteArray(), 0, args, 2, record.length());
        UEIPacket.CmdPacket cpkt = new UEIPacket.CmdPacket("RECORDSET", args);
        if (this.sendUEIPacket(cpkt.getUEIPacket(this.sequence++)) != 0) {
            System.err.println("Record failed to send");
            return -1;
        }
        UEIPacket upkt = null;
        this.ueiInStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        while (upkt == null || upkt.getFrameType() == 4 || upkt.getOpCode() != 64) {
            upkt = this.getUEIPacketIn();
            delay = Calendar.getInstance().getTimeInMillis() - this.ueiInStart;
            if (delay <= 6000L) continue;
            System.err.println("Send record timed out after delay of " + delay + "ms");
            return -2;
        }
        byte[] result = upkt.getCmdArgs();
        if (result == null) {
            return -3;
        }
        int n = upkt.isValidCmd();
        return n;
    }

    private int writeRemoteBlock(int address, byte[] data) {
        if ((address & 3) != 0) {
            return -3;
        }
        if ((data.length & 3) != 0) {
            return -4;
        }
        byte[] args = new byte[data.length + 4];
        for (int i = 0; i < 4; ++i) {
            args[3 - i] = (byte)(address >> 8 * i & 0xFF);
        }
        System.arraycopy(data, 0, args, 4, data.length);
        UEIPacket.CmdPacket cpkt = new UEIPacket.CmdPacket("DATAWRITE", args);
        if (this.sendUEIPacket(cpkt.getUEIPacket(this.sequence++)) != 0) {
            System.err.println("Write block failed to send");
            return -1;
        }
        UEIPacket upkt = null;
        this.ueiInStart = Calendar.getInstance().getTimeInMillis();
        long delay = 0L;
        while (upkt == null || upkt.getFrameType() == 4 || upkt.getOpCode() != 64) {
            upkt = this.getUEIPacketIn();
            if (upkt != null && (upkt.getFrameType() == 4 || upkt.getOpCode() != 64)) {
                System.err.println("Unexpected " + upkt.toString());
            }
            if ((delay = Calendar.getInstance().getTimeInMillis() - this.ueiInStart) <= 6000L) continue;
            System.err.println("Write Block timed out after delay of " + delay + "ms");
            return -2;
        }
        return upkt.isValidCmd();
    }

    public boolean updateConnData(int sequence) {
        int newSignalStrength = this.blei.ReadSignalStrength();
        if (newSignalStrength == 0) {
            System.err.println("Unable to read signal strength");
            return false;
        }
        this.bleRemote.signalStrength = newSignalStrength;
        UEIPacket upkt = new UEIPacket(0, sequence, 67, 66, null);
        if ((upkt = this.getUEIPacketResponse(upkt, 0)) == null || !this.bleRemote.interpret(null, upkt)) {
            System.err.println("Failed to read battery state");
            return false;
        }
        String strength = newSignalStrength == 1 ? "N/A" : newSignalStrength + "dBm";
        System.err.println("Connection data: Voltage = " + String.format("%4.2f", this.bleRemote.batteryVoltage) + ", Signal: " + strength);
        return true;
    }

    public boolean isScanning() {
        return this.blei.IsScanning();
    }

    public String bytesToString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        result.append("[ ");
        for (byte b : bytes) {
            result.append(String.format("%02X  ", b & 0xFF));
        }
        result.append("]");
        return result.toString();
    }

    public void setOwner(RMIRSetup RMIRSetup2) {
        this.owner = RMIRSetup2;
    }

    public RMIRSetup getOwner() {
        return this.owner;
    }

    public boolean isDisconnecting() {
        return this.blei.IsDisconnecting();
    }

    public void setDisconnecting(boolean disconnecting) {
        this.blei.SetDisconnecting(disconnecting);
    }

    public void discoverUEI(boolean start, boolean getAll) {
        this.blei.DiscoverUEI(start, getAll);
    }

    public int getListSize() {
        return this.blei.GetListSize();
    }

    public String getListItem(int ndx) {
        return this.blei.GetListItem(ndx);
    }

    public String getItemName(int ndx) {
        return this.blei.GetItemName(ndx);
    }

    public int getRssi(int ndx) {
        return this.blei.GetRssi(ndx);
    }

    private boolean hasCCCD() {
        return this.blei.HasCCCD();
    }

    private boolean needsCCCD() {
        return this.blei.NeedsCCCD();
    }

    public BLERemote getBleRemote() {
        return this.bleRemote;
    }

    public void setBleRemote(BLERemote bleRemote) {
        this.bleRemote = bleRemote;
    }

    public String getBleStack() {
        return this.blei.GetBLEStack();
    }

    public boolean isConnected() {
        return this.blei.IsConnected();
    }

    public String readUserDescription(String uuid) {
        byte[] value = this.blei.ReadUserDescription(uuid);
        StringBuffer sb = new StringBuffer();
        for (byte b : value) {
            sb.append((char)(b & 0xFF));
        }
        return sb.toString();
    }

    @Override
    public boolean getJP2info(byte[] buffer, int length) {
        Arrays.fill(buffer, (byte)0);
        int minLen = buffer.length < this.bleRemote.jp2info.length ? buffer.length : this.bleRemote.jp2info.length;
        int copyLen = minLen < length ? minLen : length;
        System.arraycopy(this.bleRemote.jp2info, 0, buffer, 0, copyLen);
        return true;
    }

    @Override
    public boolean getIcInfo(byte[] buffer, int length) {
        if (this.bleRemote.icinfo == null) {
            return false;
        }
        Arrays.fill(buffer, (byte)0);
        System.arraycopy(this.bleRemote.icinfo, 0, buffer, 0, Math.min(this.bleRemote.icinfo.length, buffer.length));
        return true;
    }
}

