/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Scanner;
import com.hifiremote.jp1.io.IO;
import com.hifiremote.jp1.settings.SettingFactory;
import com.hifiremote.jp1.settings.SettingImpl;
import com.hifiremote.jp1.settings.Settings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class JPS
extends IO {
    private String signature = null;
    private String filePath = null;
    private int eepromAddress = 0;
    private int eepromSize = 0;
    private int codeAddress = 0;
    private int codeSize = 0;
    private int sigAddress = 0;
    private int irdbAddress = 0;
    private Settings s = null;
    private Scanner scanner = null;

    public JPS() throws UnsatisfiedLinkError {
        super(null);
    }

    public JPS(File folder) throws UnsatisfiedLinkError {
        super(null);
    }

    @Override
    public String getInterfaceName() {
        return "JPS";
    }

    @Override
    public String getInterfaceVersion() {
        return "0.1";
    }

    @Override
    public int getInterfaceType() {
        return 769;
    }

    @Override
    public String[] getPortNames() {
        return new String[0];
    }

    public boolean isOpen() {
        return this.s != null;
    }

    @Override
    public void clear() {
        this.s = null;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String openRemote(String filePath) {
        File file;
        String osName = System.getProperty("os.name");
        if (filePath == null) {
            try {
                if (osName.startsWith("Windows")) {
                    filePath = this.getSettingsWindows();
                } else if (osName.equals("Linux")) {
                    filePath = this.getSettingsLinux();
                } else if (osName.equals("Mac OS X")) {
                    filePath = this.getSettingsMacOSX();
                } else {
                    String message = "This OS is not supported by RMIR.";
                    String title = "OS Error";
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 0);
                }
            }
            catch (Exception e) {
                System.err.println("OS file system error: " + e.getMessage());
                String message = "File system return error: " + e.getMessage();
                String title = "OS Error";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 0);
                filePath = null;
            }
            if (filePath == null) {
                return null;
            }
        } else if (osName.equals("Linux") && (file = new File(filePath)).isDirectory()) {
            String mountPoint = filePath.endsWith(File.separator) ? filePath : filePath + File.separator;
            filePath = mountPoint + "settings.bin";
        }
        this.filePath = filePath;
        SettingFactory cf = new SettingFactory(SettingImpl.class);
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + filePath);
            e.printStackTrace();
            return null;
        }
        catch (SecurityException e) {
            System.err.println("Security exception opening " + filePath + " for reading");
            e.printStackTrace();
            return null;
        }
        try {
            this.s = new Settings(in, cf);
            if (!this.s.isValid()) {
                if (RemoteMaster.admin) {
                    String chksum = this.calcChecksum(filePath);
                    System.err.println(String.format("Checksum is " + chksum, new Object[0]));
                    String title = "XOR16 Checksum Calculator";
                    String message = "File: " + filePath + "\nChecksum: " + chksum;
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, -1);
                    return null;
                }
                System.err.println("Not a Simpleset file: " + filePath);
                String message = "File \"" + filePath + "\" is not a Simpleset file";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, "File error", 0);
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.progressUpdater != null && this.getUse() == RMIRSetup.Use.UPLOAD) {
            this.progressUpdater.updateProgress(0);
        }
        byte[] data = new byte[64];
        this.s.read(0, data);
        int len = this.getInt32(data, 2);
        this.s.read(len, data);
        char[] sigArray = new char[6];
        for (int i = 0; i < 6; ++i) {
            sigArray[i] = (char)(data[6 + i] & 0xFF);
        }
        this.signature = String.valueOf(sigArray);
        this.codeAddress = this.getInt32(data, 47);
        this.s.setFlashOffset(this.codeAddress);
        this.sigAddress = this.getInt32(data, 51);
        this.codeSize = this.sigAddress - this.codeAddress;
        this.irdbAddress = this.getInt32(data, 55);
        this.eepromAddress = this.getInt32(data, 59);
        this.s.read(this.eepromAddress, data);
        this.eepromSize = this.getInt32(data, 2);
        this.filePath = filePath;
        this.scanner = new Scanner(this, this.irdbAddress);
        if (!this.scanner.scan()) {
            this.scanner = null;
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calcChecksum(String filePath) {
        System.err.println("Calculating 16-bit XOR checksum for binary file: " + filePath);
        File file = new File(filePath);
        int len = (int)file.length();
        System.err.println("File size: " + len);
        byte[] data = new byte[len];
        try (InputStream input = null;){
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(file));
            while (totalBytesRead < data.length) {
                int bytesRemaining = data.length - totalBytesRead;
                int bytesRead = input.read(data, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            System.err.println("Num bytes read: " + totalBytesRead);
        }
        catch (FileNotFoundException ex) {
            System.err.println("File not found.");
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int sum = 0;
        for (int i = 2; i <= len - 2; i += 2) {
            sum = (short)(sum ^ (data[i] << 8 & 0xFF00 | data[i + 1] & 0xFF));
        }
        sum = (short)(sum ^ 0xFF);
        return Hex.toString(new short[]{(short)(sum >> 8), (short)(sum & 0xFF)});
    }

    private int getInt32(byte[] data, int offset) {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += (data[offset + i] & 0xFF) << 8 * (3 - i);
        }
        return val;
    }

    @Override
    public boolean getJP2info(byte[] buffer, int length) {
        this.s.read(this.sigAddress, buffer);
        return true;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    @Override
    public void closeRemote() {
    }

    @Override
    public String getRemoteSignature() {
        return this.signature;
    }

    @Override
    public int getRemoteEepromAddress() {
        return this.eepromAddress;
    }

    public int getCodeAddress() {
        return this.codeAddress;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public int getSigAddress() {
        return this.sigAddress;
    }

    public int getSigSize() {
        return this.irdbAddress - this.sigAddress;
    }

    public int getIRdbAddress() {
        return this.irdbAddress;
    }

    public int getIRdbSize() {
        return this.eepromAddress - this.irdbAddress;
    }

    @Override
    public int getRemoteEepromSize() {
        return this.eepromSize;
    }

    @Override
    public int readRemote(int address, byte[] buffer, int length) {
        try {
            this.s.read(address, buffer);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        return buffer.length;
    }

    @Override
    public int writeRemote(int address, byte[] buffer, int length) {
        try {
            this.s.write(address, buffer);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        try {
            int total;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            this.s.save(bao);
            int maxChunkSize = 4096;
            String osName = System.getProperty("os.name");
            if (osName.equals("Linux")) {
                maxChunkSize = 512;
            }
            FileChannel o = FileChannel.open(Paths.get(this.filePath, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            int dataWritten = 0;
            int dataLeft = total = bao.size();
            byte[] data = bao.toByteArray();
            this.setProgressName("UPLOADING:");
            if (this.progressUpdater != null) {
                this.progressUpdater.updateProgress(0);
            }
            while (dataLeft > 0) {
                int chunkSize = Math.min(maxChunkSize, dataLeft);
                o.write(ByteBuffer.wrap(data, dataWritten, chunkSize));
                dataWritten += chunkSize;
                dataLeft -= chunkSize;
                if (this.progressUpdater == null) continue;
                this.progressUpdater.updateProgress((int)((double)dataWritten / (double)total * 100.0));
            }
            o.close();
            bao.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return -1;
        }
        return buffer.length;
    }

    public String getSettingsMacOSX() throws IOException, InterruptedException {
        Process p;
        String filePath;
        block6: {
            filePath = null;
            p = new ProcessBuilder("mount", "-t", "msdos").start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                int endIndex;
                int startIndex;
                String line;
                String mountPoint;
                File file;
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block6;
                } while (!(file = new File(mountPoint = line.substring(startIndex = line.indexOf(" on ") + 4, endIndex = line.indexOf(" (")), "settings.bin")).canRead());
                System.err.println("Loading from path: " + file);
                filePath = file.getCanonicalPath();
            }
        }
        p.waitFor();
        return filePath;
    }

    public String getSettingsWindows() {
        String filePath = null;
        List<File> files = Arrays.asList(File.listRoots());
        for (File f : files) {
            String s1 = FileSystemView.getFileSystemView().getSystemDisplayName(f);
            if (s1.indexOf("REMOTE") < 0) continue;
            int n = s1.indexOf(40);
            String drivePath = s1.substring(n + 1, n + 2);
            filePath = drivePath + ":\\settings.bin";
            System.err.println("Loading from path: " + filePath);
            if (new File(filePath).exists()) break;
            System.err.println("File does not exist");
            filePath = null;
        }
        return filePath;
    }

    public String getSettingsLinux() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/mounts"));){
            while (true) {
                String mountPoint;
                File filePath;
                String line;
                if ((line = br.readLine()) == null) {
                    String string = null;
                    return string;
                }
                String[] values = line.split("\\s+");
                String fileSystemType = values[2];
                if (!fileSystemType.equals("vfat") || !(filePath = new File(mountPoint = values[1], "settings.bin")).canRead()) continue;
                System.err.println("Loading from path: " + filePath);
                String string = filePath.getCanonicalPath();
                return string;
            }
        }
    }

    private String getCommandPath(String command) {
        for (String path : System.getenv("PATH").split(File.pathSeparator)) {
            File commandFile = new File(path + File.separator + command);
            if (!commandFile.exists()) continue;
            return commandFile.getAbsolutePath();
        }
        return null;
    }
}

