/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UEIPacket {
    public static final String[][] frameTypes = new String[][]{{"0x00", "None"}, {"0x80", "AckRequest"}, {"0x40", "AckResponse"}, {"0x30", "FragmentStart"}, {"0x20", "Fragmented"}, {"0x10", "FragmentEnd"}, {"0x08", "MoreData"}, {"0x04", "Immediate"}};
    public static final String[][] appCodes = new String[][]{{"UAPI", "0"}, {"OTA", "1"}, {"Blaster", "16"}, {"Remote", "17"}, {"Activity", "32"}, {"URC", "33"}, {"Text", "34"}, {"Alert", "36"}, {"RemoteFinder", "37"}, {"Motion", "48"}, {"Orientation", "49"}, {"Relative", "50"}, {"RelativeHi", "51"}, {"Absolute", "52"}, {"AbsoluteHi", "53"}, {"RawCompressedAudio", "54"}, {"Tap", "64"}, {"Accelerometer", "65"}, {"VirtualKeys", "66"}, {"BatteryStatus", "67"}, {"HID", "80"}, {"Audio", "96"}, {"ConfigAppMain", "128"}, {"ConfigTouchpad", "129"}, {"ConfigAccelerometer", "130"}, {"Invalid", "-1"}};
    public static final String[][] uapi_opCodes = new String[][]{{"ProductInfo", "0x05"}, {"AppInfoRequest", "0x44"}};
    public static final String[][] record_cmdCodes = new String[][]{{"0x01", "CMD_DATAREAD"}, {"0x02", "CMD_DATAWRITE"}, {"0x03", "CMD_DATAERASE"}, {"0x04", "CMD_CHECKSUM"}, {"0x50", "CMD_ICINFO"}, {"0x51", "CMD_ENTERBL"}, {"0x52", "CMD_EXIT"}, {"0x53", "CMD_GET_VERSION"}, {"0x80", "CMD_DATARMWRITE"}, {"0x81", "CMD_RECORDGET"}, {"0x82", "CMD_RECORDSET"}, {"0x83", "CMD_RECORDREMOVE"}, {"0x84", "CMD_FDRAMEMGET"}, {"0x85", "CMD_SENDIRFUNCTION"}, {"0x86", "CMD_SENDKEY"}, {"0x87", "CMD_CFGSET"}, {"0x88", "CMD_CFGRESET"}, {"0x89", "CMD_CFGGET"}, {"0x8A", "CMD_REMOVE_UNUSED_UPG"}, {"0x8B", "CMD_APPINFOGET"}, {"0x8C", "CMD_LONGRECORDSET"}, {"0x8D", "CMD_LIST_UPGRADE"}, {"0x8E", "CMD_REMOVE_UPGRADE"}, {"0x8F", "CMD_TEST_DEVICE_CODE"}};
    private int frameType;
    private int sequence;
    private int appCode;
    private int opCode;
    private int fragmentCount;
    private byte[] payload;

    public static int getFrameType(String name) {
        int type = -1;
        for (String[] currType : frameTypes) {
            if (!currType[1].equals(name)) continue;
            type = Integer.parseInt(currType[0].substring(2), 16);
            break;
        }
        return type;
    }

    public static int getCmdCode(String name) {
        int code = -1;
        for (String[] currCmdCode : record_cmdCodes) {
            if (!currCmdCode[1].equals("CMD_" + name)) continue;
            code = Integer.parseInt(currCmdCode[0].substring(2), 16);
            break;
        }
        return code;
    }

    public UEIPacket(int frameType, int sequence, int appCode, int opCode, byte[] payload) {
        this.frameType = frameType;
        this.sequence = sequence;
        this.appCode = appCode;
        this.opCode = opCode;
        this.fragmentCount = -1;
        this.payload = payload == null ? new byte[]{} : payload;
    }

    public UEIPacket(int frameType, int sequence, int appCode, int opCode, int fragmentCount, byte[] payload) {
        this.frameType = frameType;
        this.sequence = sequence;
        this.appCode = appCode;
        this.opCode = opCode;
        this.fragmentCount = fragmentCount;
        this.payload = payload == null ? new byte[]{} : payload;
    }

    public int getAppCode() {
        return this.appCode;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public boolean update(int frameType, int sequence, int appCode, int fragmentCount, byte[] payload) {
        this.frameType = frameType & ~UEIPacket.getFrameType("FragmentStart");
        if (this.appCode != appCode) {
            System.err.println("App code difference in UEIPacket, sequence = " + sequence);
            return false;
        }
        if (this.fragmentCount != fragmentCount + 1) {
            System.err.println("Fragment sequence error in UEIPacket, sequence = " + sequence);
            return false;
        }
        this.fragmentCount = fragmentCount;
        byte[] newload = new byte[this.payload.length + payload.length];
        System.arraycopy(this.payload, 0, newload, 0, this.payload.length);
        System.arraycopy(payload, 0, newload, this.payload.length, payload.length);
        this.payload = newload;
        return true;
    }

    public List<byte[]> toBLEpackets() {
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        ArrayList<UEIPacket> list = new ArrayList<UEIPacket>();
        int immed = UEIPacket.getFrameType("Immediate");
        if (this.payload.length < 17) {
            this.fragmentCount = -1;
            list.add(this);
        } else {
            int remaining;
            int index = 0;
            for (int r = remaining = this.payload.length / 16; r >= 0; --r) {
                int currentType = this.frameType | (index == 0 ? UEIPacket.getFrameType("FragmentStart") : (r == 0 ? UEIPacket.getFrameType("FragmentEnd") : UEIPacket.getFrameType("Fragmented")));
                currentType &= ~immed;
                if (r > 0) {
                    currentType |= UEIPacket.getFrameType("MoreData");
                }
                if (r == 0 && (this.frameType & immed) == immed) {
                    currentType |= immed;
                }
                byte[] currentPayload = Arrays.copyOfRange(this.payload, Math.max(0, 16 * index - 1), Math.min(this.payload.length, 16 * (index + 1) - 1));
                list.add(new UEIPacket(currentType, this.sequence, this.appCode, this.opCode, r, currentPayload));
                ++index;
            }
        }
        for (UEIPacket upkt : list) {
            int first = UEIPacket.getFrameType("FragmentStart");
            int headerSize = (upkt.frameType & first) == first ? 5 : 4;
            byte[] data = new byte[upkt.payload.length + headerSize];
            int n = 0;
            data[n++] = (byte)(upkt.frameType & 0xFF);
            data[n++] = (byte)(upkt.sequence & 0xFF);
            data[n++] = (byte)(upkt.appCode & 0xFF);
            if (upkt.fragmentCount >= 0) {
                data[n++] = (byte)(upkt.fragmentCount & 0xFF);
            }
            if (upkt.fragmentCount < 0 || headerSize == 5) {
                data[n++] = (byte)(upkt.opCode & 0xFF);
            }
            System.arraycopy(upkt.payload, 0, data, n, upkt.payload.length);
            out.add(data);
        }
        return out;
    }

    public String toString() {
        return "UEIPacket: type=" + this.frameType + ", sequence=" + this.sequence + ", appcode=" + this.appCode + ", opcode=" + this.opCode + "\n[" + UEIPacket.bytesToString(this.payload) + "]";
    }

    public static String bytesToString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte b : bytes) {
            result.append(Integer.toHexString(b & 0xFF) + " ");
        }
        return result.toString();
    }

    public static int doChecksum(byte[] payload) {
        int chk = 0;
        for (int i = 0; i < payload.length - 1; ++i) {
            chk ^= payload[i] & 0xFF;
        }
        return chk;
    }

    public int isValidCmd() {
        int ueiLen = 16 * (this.payload[0] & 0xFF) + (this.payload[1] & 0xFF);
        int payLen = this.payload.length - 2;
        if (ueiLen != payLen) {
            return -1;
        }
        int chk = UEIPacket.doChecksum(this.payload);
        if (chk != (this.payload[ueiLen + 1] & 0xFF)) {
            return -2;
        }
        return this.payload[2];
    }

    public byte[] getCmdArgs() {
        return this.payload.length < 4 ? null : Arrays.copyOfRange(this.payload, 3, this.payload.length - 1);
    }

    public static class CmdPacket {
        int cmdCode = 0;
        byte[] args = null;

        public CmdPacket(String cmd, byte[] args) {
            this.cmdCode = UEIPacket.getCmdCode(cmd);
            this.args = args;
        }

        public byte[] getPayload() {
            byte[] pl = new byte[this.args.length + 4];
            int size = this.args.length + 2;
            pl[0] = (byte)(size >> 8 & 0xFF);
            pl[1] = (byte)(size & 0xFF);
            pl[2] = (byte)(this.cmdCode & 0xFF);
            System.arraycopy(this.args, 0, pl, 3, this.args.length);
            int chksum = UEIPacket.doChecksum(pl);
            pl[pl.length - 1] = (byte)(chksum & 0xFF);
            return pl;
        }

        public UEIPacket getUEIPacket(int sequence) {
            return new UEIPacket(0, sequence, 17, 65, this.getPayload());
        }
    }
}

