/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.rf.Npdu;

public class Mpdu
extends Hex {
    public Mpdu(Hex hex) {
        super(hex);
    }

    public Mpdu(Hex hex, int offset, int length) {
        super(hex, offset, length);
    }

    public Mpdu(Hex hex, int offset) {
        super(hex, offset, hex.length() - offset);
    }

    public MSPrimitive parse() {
        boolean macIntraPAN;
        MSPrimitive prim = new MSPrimitive();
        MACAddrData addrData = prim.addrData;
        int macFrameCtl = this.getData()[0] + (this.getData()[1] << 8);
        int macFrameType = macFrameCtl & 7;
        int macDestAddrMode = macFrameCtl >> 10 & 3;
        int macSrcAddrMode = macFrameCtl >> 14 & 3;
        boolean bl = macIntraPAN = (macFrameCtl & 0x40) == 64;
        if (macFrameType != 1) {
            prim.setError("MAC frame is not a data frame");
            return prim;
        }
        if (macSrcAddrMode == 1 || macDestAddrMode == 1) {
            prim.setError("Unknown MAC address mode");
            return prim;
        }
        if (macSrcAddrMode == 0 || macDestAddrMode == 0) {
            prim.setError("MAC address mode of None is not supported");
            return prim;
        }
        int destAddrSize = macDestAddrMode == 3 ? 8 : 2;
        int srcAddrSize = macSrcAddrMode == 3 ? 8 : 2;
        int srcPANSize = macIntraPAN ? 0 : 2;
        addrData.destPAN = this.subHex(3, 2);
        int addrFieldSize = 2;
        addrData.destAddr = this.subHex(3 + addrFieldSize, destAddrSize);
        addrData.srcPAN = macIntraPAN ? addrData.destPAN : this.subHex(3 + (addrFieldSize += destAddrSize), srcPANSize);
        addrData.srcAddr = this.subHex(3 + (addrFieldSize += srcPANSize), srcAddrSize);
        int npduOffset = 3 + (addrFieldSize += srcAddrSize);
        int npduSize = this.length() - npduOffset - 2;
        prim.npdu = new Npdu(this, npduOffset, npduSize);
        return prim;
    }

    public static class MSPrimitive {
        public MACAddrData addrData = new MACAddrData();
        public Npdu npdu = null;
        private String error = null;

        public void setError(String error) {
            this.npdu = null;
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }

    public static class MACAddrData {
        public Hex srcPAN = null;
        public Hex srcAddr = null;
        public Hex destPAN = null;
        public Hex destAddr = null;
    }
}

