/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.rf.Mpdu;
import com.hifiremote.jp1.rf.Npdu;
import com.hifiremote.jp1.rf.RfTools;

public class NSAddressTableModel
extends JP1TableModel<Npdu.NSPrimitive> {
    private static String[] colNames = new String[]{"#", "Property", "Value"};
    private static String[] rowNames = new String[]{"Channel", "Source Address", "Source PAN", "Destination Address", "Destination PAN"};
    private static String[] colPrototypeNames = new String[]{" 00 ", "Name_of_the_property__________", "Value_of_the_property____________"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class};
    private static boolean[] colWidths = new boolean[]{true, false, false};
    private Npdu.NSPrimitive prim = null;

    @Override
    public int getRowCount() {
        return rowNames.length;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    public String getRowName(int row) {
        return rowNames[row];
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[col];
    }

    private Hex getRowHex(int row) {
        if (this.prim == null || this.prim.addrData == null) {
            return null;
        }
        Mpdu.MACAddrData addrData = this.prim.addrData;
        switch (row) {
            case 1: {
                return addrData.srcAddr;
            }
            case 2: {
                return addrData.srcPAN;
            }
            case 3: {
                return addrData.destAddr;
            }
            case 4: {
                return addrData.destPAN;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return this.getRowName(row);
            }
            case 2: {
                if (this.prim == null) {
                    return null;
                }
                if (row == 0) {
                    int channelDesignator = this.prim.channelDesignator;
                    if (channelDesignator == 0) {
                        return "Unspecified";
                    }
                    return "" + (10 + 5 * channelDesignator);
                }
                Hex hex = this.getRowHex(row);
                return hex == null ? null : RfTools.getAddrString(hex);
            }
        }
        return null;
    }

    public void setNSPrimitive(Npdu.NSPrimitive prim) {
        this.prim = prim;
    }
}

