/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.rf.Npdu;
import com.hifiremote.jp1.rf.RfTools;
import java.util.Arrays;

public class NSDUDetailsTableModel
extends JP1TableModel<Npdu.NSPrimitive> {
    private static String[] colNames = new String[]{"#", "Property", "Hex Value", "Interpretation"};
    private static String[] rowNames = new String[]{"Command ID", "Status", "Alloc. Network Address", "Network Address", "Node Capabilities", "Vendor ID", "Vendor String", "User String", "Dev Type List", "Profile ID List", "Requested Dev Type", "Key Exch Transfer Count", "Discovery Req LQI", "Sequence Number", "Seed Data", "Ping Options", "Ping Payload", "Data", "RAW NSDU:", "Encrypted Payload", "Msg Integrity Field", "Decrypted Payload", "", "DECRYPT PARSED:"};
    private static String[] deviceNames = new String[]{"REMOTE CONTROL", "TELEVISION", "PROJECTOR", "PLAYER", "RECORDER", "VIDEO PLAYER RECORDER", "AUDIO PLAYER RECORDER", "AUDIO VIDEO RECORDER", "SET TOP BOX", "HOME THEATER SYSTEM", "MEDIA CENTER PC", "GAME CONSOLE", "SATELLITE RADIO RECEIVER", "IR EXTENDER", "MONITOR", "GENERIC", "WILDCARD"};
    private static String[] profileNames = new String[]{"GDP", "ZRC", "ZID", "ZRC20", "UNKNOWN", "VENDOR"};
    private static String[] colPrototypeNames = new String[]{" 00 ", "Name_of_the_property__________", "Value_of_the_property__", "Interpretation_____________"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, String.class};
    private static boolean[] colWidths = new boolean[]{true, true, false, false};
    private Npdu.NSPrimitive prim = null;

    private String getDeviceName(int devType) {
        if (devType > 0 && devType < 16) {
            return deviceNames[devType - 1];
        }
        if (devType == 254 || devType == 255) {
            return deviceNames[devType - 239];
        }
        return null;
    }

    private String getProfileName(int profileID) {
        if (profileID < 4) {
            return profileNames[profileID];
        }
        if (profileID < 192) {
            return profileNames[4];
        }
        return profileNames[5];
    }

    public String getDeviceNameList(Hex devTypes) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (short devType : devTypes.getData()) {
            String s = this.getDeviceName(devType);
            if (s == null) continue;
            if (n++ > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getProfileNameList(Hex profiles) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (short profileID : profiles.getData()) {
            String s = this.getProfileName(profileID);
            if (s == null) continue;
            if (n++ > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getNodeCapabilities(int nodeCaps) {
        StringBuilder sb = new StringBuilder();
        sb.append((nodeCaps & 1) == 1 ? "Is Target, " : "Is Controller, ");
        sb.append((nodeCaps & 2) == 2 ? "Mains power, " : "Battery power, ");
        sb.append((nodeCaps & 4) == 4 ? "Can encrypt, " : "Cannot encrypt, ");
        sb.append((nodeCaps & 8) == 8 ? "Can switch channel" : "Cannot switch channel");
        return sb.toString();
    }

    private String getInterpretation(int row) {
        String descr = null;
        Hex hex = this.getRowHex(row);
        if (hex == null || !this.prim.valid) {
            return null;
        }
        switch (this.getEffectiveRow(row)) {
            case 0: {
                descr = Npdu.NSDUCommand.values()[hex.getData()[0] - 1].toString();
                break;
            }
            case 1: {
                short code = hex.getData()[0];
                descr = code == 0 ? "SUCCESS" : "ERROR CODE" + code;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                descr = RfTools.getAddrString(hex);
                break;
            }
            case 4: {
                descr = this.getNodeCapabilities(hex.getData()[0]);
                break;
            }
            case 6: 
            case 7: {
                descr = new String(hex.toByteArray());
                break;
            }
            case 8: 
            case 10: {
                descr = this.getDeviceNameList(hex);
                break;
            }
            case 9: {
                descr = this.getProfileNameList(hex);
                break;
            }
            case 11: {
                descr = "" + (hex.getData()[0] + 1);
                break;
            }
            case 13: {
                descr = "Key Seed " + (hex.getData()[0] + 1);
                break;
            }
            case 14: {
                descr = "Key Seed data (80 bytes)";
                break;
            }
            default: {
                descr = hex.toString();
            }
        }
        return descr;
    }

    private int getEffectiveRow(int row) {
        Npdu.NSDUType type = this.prim.type;
        Npdu.NSDUCommand cmd = this.prim.cmd;
        if (type == Npdu.NSDUType.COMMAND) {
            if (cmd == Npdu.NSDUCommand.PING_REQ || cmd == Npdu.NSDUCommand.PING_RSP) {
                return row < 6 ? row + 18 : (row == 6 ? 0 : row + 8);
            }
            if (row == 0) {
                return 0;
            }
            switch (cmd) {
                case DISCOVERY_REQ: {
                    return row + 3;
                }
                case DISCOVERY_RSP: {
                    return row == 1 ? 1 : (row == 8 ? 12 : row + 2);
                }
                case PAIR_REQ: {
                    return row == 1 ? 3 : (row == 8 ? 11 : row + 2);
                }
                case PAIR_RSP: {
                    return row;
                }
                case KEYSEED: {
                    return row + 12;
                }
            }
            return 0;
        }
        return row < 6 && this.prim.secured ? row + 18 : 17;
    }

    @Override
    public int getRowCount() {
        if (this.prim == null) {
            return 0;
        }
        Npdu.NSDUType type = this.prim.type;
        Npdu.NSDUCommand cmd = this.prim.cmd;
        if (type == Npdu.NSDUType.COMMAND) {
            if (!this.prim.valid) {
                return 1;
            }
            switch (cmd) {
                case DISCOVERY_REQ: {
                    return 8;
                }
                case DISCOVERY_RSP: 
                case PAIR_REQ: {
                    return 9;
                }
                case PAIR_RSP: {
                    return 10;
                }
                case UNPAIR_REQ: {
                    return 0;
                }
                case KEYSEED: {
                    return 3;
                }
                case PING_REQ: 
                case PING_RSP: {
                    return 9;
                }
            }
            return 0;
        }
        return this.prim.secured ? 7 : 1;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    public String getRowName(int row) {
        return rowNames[this.getEffectiveRow(row)];
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return colWidths[col];
    }

    private Hex[] getInfo(Hex in) {
        int len;
        Hex[] out = new Hex[7];
        out[0] = in.subHex(0, 1);
        out[1] = in.subHex(1, 2);
        out[2] = in.subHex(3, 7);
        short appCaps = in.getData()[10];
        int pos = 11;
        if ((appCaps & 1) == 1) {
            out[3] = in.subHex(pos, 15);
            pos += 15;
        }
        if ((len = appCaps >> 1 & 3) > 0) {
            out[4] = in.subHex(pos, len);
            pos += len;
        }
        if ((len = appCaps >> 4 & 7) > 0) {
            out[5] = in.subHex(pos, len);
            pos += len;
        }
        out[6] = new Hex(String.format("%02X", pos));
        return out;
    }

    private Hex getRowHex(int row) {
        Hex nsdu = this.prim.nsdu;
        Npdu.NSDUType type = this.prim.type;
        Npdu.NSDUCommand cmd = this.prim.cmd;
        Hex[] info = null;
        short pos = 0;
        Hex val = null;
        if (type == Npdu.NSDUType.COMMAND) {
            if (cmd == Npdu.NSDUCommand.PING_REQ || cmd == Npdu.NSDUCommand.PING_RSP) {
                int len = nsdu.length() - 2;
                val = row == 0 ? null : (row == 1 ? this.prim.rawNsdu : (row == 2 ? this.prim.authData : (row == 3 ? nsdu : (row < 6 ? null : (row == 6 ? nsdu.subHex(0, 1) : (row == 7 ? nsdu.subHex(1, 1) : nsdu.subHex(2, len)))))));
                return val;
            }
            if (row == 0) {
                return nsdu.subHex(0, 1);
            }
            switch (cmd) {
                case DISCOVERY_REQ: {
                    info = this.getInfo(nsdu.subHex(1));
                    pos = info[6].getData()[0];
                    val = row < 7 ? info[row - 1] : nsdu.subHex(pos + 1, 1);
                    break;
                }
                case DISCOVERY_RSP: {
                    info = this.getInfo(nsdu.subHex(2));
                    pos = info[6].getData()[0];
                    val = row == 1 ? nsdu.subHex(1, 1) : (row < 8 ? info[row - 2] : nsdu.subHex(pos + 2, 1));
                    break;
                }
                case PAIR_REQ: {
                    info = this.getInfo(nsdu.subHex(3));
                    pos = info[6].getData()[0];
                    val = row == 1 ? nsdu.subHex(1, 2) : (row < 8 ? info[row - 2] : nsdu.subHex(pos + 3, 1));
                    break;
                }
                case PAIR_RSP: {
                    info = this.getInfo(nsdu.subHex(6));
                    pos = info[6].getData()[0];
                    val = row == 1 ? nsdu.subHex(1, 1) : (row == 2 ? nsdu.subHex(2, 2) : (row == 3 ? nsdu.subHex(4, 2) : info[row - 4]));
                    break;
                }
                case KEYSEED: {
                    val = row == 1 ? nsdu.subHex(1, 1) : nsdu.subHex(2);
                }
            }
            return val;
        }
        if (this.prim.secured) {
            val = row == 0 ? null : (row == 1 ? this.prim.rawNsdu : (row == 2 ? this.prim.authData : (row == 3 ? nsdu : (row < 6 ? null : nsdu))));
            return val;
        }
        return nsdu;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return this.getRowName(row);
            }
            case 2: {
                if (this.prim.valid || Arrays.asList(18, 19, 20, 22, 23).contains(this.getEffectiveRow(row))) {
                    Hex hex = this.getRowHex(row);
                    return hex == null ? null : hex.toString();
                }
                return this.prim.getErrorMessage();
            }
            case 3: {
                return this.getInterpretation(row);
            }
        }
        return null;
    }

    public void setNSPrimitive(Npdu.NSPrimitive prim) {
        this.prim = prim;
    }
}

