/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.rf.Mpdu;
import com.hifiremote.jp1.rf.Rf4ceAuthenticator;
import com.hifiremote.jp1.rf.RfRemote;

public class Npdu
extends Hex {
    public Npdu(Hex hex) {
        super(hex);
    }

    public Npdu(Hex hex, int offset, int length) {
        super(hex, offset, length);
    }

    public Npdu(Hex hex, int offset) {
        super(hex, offset, hex.length() - offset);
    }

    public NSPrimitive parse() {
        NSPrimitive nsPrim = new NSPrimitive();
        nsPrim.frameCtl = this.getData()[0];
        nsPrim.channelDesignator = nsPrim.frameCtl >> 6;
        int frameType = nsPrim.frameCtl & 3;
        if (frameType == 0) {
            nsPrim.setError("RF4CE frame has illegal reserved type");
            return nsPrim;
        }
        nsPrim.type = NSDUType.values()[frameType - 1];
        nsPrim.secured = (nsPrim.frameCtl & 4) == 4;
        boolean hasProfileId = frameType != 2;
        boolean hasVendorId = frameType == 3;
        int rf4ceHdrSize = 5 + (hasProfileId ? 1 : 0) + (hasVendorId ? 2 : 0);
        int rf4ceFtrSize = nsPrim.secured ? 4 : 0;
        int nsduSize = this.length() - rf4ceHdrSize - rf4ceFtrSize;
        nsPrim.frameCtrHex = this.subHex(1, 4);
        if (hasProfileId) {
            nsPrim.profileID = this.subHex(5, 1);
        }
        if (hasVendorId) {
            nsPrim.vendorID = this.subHex(6, 2);
        }
        nsPrim.nsdu = this.subHex(rf4ceHdrSize, nsduSize);
        nsPrim.rawNsdu = new Hex(nsPrim.nsdu);
        nsPrim.authData = nsPrim.secured ? this.subHex(rf4ceHdrSize + nsduSize, 4) : null;
        return nsPrim;
    }

    public static class NSPrimitive {
        public int frameCtl = 0;
        public Hex frameCtrHex = null;
        public Mpdu.MACAddrData addrData = null;
        public Hex profileID = null;
        public Hex vendorID = null;
        public NSDUType type = null;
        public NSDUCommand cmd = null;
        public NSDUDirection direction = null;
        public boolean valid = true;
        public boolean secured = false;
        public int channelDesignator = 0;
        public Hex nsdu = null;
        public Hex rawNsdu = null;
        public Hex authData = null;
        public int rptCount = 0;
        public RfRemote rfRemote = null;
        private String message = null;

        public void setError(String message) {
            this.valid = false;
            this.message = message;
        }

        public String getErrorMessage() {
            return this.message;
        }

        public void setCommand() {
            if (this.type == NSDUType.COMMAND) {
                short cmdCode = this.nsdu.getData()[0];
                if (cmdCode < 1 || cmdCode > 8) {
                    this.setError("Unknown network command");
                    return;
                }
                this.cmd = NSDUCommand.values()[cmdCode - 1];
            } else {
                this.cmd = null;
            }
        }

        public void process(Rf4ceAuthenticator decrypter) {
            decrypter.decrypt(this);
            this.setCommand();
            if (this.valid) {
                if (this.type == NSDUType.COMMAND) {
                    decrypter.processCommand(this);
                }
                this.rfRemote = decrypter.getRfRemote();
            }
        }
    }

    public static enum NSDUType {
        DATA,
        COMMAND,
        VDATA;

    }

    public static enum NSDUDirection {
        IN,
        OUT;

    }

    public static enum NSDUCommand {
        DISCOVERY_REQ,
        DISCOVERY_RSP,
        PAIR_REQ,
        PAIR_RSP,
        UNPAIR_REQ,
        KEYSEED,
        PING_REQ,
        PING_RSP;

    }
}

