/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.rf.Mpdu;
import com.hifiremote.jp1.rf.Npdu;
import com.hifiremote.jp1.rf.RfRemote;
import com.hifiremote.jp1.rf.RfTools;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;

public class Rf4ceAuthenticator {
    private RfRemote rfRemote = null;
    private RfRemote lastFull = null;
    private int pairNdx = -1;
    private int keyExCount = 0;
    private Hex[] keySeeds = null;
    private boolean nwkAddrChanged = false;
    private Hex pingData = null;
    private List<RfRemote> rfRemotesList = null;
    private RfTools owner = null;

    public Rf4ceAuthenticator(List<RfRemote> rfRemotesList, RfTools owner) {
        this.rfRemotesList = rfRemotesList;
        this.owner = owner;
    }

    public void decrypt(Npdu.NSPrimitive nsPrim) {
        Source source = Source.NONE;
        Mpdu.MACAddrData addrData = nsPrim.addrData;
        for (RfRemote rfr : this.rfRemotesList) {
            source = this.getSource(rfr, addrData.srcPAN, addrData.srcAddr, addrData.destPAN, addrData.destAddr);
            if (source == Source.NONE) continue;
            this.rfRemote = rfr;
            break;
        }
        if (source == Source.NONE && this.rfRemote != null) {
            source = this.getSource(this.rfRemote, addrData.srcPAN, addrData.srcAddr, addrData.destPAN, addrData.destAddr);
        }
        if (nsPrim.secured && source == Source.NONE) {
            nsPrim.setError("Decryption failed.  This signal is not from, or for, a registered RF Remote");
            return;
        }
        if (nsPrim.type != Npdu.NSDUType.COMMAND) {
            Npdu.NSDUDirection nSDUDirection = source == Source.CONTROLLER ? Npdu.NSDUDirection.OUT : (nsPrim.direction = source == Source.TARGET ? Npdu.NSDUDirection.IN : null);
        }
        if (!nsPrim.secured) {
            return;
        }
        Hex inData = nsPrim.rawNsdu;
        Hex inFtr = nsPrim.authData;
        Hex securityKey = this.rfRemote.pairings.get(this.pairNdx).getSecurityKey();
        Hex remoteIEEEaddr = this.rfRemote.extAddr;
        Hex destIEEEaddr = this.rfRemote.pairings.get(this.pairNdx).getPeerExtAddr();
        Hex nonceIEEEaddr = source == Source.CONTROLLER ? remoteIEEEaddr : destIEEEaddr;
        Hex authIEEEaddr = source == Source.CONTROLLER ? destIEEEaddr : remoteIEEEaddr;
        byte[] nonce = new byte[13];
        System.arraycopy(nonceIEEEaddr.toByteArray(), 0, nonce, 0, 8);
        System.arraycopy(nsPrim.frameCtrHex.toByteArray(), 0, nonce, 8, 4);
        nonce[12] = 5;
        System.err.println("Nonce: " + new Hex(nonce));
        int frameCtl = nsPrim.frameCtl;
        byte[] addAuthData = new byte[13];
        addAuthData[0] = (byte)frameCtl;
        System.arraycopy(nsPrim.frameCtrHex.toByteArray(), 0, addAuthData, 1, 4);
        System.arraycopy(authIEEEaddr.toByteArray(), 0, addAuthData, 5, 8);
        System.err.println("AddAuthData: " + new Hex(addAuthData));
        byte[] initBytes = new byte[16];
        Arrays.fill(initBytes, (byte)0);
        initBytes[0] = 1;
        System.arraycopy(nonce, 0, initBytes, 1, 13);
        IvParameterSpec iv = new IvParameterSpec(initBytes);
        SecretKeySpec skeySpec = new SecretKeySpec(securityKey.toByteArray(), "AES");
        System.err.println("Key encoded: " + new Hex(skeySpec.getEncoded()));
        try {
            Cipher cipher = Cipher.getInstance("AES/OFB/NoPadding");
            cipher.init(2, (Key)skeySpec, iv);
            Hex outFtr = new Hex(cipher.doFinal(inFtr.toByteArray()));
            initBytes[15] = 1;
            iv = new IvParameterSpec(initBytes);
            skeySpec = new SecretKeySpec(securityKey.toByteArray(), "AES");
            cipher = Cipher.getInstance("AES/OFB/NoPadding");
            cipher.init(2, (Key)skeySpec, iv);
            Hex outData = new Hex(cipher.doFinal(inData.toByteArray()));
            byte[] blockB0 = new byte[16];
            blockB0[0] = 73;
            System.arraycopy(nonce, 0, blockB0, 1, 13);
            blockB0[14] = 0;
            blockB0[15] = (byte)inData.length();
            byte[] blockB1 = new byte[16];
            Arrays.fill(blockB1, (byte)0);
            blockB1[0] = 0;
            blockB1[1] = 13;
            System.arraycopy(addAuthData, 0, blockB1, 2, 13);
            byte[] blockB2 = new byte[16];
            Arrays.fill(blockB2, (byte)0);
            System.arraycopy(outData.toByteArray(), 0, blockB2, 0, inData.length());
            Arrays.fill(initBytes, (byte)0);
            iv = new IvParameterSpec(initBytes);
            cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)skeySpec, iv);
            cipher.update(blockB0);
            cipher.update(blockB1);
            Hex authCode = new Hex(cipher.doFinal(blockB2)).subHex(0, 4);
            boolean valid = outFtr.equals(authCode);
            if (valid) {
                nsPrim.nsdu = outData;
                nsPrim.setCommand();
                nsPrim.valid = true;
            } else {
                nsPrim.setError("Authentication failed");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processCommand(Npdu.NSPrimitive nsPrim) {
        if (nsPrim.type != Npdu.NSDUType.COMMAND) {
            return;
        }
        short appCaps = 0;
        int nodeCaps = 0;
        int devTypeSize = 0;
        int profileSize = 0;
        Mpdu.MACAddrData addrData = nsPrim.addrData;
        RfRemote.Pairing pair = this.pairNdx >= 0 ? this.rfRemote.pairings.get(this.pairNdx) : null;
        switch (nsPrim.cmd) {
            case DISCOVERY_REQ: {
                nodeCaps = nsPrim.nsdu.getData()[1];
                if ((nodeCaps & 1) == 0) {
                    nsPrim.direction = Npdu.NSDUDirection.OUT;
                } else {
                    nsPrim.direction = Npdu.NSDUDirection.IN;
                    System.err.println("Discovery Request received from target, RMIR does not yet handle this correctly");
                }
                appCaps = nsPrim.nsdu.getData()[11];
                Hex extAddr = addrData.srcAddr.length() == 8 ? addrData.srcAddr : null;
                this.rfRemote = null;
                RfRemote fullRemote = null;
                RfRemote provRemote = null;
                for (RfRemote rfr : this.rfRemotesList) {
                    if (rfr.extAddr != null && rfr.extAddr.equals(extAddr)) {
                        fullRemote = rfr;
                    }
                    if (rfr.extAddr != null || !rfr.vendorID.equals(nsPrim.nsdu.subHex(2, 2)) || !rfr.vendorString.equals(nsPrim.nsdu.subHex(4, 7)) || (appCaps & 1) != 0 && !rfr.userString.subHex(0, 9).equals(nsPrim.nsdu.subHex(12, 9))) continue;
                    provRemote = rfr;
                }
                if (fullRemote != null && provRemote != null) {
                    if (this.lastFull != null && fullRemote == this.lastFull) {
                        return;
                    }
                    this.lastFull = fullRemote;
                    String title = "Registration of RF Remote";
                    String message = "The Discovery Request in this file appears to be for the completion of the\nprovisional registration of the RF Remote named " + provRemote.name + ".  However,\nit also matches the full registration of that named " + fullRemote.name + ".\nAs this would create a duplicate, the registration update is aborting.";
                    JOptionPane.showMessageDialog(this.owner, message, title, 0);
                    return;
                }
                RfRemote rfRemote = this.rfRemote = fullRemote != null ? fullRemote : provRemote;
                if (this.rfRemote == null) {
                    this.rfRemote = new RfRemote(extAddr);
                }
                this.rfRemote.changed = false;
                int pos = 12;
                if (this.rfRemote.extAddr == null) {
                    this.rfRemote.extAddr = extAddr;
                    if ((appCaps & 1) == 1) {
                        pos += 15;
                    }
                    this.rfRemote.changed = true;
                } else {
                    this.rfRemote.nodeCaps = nodeCaps;
                    this.rfRemote.vendorID = nsPrim.nsdu.subHex(2, 2);
                    this.rfRemote.vendorString = nsPrim.nsdu.subHex(4, 7);
                    if ((appCaps & 1) == 1) {
                        this.rfRemote.userString = nsPrim.nsdu.subHex(pos, 15);
                        pos += 15;
                    } else {
                        this.rfRemote.userString = null;
                    }
                }
                devTypeSize = appCaps >> 1 & 3;
                this.rfRemote.devTypes = nsPrim.nsdu.subHex(pos, devTypeSize);
                profileSize = appCaps >> 4 & 7;
                this.rfRemote.profiles = nsPrim.nsdu.subHex(pos += devTypeSize, profileSize);
                break;
            }
            case DISCOVERY_RSP: {
                nodeCaps = nsPrim.nsdu.getData()[2];
                if ((nodeCaps & 1) == 1) {
                    nsPrim.direction = Npdu.NSDUDirection.IN;
                    break;
                }
                nsPrim.direction = Npdu.NSDUDirection.OUT;
                System.err.println("Discovery Response sent by remote, RMIR does not yet handle this correctly");
                break;
            }
            case PAIR_REQ: {
                nodeCaps = nsPrim.nsdu.getData()[3];
                if ((nodeCaps & 1) == 0) {
                    nsPrim.direction = Npdu.NSDUDirection.OUT;
                } else {
                    nsPrim.direction = Npdu.NSDUDirection.IN;
                    System.err.println("Pair Request received from target, RMIR does not yet handle this correctly");
                }
                if (this.getSource(this.rfRemote, addrData.srcPAN, addrData.srcAddr, addrData.destPAN, addrData.destAddr) != Source.CONTROLLER) {
                    this.pairNdx = this.rfRemote.pairings.size();
                    pair = new RfRemote.Pairing();
                    this.rfRemote.pairings.add(pair);
                } else {
                    pair = this.rfRemote.pairings.get(this.pairNdx);
                }
                pair.setPairRef(255);
                this.nwkAddrChanged = pair.getPanID() == null || !pair.getPanID().equals(addrData.destPAN);
                pair.setPanID(addrData.destPAN);
                pair.setPeerExtAddr(addrData.destAddr);
                appCaps = nsPrim.nsdu.getData()[13];
                int pos = 14;
                pos += (appCaps & 1) == 1 ? 15 : 0;
                pos += appCaps >> 1 & 3;
                this.keyExCount = nsPrim.nsdu.getData()[pos += appCaps >> 4 & 7];
                this.keySeeds = new Hex[this.keyExCount + 1];
                break;
            }
            case PAIR_RSP: {
                nodeCaps = nsPrim.nsdu.getData()[6];
                if ((nodeCaps & 1) == 1) {
                    nsPrim.direction = Npdu.NSDUDirection.IN;
                } else {
                    nsPrim.direction = Npdu.NSDUDirection.OUT;
                    System.err.println("Pair Response sent by remote, RMIR does not yet handle this correctly");
                }
                if (pair.getNwkAddr() == null || !pair.getNwkAddr().equals(nsPrim.nsdu.subHex(2, 2))) {
                    this.nwkAddrChanged = true;
                }
                pair.setNwkAddr(nsPrim.nsdu.subHex(2, 2));
                pair.setPeerNwkAddr(nsPrim.nsdu.subHex(4, 2));
                pair.setPeerNodeCaps(nsPrim.nsdu.getData()[6]);
                pair.setPeerVendorID(nsPrim.nsdu.subHex(7, 2));
                pair.peerVendorString = nsPrim.nsdu.subHex(9, 7);
                appCaps = nsPrim.nsdu.getData()[16];
                int pos = 17;
                if ((appCaps & 1) == 1) {
                    pair.peerUserString = nsPrim.nsdu.subHex(pos, 15);
                    pos += 15;
                } else {
                    pair.peerUserString = null;
                }
                devTypeSize = appCaps >> 1 & 3;
                pair.setPeerDevTypes(nsPrim.nsdu.subHex(pos, devTypeSize));
                profileSize = appCaps >> 4 & 7;
                pair.peerProfiles = nsPrim.nsdu.subHex(pos += devTypeSize, profileSize);
                break;
            }
            case KEYSEED: {
                if (this.keySeeds == null) {
                    return;
                }
                short seedNum = nsPrim.nsdu.getData()[1];
                if (seedNum < 0 || seedNum >= this.keySeeds.length) {
                    return;
                }
                nsPrim.direction = Npdu.NSDUDirection.IN;
                this.keySeeds[seedNum] = nsPrim.nsdu.subHex(2, 80);
                for (int i = 0; i < this.keySeeds.length; ++i) {
                    if (this.keySeeds[i] != null) continue;
                    return;
                }
                Hex key = this.keyGeneration(this.keySeeds);
                pair.setSecurityKey(key);
                break;
            }
            case PING_REQ: {
                short pingOptions = nsPrim.nsdu.getData()[1];
                if (pingOptions != 0) {
                    return;
                }
                nsPrim.direction = Npdu.NSDUDirection.OUT;
                this.pingData = nsPrim.nsdu.subHex(1);
                if (this.pingData.length() == 5) break;
                this.pingData = null;
                break;
            }
            case PING_RSP: {
                short pingOptions = nsPrim.nsdu.getData()[1];
                if (pingOptions != 0) {
                    return;
                }
                nsPrim.direction = Npdu.NSDUDirection.IN;
                Hex rspData = nsPrim.nsdu.subHex(1);
                if (this.pingData == null || !rspData.equals(this.pingData)) break;
                pair.setPairRef(this.pairNdx);
                this.rfRemote.changed = this.nwkAddrChanged;
                break;
            }
        }
        if (pair != null && nsPrim.direction == Npdu.NSDUDirection.IN && nsPrim.channelDesignator > 0) {
            pair.setChannel(10 + 5 * nsPrim.channelDesignator);
        }
    }

    private Source getSource(RfRemote rfRem, Hex srcPAN, Hex srcAddr, Hex destPAN, Hex destAddr) {
        if (srcAddr.length() == 8 && destAddr.equals(new Hex("FF FF")) && srcAddr.equals(rfRem.extAddr)) {
            this.pairNdx = -1;
            return Source.CONTROLLER;
        }
        if (srcAddr == null || destAddr == null) {
            return Source.NONE;
        }
        for (int i = 0; i < rfRem.pairings.size(); ++i) {
            RfRemote.Pairing pair = rfRem.pairings.get(i);
            this.pairNdx = i;
            Source result = Source.NONE;
            if (srcAddr.length() == 8) {
                if (srcAddr.equals(rfRem.extAddr)) {
                    result = Source.CONTROLLER;
                } else {
                    if (!srcAddr.equals(pair.getPeerExtAddr())) continue;
                    result = Source.TARGET;
                }
            } else if (srcPAN.equals(pair.getPanID()) && srcAddr.equals(pair.getNwkAddr())) {
                result = Source.CONTROLLER;
            } else {
                if (!srcPAN.equals(pair.getPanID()) || !srcAddr.equals(pair.getPeerNwkAddr())) continue;
                result = Source.TARGET;
            }
            if (result == Source.NONE) {
                return result;
            }
            if (destAddr.length() == 8) {
                if (destAddr.equals(pair.getPeerExtAddr()) && result == Source.CONTROLLER) {
                    return result;
                }
                if (!destAddr.equals(rfRem.extAddr) || result != Source.TARGET) continue;
                return result;
            }
            if (destPAN.equals(pair.getPanID()) && destAddr.equals(pair.getPeerNwkAddr()) && result == Source.CONTROLLER) {
                return result;
            }
            if (!destPAN.equals(pair.getPanID()) || !srcAddr.equals(pair.getNwkAddr()) || result != Source.TARGET) continue;
            return result;
        }
        this.pairNdx = -1;
        return Source.NONE;
    }

    public Hex keyGeneration(Hex[] keySeeds) {
        Hex finalSeed = new Hex(80);
        for (int i = 0; i < 80; ++i) {
            finalSeed.getData()[i] = 0;
            for (int j = 0; j < keySeeds.length; ++j) {
                short[] sArray = finalSeed.getData();
                int n = i;
                sArray[n] = (short)(sArray[n] ^ keySeeds[j].getData()[i]);
            }
        }
        Hex key = new Hex(16);
        for (int i = 0; i < 16; ++i) {
            key.getData()[i] = 0;
            for (int j = 0; j < 5; ++j) {
                short[] sArray = key.getData();
                int n = i;
                sArray[n] = (short)(sArray[n] ^ finalSeed.getData()[16 * j + i]);
            }
        }
        return key;
    }

    public RfRemote getRfRemote() {
        return this.rfRemote;
    }

    public int getPairNdx() {
        return this.pairNdx;
    }

    public static enum Source {
        CONTROLLER,
        TARGET,
        NONE;

    }
}

