/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1.rf;

import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.rf.NSPrimitiveTableModel;
import com.hifiremote.jp1.rf.Npdu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RfCapturePanel
extends JPanel
implements ActionListener {
    private JP1Table nsTable = null;
    private List<Npdu.NSPrimitive> data = null;
    private JButton clearBtn = null;

    public RfCapturePanel() {
        this.setLayout(new BorderLayout());
        this.data = new ArrayList<Npdu.NSPrimitive>();
        NSPrimitiveTableModel nsTableModel = new NSPrimitiveTableModel();
        nsTableModel.setData(this.data);
        this.nsTable = new JP1Table(nsTableModel);
        this.nsTable.initColumns();
        JScrollPane scrollPane = new JScrollPane(this.nsTable);
        this.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel(new FlowLayout(1));
        this.clearBtn = new JButton("Clear Display");
        this.clearBtn.addActionListener(this);
        this.clearBtn.setToolTipText("Clear the display");
        panel.add(this.clearBtn);
        this.add((Component)panel, "Last");
    }

    public List<Npdu.NSPrimitive> getData() {
        return this.data;
    }

    public void update() {
        NSPrimitiveTableModel model = (NSPrimitiveTableModel)this.nsTable.getModel();
        model.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.clearBtn) {
            NSPrimitiveTableModel model = (NSPrimitiveTableModel)this.nsTable.getModel();
            model.getData().clear();
            model.fireTableDataChanged();
        }
    }

    public Npdu.NSPrimitive getSelectedRow() {
        int row = this.nsTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        NSPrimitiveTableModel model = (NSPrimitiveTableModel)this.nsTable.getModel();
        return (Npdu.NSPrimitive)model.getRow(row);
    }
}

